/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Scanner;
import beaver.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;

public final class LayoutScanner
extends Scanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int INSIDE_INHERITED_HEADER_SECTION = 2;
    public static final int INSIDE_BRACKET_COMMENT = 5;
    public static final int INSIDE_STRING_IDENTIFIER_DIRECTIVE = 9;
    public static final int INSIDE_DECL_REGION = 7;
    public static final int INSIDE_STRING = 6;
    public static final int INSIDE_OPTION_SECTION = 3;
    public static final int INSIDE_LOCAL_HEADER_SECTION = 1;
    public static final int YYINITIAL = 0;
    public static final int INSIDE_META_PATTERN_DIRECTIVE = 10;
    public static final int INSIDE_INIT_REGION = 8;
    public static final int INSIDE_RULE_SECTION = 4;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u0011\u0001\b\u0001\u0000\u0001\u0011\u0001\u0007\u0002\u0000\u00010\u00011\u0001\u0013\u00015\u0001'\u0001\u0000\u0001\u0011\u0001\u0012\u0004\u000f\u0004\u0010\u0002\u0005\u0002\u0000\u0001(\u0001\u0000\u0001,\u00016\u0001\u0000\u0001)\u0001-\u0003\t\u0001/\u0007\u0004\u0001*\u0001.\t\u0004\u0001+\u0001\u0004\u00012\u0001\n\u00013\u00014\u0001\u0006\u0001\u0000\u0001\u001d\u0001%\u0001!\u0001#\u0001\u001a\u0001\f\u0001&\u0001\u0019\u0001\u0016\u0002\u0004\u0001\u001b\u0001\"\u0001\u0017\u0001\u001f\u0001\u001c\u0001\u0004\u0001\u000b\u0001 \u0001\u0018\u0001\u000e\u0001\u0004\u0001$\u0001\r\u0001\u001e\u0001\u0004\u0001\u0014\u00017\u0001\u0015\u0001\u0011\uff81\u0000";
    private static final char[] ZZ_CMAP = LayoutScanner.zzUnpackCMap("\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u0011\u0001\b\u0001\u0000\u0001\u0011\u0001\u0007\u0002\u0000\u00010\u00011\u0001\u0013\u00015\u0001'\u0001\u0000\u0001\u0011\u0001\u0012\u0004\u000f\u0004\u0010\u0002\u0005\u0002\u0000\u0001(\u0001\u0000\u0001,\u00016\u0001\u0000\u0001)\u0001-\u0003\t\u0001/\u0007\u0004\u0001*\u0001.\t\u0004\u0001+\u0001\u0004\u00012\u0001\n\u00013\u00014\u0001\u0006\u0001\u0000\u0001\u001d\u0001%\u0001!\u0001#\u0001\u001a\u0001\f\u0001&\u0001\u0019\u0001\u0016\u0002\u0004\u0001\u001b\u0001\"\u0001\u0017\u0001\u001f\u0001\u001c\u0001\u0004\u0001\u000b\u0001 \u0001\u0018\u0001\u000e\u0001\u0004\u0001$\u0001\r\u0001\u001e\u0001\u0004\u0001\u0014\u00017\u0001\u0015\u0001\u0011\uff81\u0000");
    private static final int[] ZZ_ACTION = LayoutScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u000b\u0000\u0001\u0001\u0003\u0002\u0001\u0003\u0002\u0004\u0001\u0005\u0001\u0003\u0003\u0006\u0003\u0007\u0002\b\u0001\t\u0001\n\u0002\u0002\u0001\u000b\u0002\f\u0001\r\u0001\u000e\u0001\u000b\u0001\u000f\u0001\u0010\u0001\u0011\u0002\u0010\u0001\u0012\u0001\u0010\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0007\u0000\u0001\u001f\u0001 \t\u0000\u0001!\u0001\"\u0003#\u0002\u0002\u0001\u0000\u0001$\u0018\u0000\u0001\u0002\u0002\u0000\u0001%\u0011\u0000\u0001&\u0003\u0000\u0001\u0002\u0011\u0000\u0001'\u0001(\u0001&\u0001\u0000\u0001)\u0002\u0000\u0001\u0002\u0002\u0000\u0001*\u0001+\u0001,\u0005\u0000\u0001-\u0007\u0000\u0001'\u0001\u0000\u0001(\u0001\u0000\u0001)\u0001\u0000\u0001.\u0001/\u00010\u0001\u0000\u00011\u0001\u0000\u00012\u00013\u0001-\u0004\u0000\u00014\u0003\u0000\u0001.\u0001\u0000\u0001/\u0002\u0000\u00011\u0002\u0000\u00012\u0001\u0000\u00013\u0002\u0000\u00015\u0001\u0000\u00014\u0001\u0000\u00016\u00017\u0002\u0000\u00018\u0001\u0000\u00015\u0001\u0000\u00019\u00016\u0001\u0000\u00017\u0001\u0000\u0001:\u0001;\u00018\u0001\u0000\u0001<\u00019\u0001\u0000\u0001:\u0001\u0000\u0001;\u0001\u0000\u0001<\u0001\u0000";
    private static final int[] ZZ_ROWMAP = LayoutScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00008\u0000p\u0000\u00a8\u0000\u00e0\u0000\u0118\u0000\u0150\u0000\u0188\u0000\u01c0\u0000\u01f8\u0000\u0230\u0000\u0268\u0000\u0268\u0000\u02a0\u0000\u02d8\u0000\u0268\u0000\u0310\u0000\u0268\u0000\u0348\u0000\u0380\u0000\u0268\u0000\u03b8\u0000\u0380\u0000\u0268\u0000\u03f0\u0000\u0428\u0000\u0460\u0000\u0268\u0000\u0268\u0000\u0498\u0000\u04d0\u0000\u0508\u0000\u0268\u0000\u0540\u0000\u0268\u0000\u0578\u0000\u0268\u0000\u0380\u0000\u0268\u0000\u0268\u0000\u05b0\u0000\u05e8\u0000\u0380\u0000\u0268\u0000\u0620\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0658\u0000\u0690\u0000\u06c8\u0000\u0700\u0000\u0738\u0000\u0770\u0000\u07a8\u0000\u07e0\u0000\u0268\u0000\u0818\u0000\u0850\u0000\u0888\u0000\u08c0\u0000\u08f8\u0000\u0930\u0000\u0968\u0000\u09a0\u0000\u09d8\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u0a10\u0000\u0a48\u0000\u0a80\u0000\u0ab8\u0000\u0af0\u0000\u0268\u0000\u0b28\u0000\u0b60\u0000\u0b98\u0000\u0bd0\u0000\u0c08\u0000\u0c40\u0000\u0c78\u0000\u0cb0\u0000\u0ce8\u0000\u0d20\u0000\u0d58\u0000\u0d90\u0000\u0dc8\u0000\u0e00\u0000\u0e38\u0000\u0e70\u0000\u0ea8\u0000\u0ee0\u0000\u0f18\u0000\u0f50\u0000\u0f88\u0000\u0fc0\u0000\u0ff8\u0000\u1030\u0000\u1068\u0000\u10a0\u0000\u10d8\u0000\u0268\u0000\u1110\u0000\u1148\u0000\u1180\u0000\u11b8\u0000\u11f0\u0000\u1228\u0000\u1260\u0000\u1298\u0000\u12d0\u0000\u1308\u0000\u1340\u0000\u1378\u0000\u13b0\u0000\u13e8\u0000\u1420\u0000\u1458\u0000\u1490\u0000\u14c8\u0000\u1500\u0000\u1538\u0000\u1570\u0000\u15a8\u0000\u15e0\u0000\u1618\u0000\u1650\u0000\u1688\u0000\u16c0\u0000\u16f8\u0000\u1730\u0000\u1768\u0000\u17a0\u0000\u17d8\u0000\u1810\u0000\u1848\u0000\u1880\u0000\u18b8\u0000\u18f0\u0000\u1928\u0000\u1960\u0000\u1998\u0000\u19d0\u0000\u1a08\u0000\u1a08\u0000\u1a40\u0000\u1a78\u0000\u1ab0\u0000\u1030\u0000\u1ae8\u0000\u1b20\u0000\u0268\u0000\u0268\u0000\u0268\u0000\u1b58\u0000\u1b90\u0000\u1bc8\u0000\u1c00\u0000\u1c38\u0000\u1c70\u0000\u1ca8\u0000\u1ce0\u0000\u1d18\u0000\u1d50\u0000\u1d88\u0000\u1dc0\u0000\u1df8\u0000\u1e30\u0000\u1e30\u0000\u1e68\u0000\u1e68\u0000\u1ea0\u0000\u1ea0\u0000\u1ed8\u0000\u1f10\u0000\u0268\u0000\u1f48\u0000\u1f80\u0000\u1fb8\u0000\u1ff0\u0000\u2028\u0000\u2060\u0000\u2060\u0000\u2098\u0000\u20d0\u0000\u2108\u0000\u2140\u0000\u2178\u0000\u21b0\u0000\u21e8\u0000\u2220\u0000\u2220\u0000\u2258\u0000\u2258\u0000\u2290\u0000\u22c8\u0000\u22c8\u0000\u2300\u0000\u2338\u0000\u2338\u0000\u2370\u0000\u2370\u0000\u23a8\u0000\u23e0\u0000\u2418\u0000\u2450\u0000\u2450\u0000\u2488\u0000\u24c0\u0000\u24f8\u0000\u2530\u0000\u2568\u0000\u25a0\u0000\u25d8\u0000\u25d8\u0000\u2610\u0000\u2648\u0000\u2648\u0000\u2680\u0000\u2680\u0000\u26b8\u0000\u26f0\u0000\u2728\u0000\u2728\u0000\u2760\u0000\u2798\u0000\u2798\u0000\u27d0\u0000\u27d0\u0000\u2808\u0000\u2808\u0000\u2840\u0000\u2840";
    private static final int[] ZZ_TRANS = LayoutScanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "8\f\u0007\r\u0001\u000e7\r\u0001\u000f0\r\u0001\u0010\u0001\u0011\u0002\u0012\u0003\u0010\u0001\u0013\n\u0010\u0001\u0014%\u0010\u0001\u0015\u0001\u0011\u0002\u0012\u0003\u0015\u0001\u0016\n\u0015\u0001\u0017%\u0015\u0012\u0018\u0001\u0019\u0001\u001a$\u0018\u0001\r\u0001\u001b\u0001\u001c\u0005\r\u0001\u001d\u0001\r\u0001\u001e4\r\u0001\u001f7\r\u0001 0\r\u0001!\u0001\"\u0001#\u0001\u0012\u0001$\u0003!\u0001%\u0001$\u0001!\u0004$\u0003!\u0001&\u0003!\u0011$\u0001'\u0001!\u0003$\u0001!\u0003$\b!\u0001(\u0001\"\u0001#\u0001\u0012\u0001)\u0002(\u0001*\u0001(\u0001)\u0001(\u0004)\u0003(\u0001+\u0001,\u0002(\u0011)\u0001(\u0001-\u0003)\u0001(\u0003)\u0001.\u0001/\u00010\u00011\u00012\u00013\u00014\u00015?\u0000\u000167\u0000\u000172\u0000\u0001\u0012<\u0000\u00018\f\u0000\u00019\u0001\u0000\u0001:\u0002\u0000\u0001;\u0001\u0000\u0001<\u0003\u0000\u0001=\u0001>\u0001?\u0001\u0000\u0001@&\u0000\u0001A\u0001B+\u0000\u0001C\u0003\u0000\u0001D\u0002\u0000\u0001E\b\u0000\u0001F\u0001\u0000\u0001G\u0001H\u0001\u0000\u0001I\u0003\u0000\u0001J\u0005\u0000\u0001K$\u0000\u0001L6\u0000\u0001M'\u0000\u0001\u001c5\u0000\bN\u0001\r\u0001N\u0003\r\u0001O\u0001P\u0001Q\u0001R\u0005\r\u0001N\u0002\r\fN\u0001\r\u0002N\u0001\r\u0003N\u0001\r\u0003N\b\r\u0007\u0000\u0001S\r\u0000\u0001T)\u0000\u0001U\u000e\u0000\u0001V#\u0000\u0001#9\u0000\u0003$\u0002\u0000\u0001$\u0001\u0000\u0006$\u0005\u0000\u0011$\u0002\u0000\u0003$\u0001\u0000\u0003$\f\u0000\u0003)\u0002\u0000\u0001)\u0001\u0000\u0006)\u0005\u0000\u0011)\u0002\u0000\u0003)\u0001\u0000\u0003)\f\u0000\u0001W\u0004\u0000\u0001W\u0001\u0000\u0004W\u0007\u0000\u0011W\u0002\u0000\u0003W\u0001\u0000\u0003W1\u0000\u0001X\u0003\u0000\u0001Y!\u0000\u0001Z:\u0000\u0001[7\u0000\u0001\\\u0002\u0000\u0001]6\u0000\u0001^3\u0000\u0001_>\u0000\u0001`2\u0000\u0001a\u001d\u0000\u0001A\u0002\u00005A\u0016\u0000\u0001b\u0003\u0000\u0001c7\u0000\u0001d4\u0000\u0001e=\u0000\u0001f9\u0000\u0001g/\u0000\u0001h=\u0000\u0001i2\u0000\u0001j-\u0000\u0001k.\u0000\u0001l\u0003\u0000\u0001l\u0002\u0000\u0001l\u0002\u0000\u0002l\t\u0000\u0001l\u0002\u0000\u0001l\u0003\u0000\u0001l\u0001\u0000\u0001l\u0001\u0000\u0001l\u0003\u0000\u0001l\u0003\u0000\u0001l\u0001\u0000\u0001l\r\u0000\u0001m\u0003\u0000\u0001m\u0002\u0000\u0001m\u0002\u0000\u0002m\t\u0000\u0001m\u0002\u0000\u0001m\u0003\u0000\u0001m\u0001\u0000\u0001m\u0001\u0000\u0001m\u0003\u0000\u0001m\u0003\u0000\u0001m\u0001\u0000\u0001m\u0017\u0000\u0002R6\u0000\u0002\r<\u0000\u0001N8\u0000\u0001n8\u0000\u0001o$\u0000\u0003W\u0001p\u0001\u0000\u0001W\u0001\u0000\u0006W\u0005\u0000\u0011W\u0002\u0000\u0003W\u0001\u0000\u0003W2\u0000\u0001q;\u0000\u0001r\u001f\u0000\u0001s<\u0000\u0001t)\u0000\u0001uH\u0000\u0001v1\u0000\u0001w<\u0000\u0001x<\u0000\u0001y6\u0000\u0001z-\u0000\u0001{B\u0000\u0001|1\u0000\u0001}5\u0000\u0001~\u0004\u0000\u0001\u007f:\u0000\u0001\u00805\u0000\u0001\u0081:\u0000\u0001\u0082*\u0000\u0001\u0083>\u0000\u0001\u00844\u0000\u0001\u0085\"\u0000\u0001\r\u0003\u0000\u0001\r\u0002\u0000\u0001\r\u0002\u0000\u0002\r\t\u0000\u0001\r\u0002\u0000\u0001\r\u0003\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0001\r\u0003\u0000\u0001\r\u0001\u0000\u0001\r\r\u0000\u0001\u0086\u0003\u0000\u0001\u0086\u0002\u0000\u0001\u0086\u0002\u0000\u0002\u0086\t\u0000\u0001\u0086\u0002\u0000\u0001\u0086\u0003\u0000\u0001\u0086\u0001\u0000\u0001\u0086\u0001\u0000\u0001\u0086\u0003\u0000\u0001\u0086\u0003\u0000\u0001\u0086\u0001\u0000\u0001\u0086\u001f\u0000\u0001\u00876\u0000\u0001\u0088L\u0000\u0001\u0089;\u0000\u0001\u008a \u0000\u0001\u008b;\u0000\u0001\u008c3\u0000\u0001\u008d>\u0000\u0001\u008e.\u0000\u0001\u008f,\u0000\u0001\u0090H\u0000\u0001\u00916\u0000\u0001\u00925\u0000\u0001\u0093C\u0000\u0001\u0094-\u0000\u0001\u0095>\u0000\u0001\u00961\u0000\u0001\u00975\u0000\u0001\u00985\u0000\u0001\u0099\u001f\u0000\u0004\u009a\u0003\u009b\u0002\u009a\u0001\u009b\u0001\u009a\u0006\u009b\u0005\u009a\u0011\u009b\u0002\u009a\u0003\u009b\u0001\u009a\u0003\u009b\b\u009a\u000b\u0000\u0001\u009c7\u0000\u0001\u009dL\u0000\u0001\u009e\u001c\u0000\u0001\u009f\u0003\u0000\u0001\u009f\u0002\u0000\u0001\u009f\u0002\u0000\u0002\u009f\t\u0000\u0001\u009f\u0002\u0000\u0001\u009f\u0003\u0000\u0001\u009f\u0001\u0000\u0001\u009f\u0001\u0000\u0001\u009f\u0003\u0000\u0001\u009f\u0003\u0000\u0001\u009f\u0001\u0000\u0001\u009f\u001e\u0000\u0001\u00a09\u0000\u0001\u00a1K\u0000\u0001\u00a27\u0000\u0001\u00a3\u001f\u0000\u0001\u00a4\u0003\u0000\u0001\u00a59\u0000\u0001\u00a66\u0000\u0001\u00a7,\u0000\u0001\u00a8H\u0000\u0001\u00a90\u0000\u0001\u00aa>\u0000\u0001\u00ab5\u0000\u0001\u00ac4\u0000\u0001\u00ad7\u0000\u0001\u00ae:\u0000\u0001\u00af?\u0000\u0001\u00b0*\u0000\u0001\u00b1\u001f\u0000\u0004\u00b2\u0003\u00b3\u0002\u00b2\u0001\u00b3\u0001\u00b2\u0006\u00b3\u0005\u00b2\u0011\u00b3\u0002\u00b2\u0003\u00b3\u0001\u00b2\u0003\u00b3\b\u00b2\u0004\u00b4\u0003\u00b5\u0002\u00b4\u0001\u00b5\u0001\u00b4\u0006\u00b5\u0005\u00b4\u0011\u00b5\u0002\u00b4\u0003\u00b5\u0001\u00b4\u0003\u00b5\b\u00b48\u009a\u0004\u00b6\u0003\u00b7\u0002\u00b6\u0001\u00b7\u0001\u00b6\u0006\u00b7\u0005\u00b6\u0011\u00b7\u0002\u00b6\u0003\u00b7\u0001\u00b6\u0003\u00b7\b\u00b6\u0018\u0000\u0001\u00b87\u0000\u0001\u00b97\u0000\u0001S4\u0000\u0001\u00ba;\u0000\u0001\u00bb)\u0000\u0001\u00bc7\u0000\u0001\u00bdD\u0000\u0001\u00be6\u0000\u0001\u00bf \u0000\u0004\u00c0\u0003\u00c1\u0002\u00c0\u0001\u00c1\u0001\u00c0\u0006\u00c1\u0005\u00c0\u0011\u00c1\u0002\u00c0\u0003\u00c1\u0001\u00c0\u0003\u00c1\b\u00c0\u0017\u0000\u0001\u00c2+\u0000\u0001\u00c37\u0000\u0001\u00c4O\u0000\u0001\u00c55\u0000\u0001\u00c60\u0000\u0001\u00c73\u0000\u0001\u00c8!\u00008\u00b28\u00b48\u00b6\u0004\u00c9\u0003\u00ca\u0002\u00c9\u0001\u00ca\u0001\u00c9\u0006\u00ca\u0005\u00c9\u0011\u00ca\u0002\u00c9\u0003\u00ca\u0001\u00c9\u0003\u00ca\b\u00c9\u0004\u00cb\u0003\u00cc\u0002\u00cb\u0001\u00cc\u0001\u00cb\u0006\u00cc\u0005\u00cb\u0011\u00cc\u0002\u00cb\u0003\u00cc\u0001\u00cb\u0003\u00cc\b\u00cb\u000b\u0000\u0001\u00cd,\u0000\u0004\u00ce\u0003\u00cf\u0002\u00ce\u0001\u00cf\u0001\u00ce\u0006\u00cf\u0005\u00ce\u0011\u00cf\u0002\u00ce\u0003\u00cf\u0001\u00ce\u0003\u00cf\b\u00ce\u001f\u0000\u0001\u00d0\u0018\u0000\u0004\u00d1\u0003\u00d2\u0002\u00d1\u0001\u00d2\u0001\u00d1\u0006\u00d2\u0005\u00d1\u0011\u00d2\u0002\u00d1\u0003\u00d2\u0001\u00d1\u0003\u00d2\b\u00d1\u0004\u00d3\u0003\u00d4\u0002\u00d3\u0001\u00d4\u0001\u00d3\u0006\u00d4\u0005\u00d3\u0011\u00d4\u0002\u00d3\u0003\u00d4\u0001\u00d3\u0003\u00d4\b\u00d38\u00c0\u001a\u0000\u0001\u00d57\u0000\u0001\u00d63\u0000\u0001\u00d7!\u0000\u0004\u00d8\u0003\u00d9\u0002\u00d8\u0001\u00d9\u0001\u00d8\u0006\u00d9\u0005\u00d8\u0011\u00d9\u0002\u00d8\u0003\u00d9\u0001\u00d8\u0003\u00d9\b\u00d8\u001a\u0000\u0001\u00da@\u0000\u0001\u00db3\u0000\u0001\u00dc\u0018\u00008\u00c98\u00cb\u001f\u0000\u0001\u00dd\u0018\u00008\u00ce$\u0000\u0001\u00de\u0013\u00008\u00d18\u00d3\u0017\u0000\u0001\u00df \u0000\u0004\u00e0\u0003\u00e1\u0002\u00e0\u0001\u00e1\u0001\u00e0\u0006\u00e1\u0005\u00e0\u0011\u00e1\u0002\u00e0\u0003\u00e1\u0001\u00e0\u0003\u00e1\b\u00e0\u0018\u0000\u0001\u00e2\u001f\u00008\u00d8\u0004\u00e3\u0003\u00e4\u0002\u00e3\u0001\u00e4\u0001\u00e3\u0006\u00e4\u0005\u00e3\u0011\u00e4\u0002\u00e3\u0003\u00e4\u0001\u00e3\u0003\u00e4\b\u00e3\u0004\u00e5\u0003\u00e6\u0002\u00e5\u0001\u00e6\u0001\u00e5\u0006\u00e6\u0005\u00e5\u0011\u00e6\u0002\u00e5\u0003\u00e6\u0001\u00e5\u0003\u00e6\b\u00e5\u0017\u0000\u0001\u00e7D\u0000\u0001\u00e8\u0013\u0000\u0004\u00e9\u0003\u00ea\u0002\u00e9\u0001\u00ea\u0001\u00e9\u0006\u00ea\u0005\u00e9\u0011\u00ea\u0002\u00e9\u0003\u00ea\u0001\u00e9\u0003\u00ea\b\u00e9\u0018\u0000\u0001\u00eb\u001f\u00008\u00e0\u0004\u00ec\u0003\u00ed\u0002\u00ec\u0001\u00ed\u0001\u00ec\u0006\u00ed\u0005\u00ec\u0011\u00ed\u0002\u00ec\u0003\u00ed\u0001\u00ec\u0003\u00ed\b\u00ec8\u00e38\u00e5\u0004\u00ee\u0003\u00ef\u0002\u00ee\u0001\u00ef\u0001\u00ee\u0006\u00ef\u0005\u00ee\u0011\u00ef\u0002\u00ee\u0003\u00ef\u0001\u00ee\u0003\u00ef\b\u00ee\u0004\u00f0\u0003\u00f1\u0002\u00f0\u0001\u00f1\u0001\u00f0\u0006\u00f1\u0005\u00f0\u0011\u00f1\u0002\u00f0\u0003\u00f1\u0001\u00f0\u0003\u00f1\b\u00f08\u00e9\u0004\u00f2\u0003\u00f3\u0002\u00f2\u0001\u00f3\u0001\u00f2\u0006\u00f3\u0005\u00f2\u0011\u00f3\u0002\u00f2\u0003\u00f3\u0001\u00f2\u0003\u00f3\b\u00f28\u00ec8\u00ee8\u00f08\u00f2";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = LayoutScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u000b\u0000\u0002\t\u0002\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0003\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\f\t\u0007\u0000\u0001\u0001\u0001\t\t\u0000\u0003\t\u0004\u0001\u0001\u0000\u0001\t\u0018\u0000\u0001\u0001\u0002\u0000\u0001\t\u0011\u0000\u0001\u0007\u0003\u0000\u0001\u0001\u0011\u0000\u0002\u0007\u0001\u0005\u0001\u0000\u0001\u0007\u0002\u0000\u0001\u0001\u0002\u0000\u0003\t\u0005\u0000\u0001\u0007\u0007\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0002\u0007\u0001\t\u0001\u0000\u0001\u0007\u0001\u0000\u0002\u0007\u0001\u0005\u0004\u0000\u0001\u0007\u0003\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0002\u0000\u0001\u0005\u0002\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0002\u0000\u0001\u0007\u0001\u0000\u0001\u0005\u0001\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0007\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0002\u0007\u0001\u0005\u0001\u0000\u0001\u0007\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private PositionRecord pos = new PositionRecord();
    private Stack<StateRecord> stateStack = new Stack();
    private int nestingDepth = 0;
    private StringBuffer blobBuf = new StringBuffer();

    private static int[] zzUnpackAction() {
        int[] nArray = new int[243];
        int n = 0;
        n = LayoutScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAction(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackRowMap() {
        int[] nArray = new int[243];
        int n = 0;
        n = LayoutScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackRowMap(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++) << 16;
            nArray[n3++] = n5 | string.charAt(n2++);
        }
        return n3;
    }

    private static int[] zzUnpackTrans() {
        int[] nArray = new int[10360];
        int n = 0;
        n = LayoutScanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackTrans(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            int n6 = string.charAt(n2++);
            do {
                nArray[n3++] = --n6;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAttribute() {
        int[] nArray = new int[243];
        int n = 0;
        n = LayoutScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAttribute(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private Symbol symbol(short s) {
        return this.symbol(s, null);
    }

    private Symbol symbol(short s, Object object) {
        int n = this.yyline + 1;
        int n2 = this.yycolumn + 1;
        int n3 = n;
        int n4 = n2 + this.yylength() - 1;
        return this.symbol(s, object, n, n2, n3, n4);
    }

    private Symbol symbol(short s, Object object, int n, int n2, int n3, int n4) {
        int n5 = Symbol.makePosition(n, n2);
        int n6 = Symbol.makePosition(n3, n4);
        return new Symbol(s, n5, n6, object);
    }

    private void markStartPosition() {
        this.pos.startLine = this.yyline + 1;
        this.pos.startCol = this.yycolumn + 1;
    }

    private void markEndPosition() {
        this.pos.endLine = this.yyline + 1;
        this.pos.endCol = this.yycolumn + 1 + this.yylength() - 1;
    }

    private Symbol symbolFromMarkedPositions(short s) {
        return this.symbolFromMarkedPositions(s, null);
    }

    private Symbol symbolFromMarkedPositions(short s, Object object) {
        return this.symbol(s, object, this.pos.startLine, this.pos.startCol, this.pos.endLine, this.pos.endCol);
    }

    private Symbol symbolFromMarkedStart(short s, int n) {
        return this.symbolFromMarkedStart(s, null, n);
    }

    private Symbol symbolFromMarkedStart(short s, Object object, int n) {
        return this.symbol(s, object, this.pos.startLine, this.pos.startCol, this.pos.startLine, this.pos.startCol + n - 1);
    }

    private void error(String string) throws Scanner.Exception {
        throw new Scanner.Exception(this.yyline + 1, this.yycolumn + 1, string);
    }

    private void error(String string, int n) throws Scanner.Exception {
        throw new Scanner.Exception(this.yyline + 1, this.yycolumn + 1 + n, string);
    }

    void saveStateAndTransition(int n) {
        this.stateStack.push(new StateRecord(this.yystate(), this.pos));
        this.pos = new PositionRecord();
        this.yybegin(n);
    }

    void restoreState() {
        StateRecord stateRecord = this.stateStack.pop();
        this.yybegin(stateRecord.stateNum);
        this.pos = stateRecord.pos;
    }

    private static String frontChomp(String string) {
        if (string.startsWith("\r\n")) {
            return string.substring(2);
        }
        if (string.startsWith("\n") || string.startsWith("\r")) {
            return string.substring(1);
        }
        return string;
    }

    public LayoutScanner(Reader reader) {
        this.saveStateAndTransition(1);
        this.blobBuf = new StringBuffer();
        this.markStartPosition();
        this.zzReader = reader;
    }

    public LayoutScanner(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    private static char[] zzUnpackCMap(String string) {
        char[] cArray = new char[65536];
        int n = 0;
        int n2 = 0;
        while (n < 154) {
            int n3 = string.charAt(n++);
            char c = string.charAt(n++);
            do {
                cArray[n2++] = c;
            } while (--n3 > 0);
        }
        return cArray;
    }

    private boolean zzRefill() throws IOException {
        int n;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] cArray = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, cArray, 0, this.zzBuffer.length);
            this.zzBuffer = cArray;
        }
        if ((n = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += n;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int n) {
        this.zzLexicalState = n;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int n) {
        String string;
        try {
            string = ZZ_ERROR_MSG[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = ZZ_ERROR_MSG[0];
        }
        throw new Error(string);
    }

    public void yypushback(int n) {
        if (n > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= n;
    }

    public Symbol nextToken() throws IOException, Scanner.Exception {
        int n = this.zzEndRead;
        char[] cArray = this.zzBuffer;
        char[] cArray2 = ZZ_CMAP;
        int[] nArray = ZZ_TRANS;
        int[] nArray2 = ZZ_ROWMAP;
        int[] nArray3 = ZZ_ATTRIBUTE;
        this.zzPushbackPos = -1;
        int n2 = -1;
        block148: while (true) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.zzMarkedPos;
            boolean bl = false;
            block149: for (n6 = this.zzStartRead; n6 < n7; ++n6) {
                switch (cArray[n6]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = false;
                        continue block149;
                    }
                    case '\r': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = true;
                        continue block149;
                    }
                    case '\n': {
                        if (bl) {
                            bl = false;
                            continue block149;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block149;
                    }
                    default: {
                        bl = false;
                        ++this.yycolumn;
                    }
                }
            }
            if (bl) {
                if (n7 < n) {
                    n5 = cArray[n7] == '\n' ? 1 : 0;
                } else if (this.zzAtEOF) {
                    n5 = 0;
                } else {
                    n4 = this.zzRefill();
                    n = this.zzEndRead;
                    n7 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    if (n4 != 0) {
                        n5 = 0;
                    } else {
                        int n8 = n5 = cArray[n7] == '\n' ? 1 : 0;
                    }
                }
                if (n5 != 0) {
                    --this.yyline;
                }
            }
            int n9 = -1;
            this.zzCurrentPos = this.zzStartRead = n7;
            n6 = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            boolean bl2 = false;
            while (true) {
                if (n6 < n) {
                    n3 = cArray[n6++];
                } else {
                    if (this.zzAtEOF) {
                        n3 = -1;
                        break;
                    }
                    this.zzCurrentPos = n6;
                    this.zzMarkedPos = n7;
                    this.zzPushbackPos = n2;
                    n5 = this.zzRefill();
                    n6 = this.zzCurrentPos;
                    n7 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    n = this.zzEndRead;
                    n2 = this.zzPushbackPos;
                    if (n5 != 0) {
                        n3 = -1;
                        break;
                    }
                    n3 = cArray[n6++];
                }
                n5 = nArray[nArray2[this.zzState] + cArray2[n3]];
                if (n5 == -1) break;
                this.zzState = n5;
                n4 = nArray3[this.zzState];
                if ((n4 & 2) == 2) {
                    n2 = n6;
                }
                if ((n4 & 1) != 1) continue;
                bl2 = (n4 & 4) == 4;
                n9 = this.zzState;
                n7 = n6;
                if ((n4 & 8) == 8) break;
            }
            this.zzMarkedPos = n7;
            if (bl2) {
                this.zzMarkedPos = n2;
            }
            switch (n9 < 0 ? n9 : ZZ_ACTION[n9]) {
                case 4: 
                case 61: {
                    continue block148;
                }
                case 57: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)2);
                }
                case 62: {
                    continue block148;
                }
                case 5: {
                    this.error("Invalid directive");
                }
                case 63: {
                    continue block148;
                }
                case 50: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)39);
                }
                case 64: {
                    continue block148;
                }
                case 52: {
                    return this.symbol((short)1);
                }
                case 65: {
                    continue block148;
                }
                case 39: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)35);
                }
                case 66: {
                    continue block148;
                }
                case 46: {
                    this.saveStateAndTransition(10);
                    return this.symbol((short)34);
                }
                case 67: {
                    continue block148;
                }
                case 29: {
                    this.restoreState();
                    this.saveStateAndTransition(4);
                }
                case 68: {
                    continue block148;
                }
                case 51: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)4);
                }
                case 69: {
                    continue block148;
                }
                case 15: {
                    return this.symbol((short)15);
                }
                case 70: {
                    continue block148;
                }
                case 11: {
                    this.error("Unexpected character in directive option list: " + this.yytext());
                    this.yybegin(0);
                }
                case 71: {
                    continue block148;
                }
                case 58: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)29);
                }
                case 72: {
                    continue block148;
                }
                case 6: {
                    this.error("Unexpected character in rule section: " + this.yytext());
                    this.yybegin(0);
                }
                case 73: {
                    continue block148;
                }
                case 33: {
                    ++this.nestingDepth;
                }
                case 74: {
                    continue block148;
                }
                case 43: {
                    return this.symbol((short)21);
                }
                case 75: {
                    continue block148;
                }
                case 20: {
                    return this.symbol((short)23);
                }
                case 76: {
                    continue block148;
                }
                case 27: {
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)37, this.blobBuf.toString());
                    this.restoreState();
                    this.saveStateAndTransition(2);
                    this.blobBuf = new StringBuffer();
                    this.markStartPosition();
                    return symbol;
                }
                case 77: {
                    continue block148;
                }
                case 17: {
                    return this.symbol((short)13, this.yytext());
                }
                case 78: {
                    continue block148;
                }
                case 14: {
                    this.saveStateAndTransition(6);
                    this.blobBuf = new StringBuffer(this.yytext());
                    this.markStartPosition();
                }
                case 79: {
                    continue block148;
                }
                case 13: {
                    return this.symbol((short)3, this.yytext());
                }
                case 80: {
                    continue block148;
                }
                case 48: {
                    this.blobBuf.append(this.yytext());
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)6, this.blobBuf.toString());
                    this.restoreState();
                    return symbol;
                }
                case 81: {
                    continue block148;
                }
                case 16: {
                    this.error("Unexpected character in meta-pattern: " + this.yytext());
                    this.yybegin(0);
                }
                case 82: {
                    continue block148;
                }
                case 28: {
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)38, LayoutScanner.frontChomp(this.blobBuf.toString()));
                    this.restoreState();
                    this.saveStateAndTransition(3);
                    return symbol;
                }
                case 83: {
                    continue block148;
                }
                case 25: {
                    return this.symbol((short)26);
                }
                case 84: {
                    continue block148;
                }
                case 31: 
                case 85: {
                    continue block148;
                }
                case 24: {
                    return this.symbol((short)28);
                }
                case 86: {
                    continue block148;
                }
                case 35: {
                    this.blobBuf.append(this.yytext().substring(1));
                }
                case 87: {
                    continue block148;
                }
                case 30: {
                    this.saveStateAndTransition(7);
                    this.blobBuf = new StringBuffer(this.yytext());
                    this.markStartPosition();
                }
                case 88: {
                    continue block148;
                }
                case 22: {
                    return this.symbol((short)30);
                }
                case 89: {
                    continue block148;
                }
                case 32: {
                    this.saveStateAndTransition(5);
                    ++this.nestingDepth;
                }
                case 90: {
                    continue block148;
                }
                case 44: {
                    this.saveStateAndTransition(8);
                    this.blobBuf = new StringBuffer(this.yytext());
                    this.markStartPosition();
                }
                case 91: {
                    continue block148;
                }
                case 54: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)25);
                }
                case 92: {
                    continue block148;
                }
                case 34: {
                    --this.nestingDepth;
                    if (this.nestingDepth == 0) {
                        this.restoreState();
                    }
                }
                case 93: {
                    continue block148;
                }
                case 1: {
                    this.error("Unexpected character: " + this.yytext());
                }
                case 94: {
                    continue block148;
                }
                case 3: {
                    this.error("Unexpected character in option section: " + this.yytext());
                    this.yybegin(0);
                }
                case 95: {
                    continue block148;
                }
                case 26: {
                    return this.symbol((short)24);
                }
                case 96: {
                    continue block148;
                }
                case 2: {
                    this.blobBuf.append(this.yytext());
                }
                case 97: {
                    continue block148;
                }
                case 47: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)32);
                }
                case 98: {
                    continue block148;
                }
                case 37: {
                    return this.symbol((short)14, this.yytext().substring(1, this.yylength() - 1));
                }
                case 99: {
                    continue block148;
                }
                case 59: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)10);
                }
                case 100: {
                    continue block148;
                }
                case 38: {
                    this.saveStateAndTransition(10);
                    return this.symbol((short)22);
                }
                case 101: {
                    continue block148;
                }
                case 55: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)17);
                }
                case 102: {
                    continue block148;
                }
                case 18: {
                    return this.symbol((short)27);
                }
                case 103: {
                    continue block148;
                }
                case 53: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)12);
                }
                case 104: {
                    continue block148;
                }
                case 36: {
                    this.blobBuf.append(this.yytext());
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)5, this.blobBuf.toString());
                    this.restoreState();
                    return symbol;
                }
                case 105: {
                    continue block148;
                }
                case 19: {
                    return this.symbol((short)19);
                }
                case 106: {
                    continue block148;
                }
                case 9: {
                    this.blobBuf.append(this.yytext());
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)33, this.blobBuf.toString());
                    this.restoreState();
                    return symbol;
                }
                case 107: {
                    continue block148;
                }
                case 56: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)11);
                }
                case 108: {
                    continue block148;
                }
                case 45: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)8);
                }
                case 109: {
                    continue block148;
                }
                case 23: {
                    return this.symbol((short)36);
                }
                case 110: {
                    continue block148;
                }
                case 60: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)9);
                }
                case 111: {
                    continue block148;
                }
                case 42: {
                    return this.symbol((short)20);
                }
                case 112: {
                    continue block148;
                }
                case 40: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)31);
                }
                case 113: {
                    continue block148;
                }
                case 7: 
                case 114: {
                    continue block148;
                }
                case 49: {
                    return this.symbol((short)7);
                }
                case 115: {
                    continue block148;
                }
                case 10: {
                    this.yybegin(0);
                    this.error("Incomplete escape sequence");
                }
                case 116: {
                    continue block148;
                }
                case 8: {
                    this.yybegin(0);
                    this.error("Unterminated string literal: '" + this.blobBuf + "'");
                }
                case 117: {
                    continue block148;
                }
                case 12: {
                    this.restoreState();
                }
                case 118: {
                    continue block148;
                }
                case 21: {
                    return this.symbol((short)18);
                }
                case 119: {
                    continue block148;
                }
                case 41: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)16);
                }
                case 120: {
                    continue block148;
                }
            }
            if (n3 == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 2: {
                        this.yybegin(0);
                        this.error("Unterminated inherited header section.");
                    }
                    case 244: {
                        continue block148;
                    }
                    case 5: {
                        this.yybegin(0);
                        if (this.nestingDepth != 0) {
                            this.error(this.nestingDepth + " levels of comments not closed");
                        }
                    }
                    case 245: {
                        continue block148;
                    }
                    case 9: {
                        this.yybegin(0);
                    }
                    case 246: {
                        continue block148;
                    }
                    case 7: {
                        this.yybegin(0);
                        this.error("Unterminated declaration region: '" + this.blobBuf + "'");
                    }
                    case 247: {
                        continue block148;
                    }
                    case 6: {
                        this.yybegin(0);
                        this.error("Unterminated string literal: '" + this.blobBuf + "'");
                    }
                    case 248: {
                        continue block148;
                    }
                    case 3: {
                        this.yybegin(0);
                    }
                    case 249: {
                        continue block148;
                    }
                    case 1: {
                        this.yybegin(0);
                        this.error("Unterminated local header section.");
                    }
                    case 250: {
                        continue block148;
                    }
                    case 0: {
                        return this.symbol((short)0);
                    }
                    case 251: {
                        continue block148;
                    }
                    case 10: {
                        this.yybegin(0);
                    }
                    case 252: {
                        continue block148;
                    }
                    case 8: {
                        this.yybegin(0);
                        this.error("Unterminated init region: '" + this.blobBuf + "'");
                    }
                    case 253: {
                        continue block148;
                    }
                    case 4: {
                        this.yybegin(0);
                    }
                    case 254: {
                        continue block148;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }

    private static class StateRecord {
        int stateNum;
        PositionRecord pos;

        StateRecord(int n, PositionRecord positionRecord) {
            this.stateNum = n;
            this.pos = positionRecord;
        }
    }

    private static class PositionRecord {
        int startLine = -1;
        int startCol = -1;
        int endLine = -1;
        int endCol = -1;

        private PositionRecord() {
        }
    }
}

