/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.PatternType;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Pattern;
import metalexer.jflex.CharacterAssigner;
import metalexer.jflex.PrintHelper;
import metalexer.jflex.ReturnWrap;
import metalexer.jflex.StaticFind;
import metalexer.jflex.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends ASTNode<ASTNode>
implements Cloneable {
    private char mtokCharValue;
    protected String tokenString_Action;
    public int Actionstart;
    public int Actionend;
    protected String tokenString_MetaToken;
    public int MetaTokenstart;
    public int MetaTokenend;
    protected int isMisclassified_visited = -1;
    protected int getMetaJFlexMTokName_visited = -1;
    protected int getStaticKeywordPositions_visited = -1;
    protected int containsStaticKeyword_visited = -1;
    protected int listStaticKeywordPositions_visited = -1;
    protected int getComponent_visited = -1;
    protected int getGroupPatternType_visited = -1;
    protected int getLexThrowsDecl_visited = -1;
    protected int getTokenType_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isMisclassified_visited = -1;
        this.getMetaJFlexMTokName_visited = -1;
        this.getStaticKeywordPositions_visited = -1;
        this.containsStaticKeyword_visited = -1;
        this.listStaticKeywordPositions_visited = -1;
        this.getComponent_visited = -1;
        this.getGroupPatternType_visited = -1;
        this.getLexThrowsDecl_visited = -1;
        this.getTokenType_visited = -1;
    }

    @Override
    public Rule clone() throws CloneNotSupportedException {
        Rule rule = (Rule)super.clone();
        rule.isMisclassified_visited = -1;
        rule.getMetaJFlexMTokName_visited = -1;
        rule.getStaticKeywordPositions_visited = -1;
        rule.containsStaticKeyword_visited = -1;
        rule.listStaticKeywordPositions_visited = -1;
        rule.getComponent_visited = -1;
        rule.getGroupPatternType_visited = -1;
        rule.getLexThrowsDecl_visited = -1;
        rule.getTokenType_visited = -1;
        rule.in$Circle(false);
        rule.is$Final(false);
        return rule;
    }

    public Rule copy() {
        try {
            Rule rule = this.clone();
            if (this.children != null) {
                rule.children = (ASTNode[])this.children.clone();
            }
            return rule;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Rule fullCopy() {
        Rule rule = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            rule.setChild(object, i);
        }
        return rule;
    }

    public char getMetaTokenCharValue() {
        return this.mtokCharValue;
    }

    @Override
    public void assignCharsToMetaTokens(CharacterAssigner characterAssigner) {
        this.mtokCharValue = characterAssigner.assignChar(this.getMetaJFlexMTokName());
        super.assignCharsToMetaTokens(characterAssigner);
    }

    public int printJFlexRule(PrintHelper printHelper, int n) throws IOException {
        Component component = this.getComponent();
        String string = component.getLayout().getJFlexStateObjectName();
        String string2 = component.getJFlexInnerClassInstanceName();
        String string3 = component.getJFlexActionMethodName(n);
        this.getPattern().printJFlexPattern(printHelper);
        printHelper.println(" {");
        printHelper.indent();
        printHelper.println("Maybe<" + this.getTokenType() + "> maybeResult = " + string + "." + string2 + "." + string3 + "();");
        String string4 = this.getMetaToken();
        if (string4 != null && string4.length() > 0) {
            printHelper.println("//System.err.println(\"processMTok(" + this.getMetaToken() + ")\");");
            printHelper.println(component.getLayout().getJFlexStateObjectName() + ".processMTok('" + Util.escapeChar(this.getMetaTokenCharValue()) + "'); //" + this.getMetaToken());
        }
        printHelper.println("if(maybeResult.isJust()) {");
        printHelper.indent();
        printHelper.println("return maybeResult.fromJust();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        return n + 1;
    }

    public int printJFlexActionMethod(PrintHelper printHelper, int n) throws IOException {
        String string = this.getComponent().getJFlexActionMethodName(n);
        printHelper.println("public Maybe<" + this.getTokenType() + "> " + string + "()" + this.getLexThrowsDecl() + " {");
        printHelper.indent();
        String string2 = this.getComponent().getLayout().getJFlexStateObjectName();
        String string3 = this.getComponent().getJFlexInnerClassInstanceName();
        String string4 = this.getComponent().getJFlexActionMethodName(n);
        printHelper.println("//System.err.println(\"" + string2 + "." + string3 + "." + string4 + "()\");");
        String string5 = this.getAction();
        String string6 = string5.substring(2, string5.length() - 2).trim();
        if (string6.length() > 0) {
            String string7 = ReturnWrap.wrapReturns(string6);
            printHelper.println("if(Object.class != null) {");
            printHelper.indent();
            this.printJFlexPosComment(printHelper, this.Actionstart);
            printHelper.println(string7);
            printHelper.dedent();
            printHelper.println("}");
        }
        printHelper.println("return Maybe.Nothing();");
        printHelper.dedent();
        printHelper.println("}");
        return n + 1;
    }

    public Rule() {
    }

    public Rule(Pattern pattern, String string, String string2) {
        this.setChild(pattern, 0);
        this.setAction(string);
        this.setMetaToken(string2);
    }

    public Rule(Pattern pattern, Symbol symbol, Symbol symbol2) {
        this.setChild(pattern, 0);
        this.setAction(symbol);
        this.setMetaToken(symbol2);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setPattern(Pattern pattern) {
        this.setChild(pattern, 0);
    }

    public Pattern getPattern() {
        return (Pattern)this.getChild(0);
    }

    public Pattern getPatternNoTransform() {
        return (Pattern)this.getChildNoTransform(0);
    }

    public void setAction(String string) {
        this.tokenString_Action = string;
    }

    public void setAction(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setAction is only valid for String lexemes");
        }
        this.tokenString_Action = (String)symbol.value;
        this.Actionstart = symbol.getStart();
        this.Actionend = symbol.getEnd();
    }

    public String getAction() {
        return this.tokenString_Action != null ? this.tokenString_Action : "";
    }

    public void setMetaToken(String string) {
        this.tokenString_MetaToken = string;
    }

    public void setMetaToken(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setMetaToken is only valid for String lexemes");
        }
        this.tokenString_MetaToken = (String)symbol.value;
        this.MetaTokenstart = symbol.getStart();
        this.MetaTokenend = symbol.getEnd();
    }

    public String getMetaToken() {
        return this.tokenString_MetaToken != null ? this.tokenString_MetaToken : "";
    }

    public boolean isMisclassified() {
        if (this.isMisclassified_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isMisclassified in class: ");
        }
        this.isMisclassified_visited = this.state().boundariesCrossed;
        boolean bl = this.isMisclassified_compute();
        this.isMisclassified_visited = -1;
        return bl;
    }

    private boolean isMisclassified_compute() {
        return this.getPattern().getType() != this.getGroupPatternType();
    }

    public String getMetaJFlexMTokName() {
        if (this.getMetaJFlexMTokName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexMTokName in class: ");
        }
        this.getMetaJFlexMTokName_visited = this.state().boundariesCrossed;
        String string = this.getMetaJFlexMTokName_compute();
        this.getMetaJFlexMTokName_visited = -1;
        return string;
    }

    private String getMetaJFlexMTokName_compute() {
        return "t_" + this.getMetaToken();
    }

    public List<StaticFind.Position> getStaticKeywordPositions() {
        if (this.getStaticKeywordPositions_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStaticKeywordPositions in class: ");
        }
        this.getStaticKeywordPositions_visited = this.state().boundariesCrossed;
        List<StaticFind.Position> list = this.getStaticKeywordPositions_compute();
        this.getStaticKeywordPositions_visited = -1;
        return list;
    }

    private List<StaticFind.Position> getStaticKeywordPositions_compute() {
        int n = this.Actionstart;
        int n2 = Rule.getLine(n);
        int n3 = Rule.getColumn(n);
        return StaticFind.findStaticKeywords(n2, n3, this.getAction());
    }

    public boolean containsStaticKeyword() {
        if (this.containsStaticKeyword_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: containsStaticKeyword in class: ");
        }
        this.containsStaticKeyword_visited = this.state().boundariesCrossed;
        boolean bl = this.containsStaticKeyword_compute();
        this.containsStaticKeyword_visited = -1;
        return bl;
    }

    private boolean containsStaticKeyword_compute() {
        return !this.getStaticKeywordPositions().isEmpty();
    }

    public String listStaticKeywordPositions() {
        if (this.listStaticKeywordPositions_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listStaticKeywordPositions in class: ");
        }
        this.listStaticKeywordPositions_visited = this.state().boundariesCrossed;
        String string = this.listStaticKeywordPositions_compute();
        this.listStaticKeywordPositions_visited = -1;
        return string;
    }

    private String listStaticKeywordPositions_compute() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (StaticFind.Position position : this.getStaticKeywordPositions()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append("[" + position.getLine() + ", " + position.getColumn() + "]");
        }
        return stringBuffer.toString();
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component component = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return component;
    }

    public PatternType getGroupPatternType() {
        if (this.getGroupPatternType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getGroupPatternType in class: ");
        }
        this.getGroupPatternType_visited = this.state().boundariesCrossed;
        PatternType patternType = this.getParent().Define_metalexer_PatternType_getGroupPatternType(this, null);
        this.getGroupPatternType_visited = -1;
        return patternType;
    }

    public String getLexThrowsDecl() {
        if (this.getLexThrowsDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLexThrowsDecl in class: ");
        }
        this.getLexThrowsDecl_visited = this.state().boundariesCrossed;
        String string = this.getParent().Define_String_getLexThrowsDecl(this, null);
        this.getLexThrowsDecl_visited = -1;
        return string;
    }

    public String getTokenType() {
        if (this.getTokenType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getTokenType in class: ");
        }
        this.getTokenType_visited = this.state().boundariesCrossed;
        String string = this.getParent().Define_String_getTokenType(this, null);
        this.getTokenType_visited = -1;
        return string;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component component;
        if (this.isMisclassified() && (component = this.getComponent()) != null) {
            component.Component_getErrors_contributors().add(this);
        }
        if (this.containsStaticKeyword() && (component = this.getComponent()) != null) {
            component.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_Component_listMetaTokens() {
        Component component;
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0 && (component = this.getComponent()) != null) {
            component.Component_listMetaTokens_contributors().add(this);
        }
        super.collect_contributors_Component_listMetaTokens();
    }

    @Override
    protected void collect_contributors_Component_listRules() {
        Component component = this.getComponent();
        if (component != null) {
            component.Component_listRules_contributors().add(this);
        }
        super.collect_contributors_Component_listRules();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Component_Component_getErrors(sortedSet);
        if (this.isMisclassified()) {
            sortedSet.add(this.makeCompilationError("Rule misclassified: " + (Object)((Object)this.getPattern().getType()) + " rule in " + (Object)((Object)this.getGroupPatternType()) + " section."));
        }
        if (this.containsStaticKeyword()) {
            sortedSet.add(this.makeCompilationError("(JFlex) Component code regions cannot contain the keyword 'static': " + this.listStaticKeywordPositions()));
        }
    }

    @Override
    protected void contributeTo_Component_Component_listMetaTokens(Set<String> set) {
        super.contributeTo_Component_Component_listMetaTokens(set);
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0) {
            set.add(this.getMetaToken());
        }
    }

    @Override
    protected void contributeTo_Component_Component_listRules(List<Rule> list) {
        super.contributeTo_Component_Component_listRules(list);
        list.add(this);
    }
}

