/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.Symbol;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ComponentParser;
import metalexer.ComponentScanner;
import metalexer.LayoutParser;
import metalexer.LayoutScanner;
import metalexer.ast.Component;
import metalexer.ast.ComponentWrapper;
import metalexer.ast.Layout;
import metalexer.ast.LayoutWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLoader {
    private final String baseDir;
    private final Map<String, Component> components;
    private final Map<String, Layout> layouts;

    public FileLoader(String string) {
        this.baseDir = string;
        this.components = new HashMap<String, Component>();
        this.layouts = new HashMap<String, Layout>();
    }

    public Component loadComponent(String string, SortedSet<CompilationError> sortedSet) throws IOException {
        if (this.components.containsKey(string)) {
            return this.components.get(string);
        }
        String string2 = this.baseDir + File.separator + string + ".mlc";
        BufferedReader bufferedReader = this.openFile(string2);
        ComponentScanner componentScanner = new ComponentScanner(bufferedReader);
        ComponentParser componentParser = new ComponentParser();
        componentParser.setFilename(string2);
        Component component = null;
        try {
            component = ((ComponentWrapper)componentParser.parse(componentScanner)).getComponent();
        }
        catch (Parser.Exception exception) {
            // empty catch block
        }
        sortedSet.addAll(componentParser.getErrors());
        this.components.put(string, component);
        if (component != null && !component.getName().equals(string)) {
            int n = component.Namestart;
            int n2 = Symbol.getLine(n);
            int n3 = Symbol.getColumn(n);
            sortedSet.add(new CompilationError(string2, n2, n3, "File name (" + string + ".mlc" + ") does not match component name (" + component.getName() + ")."));
        }
        return component;
    }

    public Layout loadLayout(String string, SortedSet<CompilationError> sortedSet) throws IOException {
        if (this.layouts.containsKey(string)) {
            return this.layouts.get(string);
        }
        String string2 = this.baseDir + File.separator + string + ".mll";
        BufferedReader bufferedReader = this.openFile(string2);
        LayoutScanner layoutScanner = new LayoutScanner(bufferedReader);
        LayoutParser layoutParser = new LayoutParser();
        layoutParser.setFilename(string2);
        Layout layout = null;
        try {
            layout = ((LayoutWrapper)layoutParser.parse(layoutScanner)).getLayout();
        }
        catch (Parser.Exception exception) {
            // empty catch block
        }
        sortedSet.addAll(layoutParser.getErrors());
        this.layouts.put(string, layout);
        if (layout != null && !layout.getName().equals(string)) {
            int n = layout.Namestart;
            int n2 = Symbol.getLine(n);
            int n3 = Symbol.getColumn(n);
            sortedSet.add(new CompilationError(string2, n2, n3, "File name (" + string + ".mll" + ") does not match layout name (" + layout.getName() + ")."));
        }
        return layout;
    }

    private BufferedReader openFile(String string) throws IOException {
        return new BufferedReader(new FileReader(string));
    }
}

