/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.IOException;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.FileLoader;
import metalexer.ast.Layout;
import metalexer.jflex.CharacterAssigner;
import metalexer.jflex.CharacterGenerator;

public class ML2JFlex {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("Usage: java ML2JFlex {layout} {indir} {outdir}");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        System.out.println("Checking " + string + " in " + string2);
        TreeSet<CompilationError> treeSet = new TreeSet<CompilationError>();
        Layout layout = null;
        try {
            FileLoader fileLoader = new FileLoader(string2);
            layout = fileLoader.loadLayout(string, treeSet);
            if (layout != null && (layout = layout.processInheritance(fileLoader, treeSet)).getHelper()) {
                treeSet.add(layout.makeCompilationError(layout.getName() + " is a helper layout."));
            }
        }
        catch (IOException iOException) {
            treeSet.add(new CompilationError(null, iOException.getMessage()));
        }
        if (treeSet.isEmpty()) {
            System.out.println("VALID");
            try {
                layout.tidyRuleGroups();
                layout.assignCharsToMetaTokens(new CharacterAssigner(new CharacterGenerator()));
                layout.generateJFlex(string3);
                layout.generateMetaJFlex(string3);
            }
            catch (IOException iOException) {
                System.out.println(new CompilationError(null, iOException.getMessage()));
            }
        } else {
            for (CompilationError compilationError : treeSet) {
                System.out.println(compilationError);
            }
        }
    }
}

