/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationProblem
implements Comparable<CompilationProblem> {
    private final String filename;
    private final int line;
    private final int col;
    private final String message;

    public CompilationProblem(String string, String string2) {
        this.filename = string;
        this.line = Integer.MAX_VALUE;
        this.col = Integer.MAX_VALUE;
        this.message = string2;
    }

    public CompilationProblem(String string, int n, int n2, String string2) {
        this.filename = string;
        this.line = n;
        this.col = n2;
        this.message = string2;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.line == Integer.MAX_VALUE && this.col == Integer.MAX_VALUE) {
            if (this.filename == null) {
                return this.message;
            }
            return this.filename + "  " + this.message;
        }
        if (this.filename == null) {
            throw new RuntimeException("Error has a position but not a filename: " + this.message + ".");
        }
        return this.filename + " [" + this.line + ", " + this.col + "]  " + this.message;
    }

    @Override
    public int compareTo(CompilationProblem compilationProblem) {
        if (compilationProblem == null) {
            return -1;
        }
        if (this.compare(this.filename, compilationProblem.filename) != 0) {
            return this.compare(this.filename, compilationProblem.filename);
        }
        if (this.line < compilationProblem.line) {
            return -1;
        }
        if (this.line > compilationProblem.line) {
            return 1;
        }
        if (this.col < compilationProblem.col) {
            return -1;
        }
        if (this.col > compilationProblem.col) {
            return 1;
        }
        return this.compare(this.message, compilationProblem.message);
    }

    public int compare(String string, String string2) {
        if (string == null && string2 != null) {
            return 1;
        }
        if (string != null && string2 == null) {
            return -1;
        }
        if (string == null && string2 == null) {
            return 0;
        }
        return string.compareTo(string2);
    }
}

