/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.AltMetaPattern;
import metalexer.ast.AnyMetaPattern;
import metalexer.ast.BOFMetaPattern;
import metalexer.ast.BaseMetaPattern;
import metalexer.ast.BodyElement;
import metalexer.ast.ClassMetaPattern;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Declaration;
import metalexer.ast.Embedding;
import metalexer.ast.EmbeddingRef;
import metalexer.ast.Extension;
import metalexer.ast.Layout;
import metalexer.ast.LayoutComponentDirective;
import metalexer.ast.LayoutDeclDirective;
import metalexer.ast.LayoutDeclRegion;
import metalexer.ast.LayoutDirective;
import metalexer.ast.LayoutHelperDirective;
import metalexer.ast.LayoutInitRegion;
import metalexer.ast.LayoutInitThrowDirective;
import metalexer.ast.LayoutLexThrowDirective;
import metalexer.ast.LayoutOptionDirective;
import metalexer.ast.LayoutStartDirective;
import metalexer.ast.LayoutWrapper;
import metalexer.ast.LexerOption;
import metalexer.ast.List;
import metalexer.ast.MTokPair;
import metalexer.ast.MTokRef;
import metalexer.ast.MetaPattern;
import metalexer.ast.Opt;
import metalexer.ast.OptMetaPattern;
import metalexer.ast.OptionBlob;
import metalexer.ast.OptionRef;
import metalexer.ast.PairItem;
import metalexer.ast.PlusMetaPattern;
import metalexer.ast.RegionMetaPattern;
import metalexer.ast.RegionPairItem;
import metalexer.ast.Replacement;
import metalexer.ast.SeqMetaPattern;
import metalexer.ast.StarMetaPattern;
import metalexer.ast.SymMetaPattern;
import metalexer.ast.SymPairItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutParser
extends Parser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjbtcyLLKLnzSvvo96AFSXWqz482KDXPZUm223888o28Y0FF0nPEQKDYYP5JbK6fdLf$v99S2AX003J5FHGee6pTAib11ngXISGIixVTVQ#vntpZltFZuV$wpkx$CxQvyrxEdik$VQ8gKTyOyTf9yCaKQ9P9IyNqwKu#BOwuV9uCJ7QngzBF6yqq6zYBvHXijG6I0dIVyMVUBZDOs#z6$u6mVp#fDqb8bfjDEFbNBYupMDllGu$BM3HVyn5#tqewKcyV6QmxmydETkXKnmCWlvhCw5bTnS398Zv7to6JH$LaWd2Stps$1fXNp8oInaZDMYfQIMhjHoEfe77AITMS#7y#FV6Pp#FT8vyV6QMZbUJf0FnFSwI6$f9HtalV46XRvvVJqjtfl31Y$lyTXWtxcBd2jzhLT7Ehr5tfE5ZFEbdtZyGI4zulM6Xu3fcUNngO$3UY$lzbXlRGvCsvpaz4JEJNqSTdbvbyTZ2faQRpJi0gOdSbxgux3HoqqU6#KirkCOv9Zu4OFfRQrioa9gVUb73j8G$rOXPnBvUuFJZvPF9JuUtXBlKSXHJkQmJS6QtHD$Lo4pfASS8#VXhVtOXhmmNRFc6$$KGIwIY#KI#QXSAfV9n#JZyWclFpf#Al7nkDz1PigIU3FMfoXfAxEzPJEuFuUj3gpGSsoEDiTFAAJPwxLlMtEupq4MoE9uY$IHaR9OccGHiSwo1ToNmuCAhLswoHduROdVLiYrLlk3qbtEJaTkll7F7EJpSWrpVQfyGRw4zyciIwS$HRwS#7ZyNI5rJkRmf4AkSZA7lnWIcSLEGoAp#9iXaLayev2hdSpXMKCYi$Yh8P5P$5CXLyiDyacvNAwGfNAbB9Fhv8lo5Vi7NI$BqxtaW#mbZSLLOllmUJP$VdRbgwA$2#Gq#KZy3mLlXHRYVob4dCpXW0BBWGBsAx3iB#1D1POt2tX3WUMD0bvNO7czWDSKM5uhu5K5bbSBU4M1vPK2NbPWURc0VGei#mhOgy2oju2N55XUAk151PON2tXUWUNv0bvGO7cXWESKM9uhu1q5bdSAU4k1vQq2jXjM6dvbM6LurB0zNgkGXMR5KuxrrfNnROQLs5V5gmshR7tDaG#hK2lFEmnOJVDzmssSAAlrr4At6kil5HPxY4pZ$U7uOJaKkSEGsDh7lp3yN46ascunt6h0XbQjtr5OpFJu5dHgNM6utQ3sTGfiDokGMAtNjyS$L51QfpkEpC7#FSEwU8tXPkm$KCWi6K6687XFizOaNkEaV0vhzZTPAlscLDGclq$3G4BoCCvxddtjFpo0$xl8ON8ukOS#EvEHT26VwCO#UYHUHqaFEPgTuPWqMhqYieRZKj#3HKkhQ5VEH$SYrtZtqVtOkVBHn$heA8tk9ILfnufeBuUI1#bgwKYSpaLPQjAv6CWEM4TMv6Aca5bepnQn9phDy0grH1LhcPRM4d4wQospgEKShtFzhaUJxtUdTDGj8vuafsUYNAIsc8#iQHLPQpxTEB5ThnggHfPRHJfPJkUjTzLPhjnczxJDmLKZAxSvybsrEOfdH9jHRcwBwx7rt2OhOq6ho6AR#SZ62ciWgRF6bqQHcqosthawU$BVpzUPH8mcanbB3Z9EndEsJk0qTH6Dp57bY8YT9B8vYgoL4LL7t19HjcSoula7ZHXk$Wr4HDH$ib#9RRSnbSosfOq#FcAkpAiICH4VdUk9qan9LuwB68gjKiImglDU$g#n3B5vw0EoUqcrLHBbrkfWRjOnjvEXPC3M0czLslw$vN$9KlNPALs9DPIJdLdBoTdLaxUqREkhLkfDuiSpZJTB4bEcpAc5hcUo8rhCJAjDTwuvM98#bCssCDiptZkb9r36hqMRwKCvtNLRHfFKaaZpHBPOQkoVLfl6rgOoqOnan#bdux9OZV6oBYdvz#bnXPyqLTAcrjcqSjCo7hpiGNH47Z2By1yNEmldmSNmMtIe2vnAUIQy0ZP3pTqqCzGyiHjy5jR1RVXU3o#3D$B#4B8zyZ5XYK3gBas4PqBgAnqY4kdjxIpyraCoNxaRkHk#BH9svlrno2qgOFw3$kYUGF8D0tAJy4IVO$Q2dAN11V0Pg9dxA3WVaa45t0E3Q$7l2dMCLq7ovE12fDekXlLm1xo1VlL5tebj5#KES13lcv3BuKsKdqREHNBdAJN19V0I#4t8s4kNOsDS0NUlW9jCwKfu3MLEb606VM1E8$GXxoNwNUeE6LEf7$QLw5bHuNOu578VZV2967#4JuHFr00PHpGTBe2C8reAhuDVXumjx87aPX2U19c7a6yMCZyXtp3KkU2xXL#39y1RuLgeytiNt4mito7YVX9gVxTGVXJoNKB67ErTvkPzX4fVrZxioxn$8obdoM#ob#EyNEGbVG$s#F8E9uEBl5nHgQw4BDsTY4VQycbfFrpRKWuwPFJ7yzXQz2yrytYoIbszVN$tPtGF#BfrtP$lrqgJrtNrSe2NIujr1dTuUOIN0pEsdLwkyN9t6#DSuNsML$DfY$fVykE$r8$nt5RrLsgpv6Ftjj6lhRu#$ItXXXDmrocn0mGmj0pYRCepAC#2GoWVZAFX63WMdaBCE3WUdWgRqKr0dcPvNm0ZRWS1#Kj01XEGimIMzzKXPniZpeW0XdOoBAGy4zPxpZM6eZlYLCgJEEscs8qjObSFZ0sCfn6fF0DEXWFX86F4xXd0a4mhW67A$hpdgJUym3ZC69APHR34VIw0eTtOfr6UPmp9X0K6qcGCXHq21jpasf5D1#o8IispzQuGS0S9x1uoalSHrBluFxQS2ye=");
    private String filename = null;
    private final SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public SortedSet<CompilationProblem> getProblems() {
        return Collections.unmodifiableSortedSet(this.problems);
    }

    public boolean hasProblem() {
        return !this.problems.isEmpty();
    }

    private CompilationError buildError(Symbol symbol, String string) {
        return new CompilationError(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationError buildError(Scanner.Exception exception, String string) {
        return new CompilationError(this.filename, exception.line, exception.column, string);
    }

    private CompilationWarning buildWarning(Symbol symbol, String string) {
        return new CompilationWarning(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationWarning buildWarning(Scanner.Exception exception, String string) {
        return new CompilationWarning(this.filename, exception.line, exception.column, string);
    }

    private static <T extends ASTNode<?>> List<T> makeListNode(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new List<T>().addAll(list);
    }

    private static <T extends ASTNode> List<T> nullToEmpty(List<T> list) {
        return list == null ? new List() : list;
    }

    private Layout makeLayout(Symbol symbol, Symbol symbol2, List<OptionBlob> list, List<BodyElement> list2) {
        Symbol symbol3 = null;
        boolean bl = false;
        Opt<CompRef> opt = new Opt<CompRef>();
        List<CompDecl> list3 = new List<CompDecl>();
        List<LexerOption> list4 = new List<LexerOption>();
        List<Declaration> list5 = new List<Declaration>();
        LinkedHashSet<StringSymbol> linkedHashSet = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet2 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet3 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet4 = new LinkedHashSet<StringSymbol>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<String> hashSet5 = new HashSet<String>();
        for (OptionBlob optionBlob : list) {
            Object object2;
            if (optionBlob instanceof LayoutDirective) {
                if (symbol3 == null) {
                    object2 = (LayoutDirective)optionBlob;
                    symbol3 = new Symbol(0, ((LayoutDirective)object2).Namestart, ((LayoutDirective)object2).Nameend, ((LayoutDirective)object2).getName());
                    continue;
                }
                this.problems.add(this.buildWarning(optionBlob, "Layout already has a name."));
                continue;
            }
            if (optionBlob instanceof LayoutStartDirective) {
                if (opt.getNumChild() == 0) {
                    opt = new Opt<CompRef>(((LayoutStartDirective)optionBlob).getStartComponent());
                    continue;
                }
                this.problems.add(this.buildWarning(optionBlob, "Layout already has a start component."));
                continue;
            }
            if (optionBlob instanceof LayoutHelperDirective) {
                if (bl) {
                    this.problems.add(this.buildWarning(optionBlob, "Layout has already been flagged as a helper layout."));
                }
                bl = true;
                continue;
            }
            if (optionBlob instanceof LayoutOptionDirective) {
                object2 = new LexerOption((LayoutOptionDirective)optionBlob);
                String string = ((LexerOption)object2).getName();
                if (hashSet2.contains(string)) {
                    this.problems.add(this.buildWarning((Symbol)object2, "Duplicate declaration of option " + string + "."));
                    continue;
                }
                list4.add((LexerOption)object2);
                hashSet2.add(string);
                continue;
            }
            if (optionBlob instanceof LayoutComponentDirective) {
                for (CompDecl compDecl : ((LayoutComponentDirective)optionBlob).getComponents()) {
                    String string = compDecl.getName();
                    if (hashSet.contains(string)) {
                        this.problems.add(this.buildWarning(compDecl, "Duplicate import of component " + string + "."));
                        continue;
                    }
                    list3.add(compDecl);
                    hashSet.add(string);
                }
                continue;
            }
            if (optionBlob instanceof LayoutDeclDirective) {
                object2 = ((LayoutDeclDirective)optionBlob).getDeclaration();
                String string = ((Declaration)object2).getText();
                if (hashSet3.contains(string)) {
                    this.problems.add(this.buildWarning((Symbol)object2, "Duplicate declaration."));
                    continue;
                }
                list5.add((Declaration)object2);
                hashSet3.add(string);
                continue;
            }
            if (optionBlob instanceof LayoutDeclRegion) {
                linkedHashSet.add(new StringSymbol(optionBlob, ((LayoutDeclRegion)optionBlob).getText()));
                continue;
            }
            if (optionBlob instanceof LayoutLexThrowDirective) {
                for (String string : ((LayoutLexThrowDirective)optionBlob).getExceptions()) {
                    if (hashSet4.contains(string)) {
                        this.problems.add(this.buildWarning(optionBlob, "Duplicate declaration of lex exception " + string + "."));
                        continue;
                    }
                    linkedHashSet2.add(new StringSymbol(optionBlob, string));
                    hashSet4.add(string);
                }
                continue;
            }
            if (optionBlob instanceof LayoutInitRegion) {
                linkedHashSet3.add(new StringSymbol(optionBlob, ((LayoutInitRegion)optionBlob).getText()));
                continue;
            }
            if (optionBlob instanceof LayoutInitThrowDirective) {
                for (String string : ((LayoutInitThrowDirective)optionBlob).getExceptions()) {
                    if (hashSet4.contains(string)) {
                        this.problems.add(this.buildWarning(optionBlob, "Duplicate declaration of init exception " + string + "."));
                        continue;
                    }
                    linkedHashSet4.add(new StringSymbol(optionBlob, string));
                    hashSet5.add(string);
                }
                continue;
            }
            throw new RuntimeException("Unexpected option blob type: " + optionBlob.getClass().getName());
        }
        return new Layout(symbol3, bl, symbol, symbol2, opt, list3, list4, list5, linkedHashSet, linkedHashSet2, linkedHashSet3, linkedHashSet4, list2);
    }

    public LayoutParser() {
        super(PARSING_TABLES);
        this.report = new Events();
    }

    @Override
    protected Symbol invokeReduceAction(int n, int n2) {
        switch (n) {
            case 0: {
                Symbol symbol = this._symbols[n2 + 1];
                Layout layout = (Layout)symbol.value;
                LayoutWrapper layoutWrapper = new LayoutWrapper(layout);
                layoutWrapper.setFilenameOnSubtreeNoTransform(this.filename);
                return layoutWrapper;
            }
            case 1: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol2 = this._symbols[n2 + 2];
                String string2 = (String)symbol2.value;
                Symbol symbol3 = this._symbols[n2 + 3];
                List list = (List)symbol3.value;
                Symbol symbol4 = this._symbols[n2 + 4];
                List list2 = (List)symbol4.value;
                return this.makeLayout(symbol, symbol2, list, list2);
            }
            case 2: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 3: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 6: {
                Symbol symbol = this._symbols[n2 + 1];
                LayoutDirective layoutDirective = (LayoutDirective)symbol.value;
                Symbol symbol5 = this._symbols[n2 + 2];
                ArrayList arrayList = (ArrayList)symbol5.value;
                OptionBlob[] optionBlobArray = arrayList == null ? new OptionBlob[]{} : arrayList.toArray(new OptionBlob[arrayList.size()]);
                List<LayoutDirective> list = LayoutParser.nullToEmpty(LayoutParser.makeListNode(arrayList));
                list.insertChild(layoutDirective, 0);
                return list;
            }
            case 7: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new LayoutDirective(symbol);
            }
            case 17: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new LayoutDeclRegion(string);
            }
            case 18: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new LayoutInitRegion(string);
            }
            case 19: {
                return new LayoutHelperDirective();
            }
            case 20: {
                Symbol symbol = this._symbols[n2 + 2];
                CompRef compRef = (CompRef)symbol.value;
                return new LayoutStartDirective(compRef);
            }
            case 21: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return new LayoutComponentDirective(list);
            }
            case 22: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new LayoutInitThrowDirective(list);
            }
            case 23: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new LayoutLexThrowDirective(list);
            }
            case 24: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new Declaration(string);
            }
            case 25: {
                Symbol symbol = this._symbols[n2 + 2];
                Declaration declaration = (Declaration)symbol.value;
                return new LayoutDeclDirective(declaration);
            }
            case 26: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                Symbol symbol6 = this._symbols[n2 + 3];
                String string3 = (String)symbol6.value;
                return new LayoutOptionDirective(string, string3);
            }
            case 27: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                return new Symbol(arrayList);
            }
            case 28: {
                Symbol symbol = this._symbols[n2 + 1];
                java.util.List list = (java.util.List)symbol.value;
                Symbol symbol7 = this._symbols[n2 + 3];
                String string = (String)symbol7.value;
                list.add(string);
                return symbol;
            }
            case 31: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new CompRef(symbol);
            }
            case 32: {
                Symbol symbol = this._symbols[n2 + 1];
                CompRef compRef = (CompRef)symbol.value;
                return new List<CompRef>().add(compRef);
            }
            case 33: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol8 = this._symbols[n2 + 3];
                CompRef compRef = (CompRef)symbol8.value;
                return list.add(compRef);
            }
            case 34: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new CompDecl(symbol, new Opt<Component>());
            }
            case 35: {
                Symbol symbol = this._symbols[n2 + 1];
                CompDecl compDecl = (CompDecl)symbol.value;
                return new List<CompDecl>().add(compDecl);
            }
            case 36: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol9 = this._symbols[n2 + 3];
                CompDecl compDecl = (CompDecl)symbol9.value;
                return list.add(compDecl);
            }
            case 37: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 38: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 41: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                BodyElement[] bodyElementArray = arrayList == null ? new BodyElement[]{} : arrayList.toArray(new BodyElement[arrayList.size()]);
                return LayoutParser.nullToEmpty(LayoutParser.makeListNode(arrayList));
            }
            case 44: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 45: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 48: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                Symbol symbol10 = this._symbols[n2 + 4];
                List list = (List)symbol10.value;
                Symbol symbol11 = this._symbols[n2 + 6];
                CompRef compRef = (CompRef)symbol11.value;
                Symbol symbol12 = this._symbols[n2 + 8];
                MetaPattern metaPattern = (MetaPattern)symbol12.value;
                Symbol symbol13 = this._symbols[n2 + 10];
                MetaPattern metaPattern2 = (MetaPattern)symbol13.value;
                Symbol symbol14 = this._symbols[n2 + 11];
                ArrayList arrayList = (ArrayList)symbol14.value;
                MTokPair[] mTokPairArray = arrayList == null ? new MTokPair[]{} : arrayList.toArray(new MTokPair[arrayList.size()]);
                return new Embedding(string, (List<CompRef>)list, compRef, metaPattern, metaPattern2, LayoutParser.nullToEmpty(LayoutParser.makeListNode(arrayList)));
            }
            case 49: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return list;
            }
            case 50: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol15 = this._symbols[n2 + 3];
                List list3 = (List)symbol15.value;
                return list.addAll(list3);
            }
            case 51: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new MTokRef(symbol);
            }
            case 52: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new MTokRef(symbol);
            }
            case 53: {
                Symbol symbol = this._symbols[n2 + 2];
                PairItem pairItem = (PairItem)symbol.value;
                Symbol symbol16 = this._symbols[n2 + 4];
                PairItem pairItem2 = (PairItem)symbol16.value;
                return new MTokPair(pairItem, pairItem2);
            }
            case 54: {
                Symbol symbol = this._symbols[n2 + 1];
                CompRef compRef = (CompRef)symbol.value;
                return new RegionPairItem(compRef);
            }
            case 55: {
                Symbol symbol = this._symbols[n2 + 1];
                MTokRef mTokRef = (MTokRef)symbol.value;
                return new SymPairItem(mTokRef);
            }
            case 56: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new CompRef(symbol);
            }
            case 57: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new MTokRef(symbol);
            }
            case 60: {
                Symbol symbol = this._symbols[n2 + 1];
                MetaPattern metaPattern = (MetaPattern)symbol.value;
                Symbol symbol17 = this._symbols[n2 + 3];
                MetaPattern metaPattern3 = (MetaPattern)symbol17.value;
                return new AltMetaPattern(metaPattern, metaPattern3);
            }
            case 62: {
                Symbol symbol = this._symbols[n2 + 1];
                MetaPattern metaPattern = (MetaPattern)symbol.value;
                Symbol symbol18 = this._symbols[n2 + 2];
                MetaPattern metaPattern4 = (MetaPattern)symbol18.value;
                return new SeqMetaPattern(metaPattern, metaPattern4);
            }
            case 64: {
                Symbol symbol = this._symbols[n2 + 1];
                MetaPattern metaPattern = (MetaPattern)symbol.value;
                return new OptMetaPattern(metaPattern);
            }
            case 65: {
                Symbol symbol = this._symbols[n2 + 1];
                MetaPattern metaPattern = (MetaPattern)symbol.value;
                return new StarMetaPattern(metaPattern);
            }
            case 66: {
                Symbol symbol = this._symbols[n2 + 1];
                MetaPattern metaPattern = (MetaPattern)symbol.value;
                return new PlusMetaPattern(metaPattern);
            }
            case 69: {
                return new AnyMetaPattern();
            }
            case 70: {
                return new BOFMetaPattern();
            }
            case 72: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new RegionMetaPattern(new CompRef(symbol));
            }
            case 73: {
                Symbol symbol = this._symbols[n2 + 1];
                MTokRef mTokRef = (MTokRef)symbol.value;
                return new SymMetaPattern(mTokRef);
            }
            case 74: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 75: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 76: {
                Symbol symbol = this._symbols[n2 + 2];
                ArrayList arrayList = (ArrayList)symbol.value;
                BaseMetaPattern[] baseMetaPatternArray = arrayList == null ? new BaseMetaPattern[]{} : arrayList.toArray(new BaseMetaPattern[arrayList.size()]);
                return new ClassMetaPattern(false, LayoutParser.nullToEmpty(LayoutParser.makeListNode(arrayList)));
            }
            case 77: {
                Symbol symbol = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol.value;
                BaseMetaPattern[] baseMetaPatternArray = arrayList == null ? new BaseMetaPattern[]{} : arrayList.toArray(new BaseMetaPattern[arrayList.size()]);
                return new ClassMetaPattern(true, LayoutParser.nullToEmpty(LayoutParser.makeListNode(arrayList)));
            }
            case 78: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 79: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 82: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 83: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 86: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 87: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 90: {
                String string;
                Symbol symbol = this._symbols[n2 + 2];
                String string4 = (String)symbol.value;
                Symbol symbol19 = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol19.value;
                List[] listArray = arrayList == null ? new List[]{} : arrayList.toArray(new List[arrayList.size()]);
                Symbol symbol20 = this._symbols[n2 + 4];
                ArrayList arrayList2 = (ArrayList)symbol20.value;
                Replacement[] replacementArray = arrayList2 == null ? new Replacement[]{} : arrayList2.toArray(new Replacement[arrayList2.size()]);
                Symbol symbol21 = this._symbols[n2 + 5];
                ArrayList arrayList3 = (ArrayList)symbol21.value;
                List[] listArray2 = arrayList3 == null ? new List[]{} : arrayList3.toArray(new List[arrayList3.size()]);
                HashSet<String> hashSet = new HashSet<String>();
                List<OptionRef> list = new List<OptionRef>();
                for (List list4 : listArray) {
                    for (OptionRef aSTNode : list4) {
                        string = aSTNode.getName();
                        if (hashSet.contains(string)) {
                            this.problems.add(this.buildWarning(aSTNode, "Duplicate deletion of option " + string + "."));
                            continue;
                        }
                        list.add(aSTNode);
                        hashSet.add(string);
                    }
                }
                HashSet hashSet2 = new HashSet();
                List<Replacement> list5 = new List<Replacement>();
                for (Replacement replacement : replacementArray) {
                    string = replacement.getOld().getName();
                    if (hashSet2.contains(string)) {
                        this.problems.add(this.buildWarning(replacement, "Duplicate replacement of component " + string + "."));
                        continue;
                    }
                    list5.add(replacement);
                    hashSet2.add(string);
                }
                HashSet hashSet3 = new HashSet();
                List<EmbeddingRef> list6 = new List<EmbeddingRef>();
                for (List list2 : listArray2) {
                    for (EmbeddingRef embeddingRef : list2) {
                        String string2 = embeddingRef.getName();
                        if (hashSet3.contains(string2)) {
                            this.problems.add(this.buildWarning(embeddingRef, "Duplicate deletion of embedding " + string2 + "."));
                            continue;
                        }
                        list6.add(embeddingRef);
                        hashSet3.add(string2);
                    }
                }
                return new Extension(string4, list, list5, list6);
            }
            case 91: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new OptionRef(symbol);
            }
            case 92: {
                Symbol symbol = this._symbols[n2 + 1];
                OptionRef optionRef = (OptionRef)symbol.value;
                return new List<OptionRef>().add(optionRef);
            }
            case 93: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol22 = this._symbols[n2 + 3];
                OptionRef optionRef = (OptionRef)symbol22.value;
                return list.add(optionRef);
            }
            case 95: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new EmbeddingRef(symbol);
            }
            case 96: {
                Symbol symbol = this._symbols[n2 + 1];
                EmbeddingRef embeddingRef = (EmbeddingRef)symbol.value;
                return new List<EmbeddingRef>().add(embeddingRef);
            }
            case 97: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol23 = this._symbols[n2 + 3];
                EmbeddingRef embeddingRef = (EmbeddingRef)symbol23.value;
                return list.add(embeddingRef);
            }
            case 99: {
                Symbol symbol = this._symbols[n2 + 2];
                CompRef compRef = (CompRef)symbol.value;
                Symbol symbol24 = this._symbols[n2 + 4];
                CompRef compRef2 = (CompRef)symbol24.value;
                return new Replacement(compRef, compRef2);
            }
            case 4: 
            case 39: 
            case 46: 
            case 80: 
            case 84: 
            case 88: {
                return new Symbol(null);
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 29: 
            case 30: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 67: 
            case 68: 
            case 81: 
            case 85: 
            case 89: {
                return this._symbols[n2 + 1];
            }
            case 71: 
            case 94: 
            case 98: {
                return this._symbols[n2 + 2];
            }
        }
        throw new IllegalArgumentException("unknown production #" + n);
    }

    class Events
    extends Parser.Events {
        Events() {
        }

        public void syntaxError(Symbol symbol) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(symbol, "unexpected token " + Terminals.NAMES[symbol.getId()]));
        }

        public void scannerError(Scanner.Exception exception) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(exception, "scanner error: " + exception.getMessage()));
        }

        public void unexpectedTokenRemoved(Symbol symbol) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(symbol, "try deleting " + Terminals.NAMES[symbol.getId()]));
        }

        public void missingTokenInserted(Symbol symbol) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(symbol, "try inserting " + Terminals.NAMES[symbol.getId()]));
        }

        public void misspelledTokenReplaced(Symbol symbol) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(symbol, "try replacing with " + Terminals.NAMES[symbol.getId()]));
        }
    }

    public static class Terminals {
        public static final short EOF = 0;
        public static final short START_EMBED_GROUP = 1;
        public static final short START_INHERIT_GROUP = 2;
        public static final short IDENTIFIER = 3;
        public static final short OPTION_DIRECTIVE = 4;
        public static final short DECL_REGION = 5;
        public static final short INIT_REGION = 6;
        public static final short HELPER_DIRECTIVE = 7;
        public static final short START_DIRECTIVE = 8;
        public static final short COMPONENT_DIRECTIVE = 9;
        public static final short INITTHROW_DIRECTIVE = 10;
        public static final short LEXTHROW_DIRECTIVE = 11;
        public static final short DECLARE_DIRECTIVE = 12;
        public static final short MP_SYM = 13;
        public static final short MP_REGION = 14;
        public static final short EMBEDDING_PAIR = 15;
        public static final short COMMA = 16;
        public static final short INHERIT_UNEMBED = 17;
        public static final short MP_LSQUARE = 18;
        public static final short MP_LPAREN = 19;
        public static final short MP_ANY = 20;
        public static final short MP_BOF = 21;
        public static final short EMBEDDING_END = 22;
        public static final short MP_RPAREN = 23;
        public static final short MP_OR = 24;
        public static final short INHERIT_REPLACE = 25;
        public static final short MP_OPT = 26;
        public static final short MP_STAR = 27;
        public static final short MP_PLUS = 28;
        public static final short INHERIT_UNOPTION = 29;
        public static final short MP_RSQUARE = 30;
        public static final short EMBEDDING_HOST = 31;
        public static final short EMBEDDING_GUEST = 32;
        public static final short STRING = 33;
        public static final short EMBEDDING_START = 34;
        public static final short EMBEDDING_NAME = 35;
        public static final short MP_CARET = 36;
        public static final short LOCAL_HEADER = 37;
        public static final short INHERITED_HEADER = 38;
        public static final short LAYOUT_DIRECTIVE = 39;
        public static final String[] NAMES = new String[]{"EOF", "START_EMBED_GROUP", "START_INHERIT_GROUP", "IDENTIFIER", "OPTION_DIRECTIVE", "DECL_REGION", "INIT_REGION", "HELPER_DIRECTIVE", "START_DIRECTIVE", "COMPONENT_DIRECTIVE", "INITTHROW_DIRECTIVE", "LEXTHROW_DIRECTIVE", "DECLARE_DIRECTIVE", "MP_SYM", "MP_REGION", "EMBEDDING_PAIR", "COMMA", "INHERIT_UNEMBED", "MP_LSQUARE", "MP_LPAREN", "MP_ANY", "MP_BOF", "EMBEDDING_END", "MP_RPAREN", "MP_OR", "INHERIT_REPLACE", "MP_OPT", "MP_STAR", "MP_PLUS", "INHERIT_UNOPTION", "MP_RSQUARE", "EMBEDDING_HOST", "EMBEDDING_GUEST", "STRING", "EMBEDDING_START", "EMBEDDING_NAME", "MP_CARET", "LOCAL_HEADER", "INHERITED_HEADER", "LAYOUT_DIRECTIVE"};
    }
}

