/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.FileLoader;
import metalexer.StringEval;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.ASTNode$State;
import metalexer.ast.BodyElement;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Declaration;
import metalexer.ast.Embedding;
import metalexer.ast.EmbeddingRef;
import metalexer.ast.Extension;
import metalexer.ast.LayoutWrapper;
import metalexer.ast.LexerOption;
import metalexer.ast.List;
import metalexer.ast.MTokPair;
import metalexer.ast.MTokRef;
import metalexer.ast.Opt;
import metalexer.ast.OptionRef;
import metalexer.ast.RegionMetaPattern;
import metalexer.ast.Replacement;
import metalexer.jflex.PackageFind;
import metalexer.jflex.PrintHelper;
import metalexer.jflex.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout
extends ASTNode<ASTNode>
implements Cloneable {
    private static final Comparator<MTokRef> mtokRefComparator = new Comparator<MTokRef>(){

        @Override
        public int compare(MTokRef mTokRef, MTokRef mTokRef2) {
            return mTokRef.getName().compareTo(mTokRef2.getName());
        }
    };
    private static final Comparator<RegionMetaPattern> regionComparator = new Comparator<RegionMetaPattern>(){

        @Override
        public int compare(RegionMetaPattern regionMetaPattern, RegionMetaPattern regionMetaPattern2) {
            return regionMetaPattern.getRegion().getName().compareTo(regionMetaPattern2.getRegion().getName());
        }
    };
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected boolean tokenboolean_Helper;
    protected String tokenString_LocalHeader;
    public int LocalHeaderstart;
    public int LocalHeaderend;
    protected String tokenString_InheritedHeader;
    public int InheritedHeaderstart;
    public int InheritedHeaderend;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__DeclRegions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__InitRegions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__InitExceptions;
    private boolean collect_contributors_Layout_listMetaTokens = false;
    private boolean collect_contributors_Layout_listRegions = false;
    protected int getActiveComponents_visited = -1;
    protected Map lookupCompDecls_String_visited;
    protected Map lookupEmbeddings_String_visited;
    protected int getEmbeddings_visited = -1;
    protected Map lookupExternDecls_String_visited;
    protected Map getEmbeddingsWithHost_CompRef_visited;
    protected int getGuestCompMap_visited = -1;
    protected int getHostCompMap_visited = -1;
    protected int getMetaJFlexPackage_visited = -1;
    protected int getJFlexStateClassName_visited = -1;
    protected int getJFlexStateObjectName_visited = -1;
    protected int getMetaJFlexLexerClassName_visited = -1;
    protected Map getOptionValue_String_String_visited;
    protected int getInitialPureBOFSequence_visited = -1;
    protected int getLexThrowsDecl_visited = -1;
    protected int getTokenType_visited = -1;
    protected int Layout_getErrors_visited = -1;
    protected boolean Layout_getErrors_computed = false;
    protected SortedSet<CompilationError> Layout_getErrors_value;
    Set Layout_getErrors_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_listMetaTokens_visited = -1;
    protected boolean Layout_listMetaTokens_computed = false;
    protected Set<MTokRef> Layout_listMetaTokens_value;
    Set Layout_listMetaTokens_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_getWarnings_visited = -1;
    protected boolean Layout_getWarnings_computed = false;
    protected SortedSet<CompilationWarning> Layout_getWarnings_value;
    Set Layout_getWarnings_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_getReferencedComponents_visited = -1;
    protected boolean Layout_getReferencedComponents_computed = false;
    protected java.util.List<CompDecl> Layout_getReferencedComponents_value;
    Set Layout_getReferencedComponents_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_listRegions_visited = -1;
    protected boolean Layout_listRegions_computed = false;
    protected Set<RegionMetaPattern> Layout_listRegions_value;
    Set Layout_listRegions_contributors = new ASTNode$State.IdentityHashSet(4);

    @Override
    public void flushCache() {
        super.flushCache();
        this.getActiveComponents_visited = -1;
        this.lookupCompDecls_String_visited = new HashMap(4);
        this.lookupEmbeddings_String_visited = new HashMap(4);
        this.getEmbeddings_visited = -1;
        this.lookupExternDecls_String_visited = new HashMap(4);
        this.getEmbeddingsWithHost_CompRef_visited = new HashMap(4);
        this.getGuestCompMap_visited = -1;
        this.getHostCompMap_visited = -1;
        this.getMetaJFlexPackage_visited = -1;
        this.getJFlexStateClassName_visited = -1;
        this.getJFlexStateObjectName_visited = -1;
        this.getMetaJFlexLexerClassName_visited = -1;
        this.getOptionValue_String_String_visited = new HashMap(4);
        this.getInitialPureBOFSequence_visited = -1;
        this.getLexThrowsDecl_visited = -1;
        this.getTokenType_visited = -1;
        this.Layout_getErrors_visited = -1;
        this.Layout_getErrors_computed = false;
        this.Layout_getErrors_value = null;
        this.Layout_getErrors_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_listMetaTokens_visited = -1;
        this.Layout_listMetaTokens_computed = false;
        this.Layout_listMetaTokens_value = null;
        this.Layout_listMetaTokens_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_getWarnings_visited = -1;
        this.Layout_getWarnings_computed = false;
        this.Layout_getWarnings_value = null;
        this.Layout_getWarnings_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_getReferencedComponents_visited = -1;
        this.Layout_getReferencedComponents_computed = false;
        this.Layout_getReferencedComponents_value = null;
        this.Layout_getReferencedComponents_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_listRegions_visited = -1;
        this.Layout_listRegions_computed = false;
        this.Layout_listRegions_value = null;
        this.Layout_listRegions_contributors = new ASTNode$State.IdentityHashSet(4);
        this.collect_contributors_Layout_listMetaTokens = false;
        this.collect_contributors_Layout_listRegions = false;
    }

    @Override
    public Layout clone() throws CloneNotSupportedException {
        Layout layout = (Layout)super.clone();
        layout.getActiveComponents_visited = -1;
        layout.lookupCompDecls_String_visited = new HashMap(4);
        layout.lookupEmbeddings_String_visited = new HashMap(4);
        layout.getEmbeddings_visited = -1;
        layout.lookupExternDecls_String_visited = new HashMap(4);
        layout.getEmbeddingsWithHost_CompRef_visited = new HashMap(4);
        layout.getGuestCompMap_visited = -1;
        layout.getHostCompMap_visited = -1;
        layout.getMetaJFlexPackage_visited = -1;
        layout.getJFlexStateClassName_visited = -1;
        layout.getJFlexStateObjectName_visited = -1;
        layout.getMetaJFlexLexerClassName_visited = -1;
        layout.getOptionValue_String_String_visited = new HashMap(4);
        layout.getInitialPureBOFSequence_visited = -1;
        layout.getLexThrowsDecl_visited = -1;
        layout.getTokenType_visited = -1;
        layout.in$Circle(false);
        layout.is$Final(false);
        return layout;
    }

    public Layout copy() {
        try {
            Layout layout = this.clone();
            if (this.children != null) {
                layout.children = (ASTNode[])this.children.clone();
            }
            return layout;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Layout fullCopy() {
        Layout layout = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            layout.setChild(object, i);
        }
        return layout;
    }

    public void deleteUnusedDeclarations() {
        List<CompDecl> list = new List<CompDecl>();
        for (CompDecl compDecl : this.getComponents()) {
            if (!compDecl.hasComponent()) continue;
            list.add(compDecl);
            compDecl.getComponent().deleteUnusedDeclarations();
        }
        this.setComponentList(list);
    }

    public Layout processInheritance(FileLoader fileLoader, SortedSet<CompilationProblem> sortedSet) {
        return this.processInheritance(fileLoader, new Stack<String>(), sortedSet);
    }

    private Layout processInheritance(FileLoader fileLoader, Stack<String> stack, SortedSet<CompilationProblem> sortedSet) {
        Layout layout = new LayoutWrapper(this.fullCopy()).getLayout();
        return Layout.processInheritance(layout, fileLoader, stack, sortedSet);
    }

    private static Layout processInheritance(Layout layout, FileLoader fileLoader, Stack<String> stack, SortedSet<CompilationProblem> sortedSet) {
        stack.push(layout.getName());
        List<BodyElement> list = new List<BodyElement>();
        for (BodyElement bodyElement : layout.getBodyElements()) {
            if (bodyElement instanceof Embedding) {
                list.add(bodyElement);
                continue;
            }
            if (bodyElement instanceof Extension) {
                Serializable serializable;
                String string;
                Extension extension = (Extension)bodyElement;
                Layout layout2 = null;
                try {
                    layout2 = fileLoader.loadLayout(extension.getLayoutName(), sortedSet);
                }
                catch (IOException iOException) {
                    sortedSet.add(extension.makeCompilationError(iOException.getMessage()));
                }
                if (layout2 == null) {
                    string = "Cannot process layout " + layout.getName() + " until layout " + extension.getLayoutName() + " is available.";
                    sortedSet.add(extension.makeCompilationError(string));
                    continue;
                }
                string = layout2.getName();
                if (stack.contains(string)) {
                    serializable = new StringBuffer("Cyclic inheritance detected: ");
                    boolean bl = true;
                    boolean bl2 = false;
                    for (String string2 : stack) {
                        if (string2.equals(string)) {
                            bl2 = true;
                            ((StringBuffer)serializable).append(string2);
                            bl = false;
                            continue;
                        }
                        if (!bl2 || bl) continue;
                        ((StringBuffer)serializable).append(", ");
                        ((StringBuffer)serializable).append(string2);
                    }
                    sortedSet.add(extension.makeCompilationError(((StringBuffer)serializable).toString()));
                    continue;
                }
                layout2 = layout2.processInheritance(fileLoader, stack, sortedSet);
                layout2.processReplacements(extension.getReplacements(), sortedSet);
                serializable = new HashMap();
                for (EmbeddingRef embeddingRef : extension.getDeletedEmbeddings()) {
                    serializable.put(embeddingRef.getName(), embeddingRef);
                }
                HashSet hashSet = new HashSet();
                for (BodyElement bodyElement2 : layout2.getBodyElements()) {
                    if (bodyElement2 instanceof Embedding) {
                        Embedding embedding = (Embedding)bodyElement2;
                        String string3 = embedding.getName();
                        if (serializable.containsKey(string3)) {
                            hashSet.add(serializable.get(string3));
                            continue;
                        }
                        list.add(embedding);
                        continue;
                    }
                    throw new RuntimeException("Parent still has non-Embedding BodyElements: " + bodyElement2.getClass().getName());
                }
                for (EmbeddingRef embeddingRef : extension.getDeletedEmbeddings()) {
                    if (hashSet.contains(embeddingRef)) continue;
                    sortedSet.add(embeddingRef.makeCompilationWarning("Unembed has no effect."));
                }
                layout.setInheritedHeader(layout.getInheritedHeader() + layout2.getInheritedHeader());
                Layout.appendDistinctComponents(layout.getComponents(), layout2.getComponents(), sortedSet);
                Layout.appendDistinctOptions(layout.getOptions(), layout2.getOptions(), extension.getDeletedOptions(), sortedSet);
                Layout.appendDistinctDecls(layout.getDecls(), layout2.getDecls(), sortedSet);
                Layout.appendDistinctStringSymbols(layout.getYylexExceptions(), layout2.getYylexExceptions(), sortedSet);
                Layout.appendDistinctStringSymbols(layout.getInitExceptions(), layout2.getInitExceptions(), sortedSet);
                layout.getDeclRegions().addAll(layout2.getDeclRegions());
                layout.getInitRegions().addAll(layout2.getInitRegions());
                continue;
            }
            throw new RuntimeException("Unexpected body element type: " + bodyElement.getClass().getName());
        }
        layout.setBodyElementList(list);
        layout.fetchComponents(fileLoader, sortedSet);
        sortedSet.addAll(layout.getErrors());
        sortedSet.addAll(layout.getWarnings());
        stack.pop();
        return layout;
    }

    private static void appendDistinctComponents(List<CompDecl> list, List<CompDecl> list2, SortedSet<CompilationProblem> sortedSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (CompDecl compDecl : list) {
            hashSet.add(compDecl.getName());
        }
        for (CompDecl compDecl : list2) {
            if (hashSet.contains(compDecl.getName())) continue;
            list.add(compDecl);
        }
    }

    private static void appendDistinctOptions(List<LexerOption> list, List<LexerOption> list2, List<OptionRef> list3, SortedSet<CompilationProblem> sortedSet) {
        HashMap<String, LexerOption> hashMap = new HashMap<String, LexerOption>();
        HashMap<String, OptionRef> hashMap2 = new HashMap<String, OptionRef>();
        HashSet hashSet = new HashSet();
        for (LexerOption aSTNode : list) {
            hashMap.put(aSTNode.getName(), aSTNode);
        }
        for (OptionRef optionRef : list3) {
            hashMap2.put(optionRef.getName(), optionRef);
        }
        for (LexerOption lexerOption : list2) {
            String string = lexerOption.getName();
            if (hashMap.containsKey(string)) {
                sortedSet.add(((LexerOption)hashMap.get(string)).makeCompilationWarning("Clobbering option from " + lexerOption.getFilename() + "."));
                continue;
            }
            if (hashMap2.containsKey(string)) {
                hashSet.add(hashMap2.get(string));
                continue;
            }
            list.add(lexerOption);
        }
        for (OptionRef optionRef : list3) {
            if (hashSet.contains(optionRef)) continue;
            sortedSet.add(optionRef.makeCompilationWarning("Unoption has no effect."));
        }
    }

    private static void appendDistinctDecls(List<Declaration> list, List<Declaration> list2, SortedSet<CompilationProblem> sortedSet) {
        block0: for (Declaration declaration : list2) {
            for (Declaration declaration2 : list) {
                if (!declaration.getText().equals(declaration2.getText())) continue;
                continue block0;
            }
            list.add(declaration);
        }
    }

    private static void appendDistinctStringSymbols(Set<StringSymbol> set, Set<StringSymbol> set2, SortedSet<CompilationProblem> sortedSet) {
        block0: for (StringSymbol stringSymbol : set2) {
            for (StringSymbol stringSymbol2 : set) {
                if (!stringSymbol.getText().equals(stringSymbol2.getText())) continue;
                continue block0;
            }
            set.add(stringSymbol);
        }
    }

    private void fetchComponents(FileLoader fileLoader, SortedSet<CompilationProblem> sortedSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (CompDecl compDecl : this.getReferencedComponents()) {
            String string = compDecl.getName();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            Component component = null;
            try {
                component = fileLoader.loadComponent(string, sortedSet);
            }
            catch (IOException iOException) {
                sortedSet.add(compDecl.makeCompilationError(iOException.getMessage()));
            }
            if (component == null) {
                String string2 = "Cannot process layout " + this.getName() + " until component " + string + " is available.";
                sortedSet.add(compDecl.makeCompilationError(string2));
                return;
            }
            component = component.processInheritance(fileLoader, sortedSet);
            compDecl.setComponent(component);
        }
    }

    private void processReplacements(List<Replacement> list, SortedSet<CompilationProblem> sortedSet) {
        HashMap<String, Replacement> hashMap = new HashMap<String, Replacement>();
        for (Replacement object : list) {
            hashMap.put(object.getOld().getName(), object);
        }
        Set<Replacement> set = this.replaceComponents(hashMap);
        for (Replacement replacement : list) {
            if (set.contains(replacement)) continue;
            sortedSet.add(replacement.makeCompilationWarning("Replacement has no effect."));
        }
    }

    public void tidyRuleGroups() {
        for (Component component : this.getActiveComponents()) {
            component.tidyRuleGroups();
        }
    }

    private Map<String, java.util.List<Embedding>> buildHostCompMap() {
        HashMap<String, java.util.List<Embedding>> hashMap = new HashMap<String, java.util.List<Embedding>>();
        for (Embedding embedding : this.getEmbeddings()) {
            for (CompRef compRef : embedding.getHosts()) {
                String string = compRef.getName();
                ArrayList<Embedding> arrayList = (ArrayList<Embedding>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Embedding>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(embedding);
            }
        }
        return hashMap;
    }

    private Map<String, java.util.List<Embedding>> buildGuestCompMap() {
        HashMap<String, java.util.List<Embedding>> hashMap = new HashMap<String, java.util.List<Embedding>>();
        for (Embedding embedding : this.getEmbeddings()) {
            String string = embedding.getGuest().getName();
            ArrayList<Embedding> arrayList = (ArrayList<Embedding>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Embedding>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(embedding);
        }
        return hashMap;
    }

    public void printMetaJFlexRules(PrintHelper printHelper) throws IOException {
        printHelper.println("//// START PATTERNS ////////////////////////////////////////////////////////////");
        printHelper.println();
        this.printMetaJFlexStartPatternRules(printHelper);
        printHelper.println("//// END PATTERNS //////////////////////////////////////////////////////////////");
        printHelper.println();
        this.printMetaJFlexEndPatternRules(printHelper);
        printHelper.println("//// SHARED CLEAN-UP PATTERNS //////////////////////////////////////////////////");
        printHelper.println();
        this.printMetaJFlexCleanupRules(printHelper);
    }

    public void printMetaJFlexStartPatternRules(PrintHelper printHelper) throws IOException {
        Iterable iterable;
        Object object;
        Object object2;
        Map<String, java.util.List<Embedding>> map = this.getGuestCompMap();
        Map<String, java.util.List<Embedding>> map2 = this.getHostCompMap();
        String string = this.getStartComponent().getName();
        if (!map.containsKey(string) && (object2 = map2.get(string)) != null) {
            boolean bl = Layout.allStartPatternsWillBeCommentedOut((java.util.List<Embedding>)object2);
            if (bl) {
                printHelper.println("/* Omitting empty group");
                printHelper.indent();
            }
            printHelper.println("//no embeddings completed (i.e. now in start component '" + string + "')");
            printHelper.println("<BASE> {");
            printHelper.indent();
            printHelper.println("//start patterns from embeddings with host '" + string + "'");
            object = object2.iterator();
            while (object.hasNext()) {
                iterable = (Embedding)object.next();
                printHelper.println();
                ((ASTNode)iterable).printJFlexPosComment(printHelper);
                ((Embedding)iterable).printMetaJFlexStartRule(printHelper);
            }
            printHelper.dedent();
            printHelper.println("}");
            printHelper.println();
            if (bl) {
                printHelper.dedent();
                printHelper.println("*/");
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            object = (String)entry.getKey();
            iterable = (java.util.List)entry.getValue();
            java.util.List<Embedding> list = map2.get(object);
            if (list == null) continue;
            boolean bl = Layout.allStartPatternsWillBeCommentedOut(list);
            if (bl) {
                printHelper.println("/* Omitting empty group");
                printHelper.indent();
            }
            boolean bl2 = true;
            printHelper.println("//just completed an embedding with guest '" + (String)object + "' (i.e. now in component '" + (String)object + "')");
            printHelper.print("<");
            if (string.equals(object)) {
                printHelper.print("BASE");
                bl2 = false;
            }
            for (Embedding embedding : iterable) {
                if (!bl2) {
                    printHelper.print(", ");
                }
                printHelper.print(embedding.getMetaJFlexName());
                bl2 = false;
            }
            printHelper.println("> {");
            printHelper.indent();
            printHelper.println("//start patterns from embeddings with host '" + (String)object + "'");
            for (Embedding embedding : list) {
                printHelper.println();
                embedding.printJFlexPosComment(printHelper);
                embedding.printMetaJFlexStartRule(printHelper);
            }
            printHelper.dedent();
            printHelper.println("}");
            printHelper.println();
            if (!bl) continue;
            printHelper.dedent();
            printHelper.println("*/");
        }
    }

    public void printMetaJFlexEndPatternRules(PrintHelper printHelper) throws IOException {
        for (Embedding embedding : this.getEmbeddings()) {
            boolean bl = Layout.endPatternWillBeCommentedOut(embedding);
            if (bl) {
                printHelper.println("/* Omitting empty group");
                printHelper.indent();
            }
            printHelper.println("<" + embedding.getMetaJFlexName() + "> {");
            printHelper.indent();
            embedding.printJFlexPosComment(printHelper);
            embedding.printMetaJFlexEndRule(printHelper);
            printHelper.dedent();
            printHelper.println("}");
            printHelper.println();
            if (!bl) continue;
            printHelper.dedent();
            printHelper.println("*/");
        }
    }

    public void printMetaJFlexCleanupRules(PrintHelper printHelper) throws IOException {
        printHelper.println("(.|\\n) { /*System.err.println(\"Ignoring '\" + Integer.toHexString(yytext().charAt(0)) + \"' in state \" + yystate());*/ /*consume and ignore*/ }");
        printHelper.println("<<EOF>> { return null; } //break out of infinite loop");
    }

    private static boolean startPatternWillBeCommentedOut(Embedding embedding) {
        return embedding.hasPureBOFTransition() || embedding.getStartPattern().isBadJFlex();
    }

    private static boolean endPatternWillBeCommentedOut(Embedding embedding) {
        return embedding.getEndPattern().isBadJFlex();
    }

    private static boolean allStartPatternsWillBeCommentedOut(java.util.List<Embedding> list) {
        for (Embedding embedding : list) {
            if (Layout.startPatternWillBeCommentedOut(embedding)) continue;
            return false;
        }
        return true;
    }

    private static boolean allEndPatternsWillBeCommentedOut(java.util.List<Embedding> list) {
        for (Embedding embedding : list) {
            if (Layout.endPatternWillBeCommentedOut(embedding)) continue;
            return false;
        }
        return true;
    }

    public void generateJFlex(String string) throws IOException {
        new File(string).mkdirs();
        PrintWriter printWriter = new PrintWriter(new FileWriter(string + "/" + this.getName() + ".flex"));
        PrintHelper printHelper = new PrintHelper(printWriter, 4);
        this.generateJFlex(printHelper);
        printHelper.close();
    }

    public void generateJFlex(PrintHelper printHelper) throws IOException {
        this.printJFlexHeader(printHelper);
        printHelper.println("%%");
        printHelper.println("//// This file was generated by MetaLexer ////");
        printHelper.println();
        this.printJFlexOptions(printHelper);
        printHelper.println();
        this.printJFlexStateClassInstance(printHelper);
        printHelper.println();
        this.printJFlexStateClass(printHelper);
        printHelper.println();
        this.printJFlexInnerClassBaseClass(printHelper);
        printHelper.println();
        this.printJFlexInnerClasses(printHelper);
        printHelper.println();
        this.printJFlexPairFilter(printHelper);
        printHelper.println();
        this.printJFlexEmbeddingRecord(printHelper);
        printHelper.println();
        this.printJFlexPipeClass(printHelper);
        printHelper.println();
        this.printJFlexMaybeClass(printHelper);
        printHelper.println();
        this.printJFlexStopMethod(printHelper);
        printHelper.println();
        this.printJFlexCodeRegions(printHelper);
        printHelper.println();
        this.printJFlexStates(printHelper);
        printHelper.println();
        this.printJFlexMacros(printHelper);
        printHelper.println();
        printHelper.println("%%");
        printHelper.println();
        this.printJFlexRules(printHelper);
        printHelper.println();
    }

    public void printJFlexHeader(PrintHelper printHelper) throws IOException {
        printHelper.print(this.getLocalHeader());
        printHelper.print(this.getInheritedHeader());
        for (Component component : this.getActiveComponents()) {
            component.printJFlexImports(printHelper);
        }
    }

    public void printJFlexOptions(PrintHelper printHelper) throws IOException {
        for (LexerOption cloneable2 : this.getOptions()) {
            cloneable2.printJFlexPosComment(printHelper);
            printHelper.println(StringEval.evalString(cloneable2.getValue()));
        }
        HashSet<StringSymbol> hashSet = new HashSet<StringSymbol>(this.getYylexExceptions());
        HashSet<StringSymbol> hashSet2 = new HashSet<StringSymbol>(this.getInitExceptions());
        for (Component component : this.getActiveComponents()) {
            hashSet.addAll(component.getYylexExceptions());
            hashSet2.addAll(component.getInitExceptions());
        }
        Iterator<Component> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            StringSymbol stringSymbol = (StringSymbol)((Object)iterator.next());
            stringSymbol.printJFlexPosComment(printHelper);
            printHelper.println("%yylexthrow " + StringEval.evalString(stringSymbol.getText()));
        }
        for (StringSymbol stringSymbol : hashSet2) {
            stringSymbol.printJFlexPosComment(printHelper);
            printHelper.println("%initthrow " + StringEval.evalString(stringSymbol.getText()));
        }
    }

    public void printJFlexStopMethod(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("public void stop() {");
        printHelper.indent();
        printHelper.println(this.getJFlexStateObjectName() + ".stop();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printJFlexCodeRegions(PrintHelper printHelper) throws IOException {
        for (StringSymbol stringSymbol : this.getDeclRegions()) {
            stringSymbol.printJFlexPosComment(printHelper);
            printHelper.println(stringSymbol.getText());
        }
        printHelper.println();
        for (StringSymbol stringSymbol : this.getInitRegions()) {
            stringSymbol.printJFlexPosComment(printHelper);
            printHelper.println(stringSymbol.getText());
        }
    }

    public void printJFlexInnerClassBaseClass(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("private static abstract class ComponentInnerClass {");
        printHelper.indent();
        printHelper.println("public boolean isAppend() {");
        printHelper.indent();
        printHelper.println("return false;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("public Maybe<? extends " + this.getTokenType() + "> " + "performAppendAction" + "(int startLine, int startCol, int endLine, int endCol, String text)" + this.getLexThrowsDecl() + " {");
        printHelper.indent();
        printHelper.println("throw new UnsupportedOperationException(getClass().getName() + \".performAppendAction has not been implemented.\");");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("public abstract int getStartState();");
        printHelper.println("public abstract char getCharValue();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printJFlexStateClassInstance(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        String string = this.getJFlexStateClassName();
        String string2 = this.getJFlexStateObjectName();
        printHelper.println("private final " + string + " " + string2 + " = new " + string + "();");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printJFlexStateClass(PrintHelper printHelper) throws IOException {
        String string;
        java.util.List<Embedding> list = this.getEmbeddings();
        int n = list.size();
        printHelper.println("%{");
        printHelper.indent();
        String string2 = "StateClass_" + this.getName();
        printHelper.println("private class " + string2 + " {");
        printHelper.indent();
        printHelper.println("private " + string2 + "() {");
        printHelper.indent();
        printHelper.println("metaLexerThread.start();");
        printHelper.println();
        for (Embedding object2 : list) {
            string = object2.getGuest().getDecl().getComponent().getJFlexInnerClassInstanceName();
            Iterator<Component> iterator = "PairFilter.EMPTY";
            if (!object2.getMTokPairs().isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("new PairFilter.Builder()");
                for (MTokPair mTokPair : object2.getMTokPairs()) {
                    String string3 = "/*" + mTokPair.getL().getName() + "*/ ";
                    String string4 = "'" + Util.escapeChar(mTokPair.getL().getCharValue()) + "'";
                    String string5 = "/*" + mTokPair.getR().getName() + "*/ ";
                    String string6 = "'" + Util.escapeChar(mTokPair.getR().getCharValue()) + "'";
                    stringBuffer.append(".add(" + string3 + string4 + ", " + string5 + string6 + ")");
                }
                stringBuffer.append(".build()");
                iterator = stringBuffer.toString();
            }
            object2.printJFlexPosComment(printHelper);
            printHelper.println("embeddingRecordArray[/*" + object2.getName() + "*/ " + object2.getEmbeddingIndex() + "] = " + "new EmbeddingRecord(" + string + ", " + (String)((Object)iterator) + ");");
        }
        printHelper.println();
        Component component = this.getStartComponent().getDecl().getComponent();
        String string7 = component.hasStartState() ? component.getStartState().getName() : "YYINITIAL";
        string = component.getJFlexStateName(string7);
        this.getStartComponent().printJFlexPosComment(printHelper);
        printHelper.println("yybegin(" + string + ");");
        printHelper.println();
        printHelper.println("embeddingStack.add(new EmbeddingRecord(" + component.getJFlexInnerClassInstanceName() + ", PairFilter.EMPTY));");
        printHelper.println();
        printHelper.println("//Transition through states reachable by pure BOF patterns");
        printHelper.println("//NB: append actions will not be performed");
        for (Embedding embedding : this.getInitialPureBOFSequence()) {
            printHelper.println("startEmbedding(/*" + embedding.getName() + "*/ " + embedding.getEmbeddingIndex() + "); ");
        }
        printHelper.println();
        printHelper.println("restartAppendBuf();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[" + n + "];");
        for (Component component2 : this.getActiveComponents()) {
            String string8 = component2.getJFlexInnerClassName();
            String string9 = component2.getJFlexInnerClassInstanceName();
            printHelper.println("private final " + (String)string8 + " " + string9 + " = new " + (String)string8 + "();");
        }
        printHelper.println("private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();");
        printHelper.println();
        printHelper.println("private void startEmbedding(int newEmbeddingNum) {");
        printHelper.indent();
        printHelper.println("EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];");
        printHelper.println("newEmbedding.getFilter().reset();");
        printHelper.println("embeddingStack.push(newEmbedding);");
        printHelper.println("yybegin(newEmbedding.getComp().getStartState());");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private void endEmbedding() {");
        printHelper.indent();
        printHelper.println("embeddingStack.pop();");
        printHelper.println("EmbeddingRecord newEmbedding = embeddingStack.peek();");
        printHelper.println("yybegin(newEmbedding.getComp().getStartState());");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private ComponentInnerClass getCurrComp() {");
        printHelper.indent();
        printHelper.println("return embeddingStack.peek().getComp();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private PairFilter getCurrFilter() {");
        printHelper.indent();
        printHelper.println("return embeddingStack.peek().getFilter();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private int startLine = -1;");
        printHelper.println("private int startCol = -1;");
        printHelper.println("private StringBuffer appendBuf = null;");
        printHelper.println();
        printHelper.println("private void restartAppendBuf() {");
        printHelper.indent();
        printHelper.println("startLine = yyline + 1;");
        printHelper.println("startCol = yycolumn + 1;");
        printHelper.println("appendBuf = new StringBuffer();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private int getStartLine() {");
        printHelper.indent();
        printHelper.println("return startLine;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private int getStartColumn() {");
        printHelper.indent();
        printHelper.println("return startCol;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private String getAppendText() {");
        printHelper.indent();
        printHelper.println("return appendBuf.toString();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private <T> void append(T t) {");
        printHelper.indent();
        printHelper.println("appendBuf.append(t);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private " + this.getTokenType() + " extraReturn = null;");
        printHelper.println("private int prevState = -1;");
        printHelper.println();
        printHelper.println("public " + this.getTokenType() + " getExtraReturn() {");
        printHelper.indent();
        printHelper.println("return extraReturn;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("public int getPrevState() {");
        printHelper.indent();
        printHelper.println("return prevState;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("private void returnExtraValue(" + this.getTokenType() + " value) {");
        printHelper.indent();
        printHelper.println("extraReturn = value;");
        printHelper.println("prevState = yystate();");
        printHelper.println("//System.err.println(\"yypushback(1)\");");
        printHelper.println("yypushback(1); //to ensure that at least one char is available");
        printHelper.println("yybegin(EXTRA_RETURN);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private boolean stopped = false;");
        printHelper.println();
        printHelper.println("public void stop() {");
        printHelper.indent();
        printHelper.println("stopped = true;");
        printHelper.println("pipe.writeFinal('\\n');");
        printHelper.println("boolean joined = false;");
        printHelper.println("while(!joined) {");
        printHelper.indent();
        printHelper.println("try {");
        printHelper.indent();
        printHelper.println("metaLexerThread.join();");
        printHelper.println("joined = true;");
        printHelper.dedent();
        printHelper.println("} catch(InterruptedException e) {}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private final Pipe pipe = new Pipe();");
        printHelper.println("private final " + this.getMetaJFlexLexerClassName() + " metalexer = new " + this.getMetaJFlexLexerClassName() + "(pipe);");
        printHelper.println("private final Thread metaLexerThread = new Thread(new Runnable() {");
        printHelper.indent();
        printHelper.println("public void run() {");
        printHelper.indent();
        printHelper.println("try {");
        printHelper.indent();
        printHelper.println("metalexer.start();");
        printHelper.dedent();
        printHelper.println("} catch(java.io.IOException e) {");
        printHelper.indent();
        printHelper.println("//unrecoverable");
        printHelper.println("e.printStackTrace();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}}, \"MetaLexerThread\");");
        printHelper.dedent();
        printHelper.println();
        printHelper.println("private " + this.getMetaJFlexLexerClassName() + ".Transition sendMTok(char mtok) {");
        printHelper.indent();
        printHelper.println("if(stopped) {");
        printHelper.indent();
        printHelper.println("throw new IllegalStateException(\"No meta-tokens may be sent after stop() has been called.\");");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("//System.err.println(\"sendMTok(\" + Integer.toHexString(mtok) + \")\");");
        printHelper.println("pipe.write(mtok);");
        printHelper.println("return metalexer.checkForTransition();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public void processMTok(char mtok) " + this.getLexThrowsDecl() + "{");
        printHelper.indent();
        printHelper.println("if(!getCurrFilter().test(mtok)) {");
        printHelper.indent();
        printHelper.println("//System.err.println(\"Pair filter caught: \" + Integer.toHexString(mtok));");
        printHelper.println("return; //don't send character if it gets filtered out");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("Maybe<? extends " + this.getTokenType() + "> maybeReturn = Maybe.Nothing();");
        printHelper.println("ComponentInnerClass currComp = getCurrComp();");
        printHelper.println("boolean appendActionPerformed = false;");
        printHelper.println(this.getMetaJFlexLexerClassName() + ".Transition next = sendMTok(mtok);");
        printHelper.println("while(next != null) {");
        printHelper.indent();
        printHelper.println("boolean endOfEmbedding = next.getEmbeddingNum() < 0;");
        printHelper.println("if(endOfEmbedding) {");
        printHelper.indent();
        printHelper.println("endEmbedding();");
        printHelper.dedent();
        printHelper.println("} else {");
        printHelper.indent();
        printHelper.println("//NB: update filter in the OLD embedding and only in start case");
        printHelper.println("getCurrFilter().clean(next.getMatch());");
        printHelper.println("startEmbedding(next.getEmbeddingNum());");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("ComponentInnerClass nextComp = getCurrComp();");
        printHelper.println("//NB: only one append action can meaningfully be performed since");
        printHelper.println("//  no input can be consumed while in this loop");
        printHelper.println("if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {");
        printHelper.indent();
        printHelper.println("int endLine = yyline + 1;");
        printHelper.println("int endCol = yycolumn; //+1 handled by increment below");
        printHelper.println();
        printHelper.println("final String yytext = yytext();");
        printHelper.println("final int yylength = yylength();");
        printHelper.println("boolean prevWasNewline = false;");
        printHelper.println("for(int i = 0; i < yylength; i++) {");
        printHelper.indent();
        printHelper.println("if(prevWasNewline) {");
        printHelper.indent();
        printHelper.println("endLine++;");
        printHelper.println("endCol = 0;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("switch(yytext.charAt(i)) {");
        printHelper.println("case '\\r':");
        printHelper.indent();
        printHelper.println("if(i + 1 < yylength && yytext.charAt(i+1) == '\\n') {");
        printHelper.indent();
        printHelper.println("i++;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("//NB: fall through");
        printHelper.dedent();
        printHelper.println("case '\\n':");
        printHelper.indent();
        printHelper.println("prevWasNewline = true;");
        printHelper.println("break;");
        printHelper.dedent();
        printHelper.println("default:");
        printHelper.indent();
        printHelper.println("prevWasNewline = false;");
        printHelper.println("break;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("endCol++;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());");
        printHelper.println("appendActionPerformed = true;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("if(currComp.isAppend() != nextComp.isAppend()) {");
        printHelper.indent();
        printHelper.println("restartAppendBuf();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("next = null;");
        printHelper.println("if(endOfEmbedding) {");
        printHelper.indent();
        printHelper.println("char regionChar = currComp.getCharValue();");
        printHelper.println("if(getCurrFilter().test(regionChar)) {");
        printHelper.indent();
        printHelper.println("next = sendMTok(regionChar);");
        printHelper.dedent();
        printHelper.println("} else {");
        printHelper.indent();
        printHelper.println("//System.err.println(\"Pair filter caught: \" + Integer.toHexString(regionChar));");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("if(maybeReturn.isJust()) {");
        printHelper.indent();
        printHelper.println("returnExtraValue(maybeReturn.fromJust());");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printJFlexInnerClasses(PrintHelper printHelper) throws IOException {
        for (Component component : this.getActiveComponents()) {
            component.printJFlexInnerClass(printHelper);
        }
    }

    public void printJFlexStates(PrintHelper printHelper) throws IOException {
        printHelper.println("%xstate EXTRA_RETURN");
        printHelper.println();
        for (Component component : this.getActiveComponents()) {
            component.printJFlexStates(printHelper);
        }
    }

    public void printJFlexMacros(PrintHelper printHelper) throws IOException {
        for (Component component : this.getActiveComponents()) {
            component.printJFlexMacros(printHelper);
        }
    }

    public void printJFlexRules(PrintHelper printHelper) throws IOException {
        printHelper.println("<EXTRA_RETURN> {");
        printHelper.indent();
        printHelper.println("(. | \\n) {");
        printHelper.indent();
        printHelper.println("//System.err.println(\"Reconsume char\");");
        String string = this.getJFlexStateObjectName();
        printHelper.println("yybegin(" + string + ".getPrevState());");
        printHelper.println("return " + string + ".getExtraReturn();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        for (Component component : this.getActiveComponents()) {
            component.printJFlexRules(printHelper);
        }
    }

    public void generateMetaJFlex(String string) throws IOException {
        new File(string).mkdirs();
        PrintWriter printWriter = new PrintWriter(new FileWriter(string + "/" + this.getName() + ".meta.flex"));
        PrintHelper printHelper = new PrintHelper(printWriter, 4);
        this.generateMetaJFlex(printHelper);
        printHelper.close();
    }

    public void generateMetaJFlex(PrintHelper printHelper) throws IOException {
        this.printMetaJFlexHeader(printHelper);
        printHelper.println("%%");
        this.printMetaJFlexOptions(printHelper);
        printHelper.println();
        this.printMetaJFlexCodeRegions(printHelper);
        printHelper.println();
        this.printMetaJFlexTransitionClass(printHelper);
        printHelper.println();
        this.printMetaJFlexInitialTransitions(printHelper);
        printHelper.println();
        this.printMetaJFlexStates(printHelper);
        printHelper.println();
        this.printMetaJFlexMacros(printHelper);
        printHelper.println();
        printHelper.println("%%");
        printHelper.println();
        this.printMetaJFlexRules(printHelper);
        printHelper.println();
    }

    public void printMetaJFlexHeader(PrintHelper printHelper) throws IOException {
        printHelper.println("package " + this.getMetaJFlexPackage() + ";");
        printHelper.println();
        printHelper.println("import java.util.ArrayList;");
        printHelper.println("import java.util.LinkedList;");
        printHelper.println("import java.util.List;");
        printHelper.println("import java.util.Queue;");
    }

    public void printMetaJFlexOptions(PrintHelper printHelper) throws IOException {
        printHelper.println("%public");
        printHelper.println("%final");
        printHelper.println("%unicode");
        printHelper.println("%class " + this.getMetaJFlexLexerClassName());
        printHelper.println("%function start");
        printHelper.println("%type Object");
    }

    public void printMetaJFlexCodeRegions(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();");
        printHelper.println();
        printHelper.println("void saveStateAndTransition(int newState) {");
        printHelper.indent();
        printHelper.println("stateStack.push(yystate());");
        printHelper.println("yybegin(newState);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("void restoreState() {");
        printHelper.indent();
        printHelper.println("yybegin(stateStack.pop());");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
        printHelper.println();
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("private Transition transition = null;");
        printHelper.println();
        printHelper.println("private void notifyLexer(int embeddingNum) {");
        printHelper.indent();
        printHelper.println("//System.err.println(\"in notifyLexer(\" + embeddingNum + \",\" + yytext() + \")\");");
        printHelper.println("this.transition = new Transition(embeddingNum, yytext());");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public Transition checkForTransition() {");
        printHelper.indent();
        printHelper.println("Transition tmp = transition;");
        printHelper.println("transition = null;");
        printHelper.println("return tmp;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printMetaJFlexInitialTransitions(PrintHelper printHelper) throws IOException {
        printHelper.println("%init{");
        printHelper.indent();
        printHelper.println("//Start in state BASE");
        printHelper.println("yybegin(BASE);");
        printHelper.println();
        printHelper.println("//Transition through states reachable by pure BOF patterns");
        for (Embedding embedding : this.getInitialPureBOFSequence()) {
            printHelper.println("saveStateAndTransition(" + embedding.getMetaJFlexName() + "); ");
        }
        printHelper.dedent();
        printHelper.println("%init}");
    }

    public void printMetaJFlexStates(PrintHelper printHelper) throws IOException {
        printHelper.println("%state BASE");
        for (Embedding embedding : this.getEmbeddings()) {
            embedding.printJFlexPosComment(printHelper);
            printHelper.println("%state " + embedding.getMetaJFlexName());
        }
    }

    public void printMetaJFlexMacros(PrintHelper printHelper) throws IOException {
        printHelper.println("//Meta-tokens");
        for (MTokRef aSTNode : this.listMetaTokens()) {
            printHelper.print(aSTNode.getMetaJFlexName() + " = " + Util.escapeChar(aSTNode.getCharValue()));
            printHelper.print(" ");
            aSTNode.printJFlexPosComment(printHelper);
        }
        printHelper.println();
        printHelper.println("//Regions");
        for (RegionMetaPattern regionMetaPattern : this.listRegions()) {
            char c = regionMetaPattern.getRegion().getDecl().getComponent().getRegionCharValue();
            printHelper.print(regionMetaPattern.getMetaJFlexName() + " = " + Util.escapeChar(c));
            printHelper.print(" ");
            regionMetaPattern.printJFlexPosComment(printHelper);
        }
    }

    public void printJFlexPairFilter(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("private static class PairFilter {");
        printHelper.indent();
        printHelper.println("public static final PairFilter EMPTY = new PairFilter.Builder().build();");
        printHelper.println();
        printHelper.println("private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open");
        printHelper.println("private final java.util.Set<Character> allOpenChars;");
        printHelper.println("private final java.util.List<Character> unclosedOpenChars; //really a stack, but then the iterator would go backwards");
        printHelper.println();
        printHelper.println("private PairFilter(java.util.Map<Character, java.util.Set<Character>> pairMap, java.util.Set<Character> allOpenChars) {");
        printHelper.indent();
        printHelper.println("this.pairMap = pairMap;");
        printHelper.println("this.allOpenChars = allOpenChars;");
        printHelper.println("this.unclosedOpenChars = new java.util.ArrayList<Character>();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public static class Builder {");
        printHelper.indent();
        printHelper.println("private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open");
        printHelper.println("private final java.util.Set<Character> allOpenChars;");
        printHelper.println();
        printHelper.println("public Builder() {");
        printHelper.indent();
        printHelper.println("this.pairMap = new java.util.HashMap<Character, java.util.Set<Character>>();");
        printHelper.println("this.allOpenChars = new java.util.HashSet<Character>();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public Builder add(char open, char close) {");
        printHelper.indent();
        printHelper.println("allOpenChars.add(open);");
        printHelper.println("java.util.Set<Character> list = pairMap.get(close);");
        printHelper.println("if(list == null) {");
        printHelper.indent();
        printHelper.println("list = new java.util.HashSet<Character>();");
        printHelper.println("pairMap.put(close, list);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("list.add(open);");
        printHelper.println("return this;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public PairFilter build() {");
        printHelper.indent();
        printHelper.println("return new PairFilter(pairMap, allOpenChars);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public boolean test(char ch) {");
        printHelper.indent();
        printHelper.println("//NB: closing-ness takes precedence over opening-ness");
        printHelper.println("java.util.Set<Character> correspondingOpens = pairMap.get(ch);");
        printHelper.println("if(correspondingOpens != null) { //implies closing");
        printHelper.indent();
        printHelper.println("for(java.util.Iterator<Character> it = unclosedOpenChars.iterator(); it.hasNext(); ) {");
        printHelper.indent();
        printHelper.println("char open = it.next();");
        printHelper.println("if(correspondingOpens.contains(open)) {");
        printHelper.indent();
        printHelper.println("//if closing and have seen corresponding open, then close open and reject");
        printHelper.println("it.remove();");
        printHelper.println("return false;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("//if closing and have not seen corresponding open, then accept");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("if(allOpenChars.contains(ch)) { //implies opening");
        printHelper.indent();
        printHelper.println("unclosedOpenChars.add(0, ch); //insert at beginning");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("return true;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public void clean(String chars) {");
        printHelper.indent();
        printHelper.println("for(char ch : new StringBuffer(chars).reverse().toString().toCharArray()) {");
        printHelper.indent();
        printHelper.println("if(unclosedOpenChars.isEmpty()) {");
        printHelper.indent();
        printHelper.println("return;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("if(unclosedOpenChars.get(0) == ch) {");
        printHelper.indent();
        printHelper.println("unclosedOpenChars.remove(0);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public void reset() {");
        printHelper.indent();
        printHelper.println("unclosedOpenChars.clear();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printJFlexEmbeddingRecord(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("public class EmbeddingRecord {");
        printHelper.indent();
        printHelper.println("private final ComponentInnerClass comp;");
        printHelper.println("private final PairFilter filter;");
        printHelper.println();
        printHelper.println("public EmbeddingRecord(ComponentInnerClass comp, PairFilter filter) {");
        printHelper.indent();
        printHelper.println("this.comp = comp;");
        printHelper.println("this.filter = filter;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public ComponentInnerClass getComp() {");
        printHelper.indent();
        printHelper.println("return comp;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public PairFilter getFilter() {");
        printHelper.indent();
        printHelper.println("return filter;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printJFlexPipeClass(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("public static class Pipe extends java.io.Reader {");
        printHelper.indent();
        printHelper.println("private final java.util.concurrent.locks.Lock monitorLock = new java.util.concurrent.locks.ReentrantLock();");
        printHelper.println("private final java.util.Queue<java.util.concurrent.locks.Condition> waitingForFirstRead = new java.util.LinkedList<java.util.concurrent.locks.Condition>();");
        printHelper.println("private java.util.Map<Thread, java.util.concurrent.locks.Condition> waitingForSecondRead = new java.util.HashMap<Thread, java.util.concurrent.locks.Condition>();");
        printHelper.println();
        printHelper.println("private final java.util.Queue<Character> writeQueue = new java.util.LinkedList<Character>();");
        printHelper.println("private final java.util.concurrent.locks.Condition notEmpty = monitorLock.newCondition();");
        printHelper.println();
        printHelper.println("private boolean closed = false;");
        printHelper.println("private boolean eof = false;");
        printHelper.println();
        printHelper.println("public void write(char ch) {");
        printHelper.indent();
        printHelper.println("write(ch, false);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("//NB: combine write() with eof() because the last write() will block, making it hard to call eof()");
        printHelper.println("public void writeFinal(char ch) {");
        printHelper.indent();
        printHelper.println("write(ch, true);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private void write(char ch, boolean isFinal) {");
        printHelper.indent();
        printHelper.println("monitorLock.lock();");
        printHelper.println("try {");
        printHelper.indent();
        printHelper.println("if(closed) {");
        printHelper.indent();
        printHelper.println("throw new IllegalStateException(\"Cannot write after the read end has been closed.\");");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("if(eof) {");
        printHelper.indent();
        printHelper.println("throw new IllegalStateException(\"Cannot write after EOF.\");");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("if(isFinal) {");
        printHelper.indent();
        printHelper.println("eof = true;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("writeQueue.add(ch);");
        printHelper.println("java.util.concurrent.locks.Condition cond = monitorLock.newCondition();");
        printHelper.println("waitingForFirstRead.add(cond);");
        printHelper.println("notEmpty.signalAll();");
        printHelper.println("cond.awaitUninterruptibly();");
        printHelper.dedent();
        printHelper.println("} finally {");
        printHelper.indent();
        printHelper.println("monitorLock.unlock();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("@Override");
        printHelper.println("//NB: ignore length and always write 1 byte (unless at EOF)");
        printHelper.println("public int read(char[] buf, int offset, int length) throws java.io.IOException {");
        printHelper.indent();
        printHelper.println("monitorLock.lock();");
        printHelper.println("try {");
        printHelper.indent();
        printHelper.println("if(closed) {");
        printHelper.indent();
        printHelper.println("throw new IllegalStateException(\"Cannot read after the read end has been closed.\");");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("boolean freedWriter = freeNextWriter();");
        printHelper.println("while(!eof && writeQueue.isEmpty()) {");
        printHelper.indent();
        printHelper.println("notEmpty.awaitUninterruptibly();");
        printHelper.println("if(!freedWriter) {");
        printHelper.indent();
        printHelper.println("freedWriter = freeNextWriter();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("if(eof && writeQueue.isEmpty()) {");
        printHelper.indent();
        printHelper.println("//no writers waiting, so none to free");
        printHelper.println("return -1;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("waitingForSecondRead.put(Thread.currentThread(), waitingForFirstRead.poll());");
        printHelper.println("buf[offset] = writeQueue.poll();");
        printHelper.println("return 1;");
        printHelper.dedent();
        printHelper.println("} finally {");
        printHelper.indent();
        printHelper.println("monitorLock.unlock();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("@Override");
        printHelper.println("public void close() throws java.io.IOException {");
        printHelper.indent();
        printHelper.println("monitorLock.lock();");
        printHelper.println("try {");
        printHelper.indent();
        printHelper.println("closed = true;");
        printHelper.println("freeAllWriters();");
        printHelper.dedent();
        printHelper.println("} finally {");
        printHelper.indent();
        printHelper.println("monitorLock.unlock();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("//NB: didn't bother with monitorLock because this method is always called safely");
        printHelper.println("private boolean freeNextWriter() {");
        printHelper.indent();
        printHelper.println("java.util.concurrent.locks.Condition cond = waitingForSecondRead.get(Thread.currentThread());");
        printHelper.println("if(cond != null) {");
        printHelper.indent();
        printHelper.println("cond.signal();");
        printHelper.println("waitingForSecondRead.remove(Thread.currentThread());");
        printHelper.println("return true;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("return false;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("//NB: didn't bother with monitorLock because this method is always called safely");
        printHelper.println("private void freeAllWriters() {");
        printHelper.indent();
        printHelper.println("for(java.util.concurrent.locks.Condition cond : waitingForSecondRead.values()) {");
        printHelper.indent();
        printHelper.println("cond.signal();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("waitingForSecondRead.clear();");
        printHelper.println("for(java.util.concurrent.locks.Condition cond : waitingForFirstRead) {");
        printHelper.indent();
        printHelper.println("cond.signal();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("waitingForFirstRead.clear();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printJFlexMaybeClass(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("private static abstract class Maybe<T> {");
        printHelper.indent();
        printHelper.println("@SuppressWarnings(\"unchecked\")");
        printHelper.println("private final static Maybe NOTHING = new Nothing();");
        printHelper.println();
        printHelper.println("private Maybe() {}");
        printHelper.println();
        printHelper.println("public final boolean isJust() {");
        printHelper.indent();
        printHelper.println("return !isNothing();");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println("public abstract boolean isNothing();");
        printHelper.println();
        printHelper.println("public abstract T fromJust();");
        printHelper.println();
        printHelper.println("public static <S> Maybe<S> Just(S value) {");
        printHelper.indent();
        printHelper.println("return new Just<S>(value);");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("@SuppressWarnings(\"unchecked\")");
        printHelper.println("public static <S> Maybe<S> Nothing() {");
        printHelper.indent();
        printHelper.println("return (Nothing<S>) NOTHING;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private static class Just<T> extends Maybe<T> {");
        printHelper.indent();
        printHelper.println("private T value;");
        printHelper.println();
        printHelper.println("private Just(T value) {");
        printHelper.indent();
        printHelper.println("this.value = value;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public boolean isNothing() {");
        printHelper.indent();
        printHelper.println("return false;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public T fromJust() {");
        printHelper.indent();
        printHelper.println("return value;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public String toString() { ");
        printHelper.indent();
        printHelper.println("return \"Just \" + value;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("private static class Nothing<T> extends Maybe<T> {");
        printHelper.indent();
        printHelper.println("private Nothing() {}");
        printHelper.println();
        printHelper.println("public boolean isNothing() {");
        printHelper.indent();
        printHelper.println("return true;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public T fromJust() {");
        printHelper.indent();
        printHelper.println("throw new UnsupportedOperationException(\"Cannot extract value from Nothing\");");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public String toString() {");
        printHelper.indent();
        printHelper.println("return \"Nothing\";");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public void printMetaJFlexTransitionClass(PrintHelper printHelper) throws IOException {
        printHelper.println("%{");
        printHelper.indent();
        printHelper.println("public static class Transition {");
        printHelper.indent();
        printHelper.println("private final int embeddingNum;");
        printHelper.println("private final String match;");
        printHelper.println();
        printHelper.println("public Transition(int embeddingNum, String match) {");
        printHelper.indent();
        printHelper.println("this.embeddingNum = embeddingNum;");
        printHelper.println("this.match = match;");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.println();
        printHelper.println("public int getEmbeddingNum() { return embeddingNum; }");
        printHelper.println();
        printHelper.println("public String getMatch() { return match; }");
        printHelper.dedent();
        printHelper.println("}");
        printHelper.dedent();
        printHelper.println("%}");
    }

    public Layout() {
        this.setChild(new Opt(), 0);
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
        this.setChild(new List(), 3);
        this.setChild(new List(), 4);
    }

    public Layout(String string, boolean bl, String string2, String string3, Opt<CompRef> opt, List<CompDecl> list, List<LexerOption> list2, List<Declaration> list3, Set<StringSymbol> set, Set<StringSymbol> set2, Set<StringSymbol> set3, Set<StringSymbol> set4, List<BodyElement> list4) {
        this.setName(string);
        this.setHelper(bl);
        this.setLocalHeader(string2);
        this.setInheritedHeader(string3);
        this.setChild(opt, 0);
        this.setChild(list, 1);
        this.setChild(list2, 2);
        this.setChild(list3, 3);
        this.setDeclRegions(set);
        this.setYylexExceptions(set2);
        this.setInitRegions(set3);
        this.setInitExceptions(set4);
        this.setChild(list4, 4);
    }

    public Layout(Symbol symbol, boolean bl, Symbol symbol2, Symbol symbol3, Opt<CompRef> opt, List<CompDecl> list, List<LexerOption> list2, List<Declaration> list3, Set<StringSymbol> set, Set<StringSymbol> set2, Set<StringSymbol> set3, Set<StringSymbol> set4, List<BodyElement> list4) {
        this.setName(symbol);
        this.setHelper(bl);
        this.setLocalHeader(symbol2);
        this.setInheritedHeader(symbol3);
        this.setChild(opt, 0);
        this.setChild(list, 1);
        this.setChild(list2, 2);
        this.setChild(list3, 3);
        this.setDeclRegions(set);
        this.setYylexExceptions(set2);
        this.setInitRegions(set3);
        this.setInitExceptions(set4);
        this.setChild(list4, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setHelper(boolean bl) {
        this.tokenboolean_Helper = bl;
    }

    public boolean getHelper() {
        return this.tokenboolean_Helper;
    }

    public void setLocalHeader(String string) {
        this.tokenString_LocalHeader = string;
    }

    public void setLocalHeader(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLocalHeader is only valid for String lexemes");
        }
        this.tokenString_LocalHeader = (String)symbol.value;
        this.LocalHeaderstart = symbol.getStart();
        this.LocalHeaderend = symbol.getEnd();
    }

    public String getLocalHeader() {
        return this.tokenString_LocalHeader != null ? this.tokenString_LocalHeader : "";
    }

    public void setInheritedHeader(String string) {
        this.tokenString_InheritedHeader = string;
    }

    public void setInheritedHeader(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setInheritedHeader is only valid for String lexemes");
        }
        this.tokenString_InheritedHeader = (String)symbol.value;
        this.InheritedHeaderstart = symbol.getStart();
        this.InheritedHeaderend = symbol.getEnd();
    }

    public String getInheritedHeader() {
        return this.tokenString_InheritedHeader != null ? this.tokenString_InheritedHeader : "";
    }

    public void setStartComponentOpt(Opt<CompRef> opt) {
        this.setChild(opt, 0);
    }

    public boolean hasStartComponent() {
        return this.getStartComponentOpt().getNumChild() != 0;
    }

    public CompRef getStartComponent() {
        return (CompRef)this.getStartComponentOpt().getChild(0);
    }

    public void setStartComponent(CompRef compRef) {
        this.getStartComponentOpt().setChild(compRef, 0);
    }

    public Opt<CompRef> getStartComponentOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt<CompRef> getStartComponentOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    public void setComponentList(List<CompDecl> list) {
        this.setChild(list, 1);
    }

    public int getNumComponent() {
        return this.getComponentList().getNumChild();
    }

    public CompDecl getComponent(int n) {
        return (CompDecl)this.getComponentList().getChild(n);
    }

    public void addComponent(CompDecl compDecl) {
        List<CompDecl> list = this.getComponentList();
        list.addChild(compDecl);
    }

    public void setComponent(CompDecl compDecl, int n) {
        List<CompDecl> list = this.getComponentList();
        list.setChild(compDecl, n);
    }

    public List<CompDecl> getComponents() {
        return this.getComponentList();
    }

    public List<CompDecl> getComponentsNoTransform() {
        return this.getComponentListNoTransform();
    }

    public List<CompDecl> getComponentList() {
        return (List)this.getChild(1);
    }

    public List<CompDecl> getComponentListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public void setOptionList(List<LexerOption> list) {
        this.setChild(list, 2);
    }

    public int getNumOption() {
        return this.getOptionList().getNumChild();
    }

    public LexerOption getOption(int n) {
        return (LexerOption)this.getOptionList().getChild(n);
    }

    public void addOption(LexerOption lexerOption) {
        List<LexerOption> list = this.getOptionList();
        list.addChild(lexerOption);
    }

    public void setOption(LexerOption lexerOption, int n) {
        List<LexerOption> list = this.getOptionList();
        list.setChild(lexerOption, n);
    }

    public List<LexerOption> getOptions() {
        return this.getOptionList();
    }

    public List<LexerOption> getOptionsNoTransform() {
        return this.getOptionListNoTransform();
    }

    public List<LexerOption> getOptionList() {
        return (List)this.getChild(2);
    }

    public List<LexerOption> getOptionListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public void setDeclList(List<Declaration> list) {
        this.setChild(list, 3);
    }

    public int getNumDecl() {
        return this.getDeclList().getNumChild();
    }

    public Declaration getDecl(int n) {
        return (Declaration)this.getDeclList().getChild(n);
    }

    public void addDecl(Declaration declaration) {
        List<Declaration> list = this.getDeclList();
        list.addChild(declaration);
    }

    public void setDecl(Declaration declaration, int n) {
        List<Declaration> list = this.getDeclList();
        list.setChild(declaration, n);
    }

    public List<Declaration> getDecls() {
        return this.getDeclList();
    }

    public List<Declaration> getDeclsNoTransform() {
        return this.getDeclListNoTransform();
    }

    public List<Declaration> getDeclList() {
        return (List)this.getChild(3);
    }

    public List<Declaration> getDeclListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    public void setDeclRegions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__DeclRegions = set;
    }

    public Set<StringSymbol> getDeclRegions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__DeclRegions;
    }

    public void setYylexExceptions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions = set;
    }

    public Set<StringSymbol> getYylexExceptions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions;
    }

    public void setInitRegions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__InitRegions = set;
    }

    public Set<StringSymbol> getInitRegions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__InitRegions;
    }

    public void setInitExceptions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__InitExceptions = set;
    }

    public Set<StringSymbol> getInitExceptions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__InitExceptions;
    }

    public void setBodyElementList(List<BodyElement> list) {
        this.setChild(list, 4);
    }

    public int getNumBodyElement() {
        return this.getBodyElementList().getNumChild();
    }

    public BodyElement getBodyElement(int n) {
        return (BodyElement)this.getBodyElementList().getChild(n);
    }

    public void addBodyElement(BodyElement bodyElement) {
        List<BodyElement> list = this.getBodyElementList();
        list.addChild(bodyElement);
    }

    public void setBodyElement(BodyElement bodyElement, int n) {
        List<BodyElement> list = this.getBodyElementList();
        list.setChild(bodyElement, n);
    }

    public List<BodyElement> getBodyElements() {
        return this.getBodyElementList();
    }

    public List<BodyElement> getBodyElementsNoTransform() {
        return this.getBodyElementListNoTransform();
    }

    public List<BodyElement> getBodyElementList() {
        return (List)this.getChild(4);
    }

    public List<BodyElement> getBodyElementListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    @Override
    protected void collect_contributors_Layout_listMetaTokens() {
        if (this.collect_contributors_Layout_listMetaTokens) {
            return;
        }
        super.collect_contributors_Layout_listMetaTokens();
        this.collect_contributors_Layout_listMetaTokens = true;
    }

    @Override
    protected void collect_contributors_Layout_listRegions() {
        if (this.collect_contributors_Layout_listRegions) {
            return;
        }
        super.collect_contributors_Layout_listRegions();
        this.collect_contributors_Layout_listRegions = true;
    }

    public java.util.List<Component> getActiveComponents() {
        if (this.getActiveComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getActiveComponents in class: ");
        }
        this.getActiveComponents_visited = this.state().boundariesCrossed;
        java.util.List<Component> list = this.getActiveComponents_compute();
        this.getActiveComponents_visited = -1;
        return list;
    }

    private java.util.List<Component> getActiveComponents_compute() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (CompDecl compDecl : this.getComponents()) {
            if (!compDecl.hasComponent()) continue;
            arrayList.add(compDecl.getComponent());
        }
        return arrayList;
    }

    public Set<CompDecl> lookupCompDecls(String string) {
        String string2 = string;
        if (this.lookupCompDecls_String_visited == null) {
            this.lookupCompDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupCompDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupCompDecls in class: ");
        }
        this.lookupCompDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<CompDecl> set = this.lookupCompDecls_compute(string);
        this.lookupCompDecls_String_visited.remove(string2);
        return set;
    }

    private Set<CompDecl> lookupCompDecls_compute(String string) {
        HashSet<CompDecl> hashSet = new HashSet<CompDecl>();
        for (CompDecl compDecl : this.getComponents()) {
            if (!compDecl.getName().equals(string)) continue;
            hashSet.add(compDecl);
        }
        return hashSet;
    }

    public Set<Embedding> lookupEmbeddings(String string) {
        String string2 = string;
        if (this.lookupEmbeddings_String_visited == null) {
            this.lookupEmbeddings_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupEmbeddings_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupEmbeddings in class: ");
        }
        this.lookupEmbeddings_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<Embedding> set = this.lookupEmbeddings_compute(string);
        this.lookupEmbeddings_String_visited.remove(string2);
        return set;
    }

    private Set<Embedding> lookupEmbeddings_compute(String string) {
        HashSet<Embedding> hashSet = new HashSet<Embedding>();
        for (BodyElement bodyElement : this.getBodyElements()) {
            Embedding embedding;
            if (!(bodyElement instanceof Embedding) || !(embedding = (Embedding)bodyElement).getName().equals(string)) continue;
            hashSet.add(embedding);
        }
        return hashSet;
    }

    public java.util.List<Embedding> getEmbeddings() {
        if (this.getEmbeddings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getEmbeddings in class: ");
        }
        this.getEmbeddings_visited = this.state().boundariesCrossed;
        java.util.List<Embedding> list = this.getEmbeddings_compute();
        this.getEmbeddings_visited = -1;
        return list;
    }

    private java.util.List<Embedding> getEmbeddings_compute() {
        ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
        for (BodyElement bodyElement : this.getBodyElements()) {
            if (!(bodyElement instanceof Embedding)) continue;
            arrayList.add((Embedding)bodyElement);
        }
        return arrayList;
    }

    public Set<Declaration> lookupExternDecls(String string) {
        String string2 = string;
        if (this.lookupExternDecls_String_visited == null) {
            this.lookupExternDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupExternDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupExternDecls in class: ");
        }
        this.lookupExternDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<Declaration> set = this.lookupExternDecls_compute(string);
        this.lookupExternDecls_String_visited.remove(string2);
        return set;
    }

    private Set<Declaration> lookupExternDecls_compute(String string) {
        HashSet<Declaration> hashSet = new HashSet<Declaration>();
        for (Declaration declaration : this.getDecls()) {
            if (!declaration.getText().equals(string)) continue;
            hashSet.add(declaration);
        }
        return hashSet;
    }

    public java.util.List<Embedding> getEmbeddingsWithHost(CompRef compRef) {
        CompRef compRef2 = compRef;
        if (this.getEmbeddingsWithHost_CompRef_visited == null) {
            this.getEmbeddingsWithHost_CompRef_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.getEmbeddingsWithHost_CompRef_visited.get(compRef2))) {
            throw new RuntimeException("Circular definition of attr: getEmbeddingsWithHost in class: ");
        }
        this.getEmbeddingsWithHost_CompRef_visited.put(compRef2, new Integer(this.state().boundariesCrossed));
        java.util.List<Embedding> list = this.getEmbeddingsWithHost_compute(compRef);
        this.getEmbeddingsWithHost_CompRef_visited.remove(compRef2);
        return list;
    }

    private java.util.List<Embedding> getEmbeddingsWithHost_compute(CompRef compRef) {
        ArrayList arrayList = this.getHostCompMap().get(compRef.getName());
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public Map<String, java.util.List<Embedding>> getGuestCompMap() {
        if (this.getGuestCompMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getGuestCompMap in class: ");
        }
        this.getGuestCompMap_visited = this.state().boundariesCrossed;
        Map<String, java.util.List<Embedding>> map = this.getGuestCompMap_compute();
        this.getGuestCompMap_visited = -1;
        return map;
    }

    private Map<String, java.util.List<Embedding>> getGuestCompMap_compute() {
        return this.buildGuestCompMap();
    }

    public Map<String, java.util.List<Embedding>> getHostCompMap() {
        if (this.getHostCompMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getHostCompMap in class: ");
        }
        this.getHostCompMap_visited = this.state().boundariesCrossed;
        Map<String, java.util.List<Embedding>> map = this.getHostCompMap_compute();
        this.getHostCompMap_visited = -1;
        return map;
    }

    private Map<String, java.util.List<Embedding>> getHostCompMap_compute() {
        return this.buildHostCompMap();
    }

    public String getMetaJFlexPackage() {
        if (this.getMetaJFlexPackage_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexPackage in class: ");
        }
        this.getMetaJFlexPackage_visited = this.state().boundariesCrossed;
        String string = this.getMetaJFlexPackage_compute();
        this.getMetaJFlexPackage_visited = -1;
        return string;
    }

    private String getMetaJFlexPackage_compute() {
        String string = PackageFind.findPackage(this.getLocalHeader() + this.getInheritedHeader());
        return string != null ? string : "meta." + this.getName();
    }

    public String getJFlexStateClassName() {
        if (this.getJFlexStateClassName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getJFlexStateClassName in class: ");
        }
        this.getJFlexStateClassName_visited = this.state().boundariesCrossed;
        String string = this.getJFlexStateClassName_compute();
        this.getJFlexStateClassName_visited = -1;
        return string;
    }

    private String getJFlexStateClassName_compute() {
        return "StateClass_" + this.getName();
    }

    public String getJFlexStateObjectName() {
        if (this.getJFlexStateObjectName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getJFlexStateObjectName in class: ");
        }
        this.getJFlexStateObjectName_visited = this.state().boundariesCrossed;
        String string = this.getJFlexStateObjectName_compute();
        this.getJFlexStateObjectName_visited = -1;
        return string;
    }

    private String getJFlexStateObjectName_compute() {
        return "state_" + this.getName();
    }

    public String getMetaJFlexLexerClassName() {
        if (this.getMetaJFlexLexerClassName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexLexerClassName in class: ");
        }
        this.getMetaJFlexLexerClassName_visited = this.state().boundariesCrossed;
        String string = this.getMetaJFlexLexerClassName_compute();
        this.getMetaJFlexLexerClassName_visited = -1;
        return string;
    }

    private String getMetaJFlexLexerClassName_compute() {
        return this.getOptionValue("%class", this.getName()) + "_Meta";
    }

    public String getOptionValue(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        arrayList.add(string2);
        if (this.getOptionValue_String_String_visited == null) {
            this.getOptionValue_String_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.getOptionValue_String_String_visited.get(arrayList))) {
            throw new RuntimeException("Circular definition of attr: getOptionValue in class: ");
        }
        this.getOptionValue_String_String_visited.put(arrayList, new Integer(this.state().boundariesCrossed));
        String string3 = this.getOptionValue_compute(string, string2);
        this.getOptionValue_String_String_visited.remove(arrayList);
        return string3;
    }

    private String getOptionValue_compute(String string, String string2) {
        for (LexerOption lexerOption : this.getOptions()) {
            String string3 = lexerOption.getValue();
            String string4 = StringEval.evalString(string3);
            String string5 = string4.trim();
            if (!string5.startsWith(string)) continue;
            return string5.substring(string.length()).trim();
        }
        return string2;
    }

    public java.util.List<Embedding> getInitialPureBOFSequence() {
        if (this.getInitialPureBOFSequence_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getInitialPureBOFSequence in class: ");
        }
        this.getInitialPureBOFSequence_visited = this.state().boundariesCrossed;
        java.util.List<Embedding> list = this.getInitialPureBOFSequence_compute();
        this.getInitialPureBOFSequence_visited = -1;
        return list;
    }

    private java.util.List<Embedding> getInitialPureBOFSequence_compute() {
        ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
        Embedding embedding = null;
        Object object = this.getEmbeddingsWithHost(this.getStartComponent()).iterator();
        while (object.hasNext()) {
            Embedding embedding2 = object.next();
            if (!embedding2.hasPureBOFTransition()) continue;
            embedding = embedding2;
            break;
        }
        for (object = embedding; object != null; object = ((Embedding)object).getNextByPureBOF()) {
            arrayList.add((Embedding)object);
        }
        return arrayList;
    }

    public String getLexThrowsDecl() {
        if (this.getLexThrowsDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLexThrowsDecl in class: ");
        }
        this.getLexThrowsDecl_visited = this.state().boundariesCrossed;
        String string = this.getLexThrowsDecl_compute();
        this.getLexThrowsDecl_visited = -1;
        return string;
    }

    private String getLexThrowsDecl_compute() {
        if (this.getYylexExceptions().isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(" throws");
        boolean bl = true;
        for (StringSymbol stringSymbol : this.getYylexExceptions()) {
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(" " + StringEval.evalString(stringSymbol.getText()));
            bl = false;
        }
        return stringBuffer.toString();
    }

    public String getTokenType() {
        if (this.getTokenType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getTokenType in class: ");
        }
        this.getTokenType_visited = this.state().boundariesCrossed;
        String string = this.getTokenType_compute();
        this.getTokenType_visited = -1;
        return string;
    }

    private String getTokenType_compute() {
        return this.getOptionValue("%type", "Yytoken");
    }

    @Override
    public Set<CompDecl> Define_java_util_Set_CompDecl__lookupCompDecls(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getStartComponentOptNoTransform()) {
            return this.lookupCompDecls(string);
        }
        return this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, aSTNode, string);
    }

    @Override
    public Set<Embedding> Define_java_util_Set_Embedding__lookupEmbeddings(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupEmbeddings(string);
        }
        return this.getParent().Define_java_util_Set_Embedding__lookupEmbeddings(this, aSTNode, string);
    }

    @Override
    public Set<Declaration> Define_java_util_Set_Declaration__lookupExternDecls(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getComponentListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupExternDecls(string);
        }
        return this.getParent().Define_java_util_Set_Declaration__lookupExternDecls(this, aSTNode, string);
    }

    @Override
    public Layout Define_Layout_getLayout(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this;
        }
        if (aSTNode == this.getComponentListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this;
        }
        if (aSTNode == this.getStartComponentOptNoTransform()) {
            return this;
        }
        return this.getParent().Define_Layout_getLayout(this, aSTNode);
    }

    @Override
    public java.util.List<Embedding> Define_java_util_List_Embedding__getEmbeddingsWithHost(ASTNode aSTNode, ASTNode aSTNode2, CompRef compRef) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.getEmbeddingsWithHost(compRef);
        }
        return this.getParent().Define_java_util_List_Embedding__getEmbeddingsWithHost(this, aSTNode, compRef);
    }

    @Override
    public int Define_int_getEmbeddingIndex(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return n;
        }
        return this.getParent().Define_int_getEmbeddingIndex(this, aSTNode);
    }

    @Override
    public String Define_String_getLexThrowsDecl(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getComponentListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.getLexThrowsDecl();
        }
        return this.getParent().Define_String_getLexThrowsDecl(this, aSTNode);
    }

    @Override
    public String Define_String_getTokenType(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getComponentListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.getTokenType();
        }
        return this.getParent().Define_String_getTokenType(this, aSTNode);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public SortedSet<CompilationError> getErrors() {
        if (this.Layout_getErrors_computed) {
            return this.Layout_getErrors_value;
        }
        if (this.Layout_getErrors_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getErrors in class: ");
        }
        this.Layout_getErrors_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_getErrors_value = this.getErrors_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_getErrors_computed = true;
        }
        this.Layout_getErrors_visited = -1;
        return this.Layout_getErrors_value;
    }

    public Set Layout_getErrors_contributors() {
        return this.Layout_getErrors_contributors;
    }

    private SortedSet<CompilationError> getErrors_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof LayoutWrapper)) {
            aSTNode = aSTNode.getParent();
        }
        LayoutWrapper layoutWrapper = (LayoutWrapper)aSTNode;
        layoutWrapper.collect_contributors_Layout_getErrors();
        this.Layout_getErrors_value = new TreeSet<CompilationError>();
        for (ASTNode aSTNode2 : this.Layout_getErrors_contributors) {
            aSTNode2.contributeTo_Layout_Layout_getErrors(this.Layout_getErrors_value);
        }
        return this.Layout_getErrors_value;
    }

    public Set<MTokRef> listMetaTokens() {
        if (this.Layout_listMetaTokens_computed) {
            return this.Layout_listMetaTokens_value;
        }
        if (this.Layout_listMetaTokens_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listMetaTokens in class: ");
        }
        this.Layout_listMetaTokens_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_listMetaTokens_value = this.listMetaTokens_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_listMetaTokens_computed = true;
        }
        this.Layout_listMetaTokens_visited = -1;
        return this.Layout_listMetaTokens_value;
    }

    public Set Layout_listMetaTokens_contributors() {
        return this.Layout_listMetaTokens_contributors;
    }

    private Set<MTokRef> listMetaTokens_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof Layout)) {
            aSTNode = aSTNode.getParent();
        }
        Layout layout = aSTNode;
        layout.collect_contributors_Layout_listMetaTokens();
        this.Layout_listMetaTokens_value = new TreeSet<MTokRef>(mtokRefComparator);
        for (ASTNode aSTNode2 : this.Layout_listMetaTokens_contributors) {
            aSTNode2.contributeTo_Layout_Layout_listMetaTokens(this.Layout_listMetaTokens_value);
        }
        return this.Layout_listMetaTokens_value;
    }

    public SortedSet<CompilationWarning> getWarnings() {
        if (this.Layout_getWarnings_computed) {
            return this.Layout_getWarnings_value;
        }
        if (this.Layout_getWarnings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getWarnings in class: ");
        }
        this.Layout_getWarnings_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_getWarnings_value = this.getWarnings_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_getWarnings_computed = true;
        }
        this.Layout_getWarnings_visited = -1;
        return this.Layout_getWarnings_value;
    }

    public Set Layout_getWarnings_contributors() {
        return this.Layout_getWarnings_contributors;
    }

    private SortedSet<CompilationWarning> getWarnings_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof LayoutWrapper)) {
            aSTNode = aSTNode.getParent();
        }
        LayoutWrapper layoutWrapper = (LayoutWrapper)aSTNode;
        layoutWrapper.collect_contributors_Layout_getWarnings();
        this.Layout_getWarnings_value = new TreeSet<CompilationWarning>();
        for (ASTNode aSTNode2 : this.Layout_getWarnings_contributors) {
            aSTNode2.contributeTo_Layout_Layout_getWarnings(this.Layout_getWarnings_value);
        }
        return this.Layout_getWarnings_value;
    }

    public java.util.List<CompDecl> getReferencedComponents() {
        if (this.Layout_getReferencedComponents_computed) {
            return this.Layout_getReferencedComponents_value;
        }
        if (this.Layout_getReferencedComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getReferencedComponents in class: ");
        }
        this.Layout_getReferencedComponents_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_getReferencedComponents_value = this.getReferencedComponents_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_getReferencedComponents_computed = true;
        }
        this.Layout_getReferencedComponents_visited = -1;
        return this.Layout_getReferencedComponents_value;
    }

    public Set Layout_getReferencedComponents_contributors() {
        return this.Layout_getReferencedComponents_contributors;
    }

    private java.util.List<CompDecl> getReferencedComponents_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof LayoutWrapper)) {
            aSTNode = aSTNode.getParent();
        }
        LayoutWrapper layoutWrapper = (LayoutWrapper)aSTNode;
        layoutWrapper.collect_contributors_Layout_getReferencedComponents();
        this.Layout_getReferencedComponents_value = new ArrayList<CompDecl>();
        for (ASTNode aSTNode2 : this.Layout_getReferencedComponents_contributors) {
            aSTNode2.contributeTo_Layout_Layout_getReferencedComponents(this.Layout_getReferencedComponents_value);
        }
        return this.Layout_getReferencedComponents_value;
    }

    public Set<RegionMetaPattern> listRegions() {
        if (this.Layout_listRegions_computed) {
            return this.Layout_listRegions_value;
        }
        if (this.Layout_listRegions_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listRegions in class: ");
        }
        this.Layout_listRegions_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_listRegions_value = this.listRegions_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_listRegions_computed = true;
        }
        this.Layout_listRegions_visited = -1;
        return this.Layout_listRegions_value;
    }

    public Set Layout_listRegions_contributors() {
        return this.Layout_listRegions_contributors;
    }

    private Set<RegionMetaPattern> listRegions_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof Layout)) {
            aSTNode = aSTNode.getParent();
        }
        Layout layout = aSTNode;
        layout.collect_contributors_Layout_listRegions();
        this.Layout_listRegions_value = new TreeSet<RegionMetaPattern>(regionComparator);
        for (ASTNode aSTNode2 : this.Layout_listRegions_contributors) {
            aSTNode2.contributeTo_Layout_Layout_listRegions(this.Layout_listRegions_value);
        }
        return this.Layout_listRegions_value;
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout layout;
        if (!this.getHelper() && !this.hasStartComponent() && (layout = this) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        if (!this.getHelper() && this.getReferencedComponents().isEmpty() && (layout = this) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Layout_Layout_getErrors(sortedSet);
        if (!this.getHelper() && !this.hasStartComponent()) {
            sortedSet.add(this.makeCompilationError("Layout " + this.getName() + " has no start component."));
        }
        if (!this.getHelper() && this.getReferencedComponents().isEmpty()) {
            sortedSet.add(this.makeCompilationError("Layout " + this.getName() + " is not using any components."));
        }
    }
}

