/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.CompilationWarning;
import metalexer.ast.ASTNode;
import metalexer.ast.ASTNode$State;
import metalexer.ast.Component;
import metalexer.ast.MacroInvocationRegex;
import metalexer.ast.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroDecl
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getConflictingMacros_visited = -1;
    protected int getDependencies_visited;
    protected boolean getDependencies_computed = false;
    protected boolean getDependencies_initialized = false;
    protected Set<MacroDecl> getDependencies_value;
    protected int isRequired_visited = -1;
    protected int isUsed_visited = -1;
    protected int getComponent_visited = -1;
    protected Map lookupMacroDecls_String_visited;
    protected int MacroDecl_getDirectDependencies_visited = -1;
    protected boolean MacroDecl_getDirectDependencies_computed = false;
    protected Set<MacroDecl> MacroDecl_getDirectDependencies_value;
    Set MacroDecl_getDirectDependencies_contributors = new ASTNode$State.IdentityHashSet(4);

    @Override
    public void flushCache() {
        super.flushCache();
        this.getConflictingMacros_visited = -1;
        this.getDependencies_visited = 0;
        this.getDependencies_computed = false;
        this.getDependencies_initialized = false;
        this.getDependencies_value = null;
        this.isRequired_visited = -1;
        this.isUsed_visited = -1;
        this.getComponent_visited = -1;
        this.lookupMacroDecls_String_visited = new HashMap(4);
        this.MacroDecl_getDirectDependencies_visited = -1;
        this.MacroDecl_getDirectDependencies_computed = false;
        this.MacroDecl_getDirectDependencies_value = null;
        this.MacroDecl_getDirectDependencies_contributors = new ASTNode$State.IdentityHashSet(4);
    }

    @Override
    public MacroDecl clone() throws CloneNotSupportedException {
        MacroDecl macroDecl = (MacroDecl)super.clone();
        macroDecl.getConflictingMacros_visited = -1;
        macroDecl.getDependencies_visited = 0;
        macroDecl.getDependencies_computed = false;
        macroDecl.getDependencies_initialized = false;
        macroDecl.getDependencies_value = null;
        macroDecl.isRequired_visited = -1;
        macroDecl.isUsed_visited = -1;
        macroDecl.getComponent_visited = -1;
        macroDecl.lookupMacroDecls_String_visited = new HashMap(4);
        macroDecl.in$Circle(false);
        macroDecl.is$Final(false);
        return macroDecl;
    }

    public MacroDecl copy() {
        try {
            MacroDecl macroDecl = this.clone();
            if (this.children != null) {
                macroDecl.children = (ASTNode[])this.children.clone();
            }
            return macroDecl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MacroDecl fullCopy() {
        MacroDecl macroDecl = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            macroDecl.setChild(object, i);
        }
        return macroDecl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getName() == null ? 0 : this.getName().hashCode());
        n = 31 * n + (this.getRegex() == null ? 0 : this.getRegex().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MacroDecl macroDecl = (MacroDecl)object;
        if (this.getName() == null ? macroDecl.getName() != null : !this.getName().equals(macroDecl.getName())) {
            return false;
        }
        return !(this.getRegex() == null ? macroDecl.getRegex() != null : !this.getRegex().equals(macroDecl.getRegex()));
    }

    public MacroDecl() {
    }

    public MacroDecl(String string, Regex regex) {
        this.setName(string);
        this.setChild(regex, 0);
    }

    public MacroDecl(Symbol symbol, Regex regex) {
        this.setName(symbol);
        this.setChild(regex, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setRegex(Regex regex) {
        this.setChild(regex, 0);
    }

    public Regex getRegex() {
        return (Regex)this.getChild(0);
    }

    public Regex getRegexNoTransform() {
        return (Regex)this.getChildNoTransform(0);
    }

    public Set<MacroDecl> getConflictingMacros() {
        if (this.getConflictingMacros_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getConflictingMacros in class: ");
        }
        this.getConflictingMacros_visited = this.state().boundariesCrossed;
        Set<MacroDecl> set = this.getConflictingMacros_compute();
        this.getConflictingMacros_visited = -1;
        return set;
    }

    private Set<MacroDecl> getConflictingMacros_compute() {
        String string = this.getName();
        Regex regex = this.getRegex();
        Set<MacroDecl> set = this.lookupMacroDecls(string);
        HashSet<MacroDecl> hashSet = new HashSet<MacroDecl>();
        for (MacroDecl macroDecl : set) {
            if (!string.equals(macroDecl.getName()) || regex.equals(macroDecl.getRegex())) continue;
            hashSet.add(macroDecl);
        }
        return hashSet;
    }

    public Set<MacroDecl> getDependencies() {
        if (this.getDependencies_computed) {
            return this.getDependencies_value;
        }
        if (!this.getDependencies_initialized) {
            this.getDependencies_initialized = true;
            this.getDependencies_value = this.getDirectDependencies();
        }
        if (!this.state().IN_CIRCLE) {
            this.state().IN_CIRCLE = true;
            int n = this.state().boundariesCrossed;
            boolean bl = this.is$Final();
            this.state().CIRCLE_INDEX = 1;
            do {
                this.getDependencies_visited = this.state().CIRCLE_INDEX;
                this.state().CHANGE = false;
                Set<MacroDecl> set = this.getDependencies_compute();
                if (set == null && this.getDependencies_value != null || set != null && !((Object)set).equals(this.getDependencies_value)) {
                    this.state().CHANGE = true;
                }
                this.getDependencies_value = set;
                ++this.state().CIRCLE_INDEX;
            } while (this.state().CHANGE);
            if (bl && n == this.state().boundariesCrossed) {
                this.getDependencies_computed = true;
                this.state().LAST_CYCLE = true;
                this.getDependencies_compute();
                this.state().LAST_CYCLE = false;
            } else {
                this.state().RESET_CYCLE = true;
                this.getDependencies_compute();
                this.state().RESET_CYCLE = false;
                this.getDependencies_computed = false;
                this.getDependencies_initialized = false;
            }
            this.state().IN_CIRCLE = false;
            return this.getDependencies_value;
        }
        if (this.getDependencies_visited != this.state().CIRCLE_INDEX) {
            this.getDependencies_visited = this.state().CIRCLE_INDEX;
            if (this.state().LAST_CYCLE) {
                this.getDependencies_computed = true;
                return this.getDependencies_compute();
            }
            if (this.state().RESET_CYCLE) {
                this.getDependencies_computed = false;
                this.getDependencies_initialized = false;
                return this.getDependencies_value;
            }
            Set<MacroDecl> set = this.getDependencies_compute();
            if (set == null && this.getDependencies_value != null || set != null && !((Object)set).equals(this.getDependencies_value)) {
                this.state().CHANGE = true;
            }
            this.getDependencies_value = set;
            return this.getDependencies_value;
        }
        return this.getDependencies_value;
    }

    private Set<MacroDecl> getDependencies_compute() {
        HashSet<MacroDecl> hashSet = new HashSet<MacroDecl>(this.getDependencies());
        for (MacroDecl macroDecl : this.getDependencies()) {
            hashSet.addAll(macroDecl.getDependencies());
        }
        return hashSet;
    }

    public boolean isRequired() {
        if (this.isRequired_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isRequired in class: ");
        }
        this.isRequired_visited = this.state().boundariesCrossed;
        boolean bl = this.isRequired_compute();
        this.isRequired_visited = -1;
        return bl;
    }

    private boolean isRequired_compute() {
        return this.getComponent().getRequiredMacros().contains(this);
    }

    public boolean isUsed() {
        if (this.isUsed_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isUsed in class: ");
        }
        this.isUsed_visited = this.state().boundariesCrossed;
        boolean bl = this.isUsed_compute();
        this.isUsed_visited = -1;
        return bl;
    }

    private boolean isUsed_compute() {
        String string = this.getName();
        Set<MacroInvocationRegex> set = this.getComponent().getMacroRefs();
        for (MacroInvocationRegex macroInvocationRegex : set) {
            if (!string.equals(macroInvocationRegex.getName())) continue;
            return true;
        }
        return false;
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component component = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return component;
    }

    public Set<MacroDecl> lookupMacroDecls(String string) {
        String string2 = string;
        if (this.lookupMacroDecls_String_visited == null) {
            this.lookupMacroDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupMacroDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupMacroDecls in class: ");
        }
        this.lookupMacroDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<MacroDecl> set = this.getParent().Define_java_util_Set_MacroDecl__lookupMacroDecls(this, null, string);
        this.lookupMacroDecls_String_visited.remove(string2);
        return set;
    }

    @Override
    public MacroDecl Define_MacroDecl_getContainingMacro(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getRegexNoTransform()) {
            return this;
        }
        return this.getParent().Define_MacroDecl_getContainingMacro(this, aSTNode);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public Set<MacroDecl> getDirectDependencies() {
        if (this.MacroDecl_getDirectDependencies_computed) {
            return this.MacroDecl_getDirectDependencies_value;
        }
        if (this.MacroDecl_getDirectDependencies_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDirectDependencies in class: ");
        }
        this.MacroDecl_getDirectDependencies_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.MacroDecl_getDirectDependencies_value = this.getDirectDependencies_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.MacroDecl_getDirectDependencies_computed = true;
        }
        this.MacroDecl_getDirectDependencies_visited = -1;
        return this.MacroDecl_getDirectDependencies_value;
    }

    public Set MacroDecl_getDirectDependencies_contributors() {
        return this.MacroDecl_getDirectDependencies_contributors;
    }

    private Set<MacroDecl> getDirectDependencies_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof Component)) {
            aSTNode = aSTNode.getParent();
        }
        Component component = (Component)aSTNode;
        component.collect_contributors_MacroDecl_getDirectDependencies();
        this.MacroDecl_getDirectDependencies_value = new HashSet<MacroDecl>();
        for (ASTNode aSTNode2 : this.MacroDecl_getDirectDependencies_contributors) {
            aSTNode2.contributeTo_MacroDecl_MacroDecl_getDirectDependencies(this.MacroDecl_getDirectDependencies_value);
        }
        return this.MacroDecl_getDirectDependencies_value;
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component component;
        if (this.getDependencies().contains(this) && (component = this.getComponent()) != null) {
            component.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_Component_getWarnings() {
        Component component;
        if (!this.getComponent().getHelper() && this.getComponent().getFilename().equals(this.getFilename()) && !this.isUsed() && (component = this.getComponent()) != null) {
            component.Component_getWarnings_contributors().add(this);
        }
        super.collect_contributors_Component_getWarnings();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Component_Component_getErrors(sortedSet);
        if (this.getDependencies().contains(this)) {
            sortedSet.add(this.makeCompilationError("Macro " + this.getName() + " depends (possibly indirectly) on itself."));
        }
    }

    @Override
    protected void contributeTo_Component_Component_getWarnings(SortedSet<CompilationWarning> sortedSet) {
        super.contributeTo_Component_Component_getWarnings(sortedSet);
        if (!this.getComponent().getHelper() && this.getComponent().getFilename().equals(this.getFilename()) && !this.isUsed()) {
            sortedSet.add(this.makeCompilationWarning("Macro " + this.getName() + " is unused."));
        }
    }
}

