/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Layout;
import metalexer.jflex.CharacterAssigner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTokRef
extends ASTNode<ASTNode>
implements Cloneable {
    private char charValue;
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int listComponentsMissingDecl_visited = -1;
    protected int makeMissingDeclCompilationError_visited = -1;
    protected int getMetaJFlexName_visited = -1;
    protected int getLayout_visited = -1;
    protected int getComponents_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.listComponentsMissingDecl_visited = -1;
        this.makeMissingDeclCompilationError_visited = -1;
        this.getMetaJFlexName_visited = -1;
        this.getLayout_visited = -1;
        this.getComponents_visited = -1;
    }

    @Override
    public MTokRef clone() throws CloneNotSupportedException {
        MTokRef mTokRef = (MTokRef)super.clone();
        mTokRef.listComponentsMissingDecl_visited = -1;
        mTokRef.makeMissingDeclCompilationError_visited = -1;
        mTokRef.getMetaJFlexName_visited = -1;
        mTokRef.getLayout_visited = -1;
        mTokRef.getComponents_visited = -1;
        mTokRef.in$Circle(false);
        mTokRef.is$Final(false);
        return mTokRef;
    }

    public MTokRef copy() {
        try {
            MTokRef mTokRef = this.clone();
            if (this.children != null) {
                mTokRef.children = (ASTNode[])this.children.clone();
            }
            return mTokRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MTokRef fullCopy() {
        MTokRef mTokRef = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            mTokRef.setChild(object, i);
        }
        return mTokRef;
    }

    public char getCharValue() {
        return this.charValue;
    }

    @Override
    public void assignCharsToMetaTokens(CharacterAssigner characterAssigner) {
        this.charValue = characterAssigner.assignChar(this.getMetaJFlexName());
        super.assignCharsToMetaTokens(characterAssigner);
    }

    public MTokRef() {
    }

    public MTokRef(String string) {
        this.setName(string);
    }

    public MTokRef(Symbol symbol) {
        this.setName(symbol);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public List<Component> listComponentsMissingDecl() {
        if (this.listComponentsMissingDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listComponentsMissingDecl in class: ");
        }
        this.listComponentsMissingDecl_visited = this.state().boundariesCrossed;
        List<Component> list = this.listComponentsMissingDecl_compute();
        this.listComponentsMissingDecl_visited = -1;
        return list;
    }

    private List<Component> listComponentsMissingDecl_compute() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : this.getComponents()) {
            if (component == null || component.listMetaTokens().contains(this.getName())) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    public CompilationError makeMissingDeclCompilationError() {
        if (this.makeMissingDeclCompilationError_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: makeMissingDeclCompilationError in class: ");
        }
        this.makeMissingDeclCompilationError_visited = this.state().boundariesCrossed;
        CompilationError compilationError = this.makeMissingDeclCompilationError_compute();
        this.makeMissingDeclCompilationError_visited = -1;
        return compilationError;
    }

    private CompilationError makeMissingDeclCompilationError_compute() {
        StringBuffer stringBuffer = new StringBuffer("MetaToken " + this.getName() + " is not declared in components: ");
        boolean bl = true;
        for (Component component : this.listComponentsMissingDecl()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(component.getName());
        }
        stringBuffer.append(".");
        return this.makeCompilationError(stringBuffer.toString());
    }

    public String getMetaJFlexName() {
        if (this.getMetaJFlexName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexName in class: ");
        }
        this.getMetaJFlexName_visited = this.state().boundariesCrossed;
        String string = this.getMetaJFlexName_compute();
        this.getMetaJFlexName_visited = -1;
        return string;
    }

    private String getMetaJFlexName_compute() {
        return "t_" + this.getName();
    }

    public Layout getLayout() {
        if (this.getLayout_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLayout in class: ");
        }
        this.getLayout_visited = this.state().boundariesCrossed;
        Layout layout = this.getParent().Define_Layout_getLayout(this, null);
        this.getLayout_visited = -1;
        return layout;
    }

    public List<Component> getComponents() {
        if (this.getComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponents in class: ");
        }
        this.getComponents_visited = this.state().boundariesCrossed;
        List<Component> list = this.getParent().Define_java_util_List_Component__getComponents(this, null);
        this.getComponents_visited = -1;
        return list;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout layout;
        if (!this.listComponentsMissingDecl().isEmpty() && (layout = this.getLayout()) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void collect_contributors_Layout_listMetaTokens() {
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.Layout_listMetaTokens_contributors().add(this);
        }
        super.collect_contributors_Layout_listMetaTokens();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Layout_Layout_getErrors(sortedSet);
        if (!this.listComponentsMissingDecl().isEmpty()) {
            sortedSet.add(this.makeMissingDeclCompilationError());
        }
    }

    @Override
    protected void contributeTo_Layout_Layout_listMetaTokens(Set<MTokRef> set) {
        super.contributeTo_Layout_Layout_listMetaTokens(set);
        set.add(this);
    }
}

