/*
 * Decompiled with CFR 0.152.
 */
package beaver;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public final class ParsingTables {
    private final short[] actions;
    final short[] lookaheads;
    final int[] actn_offsets;
    private final int[] goto_offsets;
    private final short[] default_actions;
    final int[] rule_infos;
    final short error_symbol_id;
    final boolean compressed;
    final int n_term;
    static final int UNUSED_OFFSET = Integer.MIN_VALUE;

    public ParsingTables(Class clazz) {
        this(ParsingTables.getSpecAsResourceStream(clazz));
    }

    public ParsingTables(String string) {
        this(new ByteArrayInputStream(ParsingTables.decode(string)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsingTables(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(inputStream));
            try {
                int n;
                int n2 = dataInputStream.readInt();
                this.actions = new short[n2];
                for (n = 0; n < n2; ++n) {
                    this.actions[n] = dataInputStream.readShort();
                }
                this.lookaheads = new short[n2];
                for (n = 0; n < n2; ++n) {
                    this.lookaheads[n] = dataInputStream.readShort();
                }
                n2 = dataInputStream.readInt();
                this.actn_offsets = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.actn_offsets[n] = dataInputStream.readInt();
                }
                this.goto_offsets = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.goto_offsets[n] = dataInputStream.readInt();
                }
                n2 = dataInputStream.readInt();
                boolean bl = this.compressed = n2 != 0;
                if (this.compressed) {
                    this.default_actions = new short[n2];
                    for (n = 0; n < n2; ++n) {
                        this.default_actions[n] = dataInputStream.readShort();
                    }
                } else {
                    this.default_actions = null;
                }
                n = Integer.MAX_VALUE;
                n2 = dataInputStream.readInt();
                this.rule_infos = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    this.rule_infos[i] = dataInputStream.readInt();
                    n = Math.min(n, this.rule_infos[i] >>> 16);
                }
                this.n_term = n;
                this.error_symbol_id = dataInputStream.readShort();
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot initialize parser tables: " + iOException.getMessage());
        }
    }

    final short findFirstTerminal(int n) {
        int n2;
        short s;
        int n3 = this.actn_offsets[n];
        short s2 = s = n3 < 0 ? (short)(-n3) : (short)0;
        while (s < this.n_term && (n2 = n3 + s) < this.lookaheads.length) {
            if (this.lookaheads[n2] == s) {
                return s;
            }
            s = (short)(s + 1);
        }
        return -1;
    }

    final short findParserAction(int n, short s) {
        int n2 = this.actn_offsets[n];
        if (n2 != Integer.MIN_VALUE && 0 <= (n2 += s) && n2 < this.actions.length && this.lookaheads[n2] == s) {
            return this.actions[n2];
        }
        return this.compressed ? this.default_actions[n] : (short)0;
    }

    final short findNextState(int n, short s) {
        int n2 = this.goto_offsets[n];
        if (n2 != Integer.MIN_VALUE && 0 <= (n2 += s) && n2 < this.actions.length && this.lookaheads[n2] == s) {
            return this.actions[n2];
        }
        return this.compressed ? this.default_actions[n] : (short)0;
    }

    static byte[] decode(String string) {
        int n;
        char[] cArray = string.toCharArray();
        if (cArray.length % 4 != 0) {
            throw new IllegalArgumentException("corrupted encoding");
        }
        int n2 = cArray.length / 4 * 3;
        byte[] byArray = new byte[cArray[cArray.length - 1] == '=' ? (cArray[cArray.length - 2] == '=' ? n2 - 2 : n2 - 1) : n2];
        n2 -= 3;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = ParsingTables.decode(cArray[n3++]) << 18 | ParsingTables.decode(cArray[n3++]) << 12 | ParsingTables.decode(cArray[n3++]) << 6 | ParsingTables.decode(cArray[n3++]);
            byArray[n4++] = (byte)(n >> 16);
            byArray[n4++] = (byte)(n >> 8 & 0xFF);
            byArray[n4++] = (byte)(n & 0xFF);
        }
        n = ParsingTables.decode(cArray[n3++]) << 18 | ParsingTables.decode(cArray[n3++]) << 12 | ParsingTables.decode(cArray[n3++]) << 6 | ParsingTables.decode(cArray[n3++]);
        byArray[n4++] = (byte)(n >> 16);
        if (n4 < byArray.length) {
            byArray[n4++] = (byte)(n >> 8 & 0xFF);
            if (n4 < byArray.length) {
                byArray[n4++] = (byte)(n & 0xFF);
            }
        }
        return byArray;
    }

    static int decode(char c) {
        if (c <= '9') {
            if (c >= '0') {
                return c - 48;
            }
            if (c == '#') {
                return 62;
            }
            if (c == '$') {
                return 63;
            }
        } else if (c <= 'Z') {
            if (c >= 'A') {
                return c - 65 + 10;
            }
            if (c == '=') {
                return 0;
            }
        } else if ('a' <= c && c <= 'z') {
            return c - 97 + 36;
        }
        throw new IllegalStateException("illegal encoding character '" + c + "'");
    }

    static InputStream getSpecAsResourceStream(Class clazz) {
        String string = clazz.getName();
        InputStream inputStream = clazz.getResourceAsStream(string = string.substring(string.lastIndexOf(46) + 1) + ".spec");
        if (inputStream == null) {
            throw new IllegalStateException("parser specification not found");
        }
        return inputStream;
    }
}

