/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.AltRegex;
import metalexer.ast.AnyPattern;
import metalexer.ast.AppendRegion;
import metalexer.ast.CharClassRegex;
import metalexer.ast.CharRegex;
import metalexer.ast.Component;
import metalexer.ast.ComponentDirective;
import metalexer.ast.ComponentWrapper;
import metalexer.ast.DeclRegion;
import metalexer.ast.Deletion;
import metalexer.ast.DotRegex;
import metalexer.ast.EOFPattern;
import metalexer.ast.EOLRegexPattern;
import metalexer.ast.EscapeRegex;
import metalexer.ast.ExternDecl;
import metalexer.ast.ExternDirective;
import metalexer.ast.HeaderBlob;
import metalexer.ast.HeaderSection;
import metalexer.ast.HelperDirective;
import metalexer.ast.ImportDirective;
import metalexer.ast.InheritSection;
import metalexer.ast.InitRegion;
import metalexer.ast.InitThrowDirective;
import metalexer.ast.LexThrowDirective;
import metalexer.ast.List;
import metalexer.ast.LookaheadRegexPattern;
import metalexer.ast.MacroDecl;
import metalexer.ast.MacroInvocationRegex;
import metalexer.ast.MultiCharRange;
import metalexer.ast.NotRegex;
import metalexer.ast.Opt;
import metalexer.ast.OptRegex;
import metalexer.ast.Pattern;
import metalexer.ast.PlusRegex;
import metalexer.ast.RangeRepeatRegex;
import metalexer.ast.Regex;
import metalexer.ast.RepeatRegex;
import metalexer.ast.Rule;
import metalexer.ast.RuleGroup;
import metalexer.ast.RuleSection;
import metalexer.ast.SeqRegex;
import metalexer.ast.SingleCharRange;
import metalexer.ast.StarRegex;
import metalexer.ast.StartDirective;
import metalexer.ast.State;
import metalexer.ast.StateDirective;
import metalexer.ast.StateRef;
import metalexer.ast.StringRegex;
import metalexer.ast.UptoRegex;
import metalexer.ast.XStateDirective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentParser
extends Parser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjMWUK55KMlLqzf1c2OJ6iYc4L54cAA2WWIXOaYeGH94WGH78G4OOiOC2Siu2A4H3526904H098b4a2uYkehZhxj$xNbLNLrV$gMdSTO#xXthdllVhXVjVLVsgxfuQe7WJyt6#ybSygFeJQ$GTYZT69Po9ir0NzRZtDaKyP$kUvoFbdwAHPGnhXherk1IduWprtuAJSOhv1UUYCghW7FDabE14rGjnKXgN#AS95nRu#Kz42Rge3lASJfutAUBlPzumRw2ed$zubE0krK6kEZW3jSqCzNT6VroBw$tynw84sQg3NCCzBl7deZQESSSgZqO9Jb0TvBgHNCtGGlqTSHNEGmS$$v4eGGtLGQw7oNKbsga$5zUW1oxoyn#E4enHdUGgXrQumjo42UhlY3QucdqbyX#A4doazYOpdNmLFJvXcw7HalWGbw2bd$z0bA2vskbcPdB5enRtfwl$xvnZ4Az48l##A45hjJFDC#OjynQAuJJyXNiYulyRvsYBk$tyEwC4XTK#mxFS14LGpFoANFAAIBGF8ztHry#$FL9#5KscZhWSuz41JNKTrERv5lzrkChCG6y$#xOeuRaNBVMvh1zdvflv688RC4BzkLYCsyrGF$#MAC5ujJVZVUKRhtn3pUiKYOflCds9$5kZ15FLtaoPH4mm8xaQNgFSgD7RUBItqfF8lojIHgeUnzf9PX8ke1ulwmj7Y1ztu7myW4v#zlrHWeVKZgDC5AqyWgeQhOdsFEvUVlwzKO8vgdDHZLmJKPDwh79LLtzDCy$CGqy$VrgKO9pgZkWcrn5TCT5yZmSnstolyH$C3yYZJkJV4IbBL4$0XNhDQkfrV9NY#hyrt#9LwaJstL72liHEe8mNpRv#D3$Y3Mg93iHhoEEH9lBlYPHFLO$5O7ADPvNeSPZl#idv3po2iNxsWr62#zIE9Tlzeiq$p7VaMcY#q#XRl8hZyRAV$nxA4E#PD67M4lC9xZIVX8MHkm2yu#TEHGvqOvMhR$OoTS$CDhFHa6Y0HhWC0t0nogC2wgEnH9WdSMypKycMq19zELAcY8Pbq#XBaJ9PTA1YYfdYQes#62NCK#tNJZQJNQtn5wA4UQejFKjyLfGmHxMbLkBFHGbpL5jg9Vvib317jQLMuaz72NDKMseb$bIKC4UrfLRYSymShgivbdKb4RZQKak$UILAcAFQKYlnuRIAD5c0E76FMH0MhzpnCuVuZCDT7SYSuaKM93NjGW4p5gR9kumemkBFuMK6ZcEXvmzaUhvtavfsc80PmzBa1aOKOV7dy383imxp$CdCnB7U4D2B1OmlJfEF6564nP$1ompCkTZp#vc9g5lbwH42naUaoMY66n9fgyoVmSiCp3d2yu$6C8p4JGaFjz4Q6Ht#ZQ2nF#jl1E1FkbUQc8GIr4UXK6GNKLoZT3Ql2t$xRLqKzxeurdB7ZIhmBENR1Mij4PDdHfayjM7va5v5MFovlCp05Sdp$A5CZsaHVOlKXcKClOgm#FLUPe1naUSFPRfCgZCzxwLurexAvxn6SHoNxncFdDaiDKjHcfY48$MAfspqgqwNGCugiqeqdyjBBQjabTQlIfS0mpgpJZGPLbaOrkaSwooosgncZ0WSzUi#wsfNMsIDMSF8cfGZNUsFrhZQ8b#QBndvCgNEPt7zafCcQyrQHjQcdDfadsjTRP4LPWKZArBgaa$u5Qwso4gpaf6LANtwBAvVSjBaS$Cv8v#drFaihbzoqkGBymKZNwJK#IokNtBIP9bPniYobEFxmAzRvcgBV6O#O#IpbFby5jSlEMcot2ndP7bAdS$Y#YKdBB0yR#aDtxqDSRHbzRxFtFV3WjGjVC#w$GGopGSutdmG5idnityoFubEOt4pv#hEB3oF5$0YNi8hc8StyJOMuMDbTxV7yGIUn5Du6jCn0pFn39x5S#Q0ES2S0xZN9ttKu$xP$8ovX9LP$PgJ9llCFaRsXNkbRozbdzahKOlizNF2iiViOMIFXV4RoXxpZKGjyesV4vRTPZSZkosCkoYxpIw9McINdnEMdMOd8pijZ3ieEyqEYLfaXvyJbkrcEoFRBOpRADlDDebQP9kV4vQjPYiZMosCNrEscgybQf6l$PomR35R6DbYOVoAiiLy9L6BVENdX6MpsSp8PWlZ9ifciqcY5jdavuHbWzd0o0OBuqRA1hDHeXRPwEU4PRrPpyXw2#D1odfpKA8MEUZdX6M$sS$8Vlit0ub9D5q2KxjF6VitYyS2UTQdG07rVm2lcMlub3DpBUVSYzXYMb6M9WO7SMIX40gZ28gY6BAHW#8QASL8DNutEfhF#j8uXj#6ZyFnVFwVm6$99L56FmTEnVcu0DLH0nUYdFhB1pnL8cQGNE08Vl#AqoPhBa9DrCA9E0brS0a$To1$ivMt0WLmzLEkkXWKmTKgGwxQoXNcaOXmEJfgdY5NpCfLaP#jmYL$tnw2ipFaQXR9vN1q7Yfdo5NIobMRAolHLwMC#weKoUNeADE#ogPnIJLmhjzNWupxggjSPPYJv1Esc7ALHslQ1XboLL2kiYbSSkOhAnTGbP6AXypbtacobyfL8UFrrStZSj0Jrv8BkWuIN8vo3SwGo#t4qRCSurckeAEA72NEVTL3FFTIuoYJ#Aggp#shDQzeflTspEkhRw2pClxzABus6VVLCDGNUExSPv5mbUFHbiXuhIRELndbAwjyjVNPB5p2qpBZzLKer9Vm2EehLoFon3BcolBwggzyZNo#19VaPCeLlevDD7yWyzsr6iCL71$AlPtQb$ZFzRcoCkQozvNbzLKVNTXNet#ZhxhCTVlAOdLBycV6rSFlgu#tJa6kkbvVNLWRI#DgPU6AyMdlS5tR8Z5ZS9t$2UoWbz4DvLINHtytedld5D3lUTAlyJRfcvfzKoUkIVwrJh0sk1rwRNBcWckPzn#hFPIU3zV#CMff7SBshRKhMQz9ZtZL0$nxPgZFcBXdoYJk6LH9ZNXxEYll9iki#VNZpr4cUJ$cDwlSgV$zMMt7wirPvVzvpl1tLVNgRmJQUhhNa6YCowYRulAeBWhYYkZlDtM1wt#$DPYCy5ugdzzTzhyyrw6TTtRMD9$E2kQmp1zTfK$5XdmgUbVSf6mefThoUpoG0$rk4ESgAMlfcGpyJlExC2JgYEGJhMp1lIVh0ZqShZjSbq#TxNdBbHgwUxbw6rjMR#IJn9ivTC#cU#sVnyRx$DOCox4bMIBEIOia2wv4MxH3UtH0Bgv2HtJ2rUZitvtTVSxUoJdbBtRvC1$ITJZCU9ZnC6F1ZFbyCyZaSzhxvMwjRn78ipu52gZ$8tZpF#UP$3RyD4$UK1XzDoNVYke0XLkHSZh7OfSGyWxp5Q1GBcFt00vpOcquNilnMA387RGJkR#TuvA4NBLNWQBihLWVOYXzmlqT45z8dbx4lOJy5rufWlanUNCoXNdoXlLse7X586SJyty0ieuaAdD$Dos$cUVyI4jU#NjBrcHY9Y5lcASHMzXBHs8CVVAMSHuXxwpVv1n5E6UCTX3n0F4kkRWoOzqPRylOoRJobbpw#fZOprXfuYAY2$UbPXinYVp5Q7iJyb#NFExOIeBpntuXs9T3n9wW9MUCVJlr2PupX$oE#Cdly1WSdhiOvt7s4Q$nU6M#ZpZUI73UU9muYsXEr23OHtm2COJWiMQL8MgovaPY1h63TOKOUuZ7KuldCPlxh7TuBOkJsnb6SBvuDLuN7e$JcZMdqtQWxoYU$yK4#uql8pfnt98yAmXU2wShpzUZjADuhNDeIt3$7TedkNySmMEKBNutkP$dWF7u78BNDtugytZjYv$2SKEY9tE#9DXljaDm7MIVJLGdhY1udDayLzbS4zayhcpoP2ydk4wp3t9U7cEESAwXhKIxYvQ$8N9u7UFi8uVNECxhMfJ77vzAMvQub6EkhQ8yhlXysX6qRz1oBHQTJSWnBwNbUe#lOs#5YTE8skJZRH9VJ$jmdXvZeI9YtN5X7azij3j6Sy#ox$X8ngOayueqyEmurnOx8n7pUFeorYleuttvSt0$36xja#FOiSpV6wWzuFaljjSwjtfsLi0tnxFMURcD3ipNFRgtM9xSFrxTae2$PgYFwwY#3#nFA#2Ocp7dJc$yKw3kzQYwL8xucPwj6#AU7XWlIQzpbdjrJVBdTexmR5MgKe4vvRbOpLvJR3ZZzRowpe4U0kSbvyPCZo$Yk0TuSyoon4fOVEqyEz3hfsngFBR7inKjjMEy6jccO2Y$0GmWhbKuw4PlD$LbeJTjR$haIToTupuA1psutuFZhlm6S0ttMzAsu7wck99eIxGZsXCTo36GDfVsAg8ZqOcuckXCo3k3BfoZBcqhuZf57Arf#ohYQABlOTntCV8NX6OSoxk3DlnaRipnzGhtLr4$zj#F#$MODuYsZeTB50uH3zWiN4g$e2PHIn7dBwyOuV2NM8nm5DKvhgxMHIFkDzAtAY0aLfZ8vk#tE17B5nUovnhCgS6vQ#YuCE6eRp3jOFg7q0wXRK3R861xiZw1YmEe7K9JXQD$uRcCuyiLSQ8G#dFSNzwgCDQBu#Ra7VOlBCSMXm==");
    private String filename = null;
    private final SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public SortedSet<CompilationProblem> getProblems() {
        return Collections.unmodifiableSortedSet(this.problems);
    }

    public boolean hasProblem() {
        return !this.problems.isEmpty();
    }

    private CompilationError buildError(Symbol symbol, String string) {
        return new CompilationError(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationError buildError(Scanner.Exception exception, String string) {
        return new CompilationError(this.filename, exception.line, exception.column, string);
    }

    private CompilationWarning buildWarning(Symbol symbol, String string) {
        return new CompilationWarning(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationWarning buildWarning(Scanner.Exception exception, String string) {
        return new CompilationWarning(this.filename, exception.line, exception.column, string);
    }

    private static <T extends ASTNode<?>> List<T> makeListNode(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new List<T>().addAll(list);
    }

    private static <T extends ASTNode<?>> List<T> nullToEmpty(List<T> list) {
        return list == null ? new List() : list;
    }

    private static SingleCharRange makeSingleCharRange(Symbol symbol) {
        SingleCharRange singleCharRange = new SingleCharRange(symbol);
        singleCharRange.acquirePositionFromChildren();
        return singleCharRange;
    }

    private static MultiCharRange makeMultiCharRange(Symbol symbol, Symbol symbol2) {
        MultiCharRange multiCharRange = new MultiCharRange(symbol, symbol2);
        multiCharRange.acquirePositionFromChildren();
        return multiCharRange;
    }

    private Symbol buildComponent(HeaderSection headerSection, RuleSection ruleSection, List<InheritSection> list) {
        Object object;
        StateRef stateRef = null;
        boolean bl = false;
        List<State> list2 = new List<State>();
        LinkedHashSet<StringSymbol> linkedHashSet = new LinkedHashSet<StringSymbol>();
        List<ExternDecl> list3 = new List<ExternDecl>();
        LinkedHashSet<StringSymbol> linkedHashSet2 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet3 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet4 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet5 = new LinkedHashSet<StringSymbol>();
        StringSymbol stringSymbol = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<Iterator<String>> hashSet3 = new HashSet<Iterator<String>>();
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<String> hashSet5 = new HashSet<String>();
        HashSet<String> hashSet6 = new HashSet<String>();
        HashSet<String> hashSet7 = new HashSet<String>();
        for (HeaderBlob symbol2 : headerSection.getHeaderBlobs()) {
            if (symbol2 instanceof StartDirective) {
                if (stateRef == null) {
                    stateRef = ((StartDirective)symbol2).getState();
                    continue;
                }
                this.problems.add(this.buildWarning(symbol2, "Start state has already been declared."));
                continue;
            }
            if (symbol2 instanceof HelperDirective) {
                if (bl) {
                    this.problems.add(this.buildWarning(symbol2, "Component has already been flagged as a helper component."));
                }
                bl = true;
                continue;
            }
            if (symbol2 instanceof StateDirective) {
                for (State state : ((StateDirective)symbol2).getStates()) {
                    String string = state.getName();
                    if (hashSet.contains(string)) {
                        this.problems.add(this.buildWarning(state, "Duplicate declaration of state " + string + "."));
                        continue;
                    }
                    list2.add(state);
                    hashSet.add(string);
                }
                continue;
            }
            if (symbol2 instanceof XStateDirective) {
                for (State state : ((XStateDirective)symbol2).getStates()) {
                    String string = state.getName();
                    if (hashSet2.contains(string)) {
                        this.problems.add(this.buildWarning(state, "Duplicate declaration of xstate " + string + "."));
                        continue;
                    }
                    list2.add(state);
                    hashSet2.add(string);
                }
                continue;
            }
            if (symbol2 instanceof ImportDirective) {
                object = ((ImportDirective)symbol2).getText();
                if (hashSet3.contains(object)) {
                    this.problems.add(this.buildWarning(symbol2, "Duplicate import."));
                    continue;
                }
                linkedHashSet.add(new StringSymbol(symbol2, (String)object));
                hashSet3.add((Iterator<String>)object);
                continue;
            }
            if (symbol2 instanceof ExternDirective) {
                object = ((ExternDirective)symbol2).getExternDecl();
                String string = ((ExternDecl)object).getText();
                if (hashSet4.contains(string)) {
                    this.problems.add(this.buildWarning(symbol2, "Duplicate extern."));
                    continue;
                }
                list3.add((ExternDecl)object);
                hashSet4.add(string);
                continue;
            }
            if (symbol2 instanceof DeclRegion) {
                linkedHashSet2.add(new StringSymbol(symbol2, ((DeclRegion)symbol2).getText()));
                continue;
            }
            if (symbol2 instanceof LexThrowDirective) {
                for (String string : ((LexThrowDirective)symbol2).getExceptions()) {
                    if (hashSet5.contains(string)) {
                        this.problems.add(this.buildWarning(symbol2, "Duplicate declaration of lex exception " + string + "."));
                        continue;
                    }
                    linkedHashSet3.add(new StringSymbol(symbol2, string));
                    hashSet5.add(string);
                }
                continue;
            }
            if (symbol2 instanceof InitRegion) {
                linkedHashSet4.add(new StringSymbol(symbol2, ((InitRegion)symbol2).getText()));
                continue;
            }
            if (symbol2 instanceof InitThrowDirective) {
                for (String string : ((InitThrowDirective)symbol2).getExceptions()) {
                    if (hashSet5.contains(string)) {
                        this.problems.add(this.buildWarning(symbol2, "Duplicate declaration of init exception " + string + "."));
                        continue;
                    }
                    linkedHashSet5.add(new StringSymbol(symbol2, string));
                    hashSet6.add(string);
                }
                continue;
            }
            if (symbol2 instanceof AppendRegion) {
                if (stringSymbol == null) {
                    stringSymbol = new StringSymbol(symbol2, ((AppendRegion)symbol2).getText());
                    continue;
                }
                this.problems.add(this.buildWarning(symbol2, "Component already has an %append region."));
                continue;
            }
            throw new RuntimeException("Unexpected header blob type: " + symbol2.getClass().getName());
        }
        ComponentDirective componentDirective = headerSection.getComponentDirective();
        Symbol symbol = new Symbol(0, componentDirective.Namestart, componentDirective.Nameend, componentDirective.getName());
        object = new List();
        for (MacroDecl macroDecl : headerSection.getMacroDeclList()) {
            String string = macroDecl.getName();
            if (hashSet7.contains(string)) {
                this.problems.add(this.buildWarning(macroDecl, "Duplicate declaration of macro " + string + "."));
                continue;
            }
            ((List)object).add((MacroDecl)macroDecl);
            hashSet7.add(string);
        }
        Opt<StateRef> opt = stateRef == null ? new Opt<StateRef>() : new Opt<StateRef>(stateRef);
        return new Component(symbol, bl, opt, list2, (Set<StringSymbol>)linkedHashSet, list3, (Set<StringSymbol>)linkedHashSet2, (Set<StringSymbol>)linkedHashSet3, (Set<StringSymbol>)linkedHashSet4, (Set<StringSymbol>)linkedHashSet5, stringSymbol, (List<MacroDecl>)object, ruleSection, list);
    }

    public ComponentParser() {
        super(PARSING_TABLES);
        this.report = new Events();
    }

    @Override
    protected Symbol invokeReduceAction(int n, int n2) {
        switch (n) {
            case 0: {
                Symbol symbol = this._symbols[n2 + 1];
                Component component = (Component)symbol.value;
                ComponentWrapper componentWrapper = new ComponentWrapper(component);
                componentWrapper.setFilenameOnSubtreeNoTransform(this.filename);
                return componentWrapper;
            }
            case 1: {
                Symbol symbol = this._symbols[n2 + 1];
                HeaderSection headerSection = (HeaderSection)symbol.value;
                return this.buildComponent(headerSection, new RuleSection(new List<RuleGroup>(), new List<RuleGroup>(), new List<RuleGroup>()), new List<InheritSection>());
            }
            case 2: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 3: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 6: {
                Symbol symbol = this._symbols[n2 + 1];
                HeaderSection headerSection = (HeaderSection)symbol.value;
                Symbol symbol2 = this._symbols[n2 + 3];
                RuleSection ruleSection = (RuleSection)symbol2.value;
                Symbol symbol3 = this._symbols[n2 + 4];
                ArrayList arrayList = (ArrayList)symbol3.value;
                InheritSection[] inheritSectionArray = arrayList == null ? new InheritSection[]{} : arrayList.toArray(new InheritSection[arrayList.size()]);
                return this.buildComponent(headerSection, ruleSection, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)));
            }
            case 7: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 8: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 11: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 12: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 15: {
                Symbol symbol = this._symbols[n2 + 1];
                ComponentDirective componentDirective = (ComponentDirective)symbol.value;
                Symbol symbol4 = this._symbols[n2 + 2];
                ArrayList arrayList = (ArrayList)symbol4.value;
                HeaderBlob[] headerBlobArray = arrayList == null ? new HeaderBlob[]{} : arrayList.toArray(new HeaderBlob[arrayList.size()]);
                Symbol symbol5 = this._symbols[n2 + 3];
                ArrayList arrayList2 = (ArrayList)symbol5.value;
                MacroDecl[] macroDeclArray = arrayList2 == null ? new MacroDecl[]{} : arrayList2.toArray(new MacroDecl[arrayList2.size()]);
                return new HeaderSection(componentDirective, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList2)));
            }
            case 16: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new ComponentDirective(symbol);
            }
            case 17: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol6 = this._symbols[n2 + 3];
                Regex regex = (Regex)symbol6.value;
                return new MacroDecl(string, regex);
            }
            case 29: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new DeclRegion(string);
            }
            case 30: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new InitRegion(string);
            }
            case 31: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new AppendRegion(string);
            }
            case 32: {
                return new HelperDirective();
            }
            case 33: {
                Symbol symbol = this._symbols[n2 + 2];
                StateRef stateRef = (StateRef)symbol.value;
                return new StartDirective(stateRef);
            }
            case 34: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new ExternDecl(string);
            }
            case 35: {
                Symbol symbol = this._symbols[n2 + 2];
                ExternDecl externDecl = (ExternDecl)symbol.value;
                return new ExternDirective(externDecl);
            }
            case 36: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new ImportDirective(string);
            }
            case 37: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new InitThrowDirective(list);
            }
            case 38: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new LexThrowDirective(list);
            }
            case 39: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return new StateDirective(list);
            }
            case 40: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return new XStateDirective(list);
            }
            case 41: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                return new Symbol(arrayList);
            }
            case 42: {
                Symbol symbol = this._symbols[n2 + 1];
                java.util.List list = (java.util.List)symbol.value;
                Symbol symbol7 = this._symbols[n2 + 3];
                String string = (String)symbol7.value;
                list.add(string);
                return symbol;
            }
            case 44: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new State(symbol, false);
            }
            case 45: {
                Symbol symbol = this._symbols[n2 + 1];
                State state = (State)symbol.value;
                return new List<State>().add(state);
            }
            case 46: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol8 = this._symbols[n2 + 3];
                State state = (State)symbol8.value;
                return list.add(state);
            }
            case 47: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new State(symbol, true);
            }
            case 48: {
                Symbol symbol = this._symbols[n2 + 1];
                State state = (State)symbol.value;
                return new List<State>().add(state);
            }
            case 49: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol9 = this._symbols[n2 + 3];
                State state = (State)symbol9.value;
                return list.add(state);
            }
            case 50: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new StateRef(symbol);
            }
            case 51: {
                Symbol symbol = this._symbols[n2 + 1];
                StateRef stateRef = (StateRef)symbol.value;
                return new List<StateRef>().add(stateRef);
            }
            case 52: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol10 = this._symbols[n2 + 3];
                StateRef stateRef = (StateRef)symbol10.value;
                return list.add(stateRef);
            }
            case 55: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                Symbol symbol11 = this._symbols[n2 + 3];
                Pattern pattern = (Pattern)symbol11.value;
                return new Deletion(list, pattern);
            }
            case 56: {
                Symbol symbol = this._symbols[n2 + 4];
                Pattern pattern = (Pattern)symbol.value;
                return new Deletion(new List<StateRef>(), pattern);
            }
            case 57: {
                Symbol symbol = this._symbols[n2 + 1];
                Rule rule = (Rule)symbol.value;
                return new RuleGroup(new List<StateRef>(), new List<Rule>().add(rule));
            }
            case 58: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 59: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 60: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol12 = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol12.value;
                Rule[] ruleArray = arrayList == null ? new Rule[]{} : arrayList.toArray(new Rule[arrayList.size()]);
                return new RuleGroup(list, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)));
            }
            case 63: {
                Symbol symbol = this._symbols[n2 + 1];
                Pattern pattern = (Pattern)symbol.value;
                Symbol symbol13 = this._symbols[n2 + 2];
                String string = (String)symbol13.value;
                Symbol symbol14 = this._symbols[n2 + 3];
                String string2 = (String)symbol14.value;
                return new Rule(pattern, symbol13, symbol14);
            }
            case 67: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(false, regex, false);
            }
            case 68: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(false, regex, true);
            }
            case 69: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol15 = this._symbols[n2 + 3];
                Regex regex2 = (Regex)symbol15.value;
                return new LookaheadRegexPattern(false, regex, regex2);
            }
            case 70: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(true, regex, false);
            }
            case 71: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(true, regex, true);
            }
            case 72: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                Symbol symbol16 = this._symbols[n2 + 4];
                Regex regex3 = (Regex)symbol16.value;
                return new LookaheadRegexPattern(true, regex, regex3);
            }
            case 73: {
                return new AnyPattern();
            }
            case 74: {
                return new EOFPattern();
            }
            case 77: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol17 = this._symbols[n2 + 3];
                Regex regex4 = (Regex)symbol17.value;
                return new AltRegex(regex, regex4);
            }
            case 79: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol18 = this._symbols[n2 + 2];
                Regex regex5 = (Regex)symbol18.value;
                return new SeqRegex(regex, regex5);
            }
            case 81: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new NotRegex(regex);
            }
            case 82: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new UptoRegex(regex);
            }
            case 84: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new OptRegex(regex);
            }
            case 85: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new PlusRegex(regex);
            }
            case 86: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new StarRegex(regex);
            }
            case 87: {
                ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
                arrayList.add(this._symbols[n2 + 1]);
                return new Symbol(arrayList);
            }
            case 88: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2]);
                return this._symbols[n2 + 1];
            }
            case 91: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol19 = this._symbols[n2 + 4];
                String string = (String)symbol19.value;
                return new RepeatRegex(regex, string);
            }
            case 92: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol20 = this._symbols[n2 + 4];
                String string = (String)symbol20.value;
                Symbol symbol21 = this._symbols[n2 + 8];
                String string3 = (String)symbol21.value;
                return new RangeRepeatRegex(regex, string, string3);
            }
            case 96: {
                return new DotRegex();
            }
            case 97: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new StringRegex(string);
            }
            case 98: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new EscapeRegex(string);
            }
            case 99: {
                return new CharRegex("=");
            }
            case 100: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new CharRegex(string);
            }
            case 101: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                return new MacroInvocationRegex(string);
            }
            case 102: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new CharClassRegex(false, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 103: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                return new CharClassRegex(true, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 104: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                Symbol symbol22 = this._symbols[n2 + 4];
                String string4 = (String)symbol22.value;
                return new CharClassRegex(false, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol22)));
            }
            case 105: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                Symbol symbol23 = this._symbols[n2 + 5];
                String string5 = (String)symbol23.value;
                return new CharClassRegex(true, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol23)));
            }
            case 108: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol24 = this._symbols[n2 + 2];
                List list = (List)symbol24.value;
                return new CharClassRegex(false, list.addFirst(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 109: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol25 = this._symbols[n2 + 3];
                String string6 = (String)symbol25.value;
                Symbol symbol26 = this._symbols[n2 + 4];
                List list = (List)symbol26.value;
                return new CharClassRegex(false, list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol25)));
            }
            case 110: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol27 = this._symbols[n2 + 2];
                List list = (List)symbol27.value;
                return new CharClassRegex(true, list.addFirst(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 111: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol28 = this._symbols[n2 + 3];
                String string7 = (String)symbol28.value;
                Symbol symbol29 = this._symbols[n2 + 4];
                List list = (List)symbol29.value;
                return new CharClassRegex(true, list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol28)));
            }
            case 112: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol));
            }
            case 113: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol30 = this._symbols[n2 + 3];
                String string8 = (String)symbol30.value;
                return new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol30));
            }
            case 114: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol31 = this._symbols[n2 + 2];
                List list = (List)symbol31.value;
                return list.addFirst(ComponentParser.makeSingleCharRange(symbol));
            }
            case 115: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol32 = this._symbols[n2 + 3];
                String string9 = (String)symbol32.value;
                Symbol symbol33 = this._symbols[n2 + 4];
                List list = (List)symbol33.value;
                return list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol32));
            }
            case 118: {
                return new Symbol("-");
            }
            case 121: {
                return new Symbol("^");
            }
            case 124: {
                return new Symbol("-");
            }
            case 125: {
                return new Symbol("^");
            }
            case 126: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 127: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 130: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), new List<RuleGroup>(), new List<RuleGroup>());
            }
            case 131: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                Symbol symbol34 = this._symbols[n2 + 3];
                ArrayList arrayList3 = (ArrayList)symbol34.value;
                RuleGroup[] ruleGroupArray2 = arrayList3 == null ? new RuleGroup[]{} : arrayList3.toArray(new RuleGroup[arrayList3.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList3)), new List<RuleGroup>());
            }
            case 132: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                Symbol symbol35 = this._symbols[n2 + 3];
                ArrayList arrayList4 = (ArrayList)symbol35.value;
                RuleGroup[] ruleGroupArray3 = arrayList4 == null ? new RuleGroup[]{} : arrayList4.toArray(new RuleGroup[arrayList4.size()]);
                Symbol symbol36 = this._symbols[n2 + 5];
                ArrayList arrayList5 = (ArrayList)symbol36.value;
                RuleGroup[] ruleGroupArray4 = arrayList5 == null ? new RuleGroup[]{} : arrayList5.toArray(new RuleGroup[arrayList5.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList4)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList5)));
            }
            case 133: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 134: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 137: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                Symbol symbol37 = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol37.value;
                Deletion[] deletionArray = arrayList == null ? new Deletion[]{} : arrayList.toArray(new Deletion[arrayList.size()]);
                Symbol symbol38 = this._symbols[n2 + 4];
                RuleSection ruleSection = (RuleSection)symbol38.value;
                return new InheritSection(string, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ruleSection);
            }
            case 4: 
            case 9: 
            case 13: 
            case 61: 
            case 89: 
            case 128: 
            case 135: {
                return new Symbol(null);
            }
            case 5: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 43: 
            case 54: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 83: 
            case 90: 
            case 94: 
            case 95: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 129: 
            case 136: {
                return this._symbols[n2 + 1];
            }
            case 53: 
            case 93: 
            case 106: {
                return this._symbols[n2 + 2];
            }
            case 107: {
                return this._symbols[n2 + 3];
            }
        }
        throw new IllegalArgumentException("unknown production #" + n);
    }

    class Events
    extends Parser.Events {
        Events() {
        }

        public void syntaxError(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "unexpected token " + Terminals.NAMES[symbol.getId()]));
        }

        public void scannerError(Scanner.Exception exception) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(exception, "scanner error: " + exception.getMessage()));
        }

        public void unexpectedTokenRemoved(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try deleting " + Terminals.NAMES[symbol.getId()]));
        }

        public void missingTokenInserted(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try inserting " + Terminals.NAMES[symbol.getId()]));
        }

        public void misspelledTokenReplaced(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try replacing with " + Terminals.NAMES[symbol.getId()]));
        }
    }

    public static class Terminals {
        public static final short EOF = 0;
        public static final short IDENTIFIER = 1;
        public static final short ESCAPE_SEQUENCE = 2;
        public static final short SECTION_SEPARATOR = 3;
        public static final short STRING = 4;
        public static final short ASSIGN = 5;
        public static final short LSQUARE = 6;
        public static final short OPEN_MACRO = 7;
        public static final short LPAREN = 8;
        public static final short NOT = 9;
        public static final short UPTO = 10;
        public static final short DOT = 11;
        public static final short NON_META = 12;
        public static final short DELETE_TERMINATOR = 13;
        public static final short ACTION = 14;
        public static final short IMPORT_DIRECTIVE = 15;
        public static final short END_OF_LINE = 16;
        public static final short SLASH = 17;
        public static final short DECL_REGION = 18;
        public static final short INIT_REGION = 19;
        public static final short APPEND_REGION = 20;
        public static final short HELPER_DIRECTIVE = 21;
        public static final short START_DIRECTIVE = 22;
        public static final short EXTERN_DIRECTIVE = 23;
        public static final short INITTHROW_DIRECTIVE = 24;
        public static final short LEXTHROW_DIRECTIVE = 25;
        public static final short STATE_DIRECTIVE = 26;
        public static final short XSTATE_DIRECTIVE = 27;
        public static final short RPAREN = 28;
        public static final short ALT = 29;
        public static final short INHERIT_SECTION_SEPARATOR = 30;
        public static final short BEGINNING_OF_LINE = 31;
        public static final short ANY_PATTERN = 32;
        public static final short EOF_PATTERN = 33;
        public static final short OPEN_REPETITION_SPEC = 34;
        public static final short OPT = 35;
        public static final short PLUS = 36;
        public static final short STAR = 37;
        public static final short COMMA = 38;
        public static final short LANGLE = 39;
        public static final short CHAR_CLASS_NEGATE = 40;
        public static final short DASH = 41;
        public static final short GROUP_SEPARATOR = 42;
        public static final short CHAR_CLASS_CHAR = 43;
        public static final short RSQUARE = 44;
        public static final short OTHER_WHITESPACE = 45;
        public static final short NUMBER = 46;
        public static final short CLOSE_REPETITION_SPEC = 47;
        public static final short DELETE_DIRECTIVE = 48;
        public static final short CLOSE_RULE_GROUP = 49;
        public static final short RANGLE = 50;
        public static final short CLOSE_MACRO = 51;
        public static final short OPEN_RULE_GROUP = 52;
        public static final short COMPONENT_DIRECTIVE = 53;
        public static final String[] NAMES = new String[]{"EOF", "IDENTIFIER", "ESCAPE_SEQUENCE", "SECTION_SEPARATOR", "STRING", "ASSIGN", "LSQUARE", "OPEN_MACRO", "LPAREN", "NOT", "UPTO", "DOT", "NON_META", "DELETE_TERMINATOR", "ACTION", "IMPORT_DIRECTIVE", "END_OF_LINE", "SLASH", "DECL_REGION", "INIT_REGION", "APPEND_REGION", "HELPER_DIRECTIVE", "START_DIRECTIVE", "EXTERN_DIRECTIVE", "INITTHROW_DIRECTIVE", "LEXTHROW_DIRECTIVE", "STATE_DIRECTIVE", "XSTATE_DIRECTIVE", "RPAREN", "ALT", "INHERIT_SECTION_SEPARATOR", "BEGINNING_OF_LINE", "ANY_PATTERN", "EOF_PATTERN", "OPEN_REPETITION_SPEC", "OPT", "PLUS", "STAR", "COMMA", "LANGLE", "CHAR_CLASS_NEGATE", "DASH", "GROUP_SEPARATOR", "CHAR_CLASS_CHAR", "RSQUARE", "OTHER_WHITESPACE", "NUMBER", "CLOSE_REPETITION_SPEC", "DELETE_DIRECTIVE", "CLOSE_RULE_GROUP", "RANGLE", "CLOSE_MACRO", "OPEN_RULE_GROUP", "COMPONENT_DIRECTIVE"};
    }
}

