/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.BOFMetaPattern;
import metalexer.ast.BodyElement;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Layout;
import metalexer.ast.List;
import metalexer.ast.MTokPair;
import metalexer.ast.MetaPattern;
import metalexer.jflex.PrintHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedding
extends BodyElement
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getConflictingEmbeddings_visited = -1;
    protected int hasPureBOFTransition_visited = -1;
    protected int getDirectPureBOFReachable_visited = -1;
    protected int getPureBOFReachable_visited;
    protected boolean getPureBOFReachable_computed = false;
    protected boolean getPureBOFReachable_initialized = false;
    protected Set<Embedding> getPureBOFReachable_value;
    protected int getMetaJFlexName_visited = -1;
    protected int getNextByPureBOF_visited = -1;
    protected int getEmbeddingIndex_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getConflictingEmbeddings_visited = -1;
        this.hasPureBOFTransition_visited = -1;
        this.getDirectPureBOFReachable_visited = -1;
        this.getPureBOFReachable_visited = 0;
        this.getPureBOFReachable_computed = false;
        this.getPureBOFReachable_initialized = false;
        this.getPureBOFReachable_value = null;
        this.getMetaJFlexName_visited = -1;
        this.getNextByPureBOF_visited = -1;
        this.getEmbeddingIndex_visited = -1;
    }

    @Override
    public Embedding clone() throws CloneNotSupportedException {
        Embedding embedding = (Embedding)super.clone();
        embedding.getConflictingEmbeddings_visited = -1;
        embedding.hasPureBOFTransition_visited = -1;
        embedding.getDirectPureBOFReachable_visited = -1;
        embedding.getPureBOFReachable_visited = 0;
        embedding.getPureBOFReachable_computed = false;
        embedding.getPureBOFReachable_initialized = false;
        embedding.getPureBOFReachable_value = null;
        embedding.getMetaJFlexName_visited = -1;
        embedding.getNextByPureBOF_visited = -1;
        embedding.getEmbeddingIndex_visited = -1;
        embedding.in$Circle(false);
        embedding.is$Final(false);
        return embedding;
    }

    public Embedding copy() {
        try {
            Embedding embedding = this.clone();
            if (this.children != null) {
                embedding.children = (ASTNode[])this.children.clone();
            }
            return embedding;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Embedding fullCopy() {
        Embedding embedding = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            embedding.setChild(object, i);
        }
        return embedding;
    }

    public void printMetaJFlexStartRule(PrintHelper printHelper) throws IOException {
        printHelper.println("//start pattern for embedding '" + this.getName() + "'");
        MetaPattern metaPattern = this.getStartPattern();
        if (metaPattern.isBadJFlex()) {
            printHelper.println("/* Omitting unreachable pattern");
            metaPattern.printMetaJFlex(printHelper);
            printHelper.print(" ");
            this.printMetaJFlexStartAction(printHelper);
            printHelper.println("*/");
        } else if (this.hasPureBOFTransition()) {
            printHelper.println("/* Omitting empty pattern (handled elsewhere)");
            metaPattern.printMetaJFlex(printHelper);
            printHelper.print(" ");
            this.printMetaJFlexStartAction(printHelper);
            printHelper.println("*/");
        } else {
            for (MetaPattern metaPattern2 : metaPattern.splitPattern()) {
                metaPattern2.printMetaJFlex(printHelper);
                printHelper.print(" ");
                this.printMetaJFlexStartAction(printHelper);
            }
        }
    }

    public void printMetaJFlexStartAction(PrintHelper printHelper) throws IOException {
        printHelper.print("{ ");
        if (this.getLayout().isTracingCodeEmbedded()) {
            printHelper.print("if(isTracingEnabled()) { ");
            printHelper.print("System.err.println(\"TRANSITION: to component " + this.getGuest().getName() + " (embedding " + this.getName() + ")\"); ");
            printHelper.print("} ");
        }
        printHelper.print("saveStateAndTransition(" + this.getMetaJFlexName() + "); ");
        printHelper.print("notifyLexer(/*" + this.getName() + "*/ " + this.getEmbeddingIndex() + "); ");
        printHelper.println("}");
    }

    public void printMetaJFlexEndRule(PrintHelper printHelper) throws IOException {
        printHelper.println("//end pattern for embedding '" + this.getName() + "'");
        MetaPattern metaPattern = this.getEndPattern();
        if (metaPattern.isBadJFlex()) {
            printHelper.println("/* Omitting unreachable pattern");
            metaPattern.printMetaJFlex(printHelper);
            printHelper.print(" ");
            this.printMetaJFlexEndAction(printHelper);
            printHelper.println("*/");
        } else {
            for (MetaPattern metaPattern2 : metaPattern.splitPattern()) {
                metaPattern2.printMetaJFlex(printHelper);
                printHelper.print(" ");
                this.printMetaJFlexEndAction(printHelper);
            }
        }
    }

    public void printMetaJFlexEndAction(PrintHelper printHelper) throws IOException {
        printHelper.print("{ ");
        if (this.getLayout().isTracingCodeEmbedded()) {
            printHelper.print("if(isTracingEnabled()) { ");
            printHelper.print("System.err.println(\"TRANSITION: to previous component (embedding " + this.getName() + ")\"); ");
            printHelper.print("} ");
        }
        printHelper.print("restoreState(); ");
        printHelper.print("notifyLexer(/*restore previous*/ -1); ");
        printHelper.println("}");
    }

    public Embedding() {
        this.setChild(new List(), 0);
        this.setChild(new List(), 4);
    }

    public Embedding(String string, List<CompRef> list, CompRef compRef, MetaPattern metaPattern, MetaPattern metaPattern2, List<MTokPair> list2) {
        this.setName(string);
        this.setChild(list, 0);
        this.setChild(compRef, 1);
        this.setChild(metaPattern, 2);
        this.setChild(metaPattern2, 3);
        this.setChild(list2, 4);
    }

    public Embedding(Symbol symbol, List<CompRef> list, CompRef compRef, MetaPattern metaPattern, MetaPattern metaPattern2, List<MTokPair> list2) {
        this.setName(symbol);
        this.setChild(list, 0);
        this.setChild(compRef, 1);
        this.setChild(metaPattern, 2);
        this.setChild(metaPattern2, 3);
        this.setChild(list2, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setHostList(List<CompRef> list) {
        this.setChild(list, 0);
    }

    public int getNumHost() {
        return this.getHostList().getNumChild();
    }

    public CompRef getHost(int n) {
        return (CompRef)this.getHostList().getChild(n);
    }

    public void addHost(CompRef compRef) {
        List<CompRef> list = this.getHostList();
        list.addChild(compRef);
    }

    public void setHost(CompRef compRef, int n) {
        List<CompRef> list = this.getHostList();
        list.setChild(compRef, n);
    }

    public List<CompRef> getHosts() {
        return this.getHostList();
    }

    public List<CompRef> getHostsNoTransform() {
        return this.getHostListNoTransform();
    }

    public List<CompRef> getHostList() {
        return (List)this.getChild(0);
    }

    public List<CompRef> getHostListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setGuest(CompRef compRef) {
        this.setChild(compRef, 1);
    }

    public CompRef getGuest() {
        return (CompRef)this.getChild(1);
    }

    public CompRef getGuestNoTransform() {
        return (CompRef)this.getChildNoTransform(1);
    }

    public void setStartPattern(MetaPattern metaPattern) {
        this.setChild(metaPattern, 2);
    }

    public MetaPattern getStartPattern() {
        return (MetaPattern)this.getChild(2);
    }

    public MetaPattern getStartPatternNoTransform() {
        return (MetaPattern)this.getChildNoTransform(2);
    }

    public void setEndPattern(MetaPattern metaPattern) {
        this.setChild(metaPattern, 3);
    }

    public MetaPattern getEndPattern() {
        return (MetaPattern)this.getChild(3);
    }

    public MetaPattern getEndPatternNoTransform() {
        return (MetaPattern)this.getChildNoTransform(3);
    }

    public void setMTokPairList(List<MTokPair> list) {
        this.setChild(list, 4);
    }

    public int getNumMTokPair() {
        return this.getMTokPairList().getNumChild();
    }

    public MTokPair getMTokPair(int n) {
        return (MTokPair)this.getMTokPairList().getChild(n);
    }

    public void addMTokPair(MTokPair mTokPair) {
        List<MTokPair> list = this.getMTokPairList();
        list.addChild(mTokPair);
    }

    public void setMTokPair(MTokPair mTokPair, int n) {
        List<MTokPair> list = this.getMTokPairList();
        list.setChild(mTokPair, n);
    }

    public List<MTokPair> getMTokPairs() {
        return this.getMTokPairList();
    }

    public List<MTokPair> getMTokPairsNoTransform() {
        return this.getMTokPairListNoTransform();
    }

    public List<MTokPair> getMTokPairList() {
        return (List)this.getChild(4);
    }

    public List<MTokPair> getMTokPairListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    public Set<Embedding> getConflictingEmbeddings() {
        if (this.getConflictingEmbeddings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getConflictingEmbeddings in class: ");
        }
        this.getConflictingEmbeddings_visited = this.state().boundariesCrossed;
        Set<Embedding> set = this.getConflictingEmbeddings_compute();
        this.getConflictingEmbeddings_visited = -1;
        return set;
    }

    private Set<Embedding> getConflictingEmbeddings_compute() {
        String string = this.getName();
        Set<Embedding> set = this.lookupEmbeddings(string);
        HashSet<Embedding> hashSet = new HashSet<Embedding>();
        for (Embedding embedding : set) {
            if (!string.equals(embedding.getName()) || embedding == this) continue;
            hashSet.add(embedding);
        }
        return hashSet;
    }

    public boolean hasPureBOFTransition() {
        if (this.hasPureBOFTransition_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: hasPureBOFTransition in class: ");
        }
        this.hasPureBOFTransition_visited = this.state().boundariesCrossed;
        boolean bl = this.hasPureBOFTransition_compute();
        this.hasPureBOFTransition_visited = -1;
        return bl;
    }

    private boolean hasPureBOFTransition_compute() {
        return this.getStartPattern() instanceof BOFMetaPattern;
    }

    public Set<Embedding> getDirectPureBOFReachable() {
        if (this.getDirectPureBOFReachable_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDirectPureBOFReachable in class: ");
        }
        this.getDirectPureBOFReachable_visited = this.state().boundariesCrossed;
        Set<Embedding> set = this.getDirectPureBOFReachable_compute();
        this.getDirectPureBOFReachable_visited = -1;
        return set;
    }

    private Set<Embedding> getDirectPureBOFReachable_compute() {
        HashSet<Embedding> hashSet = new HashSet<Embedding>();
        for (Embedding embedding : this.getEmbeddingsWithHost(this.getGuest())) {
            if (!embedding.hasPureBOFTransition()) continue;
            hashSet.add(embedding);
        }
        return hashSet;
    }

    public Set<Embedding> getPureBOFReachable() {
        if (this.getPureBOFReachable_computed) {
            return this.getPureBOFReachable_value;
        }
        if (!this.getPureBOFReachable_initialized) {
            this.getPureBOFReachable_initialized = true;
            this.getPureBOFReachable_value = this.getDirectPureBOFReachable();
        }
        if (!this.state().IN_CIRCLE) {
            this.state().IN_CIRCLE = true;
            int n = this.state().boundariesCrossed;
            boolean bl = this.is$Final();
            this.state().CIRCLE_INDEX = 1;
            do {
                this.getPureBOFReachable_visited = this.state().CIRCLE_INDEX;
                this.state().CHANGE = false;
                Set<Embedding> set = this.getPureBOFReachable_compute();
                if (set == null && this.getPureBOFReachable_value != null || set != null && !((Object)set).equals(this.getPureBOFReachable_value)) {
                    this.state().CHANGE = true;
                }
                this.getPureBOFReachable_value = set;
                ++this.state().CIRCLE_INDEX;
            } while (this.state().CHANGE);
            if (bl && n == this.state().boundariesCrossed) {
                this.getPureBOFReachable_computed = true;
                this.state().LAST_CYCLE = true;
                this.getPureBOFReachable_compute();
                this.state().LAST_CYCLE = false;
            } else {
                this.state().RESET_CYCLE = true;
                this.getPureBOFReachable_compute();
                this.state().RESET_CYCLE = false;
                this.getPureBOFReachable_computed = false;
                this.getPureBOFReachable_initialized = false;
            }
            this.state().IN_CIRCLE = false;
            return this.getPureBOFReachable_value;
        }
        if (this.getPureBOFReachable_visited != this.state().CIRCLE_INDEX) {
            this.getPureBOFReachable_visited = this.state().CIRCLE_INDEX;
            if (this.state().LAST_CYCLE) {
                this.getPureBOFReachable_computed = true;
                return this.getPureBOFReachable_compute();
            }
            if (this.state().RESET_CYCLE) {
                this.getPureBOFReachable_computed = false;
                this.getPureBOFReachable_initialized = false;
                return this.getPureBOFReachable_value;
            }
            Set<Embedding> set = this.getPureBOFReachable_compute();
            if (set == null && this.getPureBOFReachable_value != null || set != null && !((Object)set).equals(this.getPureBOFReachable_value)) {
                this.state().CHANGE = true;
            }
            this.getPureBOFReachable_value = set;
            return this.getPureBOFReachable_value;
        }
        return this.getPureBOFReachable_value;
    }

    private Set<Embedding> getPureBOFReachable_compute() {
        HashSet<Embedding> hashSet = new HashSet<Embedding>();
        for (Embedding embedding : this.getPureBOFReachable()) {
            hashSet.add(embedding);
            hashSet.addAll(embedding.getPureBOFReachable());
        }
        return hashSet;
    }

    public String getMetaJFlexName() {
        if (this.getMetaJFlexName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexName in class: ");
        }
        this.getMetaJFlexName_visited = this.state().boundariesCrossed;
        String string = this.getMetaJFlexName_compute();
        this.getMetaJFlexName_visited = -1;
        return string;
    }

    private String getMetaJFlexName_compute() {
        return "e_" + this.getName();
    }

    public Embedding getNextByPureBOF() {
        if (this.getNextByPureBOF_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getNextByPureBOF in class: ");
        }
        this.getNextByPureBOF_visited = this.state().boundariesCrossed;
        Embedding embedding = this.getNextByPureBOF_compute();
        this.getNextByPureBOF_visited = -1;
        return embedding;
    }

    private Embedding getNextByPureBOF_compute() {
        for (Embedding embedding : this.getEmbeddingsWithHost(this.getGuest())) {
            if (!embedding.hasPureBOFTransition()) continue;
            return embedding;
        }
        return null;
    }

    public int getEmbeddingIndex() {
        if (this.getEmbeddingIndex_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getEmbeddingIndex in class: ");
        }
        this.getEmbeddingIndex_visited = this.state().boundariesCrossed;
        int n = this.getParent().Define_int_getEmbeddingIndex(this, null);
        this.getEmbeddingIndex_visited = -1;
        return n;
    }

    @Override
    public Set<CompDecl> Define_java_util_Set_CompDecl__lookupCompDecls(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getGuestNoTransform()) {
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getHostListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupCompDecls(string);
        }
        return this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, aSTNode, string);
    }

    @Override
    public java.util.List<Component> Define_java_util_List_Component__getComponents(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            CompDecl compDecl = this.getGuest().getDecl();
            if (compDecl == null || !compDecl.hasComponent()) {
                return new ArrayList<Component>();
            }
            return Collections.singletonList(compDecl.getComponent());
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            for (CompRef compRef : this.getHosts()) {
                CompDecl compDecl = compRef.getDecl();
                if (compDecl == null || !compDecl.hasComponent()) continue;
                arrayList.add(compDecl.getComponent());
            }
            return arrayList;
        }
        if (aSTNode == this.getMTokPairListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            CompDecl compDecl = this.getGuest().getDecl();
            if (compDecl == null || !compDecl.hasComponent()) {
                return new ArrayList<Component>();
            }
            return Collections.singletonList(compDecl.getComponent());
        }
        return this.getParent().Define_java_util_List_Component__getComponents(this, aSTNode);
    }

    @Override
    public boolean Define_boolean_isInClass(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            return false;
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_isInClass(this, aSTNode);
    }

    @Override
    public boolean Define_boolean_isInOpt(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            return false;
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_isInOpt(this, aSTNode);
    }

    @Override
    public boolean Define_boolean_isFirstOnly(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            return true;
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isFirstOnly(this, aSTNode);
    }

    @Override
    public boolean Define_boolean_isLastOnly(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            return true;
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isLastOnly(this, aSTNode);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout layout;
        if (!this.getConflictingEmbeddings().isEmpty() && (layout = this.getLayout()) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        if (this.getEndPattern().containsBOF() && (layout = this.getLayout()) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        if (this.getPureBOFReachable().contains(this) && (layout = this.getLayout()) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Layout_Layout_getErrors(sortedSet);
        if (!this.getConflictingEmbeddings().isEmpty()) {
            sortedSet.add(this.makeCompilationError("Embedding " + this.getName() + " is declared more than once."));
        }
        if (this.getEndPattern().containsBOF()) {
            sortedSet.add(this.makeCompilationError("(JFlex) End meta-patterns may not contain <BOF>"));
        }
        if (this.getPureBOFReachable().contains(this)) {
            sortedSet.add(this.makeCompilationError("(JFlex) Embedding " + this.getName() + " may be reached from itself without consuming any input (i.e. <BOF> only)"));
        }
    }
}

