/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.AltRegex;
import metalexer.ast.AnyPattern;
import metalexer.ast.AppendRegion;
import metalexer.ast.CharClassRegex;
import metalexer.ast.CharRegex;
import metalexer.ast.Component;
import metalexer.ast.ComponentDirective;
import metalexer.ast.ComponentWrapper;
import metalexer.ast.DeclRegion;
import metalexer.ast.Deletion;
import metalexer.ast.DotRegex;
import metalexer.ast.EOFPattern;
import metalexer.ast.EOLRegexPattern;
import metalexer.ast.EscapeRegex;
import metalexer.ast.ExternDecl;
import metalexer.ast.ExternDirective;
import metalexer.ast.HeaderBlob;
import metalexer.ast.HeaderSection;
import metalexer.ast.HelperDirective;
import metalexer.ast.ImportDirective;
import metalexer.ast.InheritSection;
import metalexer.ast.InitRegion;
import metalexer.ast.InitThrowDirective;
import metalexer.ast.LexThrowDirective;
import metalexer.ast.List;
import metalexer.ast.LookaheadRegexPattern;
import metalexer.ast.MacroDecl;
import metalexer.ast.MacroInvocationRegex;
import metalexer.ast.MultiCharRange;
import metalexer.ast.NotRegex;
import metalexer.ast.Opt;
import metalexer.ast.OptRegex;
import metalexer.ast.Pattern;
import metalexer.ast.PlusRegex;
import metalexer.ast.RangeRepeatRegex;
import metalexer.ast.Regex;
import metalexer.ast.RepeatRegex;
import metalexer.ast.Rule;
import metalexer.ast.RuleGroup;
import metalexer.ast.RuleSection;
import metalexer.ast.SeqRegex;
import metalexer.ast.SingleCharRange;
import metalexer.ast.StarRegex;
import metalexer.ast.StartDirective;
import metalexer.ast.State;
import metalexer.ast.StateDirective;
import metalexer.ast.StateRef;
import metalexer.ast.StringRegex;
import metalexer.ast.UptoRegex;
import metalexer.ast.XStateDirective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentParser
extends Parser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjMWUK5CKMlTCpi#mkYiWtY$lrgui11DQ02v9qTG5141SK5W414L4aI50G9IFcd0CgmQo0WWeY22fAagGWMRA0V52K$mtltwhfxktfgMwMPO$d7mzpp#jNLU#zMw#hNrVtp2vGzXNvCWYu77C3BDraB9gZmEtN4K4x6IjZTEySd84pSGdos9iJ1CoHtm8iYdaCld3xLwAsvXwZ#sDa3vv5XknX#uqm85$#WylG08tG4tLn5YhZKZHqhTtbO$aOTP23ggY6wl9I692FT0ENOor4U$J0BQx$w32GAzF0vLWBSItQeBNh$s8Oo7MCWSknAguMv7ByNmW3kKuqS3dMc#oy7F$dmq2kHmrSZhKGDvEhg#l$N1Z8TPw1ox4#PkVb#3yRXe2y7FkVSWTo4NFxpuI1TTutKUUu6AVXTCQgodMiZya0j4Kvr$#fC2HnrIFN0CtbsAV9DBH2URV$H1YIk6x3wOe9jLnh7NJXtVHVr$$XC2Hn3R2vCbnhVTmWlqiVr$#1C2HnFK#kfZhMiU$cNNsLx7RxzuV1mrM9xRFj$SQn$oG$uMeUdVwzOM1y5PlBtRbmlMl$KNx4hJmw$Vl2mCeUAbDbAWhbP$aPvr96u2BN#Y#SAlqnoFL$90pwxcs2rcXiL$WGnlPnxHyH7n9E$ybGZ7GvHg0YQk0ADCD9ZXNdOnWkO9wEz#EX628ZDOR9S1cXCPHdRLjPNyFuT1ZYUZyO1gxJa0JO6gun6ADSwuLeYMkOb#F$K2Y6yHmxShqwC1$xRF60OsLUdT2PbUzuFngAmJox1EwHeGdWNiUAcdW6zpCln$knK8mYMm9taqq33pjMzC9pU85SZlVJOS1JPDF0qsJJu7exrjuoHQQGo$6VYIpAUpBJ3ro7IJ919l0PES6m7zBY#dv0J9R9cAnx4nB0uwoOsz6V8##40Mdo1rV#HdbVtaSPJENwlqSuzhV3W0Vb3$atFi17F7wCgPoHSErlXG53wJiFHPy9wk3Qtmm3Z1$N$deO0c8T#sjX28XrxA#68I3MiRyIXe1On$vo609Y7Vj4cSWAcsYeC6KnnqwqyMuelgBdLobmhFqmc0BfvmU6svwVu17A7Faa1OxdKCxn9ShQB7CnGkRXKzoDUnnF3A9jheoJURe7pDGdy9dCuFWCZir8mNH4AK$8T3$qcO#3vNhsPkzJSe$JlN6qUZqv0sOvFNlT#YhXM5y$N8$Ry0c5EWK#JytawV6SRK#FXzsJBvImzuKVhkVdZgJ0vwcPadksfsVCxidjIjYxtG$NyquUyYcfrUVpr4p9lJlH3tTWe6SDxkAOzmtc5Bx1gCy9#2TEfZvAzuwcZCJXF5P0F3Y3KARZxEmFE0CPxylWi90r61YOcvfzl3S3tHlF8pFGxO66t0RANRHeIS5d7DNYXxlYjgVd6jWzlwSzyYcrbXGCugWMFznuszF3QFVydecHOb$r8xXY5GBMTBHdhLx2otW5Op0Mup0Uh#8rl8utJDTxFrTxlip7qPIHE59VxKJ6IsMfFiutOga9z9yFmqUpV2VViVMTRtoPBADUfgm6B3E1WH$AD$8Duxv9ObicAsG5zGfbDM252Of5bijowkL9INyeYsGHHnSfgm6BJ63S35aYInYt92ctHR9O5bClLbO35fkWMEHR#PRwsoIsnR905b0lK5O35fZ0mC$bQ$cQSLydiIsGXRAGUg6o6h3G19ibfR9eyTTqFlvXs3TcqNUM7xx2yLTo8b#Ffyp6yJBR3#NZUlyYlwXZ2al2ytsyYRVmDjx1kvY8APY6wPYDhrpseBjih#obVI#UT0bVPFzN#LKTpQpAQi1EsScOdRxiTiWEVTnfn0uZjijsncptCVqWF#ZZTYD#C6ARR6FCDX$JLjcgZzkCs6h45jd2c2q#fisoMH#t6B7PY4soYJ6RV4mRPQC#RZ9Yen4RP0DZDlYOlfVlzN634TyRiLxMCsQzZscThDF7zKQiCsAjh6NCMX$J6bcZZskDM6F4Abd5c5K#fjMoMXzN6R7QY9MoaZ4hVKpxP9y#hZHYdn6xP1TZTWMyGUmo8NbMUoS8Vexbuqx3qpBmlII5sVz9Z1vhdF4#FQF9yf2oo2IPnBETbCA9XCNqKHRQijcCm48KCSIHnc#wwSX09hyz78Okk017e3oVqHMudnx5VVKOvdSSZaSVnjL5FMJfl4v15QWticfageGpK0CN8XSrKOiP1xFdqMPcLypPA73PyyaVqRzrA$PpDMSMESFO3qSvMc2md80JKH4dqQfyggXVjjHleFlbQXRATIQlzTd5vcfQYbpdbI9NkLBaYfGYLzKGhlDBCI$rgShOud4LrVb5g8qwh4bLkKLvgNlYZ5BXKXubvr9CrLokAcIgIeQISsMvN1NrVbTIhifaolAiVOGZ9LdxelR1SXMrAYTnHOhDPN5VS$QU29y4KJJc$kzmAGsqA3PNeh8hkpgBkv#t9fGSA9U57lRktTlbkeonrPZdWNCvhJnFVQczkl51SBNqvANoF9YyAddoIjm79UTguCchERqE9g$3FLnniXMNwmQNuMQt5V5mAHy$Lyp0LHUtxcScv#dhr5bCFtsTcPhPirRV3qidsglmlKMrkzBdNDtotbl1iJdC0UX0QrGV8nh5YysZjQcu7pJMnsB5Yl5pAFR$AHOMFSEUuza17ZbsLOExZDghKpsSki$ZcrK1RYIBgljixcZP7El9jqx7emLjESmoHtcmVPNE$nQ#MmkvgnkuWOwqN9zgqP7PwELoz#DTarVqpakhRT6UrTLiYLdTTGkSjSW3tG9MnSDj#oPpdnFiOSzxJjYyokFlCA$$3KQFr#UtiKkeBzMz1fH6k9p79hWY98FzCvKW0qGE88D0Iw8MlHcW2YMW5ZsvbN2kuBCDMOU$SgvYNtNUOKq2ihhImtarha4hj4OXsk1Qj4KxjCTrnhd3hxRQ8HjmXxIljbFrkWgY0T#jZQE9wvtwuOwKu$0bZUUKT1OZM$OXjh#MZP9IMMJprJHtrqQ6IWwzj#pCV9MSEXhqf59FjkGwDhC4dB5zb#dde$akSrQiiyjtKydk6ND#XvWECVtzc0AUQG7xIzAiYRiry3d6VU3IqjzZq3ranc1Bm8x3iU9yMva$IFsgBlflkgUIQWIGretjsXH#9uZy1bWdKvyDnBlIzZRx$1uI6SdsBkgtW3BZEFO1#x#ppM$lPTHpzasWR7aWeopb68uLScmV4FsHF0Cehr4cSwm7EJvZ$7EKXUpVHBs8iSFPVfZ#Vm0npX#hm$uKwZRKgwdxKxUbVef2djXIyiobdCfpsKiEzcDxg9b$f1LvygbdSKxcf7vXYB$8V3TnB4eVzQlNC8wfN#RLVvIflzV#Gbj5oiMKBfG7ECOvhR5ilqVD$AqZsLP$fnyD$SEPTG95FTq#fsOkLZrAO$PtKFUYxAQGDteiXTmMSxUcawC2#rnlQoCrvxFQKMTo$4BgQfIMb3ie7IdC9JgAyZA5EKNVeJ0VD6SSroiMenx3iJay7yuTEPDZFCSeyumqPJjEOOunNi#CN8upyJZVoQ9yDutpkfVXsfRPoZRNBDwTRSuNPrvnhccq0QyByum#oBLJr#H4zZaMPKsaLQUq0UpVeX5ZtXdgtCaJuxnM7eNr4vt6FFgm$H25DPBHZpA4mkkVCPuoapAFifd2zSfa$MIoVZB9brcBqeBIdi9haSaQoUHrZAwZvdMBxgIUJM4TnNYTCxTHinRJsOureMQ#wJNORaRDTOuLKAiQ8cVwZHJofJEl6DSxdRd5M8lfhBdq9PGrvFkPkJFVikK6wTEC5oYTQAUfQpOtqKQUhHaVvrgdZIxoAzFQraycTFfinvRePx9UquObZrcZl7s$CAVE7j$JMFzxFFspRDt876jriVMqeh5ekgqBp36H#ppnJSDoOovZAQjJvq2cZ$C6pbVUqxy$$9nr7KsqsnTuufQ7nVau#jjwTF9uWZU8Z#VHoTPhWxcjdsnkrbtPyuh6u#eUgXySbt4qOthOiGqzUVnPr2xJeRZd63nFh98zHqfjgJtQCBRRpd#KhPids#CrbUQrtcUOAokXzUTUzEFtlrwKhbei$Ljh9pqMunqJeLZepB7ERD#inGAhWn91HpxLhsU$EVMLx1TNhgPSGsb5QKqf9CUjr6sehwMqfRIZjATSH#b0MmVEeNwFlOhIJKiK1TItQ55$8OcWXPQe$ZxRLFrsIsd9ysZ9ju16R7VNalX6mYST9S8tXoXwKzUtvM8j5YNgqJ4#sIDQQbFgQ8dosH#XM7mNY50iBRbivsgTa8RiDwI#3D1$8Sdb#qWktqLgCBu6#q5IYpdNf4zDpbrJjzCebXxhGzs7utsf#rBdK#TxT1V6ErBF8tLzqaIBfNzpk9pjAxH4AN7qPBidRTo9AH7zb#lR$WSkXiLT");
    private String filename = null;
    private final SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public SortedSet<CompilationProblem> getProblems() {
        return Collections.unmodifiableSortedSet(this.problems);
    }

    public boolean hasProblem() {
        return !this.problems.isEmpty();
    }

    private CompilationError buildError(Symbol symbol, String string) {
        return new CompilationError(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationError buildError(Scanner.Exception exception, String string) {
        return new CompilationError(this.filename, exception.line, exception.column, string);
    }

    private CompilationWarning buildWarning(Symbol symbol, String string) {
        return new CompilationWarning(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationWarning buildWarning(Scanner.Exception exception, String string) {
        return new CompilationWarning(this.filename, exception.line, exception.column, string);
    }

    private static <T extends ASTNode<?>> List<T> makeListNode(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new List<T>().addAll(list);
    }

    private static <T extends ASTNode<?>> List<T> nullToEmpty(List<T> list) {
        return list == null ? new List() : list;
    }

    private static SingleCharRange makeSingleCharRange(Symbol symbol) {
        SingleCharRange singleCharRange = new SingleCharRange(symbol);
        singleCharRange.acquirePositionFromChildren();
        return singleCharRange;
    }

    private static MultiCharRange makeMultiCharRange(Symbol symbol, Symbol symbol2) {
        MultiCharRange multiCharRange = new MultiCharRange(symbol, symbol2);
        multiCharRange.acquirePositionFromChildren();
        return multiCharRange;
    }

    private Symbol buildComponent(HeaderSection headerSection, RuleSection ruleSection, List<InheritSection> list) {
        Object object;
        StateRef stateRef = null;
        boolean bl = false;
        List<State> list2 = new List<State>();
        LinkedHashSet<StringSymbol> linkedHashSet = new LinkedHashSet<StringSymbol>();
        List<ExternDecl> list3 = new List<ExternDecl>();
        LinkedHashSet<StringSymbol> linkedHashSet2 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet3 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet4 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet5 = new LinkedHashSet<StringSymbol>();
        StringSymbol stringSymbol = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<Iterator<String>> hashSet3 = new HashSet<Iterator<String>>();
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<String> hashSet5 = new HashSet<String>();
        HashSet<String> hashSet6 = new HashSet<String>();
        HashSet<String> hashSet7 = new HashSet<String>();
        for (HeaderBlob symbol2 : headerSection.getHeaderBlobs()) {
            if (symbol2 instanceof StartDirective) {
                if (stateRef == null) {
                    stateRef = ((StartDirective)symbol2).getState();
                    continue;
                }
                this.problems.add(this.buildWarning(symbol2, "Start state has already been declared."));
                continue;
            }
            if (symbol2 instanceof HelperDirective) {
                if (bl) {
                    this.problems.add(this.buildWarning(symbol2, "Component has already been flagged as a helper component."));
                }
                bl = true;
                continue;
            }
            if (symbol2 instanceof StateDirective) {
                for (State state : ((StateDirective)symbol2).getStates()) {
                    String string = state.getName();
                    if (hashSet.contains(string)) {
                        this.problems.add(this.buildWarning(state, "Duplicate declaration of state " + string + "."));
                        continue;
                    }
                    list2.add(state);
                    hashSet.add(string);
                }
                continue;
            }
            if (symbol2 instanceof XStateDirective) {
                for (State state : ((XStateDirective)symbol2).getStates()) {
                    String string = state.getName();
                    if (hashSet2.contains(string)) {
                        this.problems.add(this.buildWarning(state, "Duplicate declaration of xstate " + string + "."));
                        continue;
                    }
                    list2.add(state);
                    hashSet2.add(string);
                }
                continue;
            }
            if (symbol2 instanceof ImportDirective) {
                object = ((ImportDirective)symbol2).getText();
                if (hashSet3.contains(object)) {
                    this.problems.add(this.buildWarning(symbol2, "Duplicate import."));
                    continue;
                }
                linkedHashSet.add(new StringSymbol(symbol2, (String)object));
                hashSet3.add((Iterator<String>)object);
                continue;
            }
            if (symbol2 instanceof ExternDirective) {
                object = ((ExternDirective)symbol2).getExternDecl();
                String string = ((ExternDecl)object).getText();
                if (hashSet4.contains(string)) {
                    this.problems.add(this.buildWarning(symbol2, "Duplicate extern."));
                    continue;
                }
                list3.add((ExternDecl)object);
                hashSet4.add(string);
                continue;
            }
            if (symbol2 instanceof DeclRegion) {
                linkedHashSet2.add(new StringSymbol(symbol2, ((DeclRegion)symbol2).getText()));
                continue;
            }
            if (symbol2 instanceof LexThrowDirective) {
                for (String string : ((LexThrowDirective)symbol2).getExceptions()) {
                    if (hashSet5.contains(string)) {
                        this.problems.add(this.buildWarning(symbol2, "Duplicate declaration of lex exception " + string + "."));
                        continue;
                    }
                    linkedHashSet3.add(new StringSymbol(symbol2, string));
                    hashSet5.add(string);
                }
                continue;
            }
            if (symbol2 instanceof InitRegion) {
                linkedHashSet4.add(new StringSymbol(symbol2, ((InitRegion)symbol2).getText()));
                continue;
            }
            if (symbol2 instanceof InitThrowDirective) {
                for (String string : ((InitThrowDirective)symbol2).getExceptions()) {
                    if (hashSet5.contains(string)) {
                        this.problems.add(this.buildWarning(symbol2, "Duplicate declaration of init exception " + string + "."));
                        continue;
                    }
                    linkedHashSet5.add(new StringSymbol(symbol2, string));
                    hashSet6.add(string);
                }
                continue;
            }
            if (symbol2 instanceof AppendRegion) {
                if (stringSymbol == null) {
                    stringSymbol = new StringSymbol(symbol2, ((AppendRegion)symbol2).getText());
                    continue;
                }
                this.problems.add(this.buildWarning(symbol2, "Component already has an %append region."));
                continue;
            }
            throw new RuntimeException("Unexpected header blob type: " + symbol2.getClass().getName());
        }
        ComponentDirective componentDirective = headerSection.getComponentDirective();
        Symbol symbol = new Symbol(0, componentDirective.Namestart, componentDirective.Nameend, componentDirective.getName());
        object = new List();
        for (MacroDecl macroDecl : headerSection.getMacroDeclList()) {
            String string = macroDecl.getName();
            if (hashSet7.contains(string)) {
                this.problems.add(this.buildWarning(macroDecl, "Duplicate declaration of macro " + string + "."));
                continue;
            }
            ((List)object).add((MacroDecl)macroDecl);
            hashSet7.add(string);
        }
        Opt<StateRef> opt = stateRef == null ? new Opt<StateRef>() : new Opt<StateRef>(stateRef);
        return new Component(symbol, bl, opt, list2, (Set<StringSymbol>)linkedHashSet, list3, (Set<StringSymbol>)linkedHashSet2, (Set<StringSymbol>)linkedHashSet3, (Set<StringSymbol>)linkedHashSet4, (Set<StringSymbol>)linkedHashSet5, stringSymbol, (List<MacroDecl>)object, ruleSection, list);
    }

    public ComponentParser() {
        super(PARSING_TABLES);
        this.report = new Events();
    }

    @Override
    protected Symbol invokeReduceAction(int n, int n2) {
        switch (n) {
            case 0: {
                Symbol symbol = this._symbols[n2 + 1];
                Component component = (Component)symbol.value;
                ComponentWrapper componentWrapper = new ComponentWrapper(component);
                componentWrapper.setFilenameOnSubtreeNoTransform(this.filename);
                return componentWrapper;
            }
            case 1: {
                Symbol symbol = this._symbols[n2 + 1];
                HeaderSection headerSection = (HeaderSection)symbol.value;
                return this.buildComponent(headerSection, new RuleSection(new List<RuleGroup>(), new List<RuleGroup>(), new List<RuleGroup>()), new List<InheritSection>());
            }
            case 2: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 3: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 6: {
                Symbol symbol = this._symbols[n2 + 1];
                HeaderSection headerSection = (HeaderSection)symbol.value;
                Symbol symbol2 = this._symbols[n2 + 3];
                RuleSection ruleSection = (RuleSection)symbol2.value;
                Symbol symbol3 = this._symbols[n2 + 4];
                ArrayList arrayList = (ArrayList)symbol3.value;
                InheritSection[] inheritSectionArray = arrayList == null ? new InheritSection[]{} : arrayList.toArray(new InheritSection[arrayList.size()]);
                return this.buildComponent(headerSection, ruleSection, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)));
            }
            case 7: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 8: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 11: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 12: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 15: {
                Symbol symbol = this._symbols[n2 + 1];
                ComponentDirective componentDirective = (ComponentDirective)symbol.value;
                Symbol symbol4 = this._symbols[n2 + 2];
                ArrayList arrayList = (ArrayList)symbol4.value;
                HeaderBlob[] headerBlobArray = arrayList == null ? new HeaderBlob[]{} : arrayList.toArray(new HeaderBlob[arrayList.size()]);
                Symbol symbol5 = this._symbols[n2 + 3];
                ArrayList arrayList2 = (ArrayList)symbol5.value;
                MacroDecl[] macroDeclArray = arrayList2 == null ? new MacroDecl[]{} : arrayList2.toArray(new MacroDecl[arrayList2.size()]);
                return new HeaderSection(componentDirective, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList2)));
            }
            case 16: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new ComponentDirective(symbol);
            }
            case 17: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol6 = this._symbols[n2 + 3];
                Regex regex = (Regex)symbol6.value;
                return new MacroDecl(string, regex);
            }
            case 29: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new DeclRegion(string);
            }
            case 30: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new InitRegion(string);
            }
            case 31: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new AppendRegion(string);
            }
            case 32: {
                return new HelperDirective();
            }
            case 33: {
                Symbol symbol = this._symbols[n2 + 2];
                StateRef stateRef = (StateRef)symbol.value;
                return new StartDirective(stateRef);
            }
            case 34: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new ExternDecl(string);
            }
            case 35: {
                Symbol symbol = this._symbols[n2 + 2];
                ExternDecl externDecl = (ExternDecl)symbol.value;
                return new ExternDirective(externDecl);
            }
            case 36: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new ImportDirective(string);
            }
            case 37: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new InitThrowDirective(list);
            }
            case 38: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new LexThrowDirective(list);
            }
            case 39: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return new StateDirective(list);
            }
            case 40: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return new XStateDirective(list);
            }
            case 41: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                return new Symbol(arrayList);
            }
            case 42: {
                Symbol symbol = this._symbols[n2 + 1];
                java.util.List list = (java.util.List)symbol.value;
                Symbol symbol7 = this._symbols[n2 + 3];
                String string = (String)symbol7.value;
                list.add(string);
                return symbol;
            }
            case 44: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new State(symbol, false);
            }
            case 45: {
                Symbol symbol = this._symbols[n2 + 1];
                State state = (State)symbol.value;
                return new List<State>().add(state);
            }
            case 46: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol8 = this._symbols[n2 + 3];
                State state = (State)symbol8.value;
                return list.add(state);
            }
            case 47: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new State(symbol, true);
            }
            case 48: {
                Symbol symbol = this._symbols[n2 + 1];
                State state = (State)symbol.value;
                return new List<State>().add(state);
            }
            case 49: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol9 = this._symbols[n2 + 3];
                State state = (State)symbol9.value;
                return list.add(state);
            }
            case 50: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new StateRef(symbol);
            }
            case 51: {
                Symbol symbol = this._symbols[n2 + 1];
                StateRef stateRef = (StateRef)symbol.value;
                return new List<StateRef>().add(stateRef);
            }
            case 52: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol10 = this._symbols[n2 + 3];
                StateRef stateRef = (StateRef)symbol10.value;
                return list.add(stateRef);
            }
            case 56: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                Symbol symbol11 = this._symbols[n2 + 3];
                Pattern pattern = (Pattern)symbol11.value;
                return new Deletion(list, pattern);
            }
            case 57: {
                Symbol symbol = this._symbols[n2 + 4];
                Pattern pattern = (Pattern)symbol.value;
                return new Deletion(new List<StateRef>(), pattern);
            }
            case 58: {
                Symbol symbol = this._symbols[n2 + 1];
                Rule rule = (Rule)symbol.value;
                return new RuleGroup(new List<StateRef>(), new List<Rule>().add(rule));
            }
            case 59: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 60: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 61: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol12 = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol12.value;
                Rule[] ruleArray = arrayList == null ? new Rule[]{} : arrayList.toArray(new Rule[arrayList.size()]);
                return new RuleGroup(list, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)));
            }
            case 64: {
                Symbol symbol = this._symbols[n2 + 1];
                Pattern pattern = (Pattern)symbol.value;
                Symbol symbol13 = this._symbols[n2 + 2];
                String string = (String)symbol13.value;
                Symbol symbol14 = this._symbols[n2 + 3];
                String string2 = (String)symbol14.value;
                return new Rule(pattern, symbol13, symbol14);
            }
            case 68: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(false, regex, false);
            }
            case 69: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(false, regex, true);
            }
            case 70: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol15 = this._symbols[n2 + 3];
                Regex regex2 = (Regex)symbol15.value;
                return new LookaheadRegexPattern(false, regex, regex2);
            }
            case 71: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(true, regex, false);
            }
            case 72: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(true, regex, true);
            }
            case 73: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                Symbol symbol16 = this._symbols[n2 + 4];
                Regex regex3 = (Regex)symbol16.value;
                return new LookaheadRegexPattern(true, regex, regex3);
            }
            case 74: {
                return new AnyPattern();
            }
            case 75: {
                return new EOFPattern();
            }
            case 78: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol17 = this._symbols[n2 + 3];
                Regex regex4 = (Regex)symbol17.value;
                return new AltRegex(regex, regex4);
            }
            case 80: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol18 = this._symbols[n2 + 2];
                Regex regex5 = (Regex)symbol18.value;
                return new SeqRegex(regex, regex5);
            }
            case 82: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new NotRegex(regex);
            }
            case 83: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new UptoRegex(regex);
            }
            case 85: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new OptRegex(regex);
            }
            case 86: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new PlusRegex(regex);
            }
            case 87: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new StarRegex(regex);
            }
            case 88: {
                ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
                arrayList.add(this._symbols[n2 + 1]);
                return new Symbol(arrayList);
            }
            case 89: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2]);
                return this._symbols[n2 + 1];
            }
            case 92: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol19 = this._symbols[n2 + 4];
                String string = (String)symbol19.value;
                return new RepeatRegex(regex, string);
            }
            case 93: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol20 = this._symbols[n2 + 4];
                String string = (String)symbol20.value;
                Symbol symbol21 = this._symbols[n2 + 8];
                String string3 = (String)symbol21.value;
                return new RangeRepeatRegex(regex, string, string3);
            }
            case 97: {
                return new DotRegex();
            }
            case 98: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new StringRegex(string);
            }
            case 99: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new EscapeRegex(string);
            }
            case 100: {
                return new CharRegex("=");
            }
            case 101: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new CharRegex(string);
            }
            case 102: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                return new MacroInvocationRegex(string);
            }
            case 103: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new CharClassRegex(false, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 104: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                return new CharClassRegex(true, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 105: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                Symbol symbol22 = this._symbols[n2 + 4];
                String string4 = (String)symbol22.value;
                return new CharClassRegex(false, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol22)));
            }
            case 106: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                Symbol symbol23 = this._symbols[n2 + 5];
                String string5 = (String)symbol23.value;
                return new CharClassRegex(true, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol23)));
            }
            case 109: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol24 = this._symbols[n2 + 2];
                List list = (List)symbol24.value;
                return new CharClassRegex(false, list.addFirst(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 110: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol25 = this._symbols[n2 + 3];
                String string6 = (String)symbol25.value;
                Symbol symbol26 = this._symbols[n2 + 4];
                List list = (List)symbol26.value;
                return new CharClassRegex(false, list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol25)));
            }
            case 111: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol27 = this._symbols[n2 + 2];
                List list = (List)symbol27.value;
                return new CharClassRegex(true, list.addFirst(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 112: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol28 = this._symbols[n2 + 3];
                String string7 = (String)symbol28.value;
                Symbol symbol29 = this._symbols[n2 + 4];
                List list = (List)symbol29.value;
                return new CharClassRegex(true, list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol28)));
            }
            case 113: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol));
            }
            case 114: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol30 = this._symbols[n2 + 3];
                String string8 = (String)symbol30.value;
                return new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol30));
            }
            case 115: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol31 = this._symbols[n2 + 2];
                List list = (List)symbol31.value;
                return list.addFirst(ComponentParser.makeSingleCharRange(symbol));
            }
            case 116: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol32 = this._symbols[n2 + 3];
                String string9 = (String)symbol32.value;
                Symbol symbol33 = this._symbols[n2 + 4];
                List list = (List)symbol33.value;
                return list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol32));
            }
            case 119: {
                return new Symbol("-");
            }
            case 122: {
                return new Symbol("^");
            }
            case 125: {
                return new Symbol("-");
            }
            case 126: {
                return new Symbol("^");
            }
            case 127: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 128: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 131: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), new List<RuleGroup>(), new List<RuleGroup>());
            }
            case 132: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                Symbol symbol34 = this._symbols[n2 + 3];
                ArrayList arrayList3 = (ArrayList)symbol34.value;
                RuleGroup[] ruleGroupArray2 = arrayList3 == null ? new RuleGroup[]{} : arrayList3.toArray(new RuleGroup[arrayList3.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList3)), new List<RuleGroup>());
            }
            case 133: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                Symbol symbol35 = this._symbols[n2 + 3];
                ArrayList arrayList4 = (ArrayList)symbol35.value;
                RuleGroup[] ruleGroupArray3 = arrayList4 == null ? new RuleGroup[]{} : arrayList4.toArray(new RuleGroup[arrayList4.size()]);
                Symbol symbol36 = this._symbols[n2 + 5];
                ArrayList arrayList5 = (ArrayList)symbol36.value;
                RuleGroup[] ruleGroupArray4 = arrayList5 == null ? new RuleGroup[]{} : arrayList5.toArray(new RuleGroup[arrayList5.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList4)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList5)));
            }
            case 134: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 135: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 138: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                Symbol symbol37 = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol37.value;
                Deletion[] deletionArray = arrayList == null ? new Deletion[]{} : arrayList.toArray(new Deletion[arrayList.size()]);
                Symbol symbol38 = this._symbols[n2 + 4];
                RuleSection ruleSection = (RuleSection)symbol38.value;
                return new InheritSection(string, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ruleSection);
            }
            case 4: 
            case 9: 
            case 13: 
            case 62: 
            case 90: 
            case 129: 
            case 136: {
                return new Symbol(null);
            }
            case 5: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 43: 
            case 54: 
            case 55: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 84: 
            case 91: 
            case 95: 
            case 96: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 130: 
            case 137: {
                return this._symbols[n2 + 1];
            }
            case 53: 
            case 94: 
            case 107: {
                return this._symbols[n2 + 2];
            }
            case 108: {
                return this._symbols[n2 + 3];
            }
        }
        throw new IllegalArgumentException("unknown production #" + n);
    }

    class Events
    extends Parser.Events {
        Events() {
        }

        public void syntaxError(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "unexpected token " + Terminals.NAMES[symbol.getId()]));
        }

        public void scannerError(Scanner.Exception exception) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(exception, "scanner error: " + exception.getMessage()));
        }

        public void unexpectedTokenRemoved(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try deleting " + Terminals.NAMES[symbol.getId()]));
        }

        public void missingTokenInserted(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try inserting " + Terminals.NAMES[symbol.getId()]));
        }

        public void misspelledTokenReplaced(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try replacing with " + Terminals.NAMES[symbol.getId()]));
        }
    }

    public static class Terminals {
        public static final short EOF = 0;
        public static final short IDENTIFIER = 1;
        public static final short ESCAPE_SEQUENCE = 2;
        public static final short SECTION_SEPARATOR = 3;
        public static final short STRING = 4;
        public static final short ASSIGN = 5;
        public static final short LSQUARE = 6;
        public static final short OPEN_MACRO = 7;
        public static final short LPAREN = 8;
        public static final short NOT = 9;
        public static final short UPTO = 10;
        public static final short DOT = 11;
        public static final short NON_META = 12;
        public static final short DELETE_TERMINATOR = 13;
        public static final short ACTION = 14;
        public static final short IMPORT_DIRECTIVE = 15;
        public static final short DECL_REGION = 16;
        public static final short INIT_REGION = 17;
        public static final short APPEND_REGION = 18;
        public static final short HELPER_DIRECTIVE = 19;
        public static final short START_DIRECTIVE = 20;
        public static final short EXTERN_DIRECTIVE = 21;
        public static final short INITTHROW_DIRECTIVE = 22;
        public static final short LEXTHROW_DIRECTIVE = 23;
        public static final short STATE_DIRECTIVE = 24;
        public static final short XSTATE_DIRECTIVE = 25;
        public static final short END_OF_LINE = 26;
        public static final short SLASH = 27;
        public static final short RPAREN = 28;
        public static final short ALT = 29;
        public static final short INHERIT_SECTION_SEPARATOR = 30;
        public static final short BEGINNING_OF_LINE = 31;
        public static final short ANY_PATTERN = 32;
        public static final short EOF_PATTERN = 33;
        public static final short OPEN_REPETITION_SPEC = 34;
        public static final short OPT = 35;
        public static final short PLUS = 36;
        public static final short STAR = 37;
        public static final short COMMA = 38;
        public static final short LANGLE = 39;
        public static final short GROUP_SEPARATOR = 40;
        public static final short CHAR_CLASS_NEGATE = 41;
        public static final short DASH = 42;
        public static final short CHAR_CLASS_CHAR = 43;
        public static final short RSQUARE = 44;
        public static final short OTHER_WHITESPACE = 45;
        public static final short DELETE_DIRECTIVE = 46;
        public static final short NUMBER = 47;
        public static final short CLOSE_REPETITION_SPEC = 48;
        public static final short CLOSE_RULE_GROUP = 49;
        public static final short RANGLE = 50;
        public static final short CLOSE_MACRO = 51;
        public static final short OPEN_RULE_GROUP = 52;
        public static final short QUALIFIED_IDENTIFIER = 53;
        public static final short COMPONENT_DIRECTIVE = 54;
        public static final String[] NAMES = new String[]{"EOF", "IDENTIFIER", "ESCAPE_SEQUENCE", "SECTION_SEPARATOR", "STRING", "ASSIGN", "LSQUARE", "OPEN_MACRO", "LPAREN", "NOT", "UPTO", "DOT", "NON_META", "DELETE_TERMINATOR", "ACTION", "IMPORT_DIRECTIVE", "DECL_REGION", "INIT_REGION", "APPEND_REGION", "HELPER_DIRECTIVE", "START_DIRECTIVE", "EXTERN_DIRECTIVE", "INITTHROW_DIRECTIVE", "LEXTHROW_DIRECTIVE", "STATE_DIRECTIVE", "XSTATE_DIRECTIVE", "END_OF_LINE", "SLASH", "RPAREN", "ALT", "INHERIT_SECTION_SEPARATOR", "BEGINNING_OF_LINE", "ANY_PATTERN", "EOF_PATTERN", "OPEN_REPETITION_SPEC", "OPT", "PLUS", "STAR", "COMMA", "LANGLE", "GROUP_SEPARATOR", "CHAR_CLASS_NEGATE", "DASH", "CHAR_CLASS_CHAR", "RSQUARE", "OTHER_WHITESPACE", "DELETE_DIRECTIVE", "NUMBER", "CLOSE_REPETITION_SPEC", "CLOSE_RULE_GROUP", "RANGLE", "CLOSE_MACRO", "OPEN_RULE_GROUP", "QUALIFIED_IDENTIFIER", "COMPONENT_DIRECTIVE"};
    }
}

