/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.FileLoader;
import metalexer.ProblemUtil;
import metalexer.ast.Layout;
import metalexer.jflex.CharacterAssigner;
import metalexer.jflex.CharacterGenerator;

public class ML2JFlex {
    public static void main(String[] stringArray) {
        SortedSet<CompilationError> sortedSet;
        SequencedCollection<Object> sequencedCollection;
        int n = 0;
        boolean bl = false;
        if (stringArray.length > 0 && stringArray[0].equals("-t")) {
            bl = true;
            ++n;
        }
        if (stringArray.length - n != 3) {
            System.err.println("Usage: java ML2JFlex [-t] {layout} {indir1;indir2;...} {outdir}");
            System.exit(1);
        }
        String string = stringArray[n + 0];
        String string2 = stringArray[n + 1];
        String string3 = stringArray[n + 2];
        System.out.println("Checking " + string + " in " + string2);
        TreeSet<CompilationProblem> treeSet = new TreeSet<CompilationProblem>();
        Layout layout = null;
        try {
            sequencedCollection = new ArrayList<String>();
            sortedSet = new StringTokenizer(string2, ";");
            while (((StringTokenizer)((Object)sortedSet)).hasMoreTokens()) {
                sequencedCollection.add(((StringTokenizer)((Object)sortedSet)).nextToken());
            }
            Object object = new FileLoader((List<String>)sequencedCollection);
            layout = ((FileLoader)object).loadLayout(string, treeSet);
            if (layout == null) {
                treeSet.add(layout.makeCompilationError(layout.getName() + " not found."));
            } else if ((layout = layout.processInheritance((FileLoader)object, treeSet)).getHelper()) {
                treeSet.add(layout.makeCompilationError(layout.getName() + " is a helper layout."));
            }
        }
        catch (IOException iOException) {
            treeSet.add(new CompilationError(null, iOException.getMessage()));
        }
        sequencedCollection = ProblemUtil.extractWarnings(treeSet);
        for (Object object : sequencedCollection) {
            System.out.println(object);
        }
        sortedSet = ProblemUtil.extractErrors(treeSet);
        if (sortedSet.isEmpty()) {
            System.out.println("VALID");
            try {
                layout.tidyRuleGroups();
                layout.deleteUnusedDeclarations();
                layout.assignCharsToMetaTokens(new CharacterAssigner(new CharacterGenerator()));
                layout.setTracingCodeEmbedded(bl);
                layout.generateJFlex(string3);
                layout.generateMetaJFlex(string3);
            }
            catch (IOException iOException) {
                System.out.println(new CompilationError(null, iOException.getMessage()));
            }
        } else {
            for (CompilationError compilationError : sortedSet) {
                System.out.println(compilationError);
            }
        }
    }
}

