/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Pipe
extends Reader {
    private final Lock monitorLock = new ReentrantLock();
    private final Queue<Condition> waitingForFirstRead = new LinkedList<Condition>();
    private Map<Thread, Condition> waitingForSecondRead = new HashMap<Thread, Condition>();
    private final Queue<Character> writeQueue = new LinkedList<Character>();
    private final Condition notEmpty = this.monitorLock.newCondition();
    private boolean closed = false;
    private boolean eof = false;

    public void write(char ch) {
        this.write(ch, false);
    }

    public void writeFinal(char ch) {
        this.write(ch, true);
    }

    private void write(char ch, boolean isFinal) {
        this.monitorLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot write after the read end has been closed.");
            }
            if (this.eof) {
                throw new IllegalStateException("Cannot write after EOF.");
            }
            if (isFinal) {
                this.eof = true;
            }
            this.writeQueue.add(Character.valueOf(ch));
            Condition cond = this.monitorLock.newCondition();
            this.waitingForFirstRead.add(cond);
            this.notEmpty.signalAll();
            cond.awaitUninterruptibly();
        }
        finally {
            this.monitorLock.unlock();
        }
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        this.monitorLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot read after the read end has been closed.");
            }
            boolean freedWriter = this.freeNextWriter();
            while (!this.eof && this.writeQueue.isEmpty()) {
                this.notEmpty.awaitUninterruptibly();
                if (freedWriter) continue;
                freedWriter = this.freeNextWriter();
            }
            if (this.eof && this.writeQueue.isEmpty()) {
                return -1;
            }
            this.waitingForSecondRead.put(Thread.currentThread(), this.waitingForFirstRead.poll());
            buf[offset] = this.writeQueue.poll().charValue();
            return 1;
        }
        finally {
            this.monitorLock.unlock();
        }
    }

    public void close() throws IOException {
        this.monitorLock.lock();
        try {
            this.closed = true;
            this.freeAllWriters();
        }
        finally {
            this.monitorLock.unlock();
        }
    }

    private boolean freeNextWriter() {
        Condition cond = this.waitingForSecondRead.get(Thread.currentThread());
        if (cond != null) {
            cond.signal();
            this.waitingForSecondRead.remove(Thread.currentThread());
            return true;
        }
        return false;
    }

    private void freeAllWriters() {
        for (Condition cond : this.waitingForSecondRead.values()) {
            cond.signal();
        }
        this.waitingForSecondRead.clear();
        for (Condition cond : this.waitingForFirstRead) {
            cond.signal();
        }
        this.waitingForFirstRead.clear();
    }
}

