/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class PipeTest {
    private static final int NUM_ITERATIONS = 100;
    private static final int NUM_THREADS = 100;
    private static final Writer WRITER = new Writer();
    private static final Reader READER = new Reader();
    private static final AtomicInteger COUNTER = new AtomicInteger(1);
    private static final Pipe PIPE = new Pipe();

    public static void main(String[] args) throws InterruptedException {
        Thread[] w = new Thread[100];
        Thread[] r = new Thread[100];
        int i = 0;
        while (i < 100) {
            w[i] = new Thread((Runnable)WRITER, "Writer " + i);
            r[i] = new Thread((Runnable)READER, "Reader " + i);
            w[i].start();
            r[i].start();
            ++i;
        }
        Thread.sleep(1000L);
        PIPE.writeFinal('\uffff');
        i = 0;
        while (i < 100) {
            w[i].join();
            r[i].join();
            ++i;
        }
        System.exit(0);
    }

    private static class Reader
    implements Runnable {
        private Reader() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        int val;
                        if ((val = PIPE.read()) < 0) {
                            System.err.println("EOF, Read");
                            return;
                        }
                        char ch = (char)val;
                        System.err.println(String.valueOf(ch) + ", Read");
                    }
                }
                catch (IOException e) {
                    System.err.println("Failed to read a character.");
                    continue;
                }
                break;
            }
        }
    }

    private static class Writer
    implements Runnable {
        private Writer() {
        }

        public void run() {
            int i = 0;
            while (i < 100) {
                char ch = (char)COUNTER.getAndIncrement();
                System.err.println(String.valueOf(ch) + ", Writing");
                PIPE.write(ch);
                System.err.println(String.valueOf(ch) + ", Done writing");
                ++i;
            }
        }
    }
}

