/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.FileLoader;
import metalexer.ast.Layout;

public class SyntaxChecker {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java SyntaxChecker {basedir} {basename}");
            System.exit(1);
        }
        String basedir = args[0];
        String basename = args[1];
        System.out.println("Checking " + basename + " in " + basedir);
        TreeSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();
        try {
            FileLoader loader = new FileLoader(basedir);
            Layout actual = loader.loadLayout(basename, problems);
            if (actual != null && (actual = actual.processInheritance(loader, problems)).getHelper()) {
                problems.add(actual.makeCompilationError(String.valueOf(actual.getName()) + " is a helper layout."));
            }
        }
        catch (IOException e) {
            problems.add(new CompilationError(null, e.getMessage()));
        }
        if (problems.isEmpty()) {
            System.out.println("VALID");
        } else {
            for (CompilationProblem problem : problems) {
                System.out.println(problem);
            }
        }
    }
}

