/*
 * Decompiled with CFR 0.152.
 */
package beaver;

public class Symbol {
    private static final int COLUMN_FIELD_BITS = 12;
    private static final int COLUMN_FIELD_MASK = 4095;
    public final Object value;
    protected short id;
    protected int start;
    protected int end;

    public static int makePosition(int n, int n2) {
        return n << 12 | n2;
    }

    public static int getLine(int n) {
        return n >>> 12;
    }

    public static int getColumn(int n) {
        return n & 0xFFF;
    }

    public Symbol(short s) {
        this.id = s;
        this.value = null;
    }

    public Symbol(short s, Object object) {
        this.id = s;
        this.value = object;
    }

    public Symbol(short s, int n, int n2) {
        this.id = s;
        this.value = null;
        this.start = n;
        this.end = n2;
    }

    public Symbol(short s, int n, int n2, Object object) {
        this.id = s;
        this.value = object;
        this.start = n;
        this.end = n2;
    }

    public Symbol(short s, int n, int n2, int n3) {
        this.id = s;
        this.value = null;
        this.start = Symbol.makePosition(n, n2);
        this.end = Symbol.makePosition(n, n2 + n3 - 1);
    }

    public Symbol(short s, int n, int n2, int n3, Object object) {
        this.id = s;
        this.value = object;
        this.start = Symbol.makePosition(n, n2);
        this.end = Symbol.makePosition(n, n2 + n3 - 1);
    }

    public Symbol(Object object) {
        this.value = object;
    }

    protected Symbol() {
        this.value = this;
    }

    public short getId() {
        return this.id;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

