/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import machine.DFA;

public class NFA {
    private final int numStates;
    private final int numSymbols;
    private final BitSet[][] transitions;
    private final Integer[] actions;

    public NFA(BitSet[][] transitions, Integer[] actions) {
        this.numStates = transitions.length;
        this.numSymbols = transitions[0].length;
        this.transitions = transitions;
        this.actions = actions;
    }

    public DFA convertToDFA() {
        BitSet stateGroup;
        HashMap<BitSet, BitSet[]> transitionMap = new HashMap<BitSet, BitSet[]>();
        HashMap<BitSet, Integer> actionMap = new HashMap<BitSet, Integer>();
        BitSet startStateGroup = new BitSet(this.numStates);
        startStateGroup.set(0);
        LinkedList<BitSet> workList = new LinkedList<BitSet>();
        workList.add(startStateGroup);
        ArrayList<BitSet> stateGroupList = new ArrayList<BitSet>();
        while (!workList.isEmpty()) {
            BitSet stateGroup2 = (BitSet)workList.poll();
            if (transitionMap.containsKey(stateGroup2)) continue;
            BitSet[] row = new BitSet[this.numSymbols];
            int sym = 0;
            while (sym < this.numSymbols) {
                BitSet destinationStateSet = new BitSet(this.numStates);
                int state = 0;
                while (state < this.numStates) {
                    if (stateGroup2.get(state)) {
                        destinationStateSet.or(this.transitions[state][sym]);
                    }
                    ++state;
                }
                row[sym] = destinationStateSet;
                workList.add(destinationStateSet);
                ++sym;
            }
            transitionMap.put(stateGroup2, row);
            int state = 0;
            while (state < this.numStates) {
                if (stateGroup2.get(state) && this.actions[state] != null) {
                    actionMap.put(stateGroup2, this.actions[state]);
                    break;
                }
                ++state;
            }
            stateGroupList.add(stateGroup2);
        }
        int numStateGroups = stateGroupList.size();
        Integer[][] dfaTransitions = new Integer[numStateGroups][this.numSymbols];
        Integer[] dfaActions = new Integer[numStateGroups];
        HashMap<BitSet, Integer> groupToStateMap = new HashMap<BitSet, Integer>();
        groupToStateMap.put(new BitSet(this.numSymbols), null);
        int i = 0;
        while (i < numStateGroups) {
            stateGroup = (BitSet)stateGroupList.get(i);
            groupToStateMap.put(stateGroup, i);
            ++i;
        }
        i = 0;
        while (i < numStateGroups) {
            stateGroup = (BitSet)stateGroupList.get(i);
            BitSet[] row = (BitSet[])transitionMap.get(stateGroup);
            Integer[] destinations = new Integer[this.numSymbols];
            int j = 0;
            while (j < this.numSymbols) {
                destinations[j] = (Integer)groupToStateMap.get(row[j]);
                ++j;
            }
            dfaTransitions[i] = destinations;
            dfaActions[i] = (Integer)actionMap.get(stateGroup);
            ++i;
        }
        return new DFA(dfaTransitions, dfaActions);
    }

    public void dump() {
        System.out.println("NFA");
        System.out.println("Transitions:");
        int state = 0;
        while (state < this.numStates) {
            int symbol = 0;
            while (symbol < this.numSymbols) {
                System.out.print(String.valueOf(NFA.toString(this.transitions[state][symbol])) + "\t");
                ++symbol;
            }
            System.out.println();
            ++state;
        }
        System.out.println();
        System.out.println("Actions:");
        state = 0;
        while (state < this.numStates) {
            System.out.println(this.actions[state]);
            ++state;
        }
    }

    public static String toString(BitSet set) {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        boolean first = true;
        int i = 0;
        while (i < set.size()) {
            if (set.get(i)) {
                if (!first) {
                    buf.append(',');
                }
                buf.append(i);
                first = false;
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }
}

