/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestGenerator {
    private final String relativeFilename;

    protected AbstractTestGenerator(String relativeFilename) {
        this.relativeFilename = relativeFilename;
    }

    protected void generate(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: java " + this.getClass().getName() + " listFileName genDirName");
            System.exit(1);
        }
        String listFileName = args[0];
        String genDirName = args[1];
        List<String> testNames = this.getTestNames(listFileName);
        String testFileName = String.valueOf(genDirName) + this.relativeFilename;
        PrintWriter testFileWriter = new PrintWriter(new FileWriter(testFileName));
        this.printHeader(testFileWriter);
        for (String testName : testNames) {
            this.printMethod(testFileWriter, testName);
        }
        this.printFooter(testFileWriter);
        testFileWriter.close();
        System.exit(0);
    }

    private List<String> getTestNames(String listFileName) throws IOException {
        ArrayList<String> testNames = new ArrayList<String>();
        BufferedReader listFileReader = new BufferedReader(new FileReader(listFileName));
        while (listFileReader.ready()) {
            String line = listFileReader.readLine().trim();
            if (this.isCommentLine(line)) continue;
            testNames.add(line);
        }
        listFileReader.close();
        return testNames;
    }

    private boolean isCommentLine(String line) {
        return line.charAt(0) == '#';
    }

    protected abstract void printHeader(PrintWriter var1);

    protected abstract void printMethod(PrintWriter var1, String var2);

    protected abstract void printFooter(PrintWriter var1);
}

