/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.Scanner;
import java.util.List;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.ComponentParser;
import metalexer.ComponentParserFailTestBase;
import metalexer.ProblemUtil;

public class ComponentParserFailTests
extends ComponentParserFailTestBase {
    public void test_c_parserfail_empty() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_empty.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_empty.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_empty.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_empty.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_emptygroup() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_emptygroup.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_emptygroup.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_emptygroup.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_emptygroup.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_extragroup() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_extragroup.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_extragroup.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_extragroup.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_extragroup.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_extrasection() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_extrasection.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_extrasection.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_extrasection.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_extrasection.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_newlines() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_newlines.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_newlines.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_newlines.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_newlines.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_nocomponent() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_nocomponent.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_nocomponent.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_nocomponent.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_nocomponent.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_nocomponentname() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_nocomponentname.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_nocomponentname.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_nocomponentname.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_nocomponentname.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_charclass() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_charclass.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_charclass.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_charclass.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_charclass.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_qualified1() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_qualified1.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_qualified1.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_qualified1.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_qualified1.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_qualified2() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_qualified2.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_qualified2.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_qualified2.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_qualified2.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_qualified3() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_qualified3.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_qualified3.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_qualified3.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_qualified3.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }

    public void test_c_parserfail_qualified4() throws Exception {
        List<String> expectedErrors = ComponentParserFailTests.readErrors("test/frontend/c_parserfail_qualified4.out");
        Scanner scanner = this.getScanner("test/frontend/c_parserfail_qualified4.in");
        ComponentParser parser = new ComponentParser();
        parser.setFilename("test/frontend/c_parserfail_qualified4.in");
        try {
            parser.parse(scanner);
            ComponentParserFailTests.assertTrue((boolean)parser.hasProblem());
            ComponentParserFailTests.assertEquals(expectedErrors, parser.getProblems());
        }
        catch (Parser.Exception e) {
            TreeSet<CompilationError> actualErrors = new TreeSet<CompilationError>();
            actualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));
            actualErrors.add(new CompilationError("test/frontend/c_parserfail_qualified4.in", e.getMessage()));
            ComponentParserFailTests.assertEquals(expectedErrors, actualErrors);
        }
    }
}

