/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationProblem;
import metalexer.FileLoaderHelper;
import metalexer.ast.Component;
import metalexer.ast.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLoader {
    private final List<FileLoaderHelper> helpers;
    private final Map<String, Component> components;
    private final Map<String, Layout> layouts;

    public FileLoader(String dir) {
        this(Collections.singletonList(dir));
    }

    public FileLoader(List<String> dirs) {
        this.helpers = new ArrayList<FileLoaderHelper>(dirs.size());
        for (String dir : dirs) {
            this.helpers.add(new FileLoaderHelper(dir));
        }
        this.components = new HashMap<String, Component>();
        this.layouts = new HashMap<String, Layout>();
    }

    public Component loadComponent(String compName, SortedSet<CompilationProblem> errors) throws IOException {
        if (this.components.containsKey(compName)) {
            return this.components.get(compName);
        }
        for (FileLoaderHelper helper : this.helpers) {
            try {
                TreeSet helperErrors = new TreeSet();
                Component comp = helper.loadComponent(compName, errors);
                if (comp == null) continue;
                errors.addAll(helperErrors);
                this.components.put(compName, comp);
                return comp;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.components.put(compName, null);
        return null;
    }

    public Layout loadLayout(String layoutName, SortedSet<CompilationProblem> errors) throws IOException {
        if (this.layouts.containsKey(layoutName)) {
            return this.layouts.get(layoutName);
        }
        for (FileLoaderHelper helper : this.helpers) {
            try {
                TreeSet helperErrors = new TreeSet();
                Layout layout = helper.loadLayout(layoutName, errors);
                if (layout == null) continue;
                errors.addAll(helperErrors);
                this.layouts.put(layoutName, layout);
                return layout;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.layouts.put(layoutName, null);
        return null;
    }
}

