/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.PrintWriter;
import metalexer.AbstractTestGenerator;

public abstract class InheritanceFailTestGenerator
extends AbstractTestGenerator {
    private final String prefix;

    protected InheritanceFailTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "InheritanceFailTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import java.util.List;");
        testFileWriter.println("import java.util.SortedSet;");
        testFileWriter.println("import java.util.TreeSet;");
        testFileWriter.println();
        testFileWriter.println("import metalexer.ast." + this.prefix + ";");
        testFileWriter.println();
        testFileWriter.println("public class " + this.prefix + "InheritanceFailTests extends " + this.prefix + "ParserFailTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("    public void " + methodName + "() throws Exception {");
        testFileWriter.println("        FileLoader loader = new FileLoader(\"test/frontend\");");
        testFileWriter.println("        SortedSet<CompilationProblem> actualErrors = new TreeSet<CompilationProblem>();");
        testFileWriter.println("        " + this.prefix + " node = loader.load" + this.prefix + "(\"" + testName + "\", actualErrors);");
        testFileWriter.println("        assertTrue(node.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        node = node.processInheritance(loader, actualErrors);");
        testFileWriter.println("        assertTrue(node.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        assertFalse(actualErrors.isEmpty());");
        testFileWriter.println("        List<String> expectedErrors = readErrors(\"" + outFileName + "\");");
        testFileWriter.println("        assertEquals(expectedErrors, ProblemUtil.extractErrors(actualErrors));");
        testFileWriter.println("    }");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}

