/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Symbol;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.FileLoader;
import metalexer.ProblemUtil;
import metalexer.ScannerUtil;
import metalexer.ast.Layout;

public class LayoutInheritanceTestTool {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.LayoutInheritanceTestTool {basename}");
            System.exit(1);
        }
        String basename = args[0];
        try {
            FileLoader loader = new FileLoader("test/frontend");
            TreeSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();
            Layout actual = loader.loadLayout(basename, problems);
            assert (actual.subtreeNodesHaveCorrectParents());
            actual = actual.processInheritance(loader, problems);
            PrintWriter out = new PrintWriter(new FileWriter("test/frontend/" + basename + ".out"));
            SortedSet<CompilationError> errors = ProblemUtil.extractErrors(problems);
            if (errors.isEmpty()) {
                actual.tidyRuleGroups();
                int startPos = actual.getStart();
                int endPos = actual.getEnd();
                out.println(String.valueOf(Symbol.getLine(startPos)) + " " + Symbol.getColumn(startPos));
                out.println(String.valueOf(Symbol.getLine(endPos)) + " " + Symbol.getColumn(endPos));
                out.print(actual.getStructureString());
            } else {
                for (CompilationError error : errors) {
                    out.println(ScannerUtil.stringifyValue(error));
                }
            }
            out.close();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

