/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.AltMetaPattern;
import metalexer.ast.AnyMetaPattern;
import metalexer.ast.BOFMetaPattern;
import metalexer.ast.BaseMetaPattern;
import metalexer.ast.BodyElement;
import metalexer.ast.ClassMetaPattern;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Declaration;
import metalexer.ast.Embedding;
import metalexer.ast.EmbeddingRef;
import metalexer.ast.Extension;
import metalexer.ast.Layout;
import metalexer.ast.LayoutComponentDirective;
import metalexer.ast.LayoutDeclDirective;
import metalexer.ast.LayoutDeclRegion;
import metalexer.ast.LayoutDirective;
import metalexer.ast.LayoutHelperDirective;
import metalexer.ast.LayoutInitRegion;
import metalexer.ast.LayoutInitThrowDirective;
import metalexer.ast.LayoutLexThrowDirective;
import metalexer.ast.LayoutOptionDirective;
import metalexer.ast.LayoutStartDirective;
import metalexer.ast.LayoutWrapper;
import metalexer.ast.LexerOption;
import metalexer.ast.List;
import metalexer.ast.MTokPair;
import metalexer.ast.MTokRef;
import metalexer.ast.MetaPattern;
import metalexer.ast.Opt;
import metalexer.ast.OptMetaPattern;
import metalexer.ast.OptionBlob;
import metalexer.ast.OptionRef;
import metalexer.ast.PairItem;
import metalexer.ast.PlusMetaPattern;
import metalexer.ast.RegionMetaPattern;
import metalexer.ast.RegionPairItem;
import metalexer.ast.Replacement;
import metalexer.ast.SeqMetaPattern;
import metalexer.ast.StarMetaPattern;
import metalexer.ast.SymMetaPattern;
import metalexer.ast.SymPairItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutParser
extends Parser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjbscuLbKLnzSvvmKYi7il8dH1GD041K54P9v1k0O9Cda1cIIojAmSqrAqjC4SFoKPWbefNWR5B2lDj0p52bCq1faTo1d5eR3TRwszpxdlVSzxWQyzTVxFVw#zzrfhJsVlS$OIQTBU$S93ZfS#Cb8gPQWSAztb68cj$bOqpLERO9c4t0C1tlUJqa8#OxvDj5Q#1DjbDXukoAS27Z3F3j8nU4xLMXaE2vcDGMuAkIS3ddBFIqkfSVzsVrN82AsLIQJFPJO6gGxoCBVLy6IGHP1XKaNQd$oV53BM$TImLGR8IMw3zRGrQBUwxGgPw6Knv5CoaBI2$1CAQUtkCcntBoYainnfbghTxhOfQ6TRANH5IDl0ewIJUyH3Mb5U96tT2eDQQZsfN9dQ1AoGhj9DZdE$3bZXdbN8fsMk#vk1MZaHjizi379Qo3qKy6U5dExg53OQQcMAPmFK1VchW3fMzLGvXVSxrzrfe5P6mT6PZO5rzxbV1gnpwspTLogq1QsLoV3CpCPZPP0F1goqFeV963H$Dr0huqYtP3O6MHHozmLiSLjafbpbLYbeOORMoXou8BFnM1Nawe1LxYE5d6r#i#HRMelNQhasip78jqDkfqAkyR8OSgsTX##HywUmjnmkNJWFE#KwjyEmCyXY$5x1AkwGuU0Bif1q15uxT1Nb1sXtoCdIKth82TxM$Sv3FYlNOpb2pf6RIOLJfBMpuPTJcu27FUGhShvyLRucNvSBv4AvI2wssXj8Nqnj0dxh8P#dtU4Yw5#KirYXowrMuEZK9k0t7cejundBq#vfcIRpiDLQKfcUsWGyff3#Djy9pBp#qPaBkizbCpTRzwY7pjNiph5q27lCQZqRu1yAwUjbCTHBhd0R5NXjB0Nj3a9kLg3VN0hj6Bb9GMvJAKo$oUrHaDjJ2XlvTzmk1VfTfJ3$NMwtWjpkKfX#jtjLGUxLKeJs$wMG6#M7SebSAj#Go#IRShLyLxvl#jn#i1siJxg3Zs07wtCUFDVzKq4krvhRhs0S#tFuG87cWnpULw1vFuTz2ZJxSdXFWUQz7DvLe7atXxqAD7jpU4U1vfqStbQWUJk7jnHetihXJGMQDtDuGu7cZHnULw1vFOVN56XUo#5b1PgNStX5WUQL75vIe7afXuyLQ3xEuKC5cWzBORkaVz4kwMMxfBzzznzNfEVMdsIpJK$ouxQVCbivkjZMtQx8R9Sg6C4T2hpcax$TBLEGKyrIodV85rMBdvPLimpxfUwF1jKiipwvuw3vWu8wTDGrTVSeo7t2JfHgVwoWqCpTPhZ7BJ7yH25dIArfnTqMk4I9Hj3VRLXkM6ouLu7kBmhatUQxNDV0BIQjDUrogIPTR6jmhrjlM6juHe7k$h1kujQuzT8FkTRT3vundpNWPuQVAwJ14tm7err3IRMHn9B8SRp9JjmBJc2zUyc9CbSEunPqDlV8VjAAlrThpdyRQSlDurXf9#tboCopi$cUnZ$8#quspsbu3YZnbBAUu$dYUyzXvfdWsRN4irlEq#Sao0xcEGTFAV6i39x71ClEKf0cqbIQyPQRsrst9VksXrJGQbMmwHHajRMQrXs5JILxr9UhohIJSFkju4#LjjCcQyTBtUc7qewkI8MSZgw#$mIFQaOwesWygZsQjaufcNDLoMhLzzynvDIpBPuL9PvzIZoz75BabRwXvA1zwghg#otkis#PFfCIptHclgmjQ6aOdeCFgK$bmVhiNgRF2jRHbxK5zHnqIFFqkQ7qgNvdPYlKfSIpfe5dbpBllOlDjeO#qbFOcs#czj4bU7KiuvMEf0eg1i4EvgKZcST8EkREeVUOQ9OAOZVdmYcQYSV9ZNZe$MoaZ9BHCeRx#LWPPnvTognmwZ6KTXEeApmuNLdAZNkezIJ6eXv3kCEwp6DMOnvOdw5#wPDvd5NUG#TgTZuDUqmzO3cFWMNMNRqgl1wld9wwWGVMK$jVecS$bDVdzmEhOfgY7MpbgN1wuxtzN$C$fT6pavJk4ivn$NS$FON#N2P5vxBIzfEtzMUqoBR4Enr1AYjWLKcfcbtUJwh8TuJLMMtw3x5QwrFlE1thlUrhCIKhruOJKvdLpC$#yUbjHTCAsgxojjfJDewYiUNJeZbutofRWoeRiKyhBTKrg2xhd$XrCxzAwMpVHxMkpFxh3UoB7xNMbF5r3gEyPP7U9ft6MVRVrFjLTpWBpX4VZzyCkMMAsX0zyByHkLCqUdGQc$354E4#MXY8$15o578ktVFLAMo0n3po62JwYffJ9g8YmXJXbbou0TuAYTaADP2senrGOrBkoF7Xi0SSGnc$g0Ni1YaNQgaZQefuF$5iyKy7U3Kwela24M9q9MKT5z#iQ2XrnA0HD$m2yMjy2VKNGVgNXwddBXyT3udKemNesNSHKNdS4qca9HlnqxZZEieQ0wqIQTAKV5lgkVr7lAy2TGNMgl0WEfthMhWE7UiKNGptKAQV0dEBc5iq0LvFcNMEY2CAvyCBu6MKMQFe8VWS95fFs94H$IT42ibeE0aox#HSU2cy1ju2YPgIEeXlyWHy5cvd7hsGnAmnxok#2V9#uwLmDNoKjfbNl1v931EhlRwlkyHV7#z3yauApSZl5zjUXTQG6tpC#XTwXdrKfpBadwT#V55vKvel9i$C8ATx6ItnCjQpSaNGFHBQs1VALvHhgwYlpV2Z0zdKzrzeLJIMDlNvcFqLDStRnnTItxNnzg8uoA55TOD3#$ekL$hz7RSATHk2R1PiZoZJPhiWvmHvUP5kSf1xWrnuuFd6suBT2mUoEu1$o#0$COoxhg4#Eg$C#1S5UMFZxKRhGtlwB2HcZVYA56GgSYeRJcyTqybF9Z$DxZBHGJaSZe0ZuIXyHiCny5GuZxgno75iy1hoDSW#I6Ntm1wmhp7XwnWH5IWJgKNMugj$Xldafy1#WJECCN6Vm8Y$JGjYoHWc$2qZOt$cDG2f70ydmDxm96F2dpI2CV$L2COPUr9kI8tu8#D0Oyn$E845xlyHZErhFP7yB6FCdLnWn9rQ6NFZ5XZnJsn2z1F9RAF67p7HMiHVG9bmXu#v#HTamNy0ki6nZ0==");
    private String filename = null;
    private final SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public SortedSet<CompilationProblem> getProblems() {
        return Collections.unmodifiableSortedSet(this.problems);
    }

    public boolean hasProblem() {
        return !this.problems.isEmpty();
    }

    private CompilationError buildError(Symbol token, String msg) {
        return new CompilationError(this.filename, Symbol.getLine(token.getStart()), Symbol.getColumn(token.getStart()), msg);
    }

    private CompilationError buildError(Scanner.Exception e, String msg) {
        return new CompilationError(this.filename, e.line, e.column, msg);
    }

    private CompilationWarning buildWarning(Symbol token, String msg) {
        return new CompilationWarning(this.filename, Symbol.getLine(token.getStart()), Symbol.getColumn(token.getStart()), msg);
    }

    private CompilationWarning buildWarning(Scanner.Exception e, String msg) {
        return new CompilationWarning(this.filename, e.line, e.column, msg);
    }

    private static <T extends ASTNode<?>> List<T> makeListNode(java.util.List<T> children) {
        if (children == null) {
            return null;
        }
        return new List<T>().addAll(children);
    }

    private static <T extends ASTNode> List<T> nullToEmpty(List<T> original) {
        return original == null ? new List() : original;
    }

    private Layout makeLayout(Symbol iHeader, Symbol lHeader, List<OptionBlob> optionBlobs, List<BodyElement> bodyElements) {
        Symbol name = null;
        boolean isHelper = false;
        Opt<CompRef> startComp = new Opt<CompRef>();
        List<CompDecl> comps = new List<CompDecl>();
        List<LexerOption> options = new List<LexerOption>();
        List<Declaration> decls = new List<Declaration>();
        LinkedHashSet<StringSymbol> declRegions = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> yylexExceptions = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> initRegions = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> initExceptions = new LinkedHashSet<StringSymbol>();
        HashSet<String> compNames = new HashSet<String>();
        HashSet<Object> optionNames = new HashSet<Object>();
        HashSet<String> declNames = new HashSet<String>();
        HashSet<String> yylexExceptionNames = new HashSet<String>();
        HashSet<String> initExceptionNames = new HashSet<String>();
        for (OptionBlob blob : optionBlobs) {
            if (blob instanceof LayoutDirective) {
                if (name == null) {
                    LayoutDirective directive = (LayoutDirective)blob;
                    name = new Symbol(0, directive.Namestart, directive.Nameend, directive.getName());
                    continue;
                }
                this.problems.add(this.buildWarning(blob, "Layout already has a name."));
                continue;
            }
            if (blob instanceof LayoutStartDirective) {
                if (startComp.getNumChild() == 0) {
                    startComp = new Opt<CompRef>(((LayoutStartDirective)blob).getStartComponent());
                    continue;
                }
                this.problems.add(this.buildWarning(blob, "Layout already has a start component."));
                continue;
            }
            if (blob instanceof LayoutHelperDirective) {
                if (isHelper) {
                    this.problems.add(this.buildWarning(blob, "Layout has already been flagged as a helper layout."));
                }
                isHelper = true;
                continue;
            }
            if (blob instanceof LayoutOptionDirective) {
                LexerOption option = new LexerOption((LayoutOptionDirective)blob);
                String optionName = option.getName();
                if (optionNames.contains(optionName)) {
                    this.problems.add(this.buildWarning(option, "Duplicate declaration of option " + (String)optionName + "."));
                    continue;
                }
                options.add(option);
                optionNames.add(optionName);
                continue;
            }
            if (blob instanceof LayoutComponentDirective) {
                for (CompDecl comp : ((LayoutComponentDirective)blob).getComponents()) {
                    String compName = comp.getName();
                    if (compNames.contains(compName)) {
                        this.problems.add(this.buildWarning(comp, "Duplicate import of component " + compName + "."));
                        continue;
                    }
                    comps.add(comp);
                    compNames.add(compName);
                }
                continue;
            }
            if (blob instanceof LayoutDeclDirective) {
                Declaration decl = ((LayoutDeclDirective)blob).getDeclaration();
                String declName = decl.getText();
                if (declNames.contains(declName)) {
                    this.problems.add(this.buildWarning(decl, "Duplicate declaration."));
                    continue;
                }
                decls.add(decl);
                declNames.add(declName);
                continue;
            }
            if (blob instanceof LayoutDeclRegion) {
                declRegions.add(new StringSymbol(blob, ((LayoutDeclRegion)blob).getText()));
                continue;
            }
            if (blob instanceof LayoutLexThrowDirective) {
                for (String exceptionName : ((LayoutLexThrowDirective)blob).getExceptions()) {
                    if (yylexExceptionNames.contains(exceptionName)) {
                        this.problems.add(this.buildWarning(blob, "Duplicate declaration of lex exception " + exceptionName + "."));
                        continue;
                    }
                    yylexExceptions.add(new StringSymbol(blob, exceptionName));
                    yylexExceptionNames.add(exceptionName);
                }
                continue;
            }
            if (blob instanceof LayoutInitRegion) {
                initRegions.add(new StringSymbol(blob, ((LayoutInitRegion)blob).getText()));
                continue;
            }
            if (blob instanceof LayoutInitThrowDirective) {
                for (String exceptionName : ((LayoutInitThrowDirective)blob).getExceptions()) {
                    if (yylexExceptionNames.contains(exceptionName)) {
                        this.problems.add(this.buildWarning(blob, "Duplicate declaration of init exception " + exceptionName + "."));
                        continue;
                    }
                    initExceptions.add(new StringSymbol(blob, exceptionName));
                    initExceptionNames.add(exceptionName);
                }
                continue;
            }
            throw new RuntimeException("Unexpected option blob type: " + blob.getClass().getName());
        }
        return new Layout(name, isHelper, iHeader, lHeader, startComp, comps, options, decls, declRegions, yylexExceptions, initRegions, initExceptions, bodyElements);
    }

    public LayoutParser() {
        super(PARSING_TABLES);
        this.report = new Events();
    }

    @Override
    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                Symbol _symbol_l = this._symbols[offset + 1];
                Layout l = (Layout)_symbol_l.value;
                LayoutWrapper wrapper = new LayoutWrapper(l);
                wrapper.setFilenameOnSubtreeNoTransform(this.filename);
                return wrapper;
            }
            case 1: {
                Symbol _symbol_lHeader = this._symbols[offset + 1];
                String lHeader = (String)_symbol_lHeader.value;
                Symbol _symbol_iHeader = this._symbols[offset + 2];
                String iHeader = (String)_symbol_iHeader.value;
                Symbol _symbol_options = this._symbols[offset + 3];
                List options = (List)_symbol_options.value;
                Symbol _symbol_bodyElements = this._symbols[offset + 4];
                List bodyElements = (List)_symbol_bodyElements.value;
                return this.makeLayout(_symbol_lHeader, _symbol_iHeader, options, bodyElements);
            }
            case 2: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 3: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 6: {
                Symbol _symbol_layout = this._symbols[offset + 1];
                LayoutDirective layout = (LayoutDirective)_symbol_layout.value;
                Symbol _symbol_blobs = this._symbols[offset + 2];
                ArrayList _list_blobs = (ArrayList)_symbol_blobs.value;
                OptionBlob[] blobs = _list_blobs == null ? new OptionBlob[]{} : _list_blobs.toArray(new OptionBlob[_list_blobs.size()]);
                List<LayoutDirective> list = LayoutParser.nullToEmpty(LayoutParser.makeListNode(_list_blobs));
                list.insertChild(layout, 0);
                return list;
            }
            case 7: {
                Symbol _symbol_n = this._symbols[offset + 2];
                String n = (String)_symbol_n.value;
                return new LayoutDirective(_symbol_n);
            }
            case 17: {
                Symbol _symbol_text = this._symbols[offset + 1];
                String text = (String)_symbol_text.value;
                return new LayoutDeclRegion(text);
            }
            case 18: {
                Symbol _symbol_text = this._symbols[offset + 1];
                String text = (String)_symbol_text.value;
                return new LayoutInitRegion(text);
            }
            case 19: {
                return new LayoutHelperDirective();
            }
            case 20: {
                Symbol _symbol_n = this._symbols[offset + 2];
                CompRef n = (CompRef)_symbol_n.value;
                return new LayoutStartDirective(n);
            }
            case 21: {
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                return new LayoutComponentDirective(l);
            }
            case 22: {
                Symbol _symbol_l = this._symbols[offset + 2];
                java.util.List l = (java.util.List)_symbol_l.value;
                return new LayoutInitThrowDirective(l);
            }
            case 23: {
                Symbol _symbol_l = this._symbols[offset + 2];
                java.util.List l = (java.util.List)_symbol_l.value;
                return new LayoutLexThrowDirective(l);
            }
            case 24: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new Declaration(s);
            }
            case 25: {
                Symbol _symbol_t = this._symbols[offset + 2];
                Declaration t = (Declaration)_symbol_t.value;
                return new LayoutDeclDirective(t);
            }
            case 26: {
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                String s = (String)_symbol_s.value;
                return new LayoutOptionDirective(i, s);
            }
            case 27: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                ArrayList<String> strings = new ArrayList<String>();
                strings.add(s);
                return new Symbol(strings);
            }
            case 28: {
                Symbol _symbol_l = this._symbols[offset + 1];
                java.util.List l = (java.util.List)_symbol_l.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                String s = (String)_symbol_s.value;
                l.add(s);
                return _symbol_l;
            }
            case 33: {
                Symbol _symbol_n = this._symbols[offset + 1];
                String n = (String)_symbol_n.value;
                return new CompRef(_symbol_n);
            }
            case 34: {
                Symbol _symbol_n = this._symbols[offset + 1];
                CompRef n = (CompRef)_symbol_n.value;
                return new List<CompRef>().add(n);
            }
            case 35: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_n = this._symbols[offset + 3];
                CompRef n = (CompRef)_symbol_n.value;
                return l.add(n);
            }
            case 36: {
                Symbol _symbol_n = this._symbols[offset + 1];
                String n = (String)_symbol_n.value;
                return new CompDecl(_symbol_n, new Opt<Component>());
            }
            case 37: {
                Symbol _symbol_n = this._symbols[offset + 1];
                CompDecl n = (CompDecl)_symbol_n.value;
                return new List<CompDecl>().add(n);
            }
            case 38: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_n = this._symbols[offset + 3];
                CompDecl n = (CompDecl)_symbol_n.value;
                return l.add(n);
            }
            case 39: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 40: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 43: {
                Symbol _symbol_blobs = this._symbols[offset + 1];
                ArrayList _list_blobs = (ArrayList)_symbol_blobs.value;
                BodyElement[] blobs = _list_blobs == null ? new BodyElement[]{} : _list_blobs.toArray(new BodyElement[_list_blobs.size()]);
                return LayoutParser.nullToEmpty(LayoutParser.makeListNode(_list_blobs));
            }
            case 46: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 47: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 50: {
                Symbol _symbol_name = this._symbols[offset + 3];
                String name = (String)_symbol_name.value;
                Symbol _symbol_hosts = this._symbols[offset + 4];
                List hosts = (List)_symbol_hosts.value;
                Symbol _symbol_guest = this._symbols[offset + 6];
                CompRef guest = (CompRef)_symbol_guest.value;
                Symbol _symbol_start = this._symbols[offset + 8];
                MetaPattern start = (MetaPattern)_symbol_start.value;
                Symbol _symbol_end = this._symbols[offset + 10];
                MetaPattern end = (MetaPattern)_symbol_end.value;
                Symbol _symbol_pairs = this._symbols[offset + 11];
                ArrayList _list_pairs = (ArrayList)_symbol_pairs.value;
                MTokPair[] pairs = _list_pairs == null ? new MTokPair[]{} : _list_pairs.toArray(new MTokPair[_list_pairs.size()]);
                return new Embedding(name, (List<CompRef>)hosts, guest, start, end, LayoutParser.nullToEmpty(LayoutParser.makeListNode(_list_pairs)));
            }
            case 51: {
                Symbol _symbol_hosts = this._symbols[offset + 2];
                List hosts = (List)_symbol_hosts.value;
                return hosts;
            }
            case 52: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_h = this._symbols[offset + 3];
                List h = (List)_symbol_h.value;
                return l.addAll(h);
            }
            case 53: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new MTokRef(_symbol_i);
            }
            case 54: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new MTokRef(_symbol_i);
            }
            case 55: {
                Symbol _symbol_i1 = this._symbols[offset + 2];
                PairItem i1 = (PairItem)_symbol_i1.value;
                Symbol _symbol_i2 = this._symbols[offset + 4];
                PairItem i2 = (PairItem)_symbol_i2.value;
                return new MTokPair(i1, i2);
            }
            case 56: {
                Symbol _symbol_i = this._symbols[offset + 1];
                CompRef i = (CompRef)_symbol_i.value;
                return new RegionPairItem(i);
            }
            case 57: {
                Symbol _symbol_i = this._symbols[offset + 1];
                MTokRef i = (MTokRef)_symbol_i.value;
                return new SymPairItem(i);
            }
            case 58: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new CompRef(_symbol_i);
            }
            case 59: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new MTokRef(_symbol_i);
            }
            case 62: {
                Symbol _symbol_mp1 = this._symbols[offset + 1];
                MetaPattern mp1 = (MetaPattern)_symbol_mp1.value;
                Symbol _symbol_mp2 = this._symbols[offset + 3];
                MetaPattern mp2 = (MetaPattern)_symbol_mp2.value;
                return new AltMetaPattern(mp1, mp2);
            }
            case 64: {
                Symbol _symbol_mp1 = this._symbols[offset + 1];
                MetaPattern mp1 = (MetaPattern)_symbol_mp1.value;
                Symbol _symbol_mp2 = this._symbols[offset + 2];
                MetaPattern mp2 = (MetaPattern)_symbol_mp2.value;
                return new SeqMetaPattern(mp1, mp2);
            }
            case 66: {
                Symbol _symbol_mp = this._symbols[offset + 1];
                MetaPattern mp = (MetaPattern)_symbol_mp.value;
                return new OptMetaPattern(mp);
            }
            case 67: {
                Symbol _symbol_mp = this._symbols[offset + 1];
                MetaPattern mp = (MetaPattern)_symbol_mp.value;
                return new StarMetaPattern(mp);
            }
            case 68: {
                Symbol _symbol_mp = this._symbols[offset + 1];
                MetaPattern mp = (MetaPattern)_symbol_mp.value;
                return new PlusMetaPattern(mp);
            }
            case 71: {
                return new AnyMetaPattern();
            }
            case 72: {
                return new BOFMetaPattern();
            }
            case 74: {
                Symbol _symbol_r = this._symbols[offset + 1];
                String r = (String)_symbol_r.value;
                return new RegionMetaPattern(new CompRef(_symbol_r));
            }
            case 75: {
                Symbol _symbol_s = this._symbols[offset + 1];
                MTokRef s = (MTokRef)_symbol_s.value;
                return new SymMetaPattern(s);
            }
            case 76: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 77: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 78: {
                Symbol _symbol_elements = this._symbols[offset + 2];
                ArrayList _list_elements = (ArrayList)_symbol_elements.value;
                BaseMetaPattern[] elements = _list_elements == null ? new BaseMetaPattern[]{} : _list_elements.toArray(new BaseMetaPattern[_list_elements.size()]);
                return new ClassMetaPattern(false, LayoutParser.nullToEmpty(LayoutParser.makeListNode(_list_elements)));
            }
            case 79: {
                Symbol _symbol_elements = this._symbols[offset + 3];
                ArrayList _list_elements = (ArrayList)_symbol_elements.value;
                BaseMetaPattern[] elements = _list_elements == null ? new BaseMetaPattern[]{} : _list_elements.toArray(new BaseMetaPattern[_list_elements.size()]);
                return new ClassMetaPattern(true, LayoutParser.nullToEmpty(LayoutParser.makeListNode(_list_elements)));
            }
            case 80: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 81: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 84: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 85: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 88: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 89: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 92: {
                Symbol _symbol_name = this._symbols[offset + 2];
                String name = (String)_symbol_name.value;
                Symbol _symbol_deleteOptions = this._symbols[offset + 3];
                ArrayList _list_deleteOptions = (ArrayList)_symbol_deleteOptions.value;
                List[] deleteOptions = _list_deleteOptions == null ? new List[]{} : _list_deleteOptions.toArray(new List[_list_deleteOptions.size()]);
                Symbol _symbol_repls = this._symbols[offset + 4];
                ArrayList _list_repls = (ArrayList)_symbol_repls.value;
                Replacement[] repls = _list_repls == null ? new Replacement[]{} : _list_repls.toArray(new Replacement[_list_repls.size()]);
                Symbol _symbol_deleteLists = this._symbols[offset + 5];
                ArrayList _list_deleteLists = (ArrayList)_symbol_deleteLists.value;
                List[] deleteLists = _list_deleteLists == null ? new List[]{} : _list_deleteLists.toArray(new List[_list_deleteLists.size()]);
                HashSet<String> unoptions = new HashSet<String>();
                List<OptionRef> deletedOptions = new List<OptionRef>();
                List[] listArray = deleteOptions;
                int n = deleteOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    List list = listArray[n2];
                    for (OptionRef option : list) {
                        String optionName = option.getName();
                        if (unoptions.contains(optionName)) {
                            this.problems.add(this.buildWarning(option, "Duplicate deletion of option " + optionName + "."));
                            continue;
                        }
                        deletedOptions.add(option);
                        unoptions.add(optionName);
                    }
                    ++n2;
                }
                HashSet<String> replaces = new HashSet<String>();
                List<Replacement> replacements = new List<Replacement>();
                Replacement[] replacementArray = repls;
                int option = repls.length;
                int n3 = 0;
                while (n3 < option) {
                    Replacement replacement = replacementArray[n3];
                    String oldComp = replacement.getOld().getName();
                    if (replaces.contains(oldComp)) {
                        this.problems.add(this.buildWarning(replacement, "Duplicate replacement of component " + oldComp + "."));
                    } else {
                        replacements.add(replacement);
                        replaces.add(oldComp);
                    }
                    ++n3;
                }
                HashSet<String> unembeds = new HashSet<String>();
                List<EmbeddingRef> deletedEmbeddings = new List<EmbeddingRef>();
                List[] listArray2 = deleteLists;
                int n4 = deleteLists.length;
                int n5 = 0;
                while (n5 < n4) {
                    List list = listArray2[n5];
                    for (EmbeddingRef embedding : list) {
                        String embeddingName = embedding.getName();
                        if (unembeds.contains(embeddingName)) {
                            this.problems.add(this.buildWarning(embedding, "Duplicate deletion of embedding " + embeddingName + "."));
                            continue;
                        }
                        deletedEmbeddings.add(embedding);
                        unembeds.add(embeddingName);
                    }
                    ++n5;
                }
                return new Extension(name, deletedOptions, replacements, deletedEmbeddings);
            }
            case 93: {
                Symbol _symbol_n = this._symbols[offset + 1];
                String n = (String)_symbol_n.value;
                return new OptionRef(_symbol_n);
            }
            case 94: {
                Symbol _symbol_r = this._symbols[offset + 1];
                OptionRef r = (OptionRef)_symbol_r.value;
                return new List<OptionRef>().add(r);
            }
            case 95: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                OptionRef r = (OptionRef)_symbol_r.value;
                return l.add(r);
            }
            case 97: {
                Symbol _symbol_n = this._symbols[offset + 1];
                String n = (String)_symbol_n.value;
                return new EmbeddingRef(_symbol_n);
            }
            case 98: {
                Symbol _symbol_r = this._symbols[offset + 1];
                EmbeddingRef r = (EmbeddingRef)_symbol_r.value;
                return new List<EmbeddingRef>().add(r);
            }
            case 99: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                EmbeddingRef r = (EmbeddingRef)_symbol_r.value;
                return l.add(r);
            }
            case 101: {
                Symbol _symbol_c1 = this._symbols[offset + 2];
                CompRef c1 = (CompRef)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 4];
                CompRef c2 = (CompRef)_symbol_c2.value;
                return new Replacement(c1, c2);
            }
            case 4: 
            case 41: 
            case 48: 
            case 82: 
            case 86: 
            case 90: {
                return new Symbol(null);
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 42: 
            case 44: 
            case 45: 
            case 49: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 70: 
            case 83: 
            case 87: 
            case 91: {
                return this._symbols[offset + 1];
            }
            case 73: 
            case 96: 
            case 100: {
                return this._symbols[offset + 2];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    class Events
    extends Parser.Events {
        Events() {
        }

        public void syntaxError(Symbol token) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(token, "unexpected token " + Terminals.NAMES[token.getId()]));
        }

        public void scannerError(Scanner.Exception e) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(e, "scanner error: " + e.getMessage()));
        }

        public void unexpectedTokenRemoved(Symbol token) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(token, "try deleting " + Terminals.NAMES[token.getId()]));
        }

        public void missingTokenInserted(Symbol token) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(token, "try inserting " + Terminals.NAMES[token.getId()]));
        }

        public void misspelledTokenReplaced(Symbol token) {
            LayoutParser.this.problems.add(LayoutParser.this.buildError(token, "try replacing with " + Terminals.NAMES[token.getId()]));
        }
    }

    public static class Terminals {
        public static final short EOF = 0;
        public static final short START_EMBED_GROUP = 1;
        public static final short START_INHERIT_GROUP = 2;
        public static final short IDENTIFIER = 3;
        public static final short OPTION_DIRECTIVE = 4;
        public static final short DECL_REGION = 5;
        public static final short INIT_REGION = 6;
        public static final short HELPER_DIRECTIVE = 7;
        public static final short START_DIRECTIVE = 8;
        public static final short COMPONENT_DIRECTIVE = 9;
        public static final short INITTHROW_DIRECTIVE = 10;
        public static final short LEXTHROW_DIRECTIVE = 11;
        public static final short DECLARE_DIRECTIVE = 12;
        public static final short MP_SYM = 13;
        public static final short MP_REGION = 14;
        public static final short COMMA = 15;
        public static final short EMBEDDING_PAIR = 16;
        public static final short INHERIT_UNEMBED = 17;
        public static final short MP_LSQUARE = 18;
        public static final short MP_LPAREN = 19;
        public static final short MP_ANY = 20;
        public static final short MP_BOF = 21;
        public static final short EMBEDDING_END = 22;
        public static final short MP_RPAREN = 23;
        public static final short MP_OR = 24;
        public static final short INHERIT_REPLACE = 25;
        public static final short MP_OPT = 26;
        public static final short MP_STAR = 27;
        public static final short MP_PLUS = 28;
        public static final short QUALIFIED_IDENTIFIER = 29;
        public static final short INHERIT_UNOPTION = 30;
        public static final short EMBEDDING_HOST = 31;
        public static final short EMBEDDING_GUEST = 32;
        public static final short MP_RSQUARE = 33;
        public static final short STRING = 34;
        public static final short EMBEDDING_START = 35;
        public static final short EMBEDDING_NAME = 36;
        public static final short MP_CARET = 37;
        public static final short LOCAL_HEADER = 38;
        public static final short INHERITED_HEADER = 39;
        public static final short LAYOUT_DIRECTIVE = 40;
        public static final String[] NAMES = new String[]{"EOF", "START_EMBED_GROUP", "START_INHERIT_GROUP", "IDENTIFIER", "OPTION_DIRECTIVE", "DECL_REGION", "INIT_REGION", "HELPER_DIRECTIVE", "START_DIRECTIVE", "COMPONENT_DIRECTIVE", "INITTHROW_DIRECTIVE", "LEXTHROW_DIRECTIVE", "DECLARE_DIRECTIVE", "MP_SYM", "MP_REGION", "COMMA", "EMBEDDING_PAIR", "INHERIT_UNEMBED", "MP_LSQUARE", "MP_LPAREN", "MP_ANY", "MP_BOF", "EMBEDDING_END", "MP_RPAREN", "MP_OR", "INHERIT_REPLACE", "MP_OPT", "MP_STAR", "MP_PLUS", "QUALIFIED_IDENTIFIER", "INHERIT_UNOPTION", "EMBEDDING_HOST", "EMBEDDING_GUEST", "MP_RSQUARE", "STRING", "EMBEDDING_START", "EMBEDDING_NAME", "MP_CARET", "LOCAL_HEADER", "INHERITED_HEADER", "LAYOUT_DIRECTIVE"};
    }
}

