/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.PrintWriter;
import metalexer.AbstractTestGenerator;

public abstract class ParserFailTestGenerator
extends AbstractTestGenerator {
    private final String prefix;

    protected ParserFailTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "ParserFailTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import java.util.List;");
        testFileWriter.println("import java.util.SortedSet;");
        testFileWriter.println("import java.util.TreeSet;");
        testFileWriter.println();
        testFileWriter.println("import beaver.Parser;");
        testFileWriter.println("import beaver.Scanner;");
        testFileWriter.println();
        testFileWriter.println("public class " + this.prefix + "ParserFailTests extends " + this.prefix + "ParserFailTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String inFileName = "test/frontend/" + testName + ".in";
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("\tpublic void " + methodName + "() throws Exception {");
        testFileWriter.println("\t\tList<String> expectedErrors = readErrors(\"" + outFileName + "\");");
        testFileWriter.println("\t\tScanner scanner = getScanner(\"" + inFileName + "\");");
        testFileWriter.println("\t\t" + this.prefix + "Parser parser = new " + this.prefix + "Parser();");
        testFileWriter.println("        parser.setFilename(\"" + inFileName + "\");");
        testFileWriter.println("\t\ttry {");
        testFileWriter.println("\t\t\tparser.parse(scanner);");
        testFileWriter.println("\t\t\tassertTrue(parser.hasProblem());");
        testFileWriter.println("\t\t\tassertEquals(expectedErrors, parser.getProblems());");
        testFileWriter.println("\t\t} catch(Parser.Exception e) {");
        testFileWriter.println("\t\t\tSortedSet<CompilationError> actualErrors = new TreeSet<CompilationError>();");
        testFileWriter.println("\t\t\tactualErrors.addAll(ProblemUtil.extractErrors(parser.getProblems()));");
        testFileWriter.println("\t\t\tactualErrors.add(new CompilationError(\"" + inFileName + "\", e.getMessage()));");
        testFileWriter.println("\t\t\tassertEquals(expectedErrors, actualErrors);");
        testFileWriter.println("\t\t}");
        testFileWriter.println("\t}");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}

