/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.PrintWriter;
import metalexer.AbstractTestGenerator;

public abstract class ScannerTestGenerator
extends AbstractTestGenerator {
    private final String prefix;

    protected ScannerTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "ScannerTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import java.util.ArrayList;");
        testFileWriter.println("import java.util.List;");
        testFileWriter.println();
        testFileWriter.println("import beaver.Scanner;");
        testFileWriter.println("import beaver.Symbol;");
        testFileWriter.println();
        testFileWriter.println("public class " + this.prefix + "ScannerTests extends " + this.prefix + "ScannerTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String inFileName = "test/frontend/" + testName + ".in";
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("\tpublic void " + methodName + "() throws Exception {");
        testFileWriter.println("\t\tScanner scanner = getScanner(\"" + inFileName + "\");");
        testFileWriter.println("\t\tList<Symbol> symbols = new ArrayList<Symbol>();");
        testFileWriter.println("\t\tScanner.Exception exception = parseSymbols(\"" + outFileName + "\", symbols);");
        testFileWriter.println("\t\tcheckScan(scanner, symbols, exception);");
        testFileWriter.println("\t}");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}

