/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import junit.framework.TestCase;
import metalexer.StringEval;

public class StringEvalTests
extends TestCase {
    public void testUEvals() {
        StringEvalTests.checkEval("\"\\u1\"", "\u0001");
        StringEvalTests.checkEval("\"\\u10\"", "\u0010");
        StringEvalTests.checkEval("\"\\u100\"", "\u0100");
        StringEvalTests.checkEval("\"\\u1000\"", "\u1000");
    }

    public void testXEvals() {
        StringEvalTests.checkEval("\"\\x01\"", "\u0001");
    }

    public void testOctalEvals() {
        StringEvalTests.checkEval("\"\\1\"", "\u0001");
        StringEvalTests.checkEval("\"\\10\"", "\b");
        StringEvalTests.checkEval("\"\\100\"", "@");
    }

    public void testLineEndingEvals() {
        StringEvalTests.checkEval("\"\n\"", "\n");
        StringEvalTests.checkEval("\"\r\"", "\r");
        StringEvalTests.checkEval("\"\\\n\"", "\n");
        StringEvalTests.checkEval("\"\\\r\"", "\r");
    }

    public void testTraditionalEvals() {
        StringEvalTests.checkEval("\"\\n\"", "\n");
        StringEvalTests.checkEval("\"\\r\"", "\r");
        StringEvalTests.checkEval("\"\\t\"", "\t");
        StringEvalTests.checkEval("\"\\f\"", "\f");
        StringEvalTests.checkEval("\"\\b\"", "\b");
    }

    public void testMetaEvals() {
        StringEvalTests.checkEval("\"\\\\\"", "\\");
        StringEvalTests.checkEval("\"\\|\"", "|");
        StringEvalTests.checkEval("\"\\(\"", "(");
        StringEvalTests.checkEval("\"\\)\"", ")");
        StringEvalTests.checkEval("\"\\{\"", "{");
        StringEvalTests.checkEval("\"\\}\"", "}");
        StringEvalTests.checkEval("\"\\[\"", "[");
        StringEvalTests.checkEval("\"\\]\"", "]");
        StringEvalTests.checkEval("\"\\<\"", "<");
        StringEvalTests.checkEval("\"\\>\"", ">");
        StringEvalTests.checkEval("\"\\.\"", ".");
        StringEvalTests.checkEval("\"\\*\"", "*");
        StringEvalTests.checkEval("\"\\+\"", "+");
        StringEvalTests.checkEval("\"\\?\"", "?");
        StringEvalTests.checkEval("\"\\^\"", "^");
        StringEvalTests.checkEval("\"\\$\"", "$");
        StringEvalTests.checkEval("\"\\/\"", "/");
        StringEvalTests.checkEval("\"\\\"\"", "\"");
        StringEvalTests.checkEval("\"\\~\"", "~");
        StringEvalTests.checkEval("\"\\!\"", "!");
        StringEvalTests.checkEval("\"\\-\"", "-");
    }

    public void testOtherEvals() {
        StringEvalTests.checkEval("\"\\a\"", "a");
        StringEvalTests.checkEval("\"\\q\"", "q");
    }

    public void testDoubleEvals() {
        StringEvalTests.checkEval("\"\\\\u1\"", "\\u1");
        StringEvalTests.checkEval("\"\\\\1\"", "\\1");
        StringEvalTests.checkEval("\"\\\\\n\"", "\\\n");
    }

    private static void checkEval(String original, String expected) {
        StringEvalTests.assertEquals((String)"Evaluating: ", (String)expected, (String)StringEval.evalString(original));
    }
}

