/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.MacroDecl;
import metalexer.ast.Regex;
import metalexer.jflex.PrintHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroInvocationRegex
extends Regex
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getDecl_visited = -1;
    protected int isAcyclic_visited = -1;
    protected int getStructureString_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getDecl_visited = -1;
        this.isAcyclic_visited = -1;
        this.getStructureString_visited = -1;
    }

    @Override
    public MacroInvocationRegex clone() throws CloneNotSupportedException {
        MacroInvocationRegex node = (MacroInvocationRegex)super.clone();
        node.getDecl_visited = -1;
        node.isAcyclic_visited = -1;
        node.getStructureString_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MacroInvocationRegex copy() {
        try {
            MacroInvocationRegex node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MacroInvocationRegex fullCopy() {
        MacroInvocationRegex res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MacroInvocationRegex other = (MacroInvocationRegex)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    @Override
    void printJFlexRegex(PrintHelper out) throws IOException {
        out.print("{" + this.getComponent().getJFlexMacroName(this.getName()) + "}");
    }

    public MacroInvocationRegex() {
    }

    public MacroInvocationRegex(String p0) {
        this.setName(p0);
    }

    public MacroInvocationRegex(Symbol p0) {
        this.setName(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public MacroDecl getDecl() {
        if (this.getDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDecl in class: ");
        }
        this.getDecl_visited = this.state().boundariesCrossed;
        MacroDecl getDecl_value = this.getDecl_compute();
        this.getDecl_visited = -1;
        return getDecl_value;
    }

    private MacroDecl getDecl_compute() {
        Set<MacroDecl> decls = this.lookupMacroDecls(this.getName());
        return decls.isEmpty() ? null : decls.iterator().next();
    }

    @Override
    public boolean isAcyclic() {
        if (this.isAcyclic_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isAcyclic in class: ");
        }
        this.isAcyclic_visited = this.state().boundariesCrossed;
        boolean isAcyclic_value = this.isAcyclic_compute();
        this.isAcyclic_visited = -1;
        return isAcyclic_value;
    }

    private boolean isAcyclic_compute() {
        return this.getDecl() == null ? true : this.getDecl().getRegex().isAcyclic();
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        return "{" + this.getName() + "}";
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component ref;
        if (!this.getComponent().getHelper() && this.getDecl() == null && (ref = this.getComponent()) != null) {
            ref.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_MacroDecl_getDirectDependencies() {
        MacroDecl ref;
        if (this.getDecl() != null && this.getContainingMacro() != null && (ref = this.getContainingMacro()) != null) {
            ref.MacroDecl_getDirectDependencies_contributors().add(this);
        }
        super.collect_contributors_MacroDecl_getDirectDependencies();
    }

    @Override
    protected void collect_contributors_Component_getPatternMacroRefs() {
        Component ref;
        if (this.getContainingMacro() == null && (ref = this.getComponent()) != null) {
            ref.Component_getPatternMacroRefs_contributors().add(this);
        }
        super.collect_contributors_Component_getPatternMacroRefs();
    }

    @Override
    protected void collect_contributors_Component_getMacroRefs() {
        Component ref = this.getComponent();
        if (ref != null) {
            ref.Component_getMacroRefs_contributors().add(this);
        }
        super.collect_contributors_Component_getMacroRefs();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Component_Component_getErrors(collection);
        if (!this.getComponent().getHelper() && this.getDecl() == null) {
            collection.add(this.makeCompilationError("Macro " + this.getName() + " is undeclared."));
        }
    }

    @Override
    protected void contributeTo_MacroDecl_MacroDecl_getDirectDependencies(Set<MacroDecl> collection) {
        super.contributeTo_MacroDecl_MacroDecl_getDirectDependencies(collection);
        if (this.getDecl() != null && this.getContainingMacro() != null) {
            collection.add(this.getDecl());
        }
    }

    @Override
    protected void contributeTo_Component_Component_getPatternMacroRefs(Set<MacroInvocationRegex> collection) {
        super.contributeTo_Component_Component_getPatternMacroRefs(collection);
        if (this.getContainingMacro() == null) {
            collection.add(this);
        }
    }

    @Override
    protected void contributeTo_Component_Component_getMacroRefs(Set<MacroInvocationRegex> collection) {
        super.contributeTo_Component_Component_getMacroRefs(collection);
        collection.add(this);
    }
}

