/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.StringEval;
import metalexer.ast.ASTNode;
import metalexer.ast.CharClassRange;
import metalexer.ast.Component;
import metalexer.jflex.PrintHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCharRange
extends CharClassRange
implements Cloneable {
    protected String tokenString_LowerChar;
    public int LowerCharstart;
    public int LowerCharend;
    protected String tokenString_UpperChar;
    public int UpperCharstart;
    public int UpperCharend;
    protected int getStructureString_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getStructureString_visited = -1;
    }

    @Override
    public MultiCharRange clone() throws CloneNotSupportedException {
        MultiCharRange node = (MultiCharRange)super.clone();
        node.getStructureString_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MultiCharRange copy() {
        try {
            MultiCharRange node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MultiCharRange fullCopy() {
        MultiCharRange res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    private boolean isReversed() {
        char upperCh;
        String lower = this.getLowerChar();
        String upper = this.getUpperChar();
        char lowerCh = lower.length() == 1 ? lower.charAt(0) : MultiCharRange.unescape(lower);
        char c = upperCh = lower.length() == 1 ? upper.charAt(0) : MultiCharRange.unescape(upper);
        return lowerCh > upperCh;
    }

    private static char unescape(String escape) {
        String evaluated = StringEval.evalString("\"" + escape + "\"");
        if (evaluated.length() > 1) {
            throw new RuntimeException("Invalid escape sequence: " + escape);
        }
        return evaluated.charAt(0);
    }

    @Override
    public void acquirePositionFromChildren() {
        this.start = this.LowerCharstart;
        this.end = this.UpperCharend;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getLowerChar() == null ? 0 : this.getLowerChar().hashCode());
        result = 31 * result + (this.getUpperChar() == null ? 0 : this.getUpperChar().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiCharRange other = (MultiCharRange)obj;
        if (this.getLowerChar() == null ? other.getLowerChar() != null : !this.getLowerChar().equals(other.getLowerChar())) {
            return false;
        }
        return !(this.getUpperChar() == null ? other.getUpperChar() != null : !this.getUpperChar().equals(other.getUpperChar()));
    }

    @Override
    void printJFlexRegex(PrintHelper out) throws IOException {
        out.print(String.valueOf(this.getLowerChar()) + "-" + this.getUpperChar());
    }

    public MultiCharRange() {
    }

    public MultiCharRange(String p0, String p1) {
        this.setLowerChar(p0);
        this.setUpperChar(p1);
    }

    public MultiCharRange(Symbol p0, Symbol p1) {
        this.setLowerChar(p0);
        this.setUpperChar(p1);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLowerChar(String value) {
        this.tokenString_LowerChar = value;
    }

    public void setLowerChar(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLowerChar is only valid for String lexemes");
        }
        this.tokenString_LowerChar = (String)symbol.value;
        this.LowerCharstart = symbol.getStart();
        this.LowerCharend = symbol.getEnd();
    }

    public String getLowerChar() {
        return this.tokenString_LowerChar != null ? this.tokenString_LowerChar : "";
    }

    public void setUpperChar(String value) {
        this.tokenString_UpperChar = value;
    }

    public void setUpperChar(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setUpperChar is only valid for String lexemes");
        }
        this.tokenString_UpperChar = (String)symbol.value;
        this.UpperCharstart = symbol.getStart();
        this.UpperCharend = symbol.getEnd();
    }

    public String getUpperChar() {
        return this.tokenString_UpperChar != null ? this.tokenString_UpperChar : "";
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        return String.valueOf(this.getLowerChar()) + "-" + this.getUpperChar();
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component ref;
        if (this.isReversed() && (ref = this.getComponent()) != null) {
            ref.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Component_Component_getErrors(collection);
        if (this.isReversed()) {
            collection.add(this.makeCompilationError("Reversed character range."));
        }
    }
}

