/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.PatternType;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Layout;
import metalexer.ast.Pattern;
import metalexer.jflex.PrintHelper;
import metalexer.jflex.ReturnWrap;
import metalexer.jflex.StaticFind;
import metalexer.jflex.SymbolAssigner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends ASTNode<ASTNode>
implements Cloneable {
    private int mtokSymbolValue;
    protected String tokenString_Action;
    public int Actionstart;
    public int Actionend;
    protected String tokenString_MetaToken;
    public int MetaTokenstart;
    public int MetaTokenend;
    protected int isMisclassified_visited = -1;
    protected int getStructureString_visited = -1;
    protected int getMetaJFlexMTokName_visited = -1;
    protected int getStaticKeywordPositions_visited = -1;
    protected int containsStaticKeyword_visited = -1;
    protected int listStaticKeywordPositions_visited = -1;
    protected int getComponent_visited = -1;
    protected int getGroupPatternType_visited = -1;
    protected int getLexThrowsDecl_visited = -1;
    protected int getTokenType_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isMisclassified_visited = -1;
        this.getStructureString_visited = -1;
        this.getMetaJFlexMTokName_visited = -1;
        this.getStaticKeywordPositions_visited = -1;
        this.containsStaticKeyword_visited = -1;
        this.listStaticKeywordPositions_visited = -1;
        this.getComponent_visited = -1;
        this.getGroupPatternType_visited = -1;
        this.getLexThrowsDecl_visited = -1;
        this.getTokenType_visited = -1;
    }

    @Override
    public Rule clone() throws CloneNotSupportedException {
        Rule node = (Rule)super.clone();
        node.isMisclassified_visited = -1;
        node.getStructureString_visited = -1;
        node.getMetaJFlexMTokName_visited = -1;
        node.getStaticKeywordPositions_visited = -1;
        node.containsStaticKeyword_visited = -1;
        node.listStaticKeywordPositions_visited = -1;
        node.getComponent_visited = -1;
        node.getGroupPatternType_visited = -1;
        node.getLexThrowsDecl_visited = -1;
        node.getTokenType_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public Rule copy() {
        try {
            Rule node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Rule fullCopy() {
        Rule res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public int printJFlexRule(PrintHelper out, int ruleNum) throws IOException {
        Component comp = this.getComponent();
        String stateObjectName = comp.getLayout().getJFlexStateObjectName();
        String instanceName = comp.getJFlexInnerClassInstanceName();
        String actionMethodName = comp.getJFlexActionMethodName(ruleNum);
        this.getPattern().printJFlexPattern(out);
        out.println(" {");
        out.indent();
        String metaToken = this.getMetaToken();
        if (metaToken != null && metaToken.length() > 0) {
            out.println("Maybe<? extends " + this.getTokenType() + "> maybeResult;");
            out.println("try {");
            out.indent();
            out.println("maybeResult = " + stateObjectName + "." + instanceName + "." + actionMethodName + "();");
            out.dedent();
            out.println("} finally {");
            out.indent();
            out.println(String.valueOf(comp.getLayout().getJFlexStateObjectName()) + ".processMTok(" + this.getMetaTokenSymbolValue() + "); //" + this.getMetaToken());
            out.dedent();
            out.println("}");
        } else {
            out.println("Maybe<? extends " + this.getTokenType() + "> maybeResult = " + stateObjectName + "." + instanceName + "." + actionMethodName + "();");
        }
        out.println("if(maybeResult.isJust()) {");
        out.indent();
        out.println("return maybeResult.fromJust();");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        return ruleNum + 1;
    }

    public int printJFlexActionMethod(PrintHelper out, int ruleNum) throws IOException {
        String actionMethodName = this.getComponent().getJFlexActionMethodName(ruleNum);
        out.println("public Maybe<? extends " + this.getTokenType() + "> " + actionMethodName + "()" + this.getLexThrowsDecl() + " {");
        out.indent();
        String objectName = this.getComponent().getLayout().getJFlexStateObjectName();
        String fieldName = this.getComponent().getJFlexInnerClassInstanceName();
        String methodName = this.getComponent().getJFlexActionMethodName(ruleNum);
        out.println("//System.err.println(\"" + objectName + "." + fieldName + "." + methodName + "()\");");
        String action = this.getAction();
        String actionCode = action.substring(2, action.length() - 2).trim();
        if (actionCode.length() > 0) {
            String wrappedActionCode = ReturnWrap.wrapReturns(actionCode);
            out.println("if(Object.class != null) {");
            out.indent();
            this.printJFlexPosComment(out, this.Actionstart);
            out.println(wrappedActionCode);
            out.dedent();
            out.println("}");
        }
        out.println("return Maybe.Nothing();");
        out.dedent();
        out.println("}");
        return ruleNum + 1;
    }

    public int getMetaTokenSymbolValue() {
        return this.mtokSymbolValue;
    }

    @Override
    public void assignSymbolsToMetaTokens(SymbolAssigner assigner) {
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0) {
            this.mtokSymbolValue = assigner.assignSymbol(this.getMetaJFlexMTokName());
        }
        super.assignSymbolsToMetaTokens(assigner);
    }

    public Rule() {
    }

    public Rule(Pattern p0, String p1, String p2) {
        this.setChild(p0, 0);
        this.setAction(p1);
        this.setMetaToken(p2);
    }

    public Rule(Pattern p0, Symbol p1, Symbol p2) {
        this.setChild(p0, 0);
        this.setAction(p1);
        this.setMetaToken(p2);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setPattern(Pattern node) {
        this.setChild(node, 0);
    }

    public Pattern getPattern() {
        return (Pattern)this.getChild(0);
    }

    public Pattern getPatternNoTransform() {
        return (Pattern)this.getChildNoTransform(0);
    }

    public void setAction(String value) {
        this.tokenString_Action = value;
    }

    public void setAction(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setAction is only valid for String lexemes");
        }
        this.tokenString_Action = (String)symbol.value;
        this.Actionstart = symbol.getStart();
        this.Actionend = symbol.getEnd();
    }

    public String getAction() {
        return this.tokenString_Action != null ? this.tokenString_Action : "";
    }

    public void setMetaToken(String value) {
        this.tokenString_MetaToken = value;
    }

    public void setMetaToken(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setMetaToken is only valid for String lexemes");
        }
        this.tokenString_MetaToken = (String)symbol.value;
        this.MetaTokenstart = symbol.getStart();
        this.MetaTokenend = symbol.getEnd();
    }

    public String getMetaToken() {
        return this.tokenString_MetaToken != null ? this.tokenString_MetaToken : "";
    }

    public boolean isMisclassified() {
        if (this.isMisclassified_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isMisclassified in class: ");
        }
        this.isMisclassified_visited = this.state().boundariesCrossed;
        boolean isMisclassified_value = this.isMisclassified_compute();
        this.isMisclassified_visited = -1;
        return isMisclassified_value;
    }

    private boolean isMisclassified_compute() {
        return this.getPattern().getType() != this.getGroupPatternType();
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        return String.valueOf(this.getPattern().getStructureString()) + " " + this.getAction() + " " + this.getMetaToken();
    }

    public String getMetaJFlexMTokName() {
        if (this.getMetaJFlexMTokName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexMTokName in class: ");
        }
        this.getMetaJFlexMTokName_visited = this.state().boundariesCrossed;
        String getMetaJFlexMTokName_value = this.getMetaJFlexMTokName_compute();
        this.getMetaJFlexMTokName_visited = -1;
        return getMetaJFlexMTokName_value;
    }

    private String getMetaJFlexMTokName_compute() {
        return "t_" + this.getMetaToken();
    }

    public List<StaticFind.Position> getStaticKeywordPositions() {
        if (this.getStaticKeywordPositions_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStaticKeywordPositions in class: ");
        }
        this.getStaticKeywordPositions_visited = this.state().boundariesCrossed;
        List<StaticFind.Position> getStaticKeywordPositions_value = this.getStaticKeywordPositions_compute();
        this.getStaticKeywordPositions_visited = -1;
        return getStaticKeywordPositions_value;
    }

    private List<StaticFind.Position> getStaticKeywordPositions_compute() {
        int basePos = this.Actionstart;
        int baseLine = Rule.getLine(basePos);
        int baseCol = Rule.getColumn(basePos);
        return StaticFind.findStaticKeywords(baseLine, baseCol, this.getAction());
    }

    public boolean containsStaticKeyword() {
        if (this.containsStaticKeyword_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: containsStaticKeyword in class: ");
        }
        this.containsStaticKeyword_visited = this.state().boundariesCrossed;
        boolean containsStaticKeyword_value = this.containsStaticKeyword_compute();
        this.containsStaticKeyword_visited = -1;
        return containsStaticKeyword_value;
    }

    private boolean containsStaticKeyword_compute() {
        return !this.getStaticKeywordPositions().isEmpty();
    }

    public String listStaticKeywordPositions() {
        if (this.listStaticKeywordPositions_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listStaticKeywordPositions in class: ");
        }
        this.listStaticKeywordPositions_visited = this.state().boundariesCrossed;
        String listStaticKeywordPositions_value = this.listStaticKeywordPositions_compute();
        this.listStaticKeywordPositions_visited = -1;
        return listStaticKeywordPositions_value;
    }

    private String listStaticKeywordPositions_compute() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (StaticFind.Position pos : this.getStaticKeywordPositions()) {
            if (!first) {
                buf.append(", ");
            }
            first = false;
            buf.append("[" + pos.getLine() + ", " + pos.getColumn() + "]");
        }
        return buf.toString();
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component getComponent_value = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return getComponent_value;
    }

    public PatternType getGroupPatternType() {
        if (this.getGroupPatternType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getGroupPatternType in class: ");
        }
        this.getGroupPatternType_visited = this.state().boundariesCrossed;
        PatternType getGroupPatternType_value = this.getParent().Define_metalexer_PatternType_getGroupPatternType(this, null);
        this.getGroupPatternType_visited = -1;
        return getGroupPatternType_value;
    }

    public String getLexThrowsDecl() {
        if (this.getLexThrowsDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLexThrowsDecl in class: ");
        }
        this.getLexThrowsDecl_visited = this.state().boundariesCrossed;
        String getLexThrowsDecl_value = this.getParent().Define_String_getLexThrowsDecl(this, null);
        this.getLexThrowsDecl_visited = -1;
        return getLexThrowsDecl_value;
    }

    public String getTokenType() {
        if (this.getTokenType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getTokenType in class: ");
        }
        this.getTokenType_visited = this.state().boundariesCrossed;
        String getTokenType_value = this.getParent().Define_String_getTokenType(this, null);
        this.getTokenType_visited = -1;
        return getTokenType_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component ref;
        if (this.isMisclassified() && (ref = this.getComponent()) != null) {
            ref.Component_getErrors_contributors().add(this);
        }
        if (this.containsStaticKeyword() && (ref = this.getComponent()) != null) {
            ref.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_Component_listMetaTokens() {
        Component ref;
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0 && (ref = this.getComponent()) != null) {
            ref.Component_listMetaTokens_contributors().add(this);
        }
        super.collect_contributors_Component_listMetaTokens();
    }

    @Override
    protected void collect_contributors_Component_listRules() {
        Component ref = this.getComponent();
        if (ref != null) {
            ref.Component_listRules_contributors().add(this);
        }
        super.collect_contributors_Component_listRules();
    }

    @Override
    protected void collect_contributors_Layout_getSymbolsMap() {
        Layout ref;
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0 && (ref = this.getComponent().getLayout()) != null) {
            ref.Layout_getSymbolsMap_contributors().add(this);
        }
        super.collect_contributors_Layout_getSymbolsMap();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Component_Component_getErrors(collection);
        if (this.isMisclassified()) {
            collection.add(this.makeCompilationError("Rule misclassified: " + (Object)((Object)this.getPattern().getType()) + " rule in " + (Object)((Object)this.getGroupPatternType()) + " section."));
        }
        if (this.containsStaticKeyword()) {
            collection.add(this.makeCompilationError("(JFlex) Component code regions cannot contain the keyword 'static': " + this.listStaticKeywordPositions()));
        }
    }

    @Override
    protected void contributeTo_Component_Component_listMetaTokens(Set<String> collection) {
        super.contributeTo_Component_Component_listMetaTokens(collection);
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0) {
            collection.add(this.getMetaToken());
        }
    }

    @Override
    protected void contributeTo_Component_Component_listRules(List<Rule> collection) {
        super.contributeTo_Component_Component_listRules(collection);
        collection.add(this);
    }

    @Override
    protected void contributeTo_Layout_Layout_getSymbolsMap(Map<Integer, String> collection) {
        super.contributeTo_Layout_Layout_getSymbolsMap(collection);
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0) {
            collection.putAll((Map<Integer, String>)new HashMap<Integer, String>(){
                {
                    this.put(Rule.this.mtokSymbolValue, Rule.this.getMetaToken());
                }
            });
        }
    }
}

