/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateRef
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getDecl_visited = -1;
    protected int getComponent_visited = -1;
    protected Map lookupStateDecls_String_visited;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getDecl_visited = -1;
        this.getComponent_visited = -1;
        this.lookupStateDecls_String_visited = new HashMap(4);
    }

    @Override
    public StateRef clone() throws CloneNotSupportedException {
        StateRef node = (StateRef)super.clone();
        node.getDecl_visited = -1;
        node.getComponent_visited = -1;
        node.lookupStateDecls_String_visited = new HashMap(4);
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public StateRef copy() {
        try {
            StateRef node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public StateRef fullCopy() {
        StateRef res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public StateRef() {
    }

    public StateRef(String p0) {
        this.setName(p0);
    }

    public StateRef(Symbol p0) {
        this.setName(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public State getDecl() {
        if (this.getDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDecl in class: ");
        }
        this.getDecl_visited = this.state().boundariesCrossed;
        State getDecl_value = this.getDecl_compute();
        this.getDecl_visited = -1;
        return getDecl_value;
    }

    private State getDecl_compute() {
        Set<State> decls = this.lookupStateDecls(this.getName());
        return decls.isEmpty() ? null : decls.iterator().next();
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component getComponent_value = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return getComponent_value;
    }

    public Set<State> lookupStateDecls(String stateName) {
        String _parameters = stateName;
        if (this.lookupStateDecls_String_visited == null) {
            this.lookupStateDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupStateDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupStateDecls in class: ");
        }
        this.lookupStateDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<State> lookupStateDecls_String_value = this.getParent().Define_java_util_Set_State__lookupStateDecls(this, null, stateName);
        this.lookupStateDecls_String_visited.remove(_parameters);
        return lookupStateDecls_String_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component ref;
        if (!this.getComponent().getHelper() && this.getDecl() == null && (ref = this.getComponent()) != null) {
            ref.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_Component_getStateRefs() {
        Component ref = this.getComponent();
        if (ref != null) {
            ref.Component_getStateRefs_contributors().add(this);
        }
        super.collect_contributors_Component_getStateRefs();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Component_Component_getErrors(collection);
        if (!this.getComponent().getHelper() && this.getDecl() == null) {
            collection.add(this.makeCompilationError("State " + this.getName() + " is undeclared."));
        }
    }

    @Override
    protected void contributeTo_Component_Component_getStateRefs(Set<StateRef> collection) {
        super.contributeTo_Component_Component_getStateRefs(collection);
        collection.add(this);
    }
}

