/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class MetaScannerPropHelper
extends TestCase {
    private static final String RESTORE_EMBEDDING_NAME = "<<RESTORE>>";
    private final String layoutName;
    private final String baseDir;
    private final String outDir;
    private Properties macroProp;
    private Properties embeddingProp;
    private Map<Integer, String> embeddingMap;

    protected MetaScannerPropHelper(String groupName, String layoutName) {
        this.layoutName = layoutName;
        this.baseDir = "test/backend-jflex";
        this.outDir = String.valueOf(this.baseDir) + "/out/" + groupName + "/" + layoutName;
    }

    private static Properties loadPropFile(String outDir, String filename, String failMsg) {
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(String.valueOf(outDir) + "/" + filename));
            return prop;
        }
        catch (IOException e) {
            throw new RuntimeException(failMsg, e);
        }
    }

    private Properties getMacroProp() {
        if (this.macroProp == null) {
            this.macroProp = MetaScannerPropHelper.loadPropFile(this.outDir, String.valueOf(this.layoutName) + ".macro.properties", "Failed to load macro properties");
        }
        return this.macroProp;
    }

    private Properties getEmbeddingProp() {
        if (this.embeddingProp == null) {
            this.embeddingProp = MetaScannerPropHelper.loadPropFile(this.outDir, String.valueOf(this.layoutName) + ".embedding.properties", "Failed to load embedding properties");
            this.embeddingMap = new HashMap<Integer, String>();
            for (Map.Entry<Object, Object> entry : this.embeddingProp.entrySet()) {
                this.embeddingMap.put(Integer.parseInt((String)entry.getValue()), (String)entry.getKey());
            }
        }
        return this.embeddingProp;
    }

    public int getMacroValue(String name) {
        return Integer.parseInt((String)this.getMacroProp().get(name));
    }

    public int getEmbeddingValue(String name) {
        return RESTORE_EMBEDDING_NAME.equals(name) ? -1 : Integer.parseInt((String)this.getEmbeddingProp().get(name));
    }

    public String getEmbeddingName(int val) {
        return val < 0 ? RESTORE_EMBEDDING_NAME : this.embeddingMap.get(val);
    }
}

