/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import metalexer.jflex.MetaScannerPropHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaScannerTestBase
extends TestCase {
    private static final String BASE_DIR = "test/backend-jflex";
    private final MetaScannerPropHelper propHelper;

    protected MetaScannerTestBase(String groupName, String layoutName) {
        this.propHelper = new MetaScannerPropHelper(groupName, layoutName);
    }

    protected void checkOutput(String baseName) throws IOException, InterruptedException {
        String inFileName = "test/backend-jflex/" + baseName + ".in";
        String outFileName = "test/backend-jflex/" + baseName + ".out";
        ArrayList<Integer> input = new ArrayList<Integer>();
        BufferedReader inReader = new BufferedReader(new FileReader(inFileName));
        while (inReader.ready()) {
            String line = inReader.readLine();
            input.add(this.propHelper.getMacroValue(line));
        }
        inReader.close();
        ArrayList expectedOutput = new ArrayList();
        BufferedReader outReader = new BufferedReader(new FileReader(outFileName));
        while (outReader.ready()) {
            ArrayList<Integer> lineOutput = new ArrayList<Integer>();
            String line = outReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreTokens()) {
                lineOutput.add(this.propHelper.getEmbeddingValue(tokenizer.nextToken()));
            }
            expectedOutput.add(lineOutput);
        }
        outReader.close();
        if (input.size() != expectedOutput.size()) {
            throw new RuntimeException("Incorrect test specification: " + expectedOutput.size() + " outputs for " + input.size() + " inputs");
        }
        List<List<Integer>> actualOutput = this.getActualOutput(input);
        int i = 0;
        while (i < input.size()) {
            MetaScannerTestBase.assertEquals((String)("Incorrect output on input #" + i), expectedOutput.get(i), actualOutput.get(i));
            ++i;
        }
    }

    protected abstract List<List<Integer>> getActualOutput(List<Integer> var1);
}

