/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.PrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintHelper {
    private final PrintWriter out;
    private final String singleIndentString;
    private int indentLevel;
    private boolean requireIndent;
    private String indentString;

    public PrintHelper(PrintWriter out, int indentSize) {
        this.out = out;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < indentSize) {
            buf.append(' ');
            ++i;
        }
        this.singleIndentString = buf.toString();
        this.indentLevel = 0;
        this.requireIndent = true;
        this.updateIndentString();
    }

    public <T> void print(T msg) {
        this.maybePrintIndent();
        this.out.print(msg);
    }

    public <T> void println(T msg) {
        this.maybePrintIndent();
        this.out.println(msg);
        this.requireIndent = true;
    }

    public void println() {
        this.maybePrintIndent();
        this.out.println();
        this.requireIndent = true;
    }

    public void close() {
        this.out.close();
    }

    public void indent() {
        ++this.indentLevel;
        this.updateIndentString();
    }

    public void dedent() {
        --this.indentLevel;
        this.updateIndentString();
    }

    private void updateIndentString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.indentLevel) {
            buf.append(this.singleIndentString);
            ++i;
        }
        this.indentString = buf.toString();
    }

    private void maybePrintIndent() {
        if (this.requireIndent) {
            this.out.print(this.indentString);
            this.requireIndent = false;
        }
    }
}

