/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import beaver.Scanner;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import test.jflex.natlab.CommentBuffer;

public class ReflectionHelper {
    public static Scanner instantiateScanner(String className, Reader reader) {
        try {
            Class<?> scannerClass = Class.forName(className);
            Constructor<?> scannerConstructor = scannerClass.getConstructor(Reader.class);
            return (Scanner)scannerConstructor.newInstance(reader);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate scanner " + className, e);
        }
    }

    public static Scanner instantiateScanner(String className, Reader reader, CommentBuffer commentBuffer) {
        try {
            Class<?> scannerClass = Class.forName(className);
            Constructor<?> scannerConstructor = scannerClass.getConstructor(Reader.class);
            Method commentBufferMethod = scannerClass.getMethod("setCommentBuffer", CommentBuffer.class);
            Scanner scannerInstance = (Scanner)scannerConstructor.newInstance(reader);
            commentBufferMethod.invoke((Object)scannerInstance, commentBuffer);
            return scannerInstance;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate scanner " + className, e);
        }
    }

    public static class MetaLexerWrapper {
        private final Object mlInstance;
        private final Method processMethod;
        private final Class<?> mlTransitionClass;
        private final Method embeddingNumMethod;

        public MetaLexerWrapper(String className) {
            try {
                Class<?> mlClass = Class.forName(className);
                this.mlInstance = mlClass.newInstance();
                this.processMethod = mlClass.getMethod("processSymbol", Integer.TYPE);
                this.mlTransitionClass = Class.forName(String.valueOf(className) + "$Transition");
                this.embeddingNumMethod = this.mlTransitionClass.getMethod("getEmbeddingNum", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate meta-lexer " + className, e);
            }
        }

        public Integer processSymbol(int sym) {
            try {
                Object transition = this.processMethod.invoke(this.mlInstance, sym);
                return transition == null ? null : (Integer)this.embeddingNumMethod.invoke(transition, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke processSymbol()", e);
            }
        }
    }
}

