/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import junit.framework.TestCase;
import metalexer.jflex.ReturnWrap;

public class ReturnWrapTests
extends TestCase {
    public void testSingleLineComments() {
        ReturnWrapTests.checkWrap("//return x;", "//return x;");
        ReturnWrapTests.checkWrap("return x;\n//return y;", "return Maybe.Just(x);\n//return y;");
        ReturnWrapTests.checkWrap("//return x;\nreturn y;", "//return x;\nreturn Maybe.Just(y);");
        ReturnWrapTests.checkWrap("return x;\n//return y;\nreturn z;", "return Maybe.Just(x);\n//return y;\nreturn Maybe.Just(z);");
    }

    public void testMultiLineComments() {
        ReturnWrapTests.checkWrap("/*return x;*/", "/*return x;*/");
        ReturnWrapTests.checkWrap("return x;\n/*return y;*/", "return Maybe.Just(x);\n/*return y;*/");
        ReturnWrapTests.checkWrap("/*return x;*/\nreturn y;", "/*return x;*/\nreturn Maybe.Just(y);");
        ReturnWrapTests.checkWrap("return x;\n/*return y;*/\nreturn z;", "return Maybe.Just(x);\n/*return y;*/\nreturn Maybe.Just(z);");
    }

    public void testNestedComments() {
        ReturnWrapTests.checkWrap("/*return x; /*return y;*/*/", "/*return x; /*return y;*/*/");
        ReturnWrapTests.checkWrap("/*/*return x;*/ return y;*/", "/*/*return x;*/ return y;*/");
        ReturnWrapTests.checkWrap("/*/*return x;*/*/ return y;", "/*/*return x;*/*/ return Maybe.Just(y);");
    }

    public void testStrings() {
        ReturnWrapTests.checkWrap("\"return x;\"", "\"return x;\"");
        ReturnWrapTests.checkWrap("return x;\n\"return y;\"", "return Maybe.Just(x);\n\"return y;\"");
        ReturnWrapTests.checkWrap("\"return x;\"\nreturn y;", "\"return x;\"\nreturn Maybe.Just(y);");
        ReturnWrapTests.checkWrap("return x;\n\"return y;\"\nreturn z;", "return Maybe.Just(x);\n\"return y;\"\nreturn Maybe.Just(z);");
    }

    public void testStringsWithEscapes() {
        ReturnWrapTests.checkWrap("\"return \\\"x\\\";\"", "\"return \\\"x\\\";\"");
    }

    public void testVoidReturn() {
        ReturnWrapTests.checkWrap("return;", "return;");
    }

    public void testValueReturn() {
        ReturnWrapTests.checkWrap("return\t1\n+\n\t\t\t2\n;", "return\tMaybe.Just(1\n+\n\t\t\t2\n);");
    }

    public void testValueReturns() {
        ReturnWrapTests.checkWrap("return x; return y; return z;", "return Maybe.Just(x); return Maybe.Just(y); return Maybe.Just(z);");
    }

    public void testMalformed() {
        ReturnWrapTests.checkWrap("return x", "return Maybe.Just(x)");
        ReturnWrapTests.checkWrap("return", "return");
        ReturnWrapTests.checkWrap("return ", "return Maybe.Just()");
        ReturnWrapTests.checkWrap("/*return", "/*return");
        ReturnWrapTests.checkWrap("/*/*return*/", "/*/*return*/");
        ReturnWrapTests.checkWrap("/*/*return", "/*/*return");
        ReturnWrapTests.checkWrap("//return x", "//return x");
        ReturnWrapTests.checkWrap("/return x", "/return Maybe.Just(x)");
        ReturnWrapTests.checkWrap("asdjf;ilai return x; ahdfkd; fas", "asdjf;ilai return Maybe.Just(x); ahdfkd; fas");
        ReturnWrapTests.checkWrap("\"return x\\\";\"", "\"return x\\\";\"");
        ReturnWrapTests.checkWrap("\"return x", "\"return x");
    }

    public void testIdentifier() {
        ReturnWrapTests.checkWrap("return1 (x);", "return1 (x);");
    }

    public void testCommentInReturn() {
        ReturnWrapTests.checkWrap("return x//\n;", "return Maybe.Just(x//\n);");
        ReturnWrapTests.checkWrap("return /* */ x\n;", "return Maybe.Just(/* */ x\n);");
        ReturnWrapTests.checkWrap("return x//;\n;", "return Maybe.Just(x//;\n);");
        ReturnWrapTests.checkWrap("return x/*;*/\n;", "return Maybe.Just(x/*;*/\n);");
        ReturnWrapTests.checkWrap("return//\n x\n;", "return Maybe.Just(//\n x\n);");
        ReturnWrapTests.checkWrap("return/* */ x\n;", "return Maybe.Just(/* */ x\n);");
    }

    private static void checkWrap(String original, String expected) {
        ReturnWrapTests.assertEquals((String)"Wrapping: ", (String)expected, (String)ReturnWrap.wrapReturns(original));
    }
}

