/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.PrintWriter;
import metalexer.AbstractTestGenerator;

public abstract class ScannerTestGenerator
extends AbstractTestGenerator {
    protected final String prefix;
    protected final String baseDir;

    protected ScannerTestGenerator(String prefix, String baseDir) {
        super("/metalexer/jflex/" + prefix + "ScannerTests.java");
        this.prefix = prefix;
        this.baseDir = baseDir;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer.jflex;");
        testFileWriter.println();
        testFileWriter.println("import java.util.ArrayList;");
        testFileWriter.println("import java.util.List;");
        testFileWriter.println();
        testFileWriter.println("import beaver.Scanner;");
        testFileWriter.println("import beaver.Symbol;");
        testFileWriter.println();
        testFileWriter.println("public class " + this.prefix + "ScannerTests extends " + this.prefix + "ScannerTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String inFileName = String.valueOf(this.baseDir) + "/" + testName + ".in";
        String outFileName = String.valueOf(this.baseDir) + "/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("\tpublic void " + methodName + "() throws Exception {");
        testFileWriter.println("\t\tScanner scanner = getScanner(\"" + inFileName + "\");");
        testFileWriter.println("\t\tList<Symbol> symbols = new ArrayList<Symbol>();");
        testFileWriter.println("\t\tScanner.Exception exception = parseSymbols(\"" + outFileName + "\", symbols);");
        testFileWriter.println("\t\tcheckScan(scanner, symbols, exception);");
        testFileWriter.println("\t}");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}

