/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import junit.framework.TestCase;
import metalexer.jflex.StringEscape;

public class StringEscapeTests
extends TestCase {
    public void testUEscapes() {
        StringEscapeTests.checkEscape("\\u1", "\\u0001");
        StringEscapeTests.checkEscape("\\u10", "\\u0010");
        StringEscapeTests.checkEscape("\\u100", "\\u0100");
        StringEscapeTests.checkEscape("\\u1000", "\\u1000");
    }

    public void testXEscapes() {
        StringEscapeTests.checkEscape("\\x01", "\\x01");
    }

    public void testOctalEscapes() {
        StringEscapeTests.checkEscape("\\1", "\\001");
        StringEscapeTests.checkEscape("\\10", "\\010");
        StringEscapeTests.checkEscape("\\100", "\\100");
    }

    public void testLineEndingEscapes() {
        StringEscapeTests.checkEscape("\n", "\\n");
        StringEscapeTests.checkEscape("\r", "\\r");
        StringEscapeTests.checkEscape("\\\n", "\\n");
        StringEscapeTests.checkEscape("\\\r", "\\r");
    }

    public void testTraditionalEscapes() {
        StringEscapeTests.checkEscape("\\n", "\\n");
        StringEscapeTests.checkEscape("\\r", "\\r");
        StringEscapeTests.checkEscape("\\t", "\\t");
        StringEscapeTests.checkEscape("\\f", "\\f");
        StringEscapeTests.checkEscape("\\b", "\\b");
    }

    public void testMetaEscapes() {
        StringEscapeTests.checkEscape("\\\\", "\\\\");
        StringEscapeTests.checkEscape("\\|", "\\|");
        StringEscapeTests.checkEscape("\\(", "\\(");
        StringEscapeTests.checkEscape("\\)", "\\)");
        StringEscapeTests.checkEscape("\\{", "\\{");
        StringEscapeTests.checkEscape("\\}", "\\}");
        StringEscapeTests.checkEscape("\\[", "\\[");
        StringEscapeTests.checkEscape("\\]", "\\]");
        StringEscapeTests.checkEscape("\\<", "\\<");
        StringEscapeTests.checkEscape("\\>", "\\>");
        StringEscapeTests.checkEscape("\\.", "\\.");
        StringEscapeTests.checkEscape("\\*", "\\*");
        StringEscapeTests.checkEscape("\\+", "\\+");
        StringEscapeTests.checkEscape("\\?", "\\?");
        StringEscapeTests.checkEscape("\\^", "\\^");
        StringEscapeTests.checkEscape("\\$", "\\$");
        StringEscapeTests.checkEscape("\\/", "\\/");
        StringEscapeTests.checkEscape("\\\"", "\\\"");
        StringEscapeTests.checkEscape("\\~", "\\~");
        StringEscapeTests.checkEscape("\\!", "\\!");
        StringEscapeTests.checkEscape("\\-", "\\-");
    }

    public void testOtherEscapes() {
        StringEscapeTests.checkEscape("\\a", "\\a");
        StringEscapeTests.checkEscape("\\q", "\\q");
    }

    public void testDoubleEscapes() {
        StringEscapeTests.checkEscape("\\\\u1", "\\\\u1");
        StringEscapeTests.checkEscape("\\\\1", "\\\\1");
        StringEscapeTests.checkEscape("\\\\\n", "\\\\\\n");
    }

    private static void checkEscape(String original, String expected) {
        StringEscapeTests.assertEquals((String)"Escaping: ", (String)expected, (String)StringEscape.escapeString(original));
    }
}

