/*
 * Decompiled with CFR 0.152.
 */
package metalexer.metalexer;

public class EscapeHelper {
    private EscapeHelper() {
    }

    public static String escapeDeclRegion(String original) {
        return EscapeHelper.escapeAllButTerminal(original, "%}", "%%}");
    }

    public static String escapeInitRegion(String original) {
        return EscapeHelper.escapeAllButTerminal(original, "%init}", "%%init}");
    }

    public static String escapeAppendRegion(String original) {
        return EscapeHelper.escapeAllButTerminal(original, "%append}", "%%append}");
    }

    public static String escapeAction(String original) {
        return EscapeHelper.escapeAllButTerminal(original, ":}", "%:}");
    }

    public static String escapeString(String original) {
        return original.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
    }

    private static String escapeAllButTerminal(String original, String from, String to) {
        if (original.endsWith(from)) {
            String tmp = original.substring(0, original.length() - from.length());
            return String.valueOf(tmp.replaceAll(from, to)) + from;
        }
        return original.replaceAll(from, to);
    }
}

