/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Scanner;
import beaver.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;

public final class LayoutScanner
extends Scanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int INSIDE_INHERITED_HEADER_SECTION = 2;
    public static final int INSIDE_BRACKET_COMMENT = 5;
    public static final int INSIDE_STRING_IDENTIFIER_DIRECTIVE = 9;
    public static final int INSIDE_PAIR_DIRECTIVE = 11;
    public static final int INSIDE_DECL_REGION = 7;
    public static final int INSIDE_STRING = 6;
    public static final int INSIDE_OPTION_SECTION = 3;
    public static final int INSIDE_LOCAL_HEADER_SECTION = 1;
    public static final int YYINITIAL = 0;
    public static final int INSIDE_META_PATTERN_DIRECTIVE = 10;
    public static final int INSIDE_INIT_REGION = 8;
    public static final int INSIDE_RULE_SECTION = 4;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u0012\u0001\t\u0001\u0000\u0001\u0012\u0001\b\u0002\u0000\u00011\u00012\u0001\u0014\u00016\u0001(\u0001\u0000\u0001\u0007\u0001\u0013\u0004\u0010\u0004\u0011\u0002\u0005\u0002\u0000\u0001)\u0001\u0000\u0001-\u00017\u0001\u0000\u0001*\u0001.\u0003\n\u00010\u0007\u0004\u0001+\u0001/\t\u0004\u0001,\u0001\u0004\u00013\u0001\u000b\u00014\u00015\u0001\u0006\u0001\u0000\u0001\u001e\u0001&\u0001\"\u0001$\u0001\u001b\u0001\r\u0001'\u0001\u001a\u0001\u0017\u0002\u0004\u0001\u001c\u0001#\u0001\u0018\u0001 \u0001\u001d\u0001\u0004\u0001\f\u0001!\u0001\u0019\u0001\u000f\u0001\u0004\u0001%\u0001\u000e\u0001\u001f\u0001\u0004\u0001\u0015\u00018\u0001\u0016\u0001\u0012\uff81\u0000";
    private static final char[] ZZ_CMAP = LayoutScanner.zzUnpackCMap("\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u0012\u0001\t\u0001\u0000\u0001\u0012\u0001\b\u0002\u0000\u00011\u00012\u0001\u0014\u00016\u0001(\u0001\u0000\u0001\u0007\u0001\u0013\u0004\u0010\u0004\u0011\u0002\u0005\u0002\u0000\u0001)\u0001\u0000\u0001-\u00017\u0001\u0000\u0001*\u0001.\u0003\n\u00010\u0007\u0004\u0001+\u0001/\t\u0004\u0001,\u0001\u0004\u00013\u0001\u000b\u00014\u00015\u0001\u0006\u0001\u0000\u0001\u001e\u0001&\u0001\"\u0001$\u0001\u001b\u0001\r\u0001'\u0001\u001a\u0001\u0017\u0002\u0004\u0001\u001c\u0001#\u0001\u0018\u0001 \u0001\u001d\u0001\u0004\u0001\f\u0001!\u0001\u0019\u0001\u000f\u0001\u0004\u0001%\u0001\u000e\u0001\u001f\u0001\u0004\u0001\u0015\u00018\u0001\u0016\u0001\u0012\uff81\u0000");
    private static final int[] ZZ_ACTION = LayoutScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\f\u0000\u0001\u0001\u0003\u0002\u0001\u0003\u0002\u0004\u0001\u0005\u0001\u0003\u0003\u0006\u0003\u0007\u0002\b\u0001\t\u0001\n\u0002\u0002\u0001\u000b\u0002\f\u0001\r\u0001\u000e\u0001\u000b\u0001\u000f\u0001\u0010\u0001\u0011\u0002\u0010\u0001\u0012\u0001\u0010\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0003\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0007\u0000\u0001 \u0001!\t\u0000\u0001\"\u0001#\u0003$\u0002\u0002\u0001\u0000\u0001%\u0019\u0000\u0001\u0002\u0002\u0000\u0001&\u0001\u0000\u0001'\u0011\u0000\u0001(\u0003\u0000\u0001\u0002\u0011\u0000\u0001)\u0001*\u0001(\u0001\u0000\u0001+\u0002\u0000\u0001\u0002\u0002\u0000\u0001,\u0001-\u0001.\u0005\u0000\u0001/\u0007\u0000\u0001)\u0001\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u00010\u00011\u00012\u0001\u0000\u00013\u0001\u0000\u00014\u00015\u0001/\u0004\u0000\u00016\u0003\u0000\u00010\u0001\u0000\u00011\u0002\u0000\u00013\u0002\u0000\u00014\u0001\u0000\u00015\u0002\u0000\u00017\u0001\u0000\u00016\u0001\u0000\u00018\u00019\u0002\u0000\u0001:\u0001\u0000\u00017\u0001\u0000\u0001;\u00018\u0001\u0000\u00019\u0001\u0000\u0001<\u0001=\u0001:\u0001\u0000\u0001>\u0001;\u0001\u0000\u0001<\u0001\u0000\u0001=\u0001\u0000\u0001>\u0001\u0000";
    private static final int[] ZZ_ROWMAP = LayoutScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00009\u0000r\u0000\u00ab\u0000\u00e4\u0000\u011d\u0000\u0156\u0000\u018f\u0000\u01c8\u0000\u0201\u0000\u023a\u0000\u0273\u0000\u02ac\u0000\u02ac\u0000\u02e5\u0000\u031e\u0000\u02ac\u0000\u0357\u0000\u02ac\u0000\u0390\u0000\u03c9\u0000\u02ac\u0000\u0402\u0000\u03c9\u0000\u02ac\u0000\u043b\u0000\u0474\u0000\u04ad\u0000\u02ac\u0000\u02ac\u0000\u04e6\u0000\u051f\u0000\u0558\u0000\u02ac\u0000\u0591\u0000\u02ac\u0000\u05ca\u0000\u02ac\u0000\u03c9\u0000\u02ac\u0000\u02ac\u0000\u0603\u0000\u063c\u0000\u03c9\u0000\u02ac\u0000\u0675\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u063c\u0000\u03c9\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u06ae\u0000\u06e7\u0000\u0720\u0000\u0759\u0000\u0792\u0000\u07cb\u0000\u0804\u0000\u083d\u0000\u02ac\u0000\u0876\u0000\u08af\u0000\u08e8\u0000\u0921\u0000\u095a\u0000\u0993\u0000\u09cc\u0000\u0a05\u0000\u0a3e\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u0a77\u0000\u0ab0\u0000\u0ae9\u0000\u0b22\u0000\u0b5b\u0000\u02ac\u0000\u0b94\u0000\u0bcd\u0000\u0c06\u0000\u0c3f\u0000\u0c78\u0000\u0cb1\u0000\u0cea\u0000\u0d23\u0000\u0d5c\u0000\u0d95\u0000\u0dce\u0000\u0e07\u0000\u0e40\u0000\u0e79\u0000\u0eb2\u0000\u0eeb\u0000\u0f24\u0000\u0f5d\u0000\u0f96\u0000\u0fcf\u0000\u1008\u0000\u1041\u0000\u107a\u0000\u10b3\u0000\u10ec\u0000\u1125\u0000\u115e\u0000\u1197\u0000\u11d0\u0000\u063c\u0000\u02ac\u0000\u1209\u0000\u1242\u0000\u127b\u0000\u12b4\u0000\u12ed\u0000\u1326\u0000\u135f\u0000\u1398\u0000\u13d1\u0000\u140a\u0000\u1443\u0000\u147c\u0000\u14b5\u0000\u14ee\u0000\u1527\u0000\u1560\u0000\u1599\u0000\u15d2\u0000\u160b\u0000\u1644\u0000\u167d\u0000\u16b6\u0000\u16ef\u0000\u1728\u0000\u1761\u0000\u179a\u0000\u17d3\u0000\u180c\u0000\u1845\u0000\u187e\u0000\u18b7\u0000\u18f0\u0000\u1929\u0000\u1962\u0000\u199b\u0000\u19d4\u0000\u1a0d\u0000\u1a46\u0000\u1a7f\u0000\u1ab8\u0000\u1af1\u0000\u1b2a\u0000\u1b2a\u0000\u1b63\u0000\u1b9c\u0000\u1bd5\u0000\u10ec\u0000\u1c0e\u0000\u1c47\u0000\u02ac\u0000\u02ac\u0000\u02ac\u0000\u1c80\u0000\u1cb9\u0000\u1cf2\u0000\u1d2b\u0000\u1d64\u0000\u1d9d\u0000\u1dd6\u0000\u1e0f\u0000\u1e48\u0000\u1e81\u0000\u1eba\u0000\u1ef3\u0000\u1f2c\u0000\u1f65\u0000\u1f65\u0000\u1f9e\u0000\u1f9e\u0000\u1fd7\u0000\u1fd7\u0000\u2010\u0000\u2049\u0000\u02ac\u0000\u2082\u0000\u20bb\u0000\u20f4\u0000\u212d\u0000\u2166\u0000\u219f\u0000\u219f\u0000\u21d8\u0000\u2211\u0000\u224a\u0000\u2283\u0000\u22bc\u0000\u22f5\u0000\u232e\u0000\u2367\u0000\u2367\u0000\u23a0\u0000\u23a0\u0000\u23d9\u0000\u2412\u0000\u2412\u0000\u244b\u0000\u2484\u0000\u2484\u0000\u24bd\u0000\u24bd\u0000\u24f6\u0000\u252f\u0000\u2568\u0000\u25a1\u0000\u25a1\u0000\u25da\u0000\u2613\u0000\u264c\u0000\u2685\u0000\u26be\u0000\u26f7\u0000\u2730\u0000\u2730\u0000\u2769\u0000\u27a2\u0000\u27a2\u0000\u27db\u0000\u27db\u0000\u2814\u0000\u284d\u0000\u2886\u0000\u2886\u0000\u28bf\u0000\u28f8\u0000\u28f8\u0000\u2931\u0000\u2931\u0000\u296a\u0000\u296a\u0000\u29a3\u0000\u29a3";
    private static final int[] ZZ_TRANS = LayoutScanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "9\r\b\u000e\u0001\u000f8\u000e\u0001\u00100\u000e\u0001\u0011\u0001\u0012\u0002\u0013\u0004\u0011\u0001\u0014\n\u0011\u0001\u0015%\u0011\u0001\u0016\u0001\u0012\u0002\u0013\u0004\u0016\u0001\u0017\n\u0016\u0001\u0018%\u0016\u0013\u0019\u0001\u001a\u0001\u001b$\u0019\u0001\u000e\u0001\u001c\u0001\u001d\u0006\u000e\u0001\u001e\u0001\u000e\u0001\u001f5\u000e\u0001 8\u000e\u0001!0\u000e\u0001\"\u0001#\u0001$\u0001\u0013\u0001%\u0004\"\u0001&\u0001%\u0001\"\u0004%\u0003\"\u0001'\u0003\"\u0011%\u0001(\u0001\"\u0003%\u0001\"\u0003%\b\"\u0001)\u0001#\u0001$\u0001\u0013\u0001*\u0003)\u0001+\u0001)\u0001*\u0001)\u0004*\u0003)\u0001,\u0001-\u0002)\u0011*\u0001)\u0001.\u0003*\u0001)\u0003*\u0001/\u00010\u00011\u00012\u00013\u00014\u00015\u00016\u00017\u0001#\u0001$\u0001\u0013\u0001*\u00037\u00018\u00017\u0001*\u00017\u0004*\u00037\u00019\u00037\u0011*\u0001(\u00017\u0003*\u00017\u0003*\b7A\u0000\u0001:8\u0000\u0001;2\u0000\u0001\u0013>\u0000\u0001<\f\u0000\u0001=\u0001\u0000\u0001>\u0002\u0000\u0001?\u0001\u0000\u0001@\u0003\u0000\u0001A\u0001B\u0001C\u0001\u0000\u0001D'\u0000\u0001E\u0001F,\u0000\u0001G\u0003\u0000\u0001H\u0002\u0000\u0001I\b\u0000\u0001J\u0001\u0000\u0001K\u0001L\u0001\u0000\u0001M\u0003\u0000\u0001N\u0005\u0000\u0001O%\u0000\u0001P7\u0000\u0001Q'\u0000\u0001\u001d6\u0000\u0007R\u0001\u000e\u0001R\u0001\u000e\u0001R\u0003\u000e\u0001S\u0001T\u0001U\u0001V\u0005\u000e\u0001R\u0002\u000e\fR\u0001\u000e\u0002R\u0001\u000e\u0003R\u0001\u000e\u0003R\b\u000e\b\u0000\u0001W\r\u0000\u0001X*\u0000\u0001Y\u000e\u0000\u0001Z#\u0000\u0001$:\u0000\u0003%\u0001[\u0002\u0000\u0001%\u0001\u0000\u0006%\u0005\u0000\u0011%\u0002\u0000\u0003%\u0001\u0000\u0003%\f\u0000\u0003*\u0003\u0000\u0001*\u0001\u0000\u0006*\u0005\u0000\u0011*\u0002\u0000\u0003*\u0001\u0000\u0003*\f\u0000\u0001\\\u0005\u0000\u0001\\\u0001\u0000\u0004\\\u0007\u0000\u0011\\\u0002\u0000\u0003\\\u0001\u0000\u0003\\2\u0000\u0001]\u0003\u0000\u0001^\"\u0000\u0001_;\u0000\u0001`8\u0000\u0001a\u0002\u0000\u0001b7\u0000\u0001c4\u0000\u0001d?\u0000\u0001e3\u0000\u0001f\u001d\u0000\u0001E\u0002\u00006E\u0017\u0000\u0001g\u0003\u0000\u0001h8\u0000\u0001i5\u0000\u0001j>\u0000\u0001k:\u0000\u0001l0\u0000\u0001m>\u0000\u0001n3\u0000\u0001o.\u0000\u0001p.\u0000\u0001q\u0004\u0000\u0001q\u0002\u0000\u0001q\u0002\u0000\u0002q\t\u0000\u0001q\u0002\u0000\u0001q\u0003\u0000\u0001q\u0001\u0000\u0001q\u0001\u0000\u0001q\u0003\u0000\u0001q\u0003\u0000\u0001q\u0001\u0000\u0001q\r\u0000\u0001r\u0004\u0000\u0001r\u0002\u0000\u0001r\u0002\u0000\u0002r\t\u0000\u0001r\u0002\u0000\u0001r\u0003\u0000\u0001r\u0001\u0000\u0001r\u0001\u0000\u0001r\u0003\u0000\u0001r\u0003\u0000\u0001r\u0001\u0000\u0001r\u0018\u0000\u0002V7\u0000\u0002\u000e=\u0000\u0001R9\u0000\u0001s9\u0000\u0001t$\u0000\u0001u\u0005\u0000\u0001u\u0001\u0000\u0004u\u0007\u0000\u0011u\u0002\u0000\u0003u\u0001\u0000\u0003u\f\u0000\u0003\\\u0001v\u0001w\u0001\u0000\u0001\\\u0001\u0000\u0006\\\u0005\u0000\u0011\\\u0002\u0000\u0003\\\u0001\u0000\u0003\\3\u0000\u0001x<\u0000\u0001y \u0000\u0001z=\u0000\u0001{*\u0000\u0001|I\u0000\u0001}2\u0000\u0001~=\u0000\u0001\u007f=\u0000\u0001\u00807\u0000\u0001\u0081.\u0000\u0001\u0082C\u0000\u0001\u00832\u0000\u0001\u00846\u0000\u0001\u0085\u0004\u0000\u0001\u0086;\u0000\u0001\u00876\u0000\u0001\u0088;\u0000\u0001\u0089+\u0000\u0001\u008a?\u0000\u0001\u008b5\u0000\u0001\u008c\"\u0000\u0001\u000e\u0004\u0000\u0001\u000e\u0002\u0000\u0001\u000e\u0002\u0000\u0002\u000e\t\u0000\u0001\u000e\u0002\u0000\u0001\u000e\u0003\u0000\u0001\u000e\u0001\u0000\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0001\u000e\u0003\u0000\u0001\u000e\u0001\u0000\u0001\u000e\r\u0000\u0001\u008d\u0004\u0000\u0001\u008d\u0002\u0000\u0001\u008d\u0002\u0000\u0002\u008d\t\u0000\u0001\u008d\u0002\u0000\u0001\u008d\u0003\u0000\u0001\u008d\u0001\u0000\u0001\u008d\u0001\u0000\u0001\u008d\u0003\u0000\u0001\u008d\u0003\u0000\u0001\u008d\u0001\u0000\u0001\u008d \u0000\u0001\u008e7\u0000\u0001\u008f%\u0000\u0003u\u0001[\u0002\u0000\u0001u\u0001\u0000\u0006u\u0005\u0000\u0011u\u0002\u0000\u0003u\u0001\u0000\u0003u4\u0000\u0001\u0090<\u0000\u0001\u0091!\u0000\u0001\u0092<\u0000\u0001\u00934\u0000\u0001\u0094?\u0000\u0001\u0095/\u0000\u0001\u0096-\u0000\u0001\u0097I\u0000\u0001\u00987\u0000\u0001\u00996\u0000\u0001\u009aD\u0000\u0001\u009b.\u0000\u0001\u009c?\u0000\u0001\u009d2\u0000\u0001\u009e6\u0000\u0001\u009f6\u0000\u0001\u00a0\u001f\u0000\u0004\u00a1\u0003\u00a2\u0003\u00a1\u0001\u00a2\u0001\u00a1\u0006\u00a2\u0005\u00a1\u0011\u00a2\u0002\u00a1\u0003\u00a2\u0001\u00a1\u0003\u00a2\b\u00a1\f\u0000\u0001\u00a38\u0000\u0001\u00a4M\u0000\u0001\u00a5\u001c\u0000\u0001\u00a6\u0004\u0000\u0001\u00a6\u0002\u0000\u0001\u00a6\u0002\u0000\u0002\u00a6\t\u0000\u0001\u00a6\u0002\u0000\u0001\u00a6\u0003\u0000\u0001\u00a6\u0001\u0000\u0001\u00a6\u0001\u0000\u0001\u00a6\u0003\u0000\u0001\u00a6\u0003\u0000\u0001\u00a6\u0001\u0000\u0001\u00a6\u001f\u0000\u0001\u00a7:\u0000\u0001\u00a8L\u0000\u0001\u00a98\u0000\u0001\u00aa \u0000\u0001\u00ab\u0003\u0000\u0001\u00ac:\u0000\u0001\u00ad7\u0000\u0001\u00ae-\u0000\u0001\u00afI\u0000\u0001\u00b01\u0000\u0001\u00b1?\u0000\u0001\u00b26\u0000\u0001\u00b35\u0000\u0001\u00b48\u0000\u0001\u00b5;\u0000\u0001\u00b6@\u0000\u0001\u00b7+\u0000\u0001\u00b8\u001f\u0000\u0004\u00b9\u0003\u00ba\u0003\u00b9\u0001\u00ba\u0001\u00b9\u0006\u00ba\u0005\u00b9\u0011\u00ba\u0002\u00b9\u0003\u00ba\u0001\u00b9\u0003\u00ba\b\u00b9\u0004\u00bb\u0003\u00bc\u0003\u00bb\u0001\u00bc\u0001\u00bb\u0006\u00bc\u0005\u00bb\u0011\u00bc\u0002\u00bb\u0003\u00bc\u0001\u00bb\u0003\u00bc\b\u00bb9\u00a1\u0004\u00bd\u0003\u00be\u0003\u00bd\u0001\u00be\u0001\u00bd\u0006\u00be\u0005\u00bd\u0011\u00be\u0002\u00bd\u0003\u00be\u0001\u00bd\u0003\u00be\b\u00bd\u0019\u0000\u0001\u00bf8\u0000\u0001\u00c08\u0000\u0001W5\u0000\u0001\u00c1<\u0000\u0001\u00c2*\u0000\u0001\u00c38\u0000\u0001\u00c4E\u0000\u0001\u00c57\u0000\u0001\u00c6 \u0000\u0004\u00c7\u0003\u00c8\u0003\u00c7\u0001\u00c8\u0001\u00c7\u0006\u00c8\u0005\u00c7\u0011\u00c8\u0002\u00c7\u0003\u00c8\u0001\u00c7\u0003\u00c8\b\u00c7\u0018\u0000\u0001\u00c9,\u0000\u0001\u00ca8\u0000\u0001\u00cbP\u0000\u0001\u00cc6\u0000\u0001\u00cd1\u0000\u0001\u00ce4\u0000\u0001\u00cf!\u00009\u00b99\u00bb9\u00bd\u0004\u00d0\u0003\u00d1\u0003\u00d0\u0001\u00d1\u0001\u00d0\u0006\u00d1\u0005\u00d0\u0011\u00d1\u0002\u00d0\u0003\u00d1\u0001\u00d0\u0003\u00d1\b\u00d0\u0004\u00d2\u0003\u00d3\u0003\u00d2\u0001\u00d3\u0001\u00d2\u0006\u00d3\u0005\u00d2\u0011\u00d3\u0002\u00d2\u0003\u00d3\u0001\u00d2\u0003\u00d3\b\u00d2\f\u0000\u0001\u00d4,\u0000\u0004\u00d5\u0003\u00d6\u0003\u00d5\u0001\u00d6\u0001\u00d5\u0006\u00d6\u0005\u00d5\u0011\u00d6\u0002\u00d5\u0003\u00d6\u0001\u00d5\u0003\u00d6\b\u00d5 \u0000\u0001\u00d7\u0018\u0000\u0004\u00d8\u0003\u00d9\u0003\u00d8\u0001\u00d9\u0001\u00d8\u0006\u00d9\u0005\u00d8\u0011\u00d9\u0002\u00d8\u0003\u00d9\u0001\u00d8\u0003\u00d9\b\u00d8\u0004\u00da\u0003\u00db\u0003\u00da\u0001\u00db\u0001\u00da\u0006\u00db\u0005\u00da\u0011\u00db\u0002\u00da\u0003\u00db\u0001\u00da\u0003\u00db\b\u00da9\u00c7\u001b\u0000\u0001\u00dc8\u0000\u0001\u00dd4\u0000\u0001\u00de!\u0000\u0004\u00df\u0003\u00e0\u0003\u00df\u0001\u00e0\u0001\u00df\u0006\u00e0\u0005\u00df\u0011\u00e0\u0002\u00df\u0003\u00e0\u0001\u00df\u0003\u00e0\b\u00df\u001b\u0000\u0001\u00e1A\u0000\u0001\u00e24\u0000\u0001\u00e3\u0018\u00009\u00d09\u00d2 \u0000\u0001\u00e4\u0018\u00009\u00d5%\u0000\u0001\u00e5\u0013\u00009\u00d89\u00da\u0018\u0000\u0001\u00e6 \u0000\u0004\u00e7\u0003\u00e8\u0003\u00e7\u0001\u00e8\u0001\u00e7\u0006\u00e8\u0005\u00e7\u0011\u00e8\u0002\u00e7\u0003\u00e8\u0001\u00e7\u0003\u00e8\b\u00e7\u0019\u0000\u0001\u00e9\u001f\u00009\u00df\u0004\u00ea\u0003\u00eb\u0003\u00ea\u0001\u00eb\u0001\u00ea\u0006\u00eb\u0005\u00ea\u0011\u00eb\u0002\u00ea\u0003\u00eb\u0001\u00ea\u0003\u00eb\b\u00ea\u0004\u00ec\u0003\u00ed\u0003\u00ec\u0001\u00ed\u0001\u00ec\u0006\u00ed\u0005\u00ec\u0011\u00ed\u0002\u00ec\u0003\u00ed\u0001\u00ec\u0003\u00ed\b\u00ec\u0018\u0000\u0001\u00eeE\u0000\u0001\u00ef\u0013\u0000\u0004\u00f0\u0003\u00f1\u0003\u00f0\u0001\u00f1\u0001\u00f0\u0006\u00f1\u0005\u00f0\u0011\u00f1\u0002\u00f0\u0003\u00f1\u0001\u00f0\u0003\u00f1\b\u00f0\u0019\u0000\u0001\u00f2\u001f\u00009\u00e7\u0004\u00f3\u0003\u00f4\u0003\u00f3\u0001\u00f4\u0001\u00f3\u0006\u00f4\u0005\u00f3\u0011\u00f4\u0002\u00f3\u0003\u00f4\u0001\u00f3\u0003\u00f4\b\u00f39\u00ea9\u00ec\u0004\u00f5\u0003\u00f6\u0003\u00f5\u0001\u00f6\u0001\u00f5\u0006\u00f6\u0005\u00f5\u0011\u00f6\u0002\u00f5\u0003\u00f6\u0001\u00f5\u0003\u00f6\b\u00f5\u0004\u00f7\u0003\u00f8\u0003\u00f7\u0001\u00f8\u0001\u00f7\u0006\u00f8\u0005\u00f7\u0011\u00f8\u0002\u00f7\u0003\u00f8\u0001\u00f7\u0003\u00f8\b\u00f79\u00f0\u0004\u00f9\u0003\u00fa\u0003\u00f9\u0001\u00fa\u0001\u00f9\u0006\u00fa\u0005\u00f9\u0011\u00fa\u0002\u00f9\u0003\u00fa\u0001\u00f9\u0003\u00fa\b\u00f99\u00f39\u00f59\u00f79\u00f9";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = LayoutScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\f\u0000\u0002\t\u0002\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0003\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\t\t\u0002\u0001\u0004\t\u0007\u0000\u0001\u0001\u0001\t\t\u0000\u0003\t\u0004\u0001\u0001\u0000\u0001\t\u0019\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\t\u0011\u0000\u0001\u0007\u0003\u0000\u0001\u0001\u0011\u0000\u0002\u0007\u0001\u0005\u0001\u0000\u0001\u0007\u0002\u0000\u0001\u0001\u0002\u0000\u0003\t\u0005\u0000\u0001\u0007\u0007\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0002\u0007\u0001\t\u0001\u0000\u0001\u0007\u0001\u0000\u0002\u0007\u0001\u0005\u0004\u0000\u0001\u0007\u0003\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0002\u0000\u0001\u0005\u0002\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0002\u0000\u0001\u0007\u0001\u0000\u0001\u0005\u0001\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0007\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0002\u0007\u0001\u0005\u0001\u0000\u0001\u0007\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private PositionRecord pos = new PositionRecord();
    private Stack<StateRecord> stateStack = new Stack();
    private int nestingDepth = 0;
    private StringBuffer blobBuf = new StringBuffer();

    private static int[] zzUnpackAction() {
        int[] nArray = new int[250];
        int n = 0;
        n = LayoutScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAction(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackRowMap() {
        int[] nArray = new int[250];
        int n = 0;
        n = LayoutScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackRowMap(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++) << 16;
            nArray[n3++] = n5 | string.charAt(n2++);
        }
        return n3;
    }

    private static int[] zzUnpackTrans() {
        int[] nArray = new int[10716];
        int n = 0;
        n = LayoutScanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackTrans(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            int n6 = string.charAt(n2++);
            do {
                nArray[n3++] = --n6;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAttribute() {
        int[] nArray = new int[250];
        int n = 0;
        n = LayoutScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAttribute(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private Symbol symbol(short s) {
        return this.symbol(s, null);
    }

    private Symbol symbol(short s, Object object) {
        int n = this.yyline + 1;
        int n2 = this.yycolumn + 1;
        int n3 = n;
        int n4 = n2 + this.yylength() - 1;
        return this.symbol(s, object, n, n2, n3, n4);
    }

    private Symbol symbol(short s, Object object, int n, int n2, int n3, int n4) {
        int n5 = Symbol.makePosition(n, n2);
        int n6 = Symbol.makePosition(n3, n4);
        return new Symbol(s, n5, n6, object);
    }

    private void markStartPosition() {
        this.pos.startLine = this.yyline + 1;
        this.pos.startCol = this.yycolumn + 1;
    }

    private void markEndPosition() {
        this.pos.endLine = this.yyline + 1;
        this.pos.endCol = this.yycolumn + 1 + this.yylength() - 1;
    }

    private Symbol symbolFromMarkedPositions(short s) {
        return this.symbolFromMarkedPositions(s, null);
    }

    private Symbol symbolFromMarkedPositions(short s, Object object) {
        return this.symbol(s, object, this.pos.startLine, this.pos.startCol, this.pos.endLine, this.pos.endCol);
    }

    private Symbol symbolFromMarkedStart(short s, int n) {
        return this.symbolFromMarkedStart(s, null, n);
    }

    private Symbol symbolFromMarkedStart(short s, Object object, int n) {
        return this.symbol(s, object, this.pos.startLine, this.pos.startCol, this.pos.startLine, this.pos.startCol + n - 1);
    }

    private void error(String string) throws Scanner.Exception {
        throw new Scanner.Exception(this.yyline + 1, this.yycolumn + 1, string);
    }

    private void error(String string, int n) throws Scanner.Exception {
        throw new Scanner.Exception(this.yyline + 1, this.yycolumn + 1 + n, string);
    }

    void saveStateAndTransition(int n) {
        this.stateStack.push(new StateRecord(this.yystate(), this.pos));
        this.pos = new PositionRecord();
        this.yybegin(n);
    }

    void restoreState() {
        StateRecord stateRecord = this.stateStack.pop();
        this.yybegin(stateRecord.stateNum);
        this.pos = stateRecord.pos;
    }

    private static String frontChomp(String string) {
        if (string.startsWith("\r\n")) {
            return string.substring(2);
        }
        if (string.startsWith("\n") || string.startsWith("\r")) {
            return string.substring(1);
        }
        return string;
    }

    public LayoutScanner(Reader reader) {
        this.saveStateAndTransition(1);
        this.blobBuf = new StringBuffer();
        this.markStartPosition();
        this.zzReader = reader;
    }

    public LayoutScanner(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    private static char[] zzUnpackCMap(String string) {
        char[] cArray = new char[65536];
        int n = 0;
        int n2 = 0;
        while (n < 154) {
            int n3 = string.charAt(n++);
            char c = string.charAt(n++);
            do {
                cArray[n2++] = c;
            } while (--n3 > 0);
        }
        return cArray;
    }

    private boolean zzRefill() throws IOException {
        int n;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] cArray = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, cArray, 0, this.zzBuffer.length);
            this.zzBuffer = cArray;
        }
        if ((n = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += n;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int n) {
        this.zzLexicalState = n;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int n) {
        String string;
        try {
            string = ZZ_ERROR_MSG[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = ZZ_ERROR_MSG[0];
        }
        throw new Error(string);
    }

    public void yypushback(int n) {
        if (n > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= n;
    }

    public Symbol nextToken() throws IOException, Scanner.Exception {
        int n = this.zzEndRead;
        char[] cArray = this.zzBuffer;
        char[] cArray2 = ZZ_CMAP;
        int[] nArray = ZZ_TRANS;
        int[] nArray2 = ZZ_ROWMAP;
        int[] nArray3 = ZZ_ATTRIBUTE;
        this.zzPushbackPos = -1;
        int n2 = -1;
        block154: while (true) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.zzMarkedPos;
            boolean bl = false;
            block155: for (n6 = this.zzStartRead; n6 < n7; ++n6) {
                switch (cArray[n6]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = false;
                        continue block155;
                    }
                    case '\r': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = true;
                        continue block155;
                    }
                    case '\n': {
                        if (bl) {
                            bl = false;
                            continue block155;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block155;
                    }
                    default: {
                        bl = false;
                        ++this.yycolumn;
                    }
                }
            }
            if (bl) {
                if (n7 < n) {
                    n5 = cArray[n7] == '\n' ? 1 : 0;
                } else if (this.zzAtEOF) {
                    n5 = 0;
                } else {
                    n4 = this.zzRefill();
                    n = this.zzEndRead;
                    n7 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    if (n4 != 0) {
                        n5 = 0;
                    } else {
                        int n8 = n5 = cArray[n7] == '\n' ? 1 : 0;
                    }
                }
                if (n5 != 0) {
                    --this.yyline;
                }
            }
            int n9 = -1;
            this.zzCurrentPos = this.zzStartRead = n7;
            n6 = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            boolean bl2 = false;
            while (true) {
                if (n6 < n) {
                    n3 = cArray[n6++];
                } else {
                    if (this.zzAtEOF) {
                        n3 = -1;
                        break;
                    }
                    this.zzCurrentPos = n6;
                    this.zzMarkedPos = n7;
                    this.zzPushbackPos = n2;
                    n5 = this.zzRefill();
                    n6 = this.zzCurrentPos;
                    n7 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    n = this.zzEndRead;
                    n2 = this.zzPushbackPos;
                    if (n5 != 0) {
                        n3 = -1;
                        break;
                    }
                    n3 = cArray[n6++];
                }
                n5 = nArray[nArray2[this.zzState] + cArray2[n3]];
                if (n5 == -1) break;
                this.zzState = n5;
                n4 = nArray3[this.zzState];
                if ((n4 & 2) == 2) {
                    n2 = n6;
                }
                if ((n4 & 1) != 1) continue;
                bl2 = (n4 & 4) == 4;
                n9 = this.zzState;
                n7 = n6;
                if ((n4 & 8) == 8) break;
            }
            this.zzMarkedPos = n7;
            if (bl2) {
                this.zzMarkedPos = n2;
            }
            switch (n9 < 0 ? n9 : ZZ_ACTION[n9]) {
                case 4: 
                case 63: {
                    continue block154;
                }
                case 59: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)2);
                }
                case 64: {
                    continue block154;
                }
                case 5: {
                    this.error("Invalid directive");
                }
                case 65: {
                    continue block154;
                }
                case 52: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)40);
                }
                case 66: {
                    continue block154;
                }
                case 54: {
                    return this.symbol((short)1);
                }
                case 67: {
                    continue block154;
                }
                case 41: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)36);
                }
                case 68: {
                    continue block154;
                }
                case 48: {
                    this.saveStateAndTransition(10);
                    return this.symbol((short)35);
                }
                case 69: {
                    continue block154;
                }
                case 30: {
                    this.restoreState();
                    this.saveStateAndTransition(4);
                }
                case 70: {
                    continue block154;
                }
                case 53: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)4);
                }
                case 71: {
                    continue block154;
                }
                case 15: {
                    return this.symbol((short)15);
                }
                case 72: {
                    continue block154;
                }
                case 11: {
                    this.error("Unexpected character in directive option list: " + this.yytext());
                    this.yybegin(0);
                }
                case 73: {
                    continue block154;
                }
                case 60: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)30);
                }
                case 74: {
                    continue block154;
                }
                case 6: {
                    this.error("Unexpected character in rule section: " + this.yytext());
                    this.yybegin(0);
                }
                case 75: {
                    continue block154;
                }
                case 34: {
                    ++this.nestingDepth;
                }
                case 76: {
                    continue block154;
                }
                case 45: {
                    return this.symbol((short)21);
                }
                case 77: {
                    continue block154;
                }
                case 20: {
                    return this.symbol((short)23);
                }
                case 78: {
                    continue block154;
                }
                case 28: {
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)38, this.blobBuf.toString());
                    this.restoreState();
                    this.saveStateAndTransition(2);
                    this.blobBuf = new StringBuffer();
                    this.markStartPosition();
                    return symbol;
                }
                case 79: {
                    continue block154;
                }
                case 17: {
                    return this.symbol((short)13, this.yytext());
                }
                case 80: {
                    continue block154;
                }
                case 14: {
                    this.saveStateAndTransition(6);
                    this.blobBuf = new StringBuffer(this.yytext());
                    this.markStartPosition();
                }
                case 81: {
                    continue block154;
                }
                case 13: {
                    return this.symbol((short)3, this.yytext());
                }
                case 82: {
                    continue block154;
                }
                case 50: {
                    this.blobBuf.append(this.yytext());
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)6, this.blobBuf.toString());
                    this.restoreState();
                    return symbol;
                }
                case 83: {
                    continue block154;
                }
                case 16: {
                    this.error("Unexpected character in meta-pattern: " + this.yytext());
                    this.yybegin(0);
                }
                case 84: {
                    continue block154;
                }
                case 43: {
                    this.saveStateAndTransition(11);
                    return this.symbol((short)16);
                }
                case 85: {
                    continue block154;
                }
                case 29: {
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)39, LayoutScanner.frontChomp(this.blobBuf.toString()));
                    this.restoreState();
                    this.saveStateAndTransition(3);
                    return symbol;
                }
                case 86: {
                    continue block154;
                }
                case 25: {
                    return this.symbol((short)26);
                }
                case 87: {
                    continue block154;
                }
                case 32: 
                case 88: {
                    continue block154;
                }
                case 24: {
                    return this.symbol((short)28);
                }
                case 89: {
                    continue block154;
                }
                case 36: {
                    this.blobBuf.append(this.yytext().substring(1));
                }
                case 90: {
                    continue block154;
                }
                case 31: {
                    this.saveStateAndTransition(7);
                    this.blobBuf = new StringBuffer(this.yytext());
                    this.markStartPosition();
                }
                case 91: {
                    continue block154;
                }
                case 22: {
                    return this.symbol((short)33);
                }
                case 92: {
                    continue block154;
                }
                case 33: {
                    this.saveStateAndTransition(5);
                    ++this.nestingDepth;
                }
                case 93: {
                    continue block154;
                }
                case 46: {
                    this.saveStateAndTransition(8);
                    this.blobBuf = new StringBuffer(this.yytext());
                    this.markStartPosition();
                }
                case 94: {
                    continue block154;
                }
                case 56: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)25);
                }
                case 95: {
                    continue block154;
                }
                case 35: {
                    --this.nestingDepth;
                    if (this.nestingDepth == 0) {
                        this.restoreState();
                    }
                }
                case 96: {
                    continue block154;
                }
                case 1: {
                    this.error("Unexpected character: " + this.yytext());
                }
                case 97: {
                    continue block154;
                }
                case 3: {
                    this.error("Unexpected character in option section: " + this.yytext());
                    this.yybegin(0);
                }
                case 98: {
                    continue block154;
                }
                case 26: {
                    return this.symbol((short)24);
                }
                case 99: {
                    continue block154;
                }
                case 2: {
                    this.blobBuf.append(this.yytext());
                }
                case 100: {
                    continue block154;
                }
                case 49: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)32);
                }
                case 101: {
                    continue block154;
                }
                case 39: {
                    return this.symbol((short)14, this.yytext().substring(1, this.yylength() - 1));
                }
                case 102: {
                    continue block154;
                }
                case 61: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)10);
                }
                case 103: {
                    continue block154;
                }
                case 40: {
                    this.saveStateAndTransition(10);
                    return this.symbol((short)22);
                }
                case 104: {
                    continue block154;
                }
                case 57: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)17);
                }
                case 105: {
                    continue block154;
                }
                case 18: {
                    return this.symbol((short)27);
                }
                case 106: {
                    continue block154;
                }
                case 55: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)12);
                }
                case 107: {
                    continue block154;
                }
                case 27: {
                    this.error("Unexpected character in pair element: " + this.yytext());
                    this.yybegin(0);
                }
                case 108: {
                    continue block154;
                }
                case 37: {
                    this.blobBuf.append(this.yytext());
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)5, this.blobBuf.toString());
                    this.restoreState();
                    return symbol;
                }
                case 109: {
                    continue block154;
                }
                case 19: {
                    return this.symbol((short)19);
                }
                case 110: {
                    continue block154;
                }
                case 38: {
                    return this.symbol((short)29, this.yytext());
                }
                case 111: {
                    continue block154;
                }
                case 9: {
                    this.blobBuf.append(this.yytext());
                    this.markEndPosition();
                    Symbol symbol = this.symbolFromMarkedPositions((short)34, this.blobBuf.toString());
                    this.restoreState();
                    return symbol;
                }
                case 112: {
                    continue block154;
                }
                case 58: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)11);
                }
                case 113: {
                    continue block154;
                }
                case 47: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)8);
                }
                case 114: {
                    continue block154;
                }
                case 23: {
                    return this.symbol((short)37);
                }
                case 115: {
                    continue block154;
                }
                case 62: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)9);
                }
                case 116: {
                    continue block154;
                }
                case 44: {
                    return this.symbol((short)20);
                }
                case 117: {
                    continue block154;
                }
                case 42: {
                    this.saveStateAndTransition(9);
                    return this.symbol((short)31);
                }
                case 118: {
                    continue block154;
                }
                case 7: 
                case 119: {
                    continue block154;
                }
                case 51: {
                    return this.symbol((short)7);
                }
                case 120: {
                    continue block154;
                }
                case 10: {
                    this.yybegin(0);
                    this.error("Incomplete escape sequence");
                }
                case 121: {
                    continue block154;
                }
                case 8: {
                    this.yybegin(0);
                    this.error("Unterminated string literal: '" + this.blobBuf + "'");
                }
                case 122: {
                    continue block154;
                }
                case 12: {
                    this.restoreState();
                }
                case 123: {
                    continue block154;
                }
                case 21: {
                    return this.symbol((short)18);
                }
                case 124: {
                    continue block154;
                }
            }
            if (n3 == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 2: {
                        this.yybegin(0);
                        this.error("Unterminated inherited header section.");
                    }
                    case 251: {
                        continue block154;
                    }
                    case 5: {
                        this.yybegin(0);
                        if (this.nestingDepth != 0) {
                            this.error(this.nestingDepth + " levels of comments not closed");
                        }
                    }
                    case 252: {
                        continue block154;
                    }
                    case 9: {
                        this.yybegin(0);
                    }
                    case 253: {
                        continue block154;
                    }
                    case 11: {
                        this.yybegin(0);
                    }
                    case 254: {
                        continue block154;
                    }
                    case 7: {
                        this.yybegin(0);
                        this.error("Unterminated declaration region: '" + this.blobBuf + "'");
                    }
                    case 255: {
                        continue block154;
                    }
                    case 6: {
                        this.yybegin(0);
                        this.error("Unterminated string literal: '" + this.blobBuf + "'");
                    }
                    case 256: {
                        continue block154;
                    }
                    case 3: {
                        this.yybegin(0);
                    }
                    case 257: {
                        continue block154;
                    }
                    case 1: {
                        this.yybegin(0);
                        this.error("Unterminated local header section.");
                    }
                    case 258: {
                        continue block154;
                    }
                    case 0: {
                        return this.symbol((short)0);
                    }
                    case 259: {
                        continue block154;
                    }
                    case 10: {
                        this.yybegin(0);
                    }
                    case 260: {
                        continue block154;
                    }
                    case 8: {
                        this.yybegin(0);
                        this.error("Unterminated init region: '" + this.blobBuf + "'");
                    }
                    case 261: {
                        continue block154;
                    }
                    case 4: {
                        this.yybegin(0);
                    }
                    case 262: {
                        continue block154;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }

    private static class StateRecord {
        int stateNum;
        PositionRecord pos;

        StateRecord(int n, PositionRecord positionRecord) {
            this.stateNum = n;
            this.pos = positionRecord;
        }
    }

    private static class PositionRecord {
        int startLine = -1;
        int startCol = -1;
        int endLine = -1;
        int endCol = -1;

        private PositionRecord() {
        }
    }
}

