/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.StringEval;
import metalexer.ast.ASTNode;
import metalexer.ast.CharClassRange;
import metalexer.ast.Component;
import metalexer.jflex.PrintHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCharRange
extends CharClassRange
implements Cloneable {
    protected String tokenString_LowerChar;
    public int LowerCharstart;
    public int LowerCharend;
    protected String tokenString_UpperChar;
    public int UpperCharstart;
    public int UpperCharend;

    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public MultiCharRange clone() throws CloneNotSupportedException {
        MultiCharRange multiCharRange = (MultiCharRange)super.clone();
        multiCharRange.in$Circle(false);
        multiCharRange.is$Final(false);
        return multiCharRange;
    }

    public MultiCharRange copy() {
        try {
            MultiCharRange multiCharRange = this.clone();
            if (this.children != null) {
                multiCharRange.children = (ASTNode[])this.children.clone();
            }
            return multiCharRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MultiCharRange fullCopy() {
        MultiCharRange multiCharRange = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            multiCharRange.setChild(object, i);
        }
        return multiCharRange;
    }

    private boolean isReversed() {
        String string = this.getLowerChar();
        String string2 = this.getUpperChar();
        char c = string.length() == 1 ? string.charAt(0) : MultiCharRange.unescape(string);
        char c2 = string.length() == 1 ? string2.charAt(0) : MultiCharRange.unescape(string2);
        return c > c2;
    }

    private static char unescape(String string) {
        String string2 = StringEval.evalString("\"" + string + "\"");
        if (string2.length() > 1) {
            throw new RuntimeException("Invalid escape sequence: " + string);
        }
        return string2.charAt(0);
    }

    @Override
    public void acquirePositionFromChildren() {
        this.start = this.LowerCharstart;
        this.end = this.UpperCharend;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getLowerChar() == null ? 0 : this.getLowerChar().hashCode());
        n = 31 * n + (this.getUpperChar() == null ? 0 : this.getUpperChar().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiCharRange multiCharRange = (MultiCharRange)object;
        if (this.getLowerChar() == null ? multiCharRange.getLowerChar() != null : !this.getLowerChar().equals(multiCharRange.getLowerChar())) {
            return false;
        }
        return !(this.getUpperChar() == null ? multiCharRange.getUpperChar() != null : !this.getUpperChar().equals(multiCharRange.getUpperChar()));
    }

    @Override
    void printJFlexRegex(PrintHelper printHelper) throws IOException {
        printHelper.print(this.getLowerChar() + "-" + this.getUpperChar());
    }

    public MultiCharRange() {
    }

    public MultiCharRange(String string, String string2) {
        this.setLowerChar(string);
        this.setUpperChar(string2);
    }

    public MultiCharRange(Symbol symbol, Symbol symbol2) {
        this.setLowerChar(symbol);
        this.setUpperChar(symbol2);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLowerChar(String string) {
        this.tokenString_LowerChar = string;
    }

    public void setLowerChar(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLowerChar is only valid for String lexemes");
        }
        this.tokenString_LowerChar = (String)symbol.value;
        this.LowerCharstart = symbol.getStart();
        this.LowerCharend = symbol.getEnd();
    }

    public String getLowerChar() {
        return this.tokenString_LowerChar != null ? this.tokenString_LowerChar : "";
    }

    public void setUpperChar(String string) {
        this.tokenString_UpperChar = string;
    }

    public void setUpperChar(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setUpperChar is only valid for String lexemes");
        }
        this.tokenString_UpperChar = (String)symbol.value;
        this.UpperCharstart = symbol.getStart();
        this.UpperCharend = symbol.getEnd();
    }

    public String getUpperChar() {
        return this.tokenString_UpperChar != null ? this.tokenString_UpperChar : "";
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component component;
        if (this.isReversed() && (component = this.getComponent()) != null) {
            component.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Component_Component_getErrors(sortedSet);
        if (this.isReversed()) {
            sortedSet.add(this.makeCompilationError("Reversed character range."));
        }
    }
}

