/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex.fsm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class DFA {
    private final int numStates;
    private final int numSymbols;
    private final Integer[][] transitions;
    private final Integer[] actions;

    public DFA(Integer[][] integerArray, Integer[] integerArray2) {
        this.numStates = integerArray.length;
        this.numSymbols = integerArray[0].length;
        this.transitions = integerArray;
        this.actions = integerArray2;
    }

    public DFA minimize() {
        int n;
        Serializable serializable;
        Integer[][] integerArray;
        boolean[][] blArray = this.findDistinct();
        int[] nArray = this.buildStateMap(blArray);
        HashMap<Integer, Integer[][]> hashMap = new HashMap<Integer, Integer[][]>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        Integer n2 = nArray[0];
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        linkedList.add(n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (!linkedList.isEmpty()) {
            Integer n3 = (Integer)linkedList.poll();
            if (hashMap.containsKey(n3)) continue;
            integerArray = new Integer[this.numSymbols];
            for (int i = 0; i < this.numSymbols; ++i) {
                serializable = Integer.valueOf(nArray[this.transitions[n3][i]]);
                integerArray[i] = serializable;
                linkedList.add(serializable);
            }
            hashMap.put(n3, integerArray);
            hashMap2.put(n3, this.actions[nArray[n3]]);
            arrayList.add(n3);
        }
        int n4 = arrayList.size();
        integerArray = new Integer[n4][this.numSymbols];
        Integer[] integerArray2 = new Integer[n4];
        serializable = new HashMap();
        for (n = 0; n < n4; ++n) {
            serializable.put(arrayList.get(n), n);
        }
        for (n = 0; n < n4; ++n) {
            Integer n5 = (Integer)arrayList.get(n);
            Integer[] integerArray3 = (Integer[])hashMap.get(n5);
            Integer[] integerArray4 = new Integer[this.numSymbols];
            for (int i = 0; i < this.numSymbols; ++i) {
                integerArray4[i] = (Integer)serializable.get(integerArray3[i]);
            }
            integerArray[n] = integerArray4;
            integerArray2[n] = (Integer)hashMap2.get(n5);
        }
        return new DFA(integerArray, integerArray2);
    }

    private boolean[][] findDistinct() {
        int n;
        int n2;
        boolean[][] blArrayArray = new boolean[this.numStates][];
        for (n2 = 0; n2 < this.numStates; ++n2) {
            blArrayArray[n2] = new boolean[n2];
            for (n = 0; n < n2; ++n) {
                blArrayArray[n2][n] = !DFA.equals(this.actions[n2], this.actions[n]);
            }
        }
        do {
            n2 = 0;
            for (n = 0; n < this.numStates; ++n) {
                for (int i = 0; i < n; ++i) {
                    if (blArrayArray[n][i]) continue;
                    for (int j = 0; j < this.numSymbols; ++j) {
                        int n3;
                        int n4 = this.transitions[n][j];
                        if (n4 == (n3 = this.transitions[i][j].intValue())) continue;
                        if (n4 < n3) {
                            int n5 = n4;
                            n4 = n3;
                            n3 = n5;
                        }
                        if (!blArrayArray[n4][n3]) continue;
                        blArrayArray[n][i] = true;
                        n2 = 1;
                    }
                }
            }
        } while (n2 != 0);
        return blArrayArray;
    }

    private int[] buildStateMap(boolean[][] blArray) {
        int[] nArray = new int[this.numStates];
        block0: for (int i = 0; i < this.numStates; ++i) {
            nArray[i] = i;
            for (int j = 0; j < i; ++j) {
                if (blArray[i][j]) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    public DFA moveAcceptingToEnd() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IndexActionPair
        implements Comparable<IndexActionPair> {
            int index;
            Integer action;

            IndexActionPair() {
            }

            @Override
            public int compareTo(IndexActionPair indexActionPair) {
                if (this.index == 0) {
                    return -1;
                }
                if (indexActionPair.index == 0) {
                    return 1;
                }
                if (this.action == null) {
                    return indexActionPair.action == null ? 0 : -1;
                }
                return indexActionPair.action == null ? 1 : 0;
            }
        }
        Object[] objectArray = new IndexActionPair[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            objectArray[i] = new IndexActionPair();
            ((IndexActionPair)objectArray[i]).index = i;
            ((IndexActionPair)objectArray[i]).action = this.actions[i];
        }
        Arrays.sort(objectArray);
        int[] nArray = new int[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            nArray[((IndexActionPair)objectArray[i]).index] = i;
        }
        Integer[][] integerArray = new Integer[this.numStates][this.numSymbols];
        Integer[] integerArray2 = new Integer[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            integerArray2[i] = ((IndexActionPair)objectArray[i]).action;
            for (int j = 0; j < this.numSymbols; ++j) {
                integerArray[nArray[i]][j] = nArray[this.transitions[i][j]];
            }
        }
        return new DFA(integerArray, integerArray2);
    }

    public int getNumStates() {
        return this.numStates;
    }

    public int getNumSymbols() {
        return this.numSymbols;
    }

    public Integer[][] getTransitions() {
        return this.transitions;
    }

    public Integer[] getActions() {
        return this.actions;
    }

    private static boolean equals(Integer n, Integer n2) {
        if (n == null || n2 == null) {
            return n == n2;
        }
        return n.equals(n2);
    }

    public void dump() {
        int n;
        System.out.println("DFA");
        System.out.println("Transitions:");
        for (n = 0; n < this.numStates; ++n) {
            for (int i = 0; i < this.numSymbols; ++i) {
                System.out.print(this.transitions[n][i] + "\t");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Actions:");
        for (n = 0; n < this.numStates; ++n) {
            System.out.println(this.actions[n]);
        }
    }
}

