/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.CompDecl;
import metalexer.ast.Layout;
import metalexer.ast.Replacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompRef
extends ASTNode<ASTNode>
implements Cloneable {
    private Stack<Replacement> replacements = new Stack();
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getDecl_visited = -1;
    protected Map makeCompilationError_String_visited;
    protected Map lookupCompDecls_String_visited;
    protected int getLayout_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getDecl_visited = -1;
        this.makeCompilationError_String_visited = new HashMap(4);
        this.lookupCompDecls_String_visited = new HashMap(4);
        this.getLayout_visited = -1;
    }

    @Override
    public CompRef clone() throws CloneNotSupportedException {
        CompRef compRef = (CompRef)super.clone();
        compRef.getDecl_visited = -1;
        compRef.makeCompilationError_String_visited = new HashMap(4);
        compRef.lookupCompDecls_String_visited = new HashMap(4);
        compRef.getLayout_visited = -1;
        compRef.in$Circle(false);
        compRef.is$Final(false);
        return compRef;
    }

    public CompRef copy() {
        try {
            CompRef compRef = this.clone();
            if (this.children != null) {
                compRef.children = (ASTNode[])this.children.clone();
            }
            return compRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public CompRef fullCopy() {
        CompRef compRef = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            compRef.setChild(object, i);
        }
        return compRef;
    }

    @Override
    Set<Replacement> replaceComponents(Map<String, Replacement> map) {
        if (map.containsKey(this.getName())) {
            Replacement replacement = map.get(this.getName());
            this.setName(replacement.getNew().getName());
            this.replacements.push(replacement);
            return Collections.singleton(replacement);
        }
        return Collections.emptySet();
    }

    public CompRef() {
    }

    public CompRef(String string) {
        this.setName(string);
    }

    public CompRef(Symbol symbol) {
        this.setName(symbol);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public CompDecl getDecl() {
        if (this.getDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDecl in class: ");
        }
        this.getDecl_visited = this.state().boundariesCrossed;
        CompDecl compDecl = this.getDecl_compute();
        this.getDecl_visited = -1;
        return compDecl;
    }

    private CompDecl getDecl_compute() {
        Set<CompDecl> set = this.lookupCompDecls(this.getName());
        return set.isEmpty() ? null : set.iterator().next();
    }

    @Override
    public CompilationError makeCompilationError(String string) {
        String string2 = string;
        if (this.makeCompilationError_String_visited == null) {
            this.makeCompilationError_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.makeCompilationError_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: makeCompilationError in class: ");
        }
        this.makeCompilationError_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        CompilationError compilationError = this.makeCompilationError_compute(string);
        this.makeCompilationError_String_visited.remove(string2);
        return compilationError;
    }

    private CompilationError makeCompilationError_compute(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Collections.reverse(this.replacements);
        for (Replacement replacement : this.replacements) {
            int n = replacement.getStart();
            int n2 = Symbol.getLine(n);
            int n3 = Symbol.getColumn(n);
            stringBuffer.append("\n\tReplaced '" + replacement.getOld().getName() + "' with '" + replacement.getNew().getName() + "' at " + replacement.getFilename() + " [" + n2 + ", " + n3 + "]");
        }
        Collections.reverse(this.replacements);
        return super.makeCompilationError(stringBuffer.toString());
    }

    public Set<CompDecl> lookupCompDecls(String string) {
        String string2 = string;
        if (this.lookupCompDecls_String_visited == null) {
            this.lookupCompDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupCompDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupCompDecls in class: ");
        }
        this.lookupCompDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<CompDecl> set = this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, null, string);
        this.lookupCompDecls_String_visited.remove(string2);
        return set;
    }

    public Layout getLayout() {
        if (this.getLayout_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLayout in class: ");
        }
        this.getLayout_visited = this.state().boundariesCrossed;
        Layout layout = this.getParent().Define_Layout_getLayout(this, null);
        this.getLayout_visited = -1;
        return layout;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout layout;
        if (!this.getLayout().getHelper() && this.getDecl() == null && (layout = this.getLayout()) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void collect_contributors_Layout_getReferencedComponents() {
        Layout layout;
        if (this.getDecl() != null && (layout = this.getLayout()) != null) {
            layout.Layout_getReferencedComponents_contributors().add(this);
        }
        super.collect_contributors_Layout_getReferencedComponents();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Layout_Layout_getErrors(sortedSet);
        if (!this.getLayout().getHelper() && this.getDecl() == null) {
            sortedSet.add(this.makeCompilationError("Component " + this.getName() + " has not been imported."));
        }
    }

    @Override
    protected void contributeTo_Layout_Layout_getReferencedComponents(List<CompDecl> list) {
        super.contributeTo_Layout_Layout_getReferencedComponents(list);
        if (this.getDecl() != null) {
            list.add(this.getDecl());
        }
    }
}

