/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex.fsm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import metalexer.jflex.fsm.DFA;

public class NFA {
    private final int numStates;
    private final int numSymbols;
    private final BitSet[][] transitions;
    private final Integer[] actions;

    public NFA(BitSet[][] bitSetArray, Integer[] integerArray) {
        this.numStates = bitSetArray.length;
        this.numSymbols = bitSetArray[0].length;
        this.transitions = bitSetArray;
        this.actions = integerArray;
    }

    public DFA convertToDFA() {
        BitSet bitSet;
        int n;
        Cloneable cloneable;
        Integer[][] integerArray;
        HashMap<BitSet, Integer[][]> hashMap = new HashMap<BitSet, Integer[][]>();
        HashMap<BitSet, Integer> hashMap2 = new HashMap<BitSet, Integer>();
        BitSet bitSet2 = new BitSet(this.numStates);
        bitSet2.set(0);
        LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
        linkedList.add(bitSet2);
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        while (!linkedList.isEmpty()) {
            int n2;
            BitSet bitSet3 = (BitSet)linkedList.poll();
            if (hashMap.containsKey(bitSet3)) continue;
            integerArray = new BitSet[this.numSymbols];
            for (n2 = 0; n2 < this.numSymbols; ++n2) {
                cloneable = new BitSet(this.numStates);
                n = bitSet3.nextSetBit(0);
                while (n >= 0) {
                    ((BitSet)cloneable).or(this.transitions[n][n2]);
                    n = bitSet3.nextSetBit(n + 1);
                }
                integerArray[n2] = cloneable;
                linkedList.add(cloneable);
            }
            hashMap.put(bitSet3, integerArray);
            n2 = bitSet3.nextSetBit(0);
            while (n2 >= 0) {
                if (this.actions[n2] != null) {
                    hashMap2.put(bitSet3, this.actions[n2]);
                    break;
                }
                n2 = bitSet3.nextSetBit(n2 + 1);
            }
            arrayList.add(bitSet3);
        }
        int n3 = arrayList.size();
        integerArray = new Integer[n3][this.numSymbols];
        Integer[] integerArray2 = new Integer[n3];
        cloneable = new HashMap<BitSet, Object>();
        cloneable.put(new BitSet(this.numSymbols), null);
        for (n = 0; n < n3; ++n) {
            bitSet = (BitSet)arrayList.get(n);
            cloneable.put(bitSet, n);
        }
        for (n = 0; n < n3; ++n) {
            bitSet = (BitSet)arrayList.get(n);
            BitSet[] bitSetArray = (BitSet[])hashMap.get(bitSet);
            Integer[] integerArray3 = new Integer[this.numSymbols];
            for (int i = 0; i < this.numSymbols; ++i) {
                integerArray3[i] = (Integer)cloneable.get(bitSetArray[i]);
            }
            integerArray[n] = integerArray3;
            integerArray2[n] = (Integer)hashMap2.get(bitSet);
        }
        return new DFA(integerArray, integerArray2);
    }
}

