/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.PrintWriter;

public class PrintHelper {
    private final PrintWriter out;
    private final String singleIndentString;
    private int indentLevel;
    private boolean requireIndent;
    private String indentString;

    public PrintHelper(PrintWriter printWriter, int n) {
        this.out = printWriter;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        this.singleIndentString = stringBuffer.toString();
        this.indentLevel = 0;
        this.requireIndent = true;
        this.updateIndentString();
    }

    public <T> void print(T t) {
        this.maybePrintIndent();
        this.out.print(t);
    }

    public <T> void println(T t) {
        this.maybePrintIndent();
        this.out.println(t);
        this.requireIndent = true;
    }

    public void println() {
        this.maybePrintIndent();
        this.out.println();
        this.requireIndent = true;
    }

    public void close() {
        this.out.close();
    }

    public void indent() {
        ++this.indentLevel;
        this.updateIndentString();
    }

    public void dedent() {
        --this.indentLevel;
        this.updateIndentString();
    }

    private void updateIndentString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indentLevel; ++i) {
            stringBuffer.append(this.singleIndentString);
        }
        this.indentString = stringBuffer.toString();
    }

    private void maybePrintIndent() {
        if (this.requireIndent) {
            this.out.print(this.indentString);
            this.requireIndent = false;
        }
    }
}

