/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected boolean tokenboolean_Exclusive;
    protected int getConflictingStates_visited = -1;
    protected int getComponent_visited = -1;
    protected Map lookupStateDecls_String_visited;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getConflictingStates_visited = -1;
        this.getComponent_visited = -1;
        this.lookupStateDecls_String_visited = new HashMap(4);
    }

    @Override
    public State clone() throws CloneNotSupportedException {
        State state = (State)super.clone();
        state.getConflictingStates_visited = -1;
        state.getComponent_visited = -1;
        state.lookupStateDecls_String_visited = new HashMap(4);
        state.in$Circle(false);
        state.is$Final(false);
        return state;
    }

    public State copy() {
        try {
            State state = this.clone();
            if (this.children != null) {
                state.children = (ASTNode[])this.children.clone();
            }
            return state;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public State fullCopy() {
        State state = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            state.setChild(object, i);
        }
        return state;
    }

    public State() {
    }

    public State(String string, boolean bl) {
        this.setName(string);
        this.setExclusive(bl);
    }

    public State(Symbol symbol, boolean bl) {
        this.setName(symbol);
        this.setExclusive(bl);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setExclusive(boolean bl) {
        this.tokenboolean_Exclusive = bl;
    }

    public boolean getExclusive() {
        return this.tokenboolean_Exclusive;
    }

    public Set<State> getConflictingStates() {
        if (this.getConflictingStates_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getConflictingStates in class: ");
        }
        this.getConflictingStates_visited = this.state().boundariesCrossed;
        Set<State> set = this.getConflictingStates_compute();
        this.getConflictingStates_visited = -1;
        return set;
    }

    private Set<State> getConflictingStates_compute() {
        String string = this.getName();
        boolean bl = this.getExclusive();
        Set<State> set = this.lookupStateDecls(string);
        HashSet<State> hashSet = new HashSet<State>();
        for (State state : set) {
            if (!string.equals(state.getName()) || bl == state.getExclusive()) continue;
            hashSet.add(state);
        }
        return hashSet;
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component component = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return component;
    }

    public Set<State> lookupStateDecls(String string) {
        String string2 = string;
        if (this.lookupStateDecls_String_visited == null) {
            this.lookupStateDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupStateDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupStateDecls in class: ");
        }
        this.lookupStateDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<State> set = this.getParent().Define_java_util_Set_State__lookupStateDecls(this, null, string);
        this.lookupStateDecls_String_visited.remove(string2);
        return set;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component component;
        if (!this.getConflictingStates().isEmpty() && (component = this.getComponent()) != null) {
            component.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Component_Component_getErrors(sortedSet);
        if (!this.getConflictingStates().isEmpty()) {
            sortedSet.add(this.makeCompilationError("State " + this.getName() + " is declared as both inclusive and exclusive."));
        }
    }
}

