/*
 * Decompiled with CFR 0.152.
 */
package metalexer.metalexer;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.FileLoader;
import metalexer.ProblemUtil;
import metalexer.ast.Layout;

public class ML2ML {
    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length != 3) {
            System.err.println("Usage: java ML2ML {layout} {indir} {outdir}");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        System.out.println("Checking " + string + " in " + string2);
        TreeSet<CompilationProblem> treeSet = new TreeSet<CompilationProblem>();
        Layout layout = null;
        try {
            object = new FileLoader(string2);
            layout = ((FileLoader)object).loadLayout(string, treeSet);
            if (layout != null && (layout = layout.processInheritance((FileLoader)object, treeSet)).getHelper()) {
                treeSet.add(layout.makeCompilationError(layout.getName() + " is a helper layout."));
            }
        }
        catch (IOException iOException) {
            treeSet.add(new CompilationError(null, iOException.getMessage()));
        }
        object = ProblemUtil.extractWarnings(treeSet);
        SortedSet<CompilationError> sortedSet = object.iterator();
        while (sortedSet.hasNext()) {
            CompilationWarning compilationWarning = (CompilationWarning)sortedSet.next();
            System.out.println(compilationWarning);
        }
        sortedSet = ProblemUtil.extractErrors(treeSet);
        if (sortedSet.isEmpty()) {
            System.out.println("VALID");
            try {
                layout.tidyRuleGroups();
                layout.deleteUnusedDeclarations();
                layout.generateMetaLexer(string3);
            }
            catch (IOException iOException) {
                System.out.println(new CompilationError(null, iOException.getMessage()));
            }
        } else {
            for (CompilationError compilationError : sortedSet) {
                System.out.println(compilationError);
            }
        }
    }
}

