/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import metalexer.CompilationError;
import metalexer.CompilationWarning;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Declaration;
import metalexer.ast.Layout;
import metalexer.ast.Opt;
import metalexer.ast.Replacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompDecl
extends ASTNode<ASTNode>
implements Cloneable {
    private Stack<Replacement> replacements = new Stack();
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected Map makeCompilationError_String_visited;
    protected Map lookupExternDecls_String_visited;
    protected int getLayout_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.makeCompilationError_String_visited = new HashMap(4);
        this.lookupExternDecls_String_visited = new HashMap(4);
        this.getLayout_visited = -1;
    }

    @Override
    public CompDecl clone() throws CloneNotSupportedException {
        CompDecl compDecl = (CompDecl)super.clone();
        compDecl.makeCompilationError_String_visited = new HashMap(4);
        compDecl.lookupExternDecls_String_visited = new HashMap(4);
        compDecl.getLayout_visited = -1;
        compDecl.in$Circle(false);
        compDecl.is$Final(false);
        return compDecl;
    }

    public CompDecl copy() {
        try {
            CompDecl compDecl = this.clone();
            if (this.children != null) {
                compDecl.children = (ASTNode[])this.children.clone();
            }
            return compDecl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public CompDecl fullCopy() {
        CompDecl compDecl = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            compDecl.setChild(object, i);
        }
        return compDecl;
    }

    @Override
    Set<Replacement> replaceComponents(Map<String, Replacement> map) {
        if (map.containsKey(this.getName())) {
            Replacement replacement = map.get(this.getName());
            this.setName(replacement.getNew().getName());
            this.replacements.push(replacement);
            return Collections.singleton(replacement);
        }
        return Collections.emptySet();
    }

    public CompDecl() {
        this.setChild(new Opt(), 0);
    }

    public CompDecl(String string, Opt<Component> opt) {
        this.setName(string);
        this.setChild(opt, 0);
    }

    public CompDecl(Symbol symbol, Opt<Component> opt) {
        this.setName(symbol);
        this.setChild(opt, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setComponentOpt(Opt<Component> opt) {
        this.setChild(opt, 0);
    }

    public boolean hasComponent() {
        return this.getComponentOpt().getNumChild() != 0;
    }

    public Component getComponent() {
        return (Component)this.getComponentOpt().getChild(0);
    }

    public void setComponent(Component component) {
        this.getComponentOpt().setChild(component, 0);
    }

    public Opt<Component> getComponentOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt<Component> getComponentOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    @Override
    public CompilationError makeCompilationError(String string) {
        String string2 = string;
        if (this.makeCompilationError_String_visited == null) {
            this.makeCompilationError_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.makeCompilationError_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: makeCompilationError in class: ");
        }
        this.makeCompilationError_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        CompilationError compilationError = this.makeCompilationError_compute(string);
        this.makeCompilationError_String_visited.remove(string2);
        return compilationError;
    }

    private CompilationError makeCompilationError_compute(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Collections.reverse(this.replacements);
        for (Replacement replacement : this.replacements) {
            int n = replacement.getStart();
            int n2 = Symbol.getLine(n);
            int n3 = Symbol.getColumn(n);
            stringBuffer.append("\n\tReplaced '" + replacement.getOld().getName() + "' with '" + replacement.getNew().getName() + "' at " + replacement.getFilename() + " [" + n2 + ", " + n3 + "]");
        }
        Collections.reverse(this.replacements);
        return super.makeCompilationError(stringBuffer.toString());
    }

    public Set<Declaration> lookupExternDecls(String string) {
        String string2 = string;
        if (this.lookupExternDecls_String_visited == null) {
            this.lookupExternDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupExternDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupExternDecls in class: ");
        }
        this.lookupExternDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<Declaration> set = this.getParent().Define_java_util_Set_Declaration__lookupExternDecls(this, null, string);
        this.lookupExternDecls_String_visited.remove(string2);
        return set;
    }

    public Layout getLayout() {
        if (this.getLayout_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLayout in class: ");
        }
        this.getLayout_visited = this.state().boundariesCrossed;
        Layout layout = this.getParent().Define_Layout_getLayout(this, null);
        this.getLayout_visited = -1;
        return layout;
    }

    @Override
    public Layout Define_Layout_getLayout(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getComponentOptNoTransform()) {
            return this.getLayout();
        }
        return this.getParent().Define_Layout_getLayout(this, aSTNode);
    }

    @Override
    public Set<Declaration> Define_java_util_Set_Declaration__lookupExternDecls(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getComponentOptNoTransform()) {
            return this.lookupExternDecls(string);
        }
        return this.getParent().Define_java_util_Set_Declaration__lookupExternDecls(this, aSTNode, string);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getWarnings() {
        Layout layout;
        if (!this.getLayout().getHelper() && !this.hasComponent() && (layout = this.getLayout()) != null) {
            layout.Layout_getWarnings_contributors().add(this);
        }
        super.collect_contributors_Layout_getWarnings();
    }

    @Override
    protected void contributeTo_Layout_Layout_getWarnings(SortedSet<CompilationWarning> sortedSet) {
        super.contributeTo_Layout_Layout_getWarnings(sortedSet);
        if (!this.getLayout().getHelper() && !this.hasComponent()) {
            sortedSet.add(this.makeCompilationWarning("Component " + this.getName() + " import is unused."));
        }
    }
}

