/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.BodyElement;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Layout;
import metalexer.ast.List;
import metalexer.ast.MTokPair;
import metalexer.ast.MetaPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedding
extends BodyElement
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getConflictingEmbeddings_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getConflictingEmbeddings_visited = -1;
    }

    @Override
    public Embedding clone() throws CloneNotSupportedException {
        Embedding embedding = (Embedding)super.clone();
        embedding.getConflictingEmbeddings_visited = -1;
        embedding.in$Circle(false);
        embedding.is$Final(false);
        return embedding;
    }

    public Embedding copy() {
        try {
            Embedding embedding = this.clone();
            if (this.children != null) {
                embedding.children = (ASTNode[])this.children.clone();
            }
            return embedding;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Embedding fullCopy() {
        Embedding embedding = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            embedding.setChild(object, i);
        }
        return embedding;
    }

    void generateMetaLexer(PrintWriter printWriter) throws IOException {
        printWriter.println("%%embed");
        printWriter.println("%name " + this.getName());
        for (CompRef aSTNode : this.getHosts()) {
            printWriter.println("%host " + aSTNode.getName());
        }
        printWriter.println("%guest " + this.getGuest().getName());
        printWriter.print("%start ");
        this.getStartPattern().generateMetaLexer(printWriter);
        printWriter.println();
        printWriter.print("%end ");
        this.getEndPattern().generateMetaLexer(printWriter);
        printWriter.println();
        for (MTokPair mTokPair : this.getMTokPairs()) {
            printWriter.println("%pair " + mTokPair.getL().getName() + ", " + mTokPair.getR().getName());
        }
        printWriter.println();
    }

    public Embedding() {
        this.setChild(new List(), 0);
        this.setChild(new List(), 4);
    }

    public Embedding(String string, List<CompRef> list, CompRef compRef, MetaPattern metaPattern, MetaPattern metaPattern2, List<MTokPair> list2) {
        this.setName(string);
        this.setChild(list, 0);
        this.setChild(compRef, 1);
        this.setChild(metaPattern, 2);
        this.setChild(metaPattern2, 3);
        this.setChild(list2, 4);
    }

    public Embedding(Symbol symbol, List<CompRef> list, CompRef compRef, MetaPattern metaPattern, MetaPattern metaPattern2, List<MTokPair> list2) {
        this.setName(symbol);
        this.setChild(list, 0);
        this.setChild(compRef, 1);
        this.setChild(metaPattern, 2);
        this.setChild(metaPattern2, 3);
        this.setChild(list2, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setHostList(List<CompRef> list) {
        this.setChild(list, 0);
    }

    public int getNumHost() {
        return this.getHostList().getNumChild();
    }

    public CompRef getHost(int n) {
        return (CompRef)this.getHostList().getChild(n);
    }

    public void addHost(CompRef compRef) {
        List<CompRef> list = this.getHostList();
        list.addChild(compRef);
    }

    public void setHost(CompRef compRef, int n) {
        List<CompRef> list = this.getHostList();
        list.setChild(compRef, n);
    }

    public List<CompRef> getHosts() {
        return this.getHostList();
    }

    public List<CompRef> getHostsNoTransform() {
        return this.getHostListNoTransform();
    }

    public List<CompRef> getHostList() {
        return (List)this.getChild(0);
    }

    public List<CompRef> getHostListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setGuest(CompRef compRef) {
        this.setChild(compRef, 1);
    }

    public CompRef getGuest() {
        return (CompRef)this.getChild(1);
    }

    public CompRef getGuestNoTransform() {
        return (CompRef)this.getChildNoTransform(1);
    }

    public void setStartPattern(MetaPattern metaPattern) {
        this.setChild(metaPattern, 2);
    }

    public MetaPattern getStartPattern() {
        return (MetaPattern)this.getChild(2);
    }

    public MetaPattern getStartPatternNoTransform() {
        return (MetaPattern)this.getChildNoTransform(2);
    }

    public void setEndPattern(MetaPattern metaPattern) {
        this.setChild(metaPattern, 3);
    }

    public MetaPattern getEndPattern() {
        return (MetaPattern)this.getChild(3);
    }

    public MetaPattern getEndPatternNoTransform() {
        return (MetaPattern)this.getChildNoTransform(3);
    }

    public void setMTokPairList(List<MTokPair> list) {
        this.setChild(list, 4);
    }

    public int getNumMTokPair() {
        return this.getMTokPairList().getNumChild();
    }

    public MTokPair getMTokPair(int n) {
        return (MTokPair)this.getMTokPairList().getChild(n);
    }

    public void addMTokPair(MTokPair mTokPair) {
        List<MTokPair> list = this.getMTokPairList();
        list.addChild(mTokPair);
    }

    public void setMTokPair(MTokPair mTokPair, int n) {
        List<MTokPair> list = this.getMTokPairList();
        list.setChild(mTokPair, n);
    }

    public List<MTokPair> getMTokPairs() {
        return this.getMTokPairList();
    }

    public List<MTokPair> getMTokPairsNoTransform() {
        return this.getMTokPairListNoTransform();
    }

    public List<MTokPair> getMTokPairList() {
        return (List)this.getChild(4);
    }

    public List<MTokPair> getMTokPairListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    public Set<Embedding> getConflictingEmbeddings() {
        if (this.getConflictingEmbeddings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getConflictingEmbeddings in class: ");
        }
        this.getConflictingEmbeddings_visited = this.state().boundariesCrossed;
        Set<Embedding> set = this.getConflictingEmbeddings_compute();
        this.getConflictingEmbeddings_visited = -1;
        return set;
    }

    private Set<Embedding> getConflictingEmbeddings_compute() {
        String string = this.getName();
        Set<Embedding> set = this.lookupEmbeddings(string);
        HashSet<Embedding> hashSet = new HashSet<Embedding>();
        for (Embedding embedding : set) {
            if (!string.equals(embedding.getName()) || embedding == this) continue;
            hashSet.add(embedding);
        }
        return hashSet;
    }

    @Override
    public Set<CompDecl> Define_java_util_Set_CompDecl__lookupCompDecls(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getGuestNoTransform()) {
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getHostListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupCompDecls(string);
        }
        return this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, aSTNode, string);
    }

    @Override
    public java.util.List<Component> Define_java_util_List_Component__getComponents(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getEndPatternNoTransform()) {
            CompDecl compDecl = this.getGuest().getDecl();
            if (compDecl == null || !compDecl.hasComponent()) {
                return new ArrayList<Component>();
            }
            return Collections.singletonList(compDecl.getComponent());
        }
        if (aSTNode == this.getStartPatternNoTransform()) {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            for (CompRef compRef : this.getHosts()) {
                CompDecl compDecl = compRef.getDecl();
                if (compDecl == null || !compDecl.hasComponent()) continue;
                arrayList.add(compDecl.getComponent());
            }
            return arrayList;
        }
        if (aSTNode == this.getMTokPairListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            CompDecl compDecl = this.getGuest().getDecl();
            if (compDecl == null || !compDecl.hasComponent()) {
                return new ArrayList<Component>();
            }
            return Collections.singletonList(compDecl.getComponent());
        }
        return this.getParent().Define_java_util_List_Component__getComponents(this, aSTNode);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout layout;
        if (!this.getConflictingEmbeddings().isEmpty() && (layout = this.getLayout()) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Layout_Layout_getErrors(sortedSet);
        if (!this.getConflictingEmbeddings().isEmpty()) {
            sortedSet.add(this.makeCompilationError("Embedding " + this.getName() + " is declared more than once."));
        }
    }
}

